/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;

public class ChangeDataUtil {
    public static boolean isRealChanged(ChangeData changeSet) {
        boolean isRealChanged = true;
        if (StringUtils.isBlank((Object)changeSet)) {
            return false;
        }
        Object oldObject = changeSet.getOldValue();
        Object newObject = changeSet.getNewValue();
        if (oldObject != null && newObject != null && oldObject.getClass().toString().equals(newObject.getClass().toString())) {
            isRealChanged = ChangeDataUtil.isRealChanged(oldObject, newObject);
        }
        if (isRealChanged && StringUtils.equalsIgnoreCase((CharSequence)String.valueOf(oldObject), (CharSequence)String.valueOf(newObject))) {
            isRealChanged = false;
        }
        return isRealChanged;
    }

    private static boolean isRealChanged(Object oldObject, Object newObject) {
        boolean isRealChanged = true;
        if (newObject instanceof DynamicObject) {
            Object newPkVal = ((DynamicObject)newObject).getPkValue();
            Object oldPkVal = ((DynamicObject)oldObject).getPkValue();
            if (newPkVal != null && newPkVal.equals(oldPkVal) || newPkVal == oldPkVal) {
                isRealChanged = false;
            }
        } else if (newObject instanceof BigDecimal && ((BigDecimal)newObject).compareTo((BigDecimal)oldObject) == 0) {
            isRealChanged = false;
        }
        return isRealChanged;
    }

    public static DynamicObject getDataEntity(ChangeData changeSet) {
        DynamicObject dataEntity = null;
        if (StringUtils.isBlank((Object)changeSet)) {
            return dataEntity;
        }
        return changeSet.getDataEntity();
    }

    public static Object getOldValue(ChangeData changeSet) {
        Object oldValue = null;
        if (StringUtils.isBlank((Object)changeSet)) {
            return oldValue;
        }
        oldValue = changeSet.getOldValue();
        return oldValue;
    }

    public static Object getNewValue(ChangeData changeSet) {
        Object newValue = null;
        if (StringUtils.isBlank((Object)changeSet)) {
            return newValue;
        }
        newValue = changeSet.getNewValue();
        return newValue;
    }

    public static boolean valueCheck(Object newValue, Object oldValue) {
        boolean newflag;
        boolean result = true;
        boolean dynflag = oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue());
        boolean decflag = oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0;
        boolean nullflag = newValue == null && oldValue == null;
        boolean bl = newflag = newValue != null && newValue.equals(oldValue);
        if (nullflag || newflag || dynflag || decflag) {
            result = false;
        }
        return result;
    }
}

