/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.common.enums.ErrorTypeEnum;
import kd.qmc.qcbd.common.errorcode.QmcBaseErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCodeUtils;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class ControlUtil {
    private ControlUtil() {
    }

    public static void setOldValue(IFormView fv, IDataModel dm, DynamicObject propertyValueCDDE, String propertyName, Object oldObject) {
        dm.beginInit();
        if (propertyValueCDDE != null) {
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set(propertyName, oldObject);
            propertyValueCDDE.endInit();
        }
        dm.endInit();
        fv.updateView(propertyName);
    }

    public static void setOldValue(IFormView fv, IDataModel dm, DynamicObject propertyValueCDDE, String propertyName, Object oldObject, int row) {
        dm.beginInit();
        if (propertyValueCDDE != null) {
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set(propertyName, oldObject);
            propertyValueCDDE.endInit();
        }
        dm.endInit();
        fv.updateView(propertyName, row);
    }

    public static void setOldValueTip(IFormView fv, IDataModel dm, DynamicObject propertyValueCDDE, String propertyName, Object oldObject, int row, String errStr) {
        String cacheKey = StringQMCUtil.getCaheKey("errormessage", propertyName, String.valueOf(row));
        IPageCache pc = fv.getPageCache();
        String cacheVal = pc.get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheVal)) {
            pc.remove(cacheKey);
        } else {
            pc.put(cacheKey, errStr);
        }
        dm.beginInit();
        if (propertyValueCDDE != null) {
            propertyValueCDDE.beginInit();
            propertyValueCDDE.set(propertyName, oldObject);
            propertyValueCDDE.endInit();
        }
        dm.endInit();
        fv.updateView(propertyName, row);
        if (StringUtils.isBlank((CharSequence)cacheVal)) {
            fv.showTipNotification(errStr);
        }
    }

    @Deprecated
    public static void setControlMustInput(IFormView fv, String controlName, String tip, boolean isMustInput) {
        FieldEdit fieldEdit = (FieldEdit)fv.getControl(controlName);
        if (fieldEdit == null) {
            return;
        }
        HashMap<String, String> itemMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> ctlMap = new HashMap<String, HashMap<String, String>>();
        fieldEdit.setMustInput(isMustInput);
        if (tip != null) {
            itemMap.put("emptytip", tip);
        }
        ctlMap.put("item", itemMap);
        fv.updateControlMetadata(controlName, ctlMap);
    }

    public static void setCtrlMustInput(IFormView fv, String controlName, String tip, boolean isMustInput) {
        FieldEdit fieldEdit = (FieldEdit)fv.getControl(controlName);
        if (fieldEdit == null) {
            return;
        }
        FieldProp fieldProp = (FieldProp)fieldEdit.getProperty();
        HashMap<String, String> itemMap = new HashMap<String, String>(16);
        HashMap<String, HashMap<String, String>> ctlMap = new HashMap<String, HashMap<String, String>>(16);
        fieldEdit.setMustInput(isMustInput);
        fieldProp.setMustInput(isMustInput);
        if (tip != null) {
            itemMap.put("emptytip", tip);
        }
        ctlMap.put("item", itemMap);
        fv.updateControlMetadata(controlName, ctlMap);
    }

    public static void showEntityFieldForm(TreeNode entityNode, String formId, String customParmsName, String callbackKey, IFormView fv, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        String nodesJson = SerializationUtils.toJsonString((Object)entityNode);
        showParameter.getCustomParams().put(customParmsName, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, callbackKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        fv.showForm(showParameter);
    }

    public static MainEntityType getMainEntityType(DynamicObject entity) {
        if (entity != null) {
            Object billentityPkValue = entity.getPkValue();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
            return dataEntityType;
        }
        return null;
    }

    public static FormShowParameter createFormShowParameter(String formID, ShowType showType, Map<String, Object> customParameters, CloseCallBack closeCallBack) {
        if (StringUtils.isNotBlank((CharSequence)formID) && showType != null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(formID);
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            if (openStyle != null) {
                openStyle.setShowType(showType);
            }
            if (customParameters != null) {
                formShowParameter.setCustomParams(customParameters);
            }
            if (closeCallBack != null) {
                formShowParameter.setCloseCallBack(closeCallBack);
            }
            return formShowParameter;
        }
        return null;
    }

    public static BillShowParameter createBillShowParameter(String pkId, String formID, ShowType showType, OperationStatus operationStatus, Map<String, Object> customParameters, CloseCallBack closeCallBack) {
        if (StringUtils.isNotBlank((CharSequence)formID) && showType != null) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(formID);
            OpenStyle openStyle = billShowParameter.getOpenStyle();
            if (openStyle != null) {
                openStyle.setShowType(showType);
            }
            if (StringUtils.isNotBlank((CharSequence)pkId)) {
                billShowParameter.setPkId((Object)pkId);
            }
            if (operationStatus != null) {
                billShowParameter.setStatus(operationStatus);
            }
            if (customParameters != null) {
                billShowParameter.setCustomParams(customParameters);
            }
            if (closeCallBack != null) {
                billShowParameter.setCloseCallBack(closeCallBack);
            }
            return billShowParameter;
        }
        return null;
    }

    public static void showForm(String formId, Map<String, Object> customParams, String callbackKey, IFormView fv, IFormPlugin plugin, ShowType showType) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        FormShowParameter formshow = new FormShowParameter();
        formshow.setFormId(formId);
        formshow.setCustomParams(customParams);
        if (plugin != null) {
            formshow.setCloseCallBack(new CloseCallBack(plugin, callbackKey));
        }
        formshow.getOpenStyle().setShowType(showType);
        fv.showForm(formshow);
    }

    public static FormShowParameter getFormShowParameter(String formId, Map<String, Object> customParams, String callbackKey, IFormView fv, IFormPlugin plugin, ShowType showType) {
        FormShowParameter formshow = new FormShowParameter();
        if (StringUtils.isBlank((CharSequence)formId)) {
            return null;
        }
        formshow.setFormId(formId);
        formshow.setCustomParams(customParams);
        formshow.setCloseCallBack(new CloseCallBack(plugin, callbackKey));
        formshow.getOpenStyle().setShowType(showType);
        return formshow;
    }

    public static void deleteEmptyRows(IDataModel dataModel, String entryKey, String keyId) {
        DynamicObjectCollection entrys = dataModel.getEntryEntity(entryKey);
        List<Object> rows = new ArrayList();
        rows = entrys.stream().filter(o -> Objects.isNull(o.getDynamicObject(keyId))).map(o -> o.getInt("seq") - 1).collect(Collectors.toList());
        int[] rowsArray = new int[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            rowsArray[i] = (Integer)rows.get(i);
        }
        dataModel.deleteEntryRows(entryKey, rowsArray);
    }

    public static void unitCheck(BeforeF7SelectEvent e, IFormView view, DynamicObject material) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (material == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"ControlUtil_0", (String)"qmc-qcbd-common", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            DynamicObject baseunit = material.getDynamicObject("baseunit");
            QFilter qFilter = new QFilter("materialid", "=", material.getPkValue());
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{qFilter});
            List unitIds = dynamicObjects.stream().map(o -> o.getLong("measureunitid")).collect(Collectors.toList());
            unitIds.add(baseunit.getLong("id"));
            qFilter = new QFilter("id", "in", unitIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public static void setIgnoreBizChanged(IDataModel dm, Set<String> fieldSet) {
        DynamicObject doMain = dm.getDataEntity();
        DynamicObjectType dotMain = doMain.getDynamicObjectType();
        for (String field : fieldSet) {
            DynamicProperty dpTmp = dotMain.getProperty(field);
            int propOrdinal = dpTmp.getOrdinal();
            DataEntityState desMain = doMain.getDataEntityState();
            desMain.setBizChanged(propOrdinal, false);
        }
    }

    public static boolean dataChangePermit(IDataModel model, IFormView view, Object fieldObj, int index) {
        boolean permit = true;
        Object billStatus = model.getValue("billstatus");
        if ("B".equals(billStatus) || "C".equals(billStatus)) {
            String fieldKey = "";
            String fieldName = "";
            if (fieldObj instanceof FieldEdit) {
                FieldEdit fieldEdit = (FieldEdit)fieldObj;
                fieldKey = fieldEdit.getFieldKey();
                fieldName = fieldEdit.getProperty().getDisplayName().getLocaleValue();
            } else if (fieldObj instanceof IDataEntityProperty) {
                IDataEntityProperty property = (IDataEntityProperty)fieldObj;
                fieldKey = property.getName();
                fieldName = property.getDisplayName().getLocaleValue();
            }
            Object oldValue = model.getValue(fieldKey, index);
            model.setValue(fieldKey, oldValue, index);
            view.updateView(fieldKey, index);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ControlUtil_1", (String)"qmc-qcbd-common", (Object[])new Object[0]), fieldName));
            permit = false;
        }
        return permit;
    }

    public static void setValueWithoutPropchange(IDataModel dataModel, IFormView gridView, String prop, Object propValue) {
        dataModel.beginInit();
        dataModel.setValue(prop, propValue);
        dataModel.endInit();
        gridView.updateView(prop);
    }

    public static void setValueWithoutPropchange(IDataModel dataModel, IFormView gridView, String prop, Object propValue, int rowIndex) {
        dataModel.beginInit();
        dataModel.setValue(prop, propValue, rowIndex);
        dataModel.endInit();
        gridView.updateView(prop, rowIndex);
    }

    public static void setValueWithoutPropchange(IDataModel dataModel, IFormView gridView, String prop, Object propValue, int rowIndex, int parentRowIndex) {
        dataModel.beginInit();
        dataModel.setValue(prop, propValue, rowIndex, parentRowIndex);
        dataModel.endInit();
        gridView.updateView(prop, rowIndex, parentRowIndex);
    }

    public static void setAfterF7InputPk(AfterF7SelectEvent e) {
        if (!e.getInputValues().isEmpty()) {
            ListSelectedRowCollection selectedRowColl = new ListSelectedRowCollection();
            ListSelectedRow selectedRow = new ListSelectedRow();
            selectedRow.setPrimaryKeyValue(e.getInputValues().get(0));
            selectedRowColl.add((Object)selectedRow);
            e.setListSelectedRowCollection(selectedRowColl);
        }
    }

    public static void setListSelectedMode(ListShowParameter showParameter, boolean isAllSelected) {
        showParameter.setCustomParam("ismergerows", (Object)isAllSelected);
    }

    public static void preEntryBeforeDoOpr(BeforeDoOperationEventArgs args, IDataModel model, IFormView view, String entryKey) {
        int row = model.getEntryCurrentRowIndex(entryKey);
        int rowCount = model.getEntryRowCount(entryKey);
        if (rowCount != 0 && row == 0) {
            QmcErrorCodeUtils.showMessge(view, QmcBaseErrorCode.getErrorInfo(ErrorTypeEnum.Msg_FirstRow));
            args.setCancel(true);
        }
    }

    public static void nextEntryBeforeDoOpr(BeforeDoOperationEventArgs args, IDataModel model, IFormView view, String entryKey) {
        int row = model.getEntryCurrentRowIndex(entryKey);
        int rowCount = model.getEntryRowCount(entryKey);
        if (rowCount != 0 && row + 1 == rowCount) {
            QmcErrorCodeUtils.showMessge(view, QmcBaseErrorCode.getErrorInfo(ErrorTypeEnum.Msg_LastRow));
            args.setCancel(true);
        }
    }
}

