/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;

public class CopyUtil {
    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, Set<String> ignoreKeys, Map<String, String> convertKeysMap, boolean needCopyId) {
        DataEntityPropertyCollection toPs = toObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection fromPs = fromObj.getDataEntityType().getProperties();
        HashSet<String> fromPsSet = new HashSet<String>(fromPs.size());
        for (IDataEntityProperty dp : fromPs) {
            fromPsSet.add(dp.getName());
        }
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>(16);
        }
        if (!needCopyId) {
            ignoreKeys.add("id");
        }
        String toKey = null;
        String fromKey = null;
        int len = toPs.size();
        for (int i = 0; i < len; ++i) {
            toKey = ((IDataEntityProperty)toPs.get(i)).getName();
            if (ignoreKeys.contains(toKey) || !fromPsSet.contains(fromKey = convertKeysMap != null && convertKeysMap.containsKey(toKey) ? convertKeysMap.get(toKey) : toKey)) continue;
            Object value = fromObj.get(fromKey);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
                DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toKey);
                if (toEntity != null) {
                    toEntity.clear();
                    DynamicObjectType entityType = toEntity.getDynamicObjectType();
                    for (DynamicObject baseEntry : formEntity) {
                        DynamicObject newEntry = new DynamicObject(entityType);
                        CopyUtil.copy(baseEntry, newEntry, ignoreKeys);
                        toEntity.add((Object)newEntry);
                    }
                }
                toObj.set(toKey, (Object)toEntity);
                continue;
            }
            toObj.set(toKey, value);
        }
    }

    public static void copyPropertiesWithOutId(DynamicObject toObj, DynamicObject fromObj) {
        CopyUtil.copyProperties(toObj, fromObj, null, null, false);
    }

    public static void copyPropertiesWithId(DynamicObject toObj, DynamicObject fromObj) {
        CopyUtil.copyProperties(toObj, fromObj, null, null, true);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        CopyUtil.copy(fromObj, toObj, ignoreKeys, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (Object pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        ISimpleProperty primaryKeyObj = toObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        for (IDataEntityProperty pro : toPros) {
            String toProName;
            String fromProName = toProName = pro.getName();
            if (transKeyMap != null && transKeyMap.containsKey(fromProName)) {
                toProName = transKeyMap.get(fromProName);
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            if (toProName.equals(primaryKey)) {
                toObj.set(toProName, null);
                continue;
            }
            Object value = fromObj.get(fromProName);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
                DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
                if (toEntity != null) {
                    toEntity.clear();
                    DynamicObjectType entityType = toEntity.getDynamicObjectType();
                    for (DynamicObject baseEntry : formEntity) {
                        DynamicObject newEntry = new DynamicObject(entityType);
                        CopyUtil.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                        toEntity.add((Object)newEntry);
                    }
                }
                toObj.set(toProName, (Object)toEntity);
                continue;
            }
            toObj.set(toProName, value);
        }
    }
}

