/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class DataImportUtil {
    private static final String SYSTEM_TYPE = "qmc-qcbd-common";

    public static void checkObjList(List<String> keyNameList, List<Object> objectList, List<String> warnList) {
        int size = objectList.size();
        for (int i = 0; i < size; ++i) {
            Object object = objectList.get(i);
            String keyName = keyNameList.get(i);
            if (object instanceof Date) {
                DataImportUtil.checkDateObj(keyName, (Date)object, warnList);
                continue;
            }
            if (object instanceof BigDecimal) {
                DataImportUtil.checkBigDicimal(keyName, (BigDecimal)object, warnList);
                continue;
            }
            if (!(object instanceof DynamicObject)) continue;
            DataImportUtil.checkDynamicObj(keyName, (DynamicObject)object, warnList);
        }
    }

    public static void checkDynamicObj(String keyname, DynamicObject object, List<String> warnList) {
        if (object != null && !object.getBoolean("enable")) {
            warnList.add(String.format(ResManager.loadKDString((String)"%s\u7981\u7528\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"DataImportUtil_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), keyname));
        }
    }

    public static void checkBigDicimal(String keyName, BigDecimal bigDecimal, List<String> warnList) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            warnList.add(String.format(ResManager.loadKDString((String)"%s\u6570\u91cf\u5e94\u5927\u4e8e0\u3002", (String)"DataImportUtil_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), keyName));
        }
    }

    public static void checkDateObj(String keyName, Date object, List<String> warnList) {
        if (object != null && !DataImportUtil.dateCheck(object)) {
            warnList.add(String.format(ResManager.loadKDString((String)"%s\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"DataImportUtil_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), keyName));
        }
    }

    public static void cancelBeforeImport(BeforeImportDataEventArgs e, List<String> warnList, int i) {
        if (!warnList.isEmpty()) {
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(i), warnList);
            e.setCancel(true);
        }
    }

    public static void cancelAfterImport(ImportDataEventArgs e, List<String> warnList, int i) {
        if (!warnList.isEmpty()) {
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(i), warnList);
            e.setCancel(true);
        }
    }

    public static boolean dateCheck(Date date) {
        boolean r = false;
        String DateStr1 = "1900-1-1 00:00:00";
        String DateStr2 = "3000-1-1 00:00:00";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date dateTime1 = dateFormat.parse(DateStr1);
            Date dateTime2 = dateFormat.parse(DateStr2);
            if (date.compareTo(dateTime1) >= 0 && date.compareTo(dateTime2) <= 0) {
                r = true;
            }
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.parse, new Object[]{String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"DataImportUtil_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage())});
        }
        return r;
    }

    public static void addKeyId(Map obj, String createOrgNumber, String entity, Map cacheMap) {
        if (null == obj || StringUtils.isEmpty((String)createOrgNumber) || StringUtils.isEmpty((String)entity)) {
            return;
        }
        Object number = obj.get("number");
        if (number instanceof String) {
            DynamicObject orgObj;
            String numberStr = String.valueOf(number);
            String key = createOrgNumber + "-" + entity + "-" + numberStr;
            if (cacheMap.containsKey(key)) {
                obj.put("id", cacheMap.get(key));
            }
            if (null == (orgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)createOrgNumber)}))) {
                return;
            }
            QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)orgObj.getLong("id"));
            baseFilter.and("number", "=", number);
            DynamicObjectCollection ids = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])baseFilter.toArray());
            if (!ids.isEmpty()) {
                Object id = ((DynamicObject)ids.get(0)).get("id");
                obj.put("id", id);
                cacheMap.put(key, id);
            }
        }
    }
}

