/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.servicehelper.MetadataServiceHelper;

public class DynamicObjPropUtil {
    public static String getPropCap(IDataEntityProperty prop) {
        StringBuilder sbDisplayname = new StringBuilder();
        if (prop == null) {
            return sbDisplayname.toString();
        }
        LocaleString localdisplayname = prop.getDisplayName();
        if (localdisplayname != null) {
            sbDisplayname.append(localdisplayname.getLocaleValue());
        } else {
            sbDisplayname.append(prop.getName());
        }
        return sbDisplayname.toString();
    }

    public static Boolean validProp(EntityType entityType, String fieldID) {
        DynamicProperty prop = entityType.getProperty(fieldID);
        if (prop == null || fieldID.contains("_id") || entityType instanceof LinkEntryType || prop instanceof LinkEntryProp || StringUtils.isBlank((CharSequence)prop.getAlias())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static String getEntryCaption(String entityId, String entryName) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        Map mapEntrys = mainEntityType.getAllEntities();
        EntityType entityType = (EntityType)mapEntrys.get(entryName);
        String localVal = entityType.getDisplayName().getLocaleValue();
        return localVal;
    }

    public static Boolean isFirstDrawByDyo(DynamicObject object) {
        Boolean isDrawFlag = Boolean.FALSE;
        if (Objects.nonNull(object)) {
            boolean isFromDb = object.getDataEntityState().getFromDatabase();
            boolean pushChanged = object.getDataEntityState().isPushChanged();
            if (!isFromDb && pushChanged) {
                isDrawFlag = Boolean.TRUE;
            }
        }
        return isDrawFlag;
    }
}

