/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.IDataEntityBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class DynamicObjUtil {
    public static DynamicObject getSingleObj(List<DynamicObject> dyncObjs, Map<String, String> mFilters) {
        DynamicObject dyncObj = null;
        List<DynamicObject> redyncObjs = DynamicObjUtil.getListObj(dyncObjs.toArray(new DynamicObject[dyncObjs.size()]), mFilters);
        if (redyncObjs.size() > 0) {
            dyncObj = redyncObjs.get(0);
        }
        return dyncObj;
    }

    public static List<DynamicObject> getListObj(DynamicObject[] dyncObjs, Map<String, String> mFilters) {
        ArrayList<DynamicObject> newDyncObjs = new ArrayList<DynamicObject>();
        for (DynamicObject dyncObj : dyncObjs) {
            int i = 0;
            for (Map.Entry<String, String> mFilter : mFilters.entrySet()) {
                String fKey = mFilter.getKey();
                String fVal = mFilter.getValue();
                Object valObj = dyncObj.get(fKey);
                if (!StringUtils.isNotBlank((Object)valObj) || !StringUtils.isNotBlank((CharSequence)fVal) || !StringUtils.equalsIgnoreCase((CharSequence)valObj.toString(), (CharSequence)fVal)) continue;
                ++i;
            }
            if (i != mFilters.size()) continue;
            newDyncObjs.add(dyncObj);
        }
        return newDyncObjs;
    }

    public static DynamicObject[] getArrayObj(DynamicObject[] dyncObjs, Map<String, String> mFilters) {
        List<DynamicObject> newDyncObjs = DynamicObjUtil.getListObj(dyncObjs, mFilters);
        DynamicObject[] arrayObjs = newDyncObjs.toArray(new DynamicObject[newDyncObjs.size()]);
        return arrayObjs;
    }

    public static DynamicObject[] getLoadData(String entityName, QFilter[] qfilters) {
        DynamicObjectCollection objs = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qfilters);
        List<Long> objids = DynamicObjUtil.getIDs(objs);
        DynamicObject[] resObjs = DynamicObjUtil.getLoadData(entityName, objids);
        return resObjs;
    }

    public static DynamicObject getLoadSingleData(String entityName, QFilter[] qfilters) {
        DynamicObject singleObj = null;
        DynamicObject[] dyncObjs = DynamicObjUtil.getLoadData(entityName, qfilters);
        if (dyncObjs != null && dyncObjs.length > 0) {
            singleObj = dyncObjs[0];
        }
        return singleObj;
    }

    public static DynamicObject[] getLoadData(String entityName, List<Long> ids) {
        DynamicObject[] dyncObjs = null;
        if (ids.size() <= 0) {
            return dyncObjs;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        dyncObjs = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)entityType);
        return dyncObjs;
    }

    public static DynamicObject[] getLoadData(String entityName, Set<Long> ids) {
        DynamicObject[] dyncObjs = null;
        if (ids.size() <= 0) {
            return dyncObjs;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        dyncObjs = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)entityType);
        return dyncObjs;
    }

    public static List<Long> getIDs(DynamicObjectCollection dyncObjs) {
        ArrayList<Long> lstID = new ArrayList<Long>();
        for (int i = 0; i < dyncObjs.size(); ++i) {
            DynamicObject dyncObj = (DynamicObject)dyncObjs.get(i);
            Long id = dyncObj.getLong("id");
            if (lstID.contains(id)) continue;
            lstID.add(id);
        }
        return lstID;
    }

    public static List<Long> getIDs(DynamicObject[] dyncObjs) {
        ArrayList<Long> lstID = new ArrayList<Long>();
        if (dyncObjs == null) {
            return lstID;
        }
        for (int i = 0; i < dyncObjs.length; ++i) {
            DynamicObject dyncObj = dyncObjs[i];
            Long id = (Long)dyncObj.getPkValue();
            if (lstID.contains(id) || id <= 0L) continue;
            lstID.add(id);
        }
        return lstID;
    }

    public static Set<Object> getIDSet(DynamicObject[] dyncObjs) {
        HashSet<Object> pkSet = new HashSet<Object>(10);
        if (dyncObjs == null) {
            return pkSet;
        }
        for (int i = 0; i < dyncObjs.length; ++i) {
            DynamicObject dyncObj = dyncObjs[i];
            pkSet.add(dyncObj.getPkValue());
        }
        return pkSet;
    }

    public static List<Object> getIDList(DynamicObject[] dyncObjs) {
        ArrayList<Object> lstID = new ArrayList<Object>();
        if (dyncObjs == null) {
            return lstID;
        }
        for (int i = 0; i < dyncObjs.length; ++i) {
            DynamicObject dyncObj = dyncObjs[i];
            if (lstID.contains(dyncObj.getPkValue())) continue;
            lstID.add(dyncObj.getPkValue());
        }
        return lstID;
    }

    public static Map<Long, DynamicObject> getObjectMap(DynamicObject[] dyncObjs) {
        HashMap<Long, DynamicObject> objMap = new HashMap<Long, DynamicObject>(10);
        if (dyncObjs == null) {
            return objMap;
        }
        for (int i = 0; i < dyncObjs.length; ++i) {
            DynamicObject dyncObj = dyncObjs[i];
            objMap.put((Long)dyncObj.getPkValue(), dyncObj);
        }
        return objMap;
    }

    public static Map<Long, DynamicObject> getObjectMap(DynamicObjectCollection dyncObjs, String fieldName) {
        HashMap<Long, DynamicObject> objMap = new HashMap<Long, DynamicObject>(10);
        if (dyncObjs == null) {
            return objMap;
        }
        for (int i = 0; i < dyncObjs.size(); ++i) {
            DynamicObject dyncObj = (DynamicObject)dyncObjs.get(i);
            objMap.put(dyncObj.getLong(fieldName), dyncObj);
        }
        return objMap;
    }

    public static Map<String, List<DynamicObject>> getOnlyObjMap(DynamicObjectCollection dyncObjs, String ... paras) {
        HashMap<String, List<DynamicObject>> objMap = new HashMap<String, List<DynamicObject>>(100);
        if (dyncObjs == null) {
            return objMap;
        }
        for (int i = 0; i < dyncObjs.size(); ++i) {
            DynamicObject dyncObj = (DynamicObject)dyncObjs.get(i);
            String onlyKey = DynamicObjUtil.getOnlyObjMapKey(dyncObj, paras);
            if (onlyKey.length() == 0) continue;
            ArrayList<DynamicObject> fieldObjs = (ArrayList<DynamicObject>)objMap.get(onlyKey);
            if (fieldObjs == null) {
                fieldObjs = new ArrayList<DynamicObject>();
            }
            fieldObjs.add(dyncObj);
            objMap.put(onlyKey, fieldObjs);
        }
        return objMap;
    }

    public static Map<String, List<DynamicObject>> getOnlyObjMap(List<DynamicObject> dyncObjs, String ... paras) {
        HashMap<String, List<DynamicObject>> objMap = new HashMap<String, List<DynamicObject>>(100);
        if (dyncObjs == null) {
            return objMap;
        }
        for (int i = 0; i < dyncObjs.size(); ++i) {
            DynamicObject dyncObj = dyncObjs.get(i);
            String onlyKey = DynamicObjUtil.getOnlyObjMapKey(dyncObj, paras);
            ArrayList<DynamicObject> fieldObjs = (ArrayList<DynamicObject>)objMap.get(onlyKey);
            if (fieldObjs == null) {
                fieldObjs = new ArrayList<DynamicObject>();
            }
            fieldObjs.add(dyncObj);
            objMap.put(onlyKey, fieldObjs);
        }
        return objMap;
    }

    public static String getOnlyObjMapKey(DynamicObject dyncObj, String ... paras) {
        StringBuilder sbStr = new StringBuilder();
        for (String para : paras) {
            Object objVal = dyncObj.get(para);
            if (objVal instanceof DynamicObject) {
                sbStr.append(((DynamicObject)objVal).getPkValue());
                continue;
            }
            if (!(objVal instanceof String)) continue;
            sbStr.append(objVal);
        }
        return sbStr.toString();
    }

    public static String getOnlyObjStr(DynamicObject dyncObj, List<String> valList) {
        StringBuilder sbStr = new StringBuilder();
        for (String para : valList) {
            Object objVal = dyncObj.get(para);
            if (objVal instanceof DynamicObject) {
                sbStr.append(((DynamicObject)objVal).getPkValue());
                continue;
            }
            if (objVal instanceof String) {
                sbStr.append(objVal);
                continue;
            }
            if (objVal instanceof Long) {
                sbStr.append(objVal);
                continue;
            }
            if (!(objVal instanceof OrmLocaleValue)) continue;
            sbStr.append(((OrmLocaleValue)objVal).getLocaleValue());
        }
        return sbStr.toString();
    }

    public static String getOnlyRowStr(Row row, List<String> paras) {
        StringBuilder sbStr = new StringBuilder();
        for (String para : paras) {
            Object objVal = row.get(para);
            if (objVal instanceof Long) {
                if (objVal.equals(0L)) continue;
                sbStr.append(objVal);
                continue;
            }
            if (!(objVal instanceof String)) continue;
            sbStr.append(objVal);
        }
        return sbStr.toString();
    }

    public static Set<String> getFieldSetStr(List<DynamicObject> colls, String fieldName) {
        HashSet<String> valSet = new HashSet<String>(100);
        if (colls == null) {
            return valSet;
        }
        for (DynamicObject coll : colls) {
            valSet.add(coll.getString(fieldName));
        }
        return valSet;
    }

    public static Set<String> getFieldSetStr(DynamicObject[] colls, String fieldName) {
        HashSet<String> valSet = new HashSet<String>(100);
        if (colls == null) {
            return valSet;
        }
        for (int i = 0; i < colls.length; ++i) {
            DynamicObject coll = colls[i];
            valSet.add(coll.getString(fieldName));
        }
        return valSet;
    }

    public static List<String> getPropValList(DynamicObject[] dyncObjs, String propKey) {
        ArrayList<String> lstPropVals = new ArrayList<String>(100);
        if (dyncObjs.length <= 0) {
            return lstPropVals;
        }
        for (int i = 0; i < dyncObjs.length; ++i) {
            DynamicObject dyncObj = dyncObjs[i];
            String propVal = dyncObj.getString(propKey);
            lstPropVals.add(propVal);
        }
        return lstPropVals;
    }

    public static Long getLongId(DynamicObject dynamicObject) {
        if (null == dynamicObject) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    public static String serializeFromEntityToString(DynamicObject dynamicObject) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeDataEntityState(true);
        option.setIncludeType(true);
        option.setDataEntityBinder(new IDataEntityBinder(){

            public boolean isSerializProperty(IDataEntityProperty prop, DataEntitySerializerOption option) {
                if (prop instanceof DynamicLocaleProperty) {
                    return true;
                }
                return prop instanceof MulBasedataProp ? true : super.isSerializProperty(prop, option);
            }
        });
        String dataStr = DataEntitySerializer.serializerToString((Object)dynamicObject, (DataEntitySerializerOption)option);
        return dataStr;
    }
}

