/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InspectEventCenterUtil {
    private static final String QCP_INSPEC_APPLY = "qcp_inspecapply";
    private static final String QCPP_INSPEC_APPLY = "qcpp_manuinspecapply";
    private static final String QCAS_INSPEC_APPLY = "qcas_inspecapply";
    private static final String QCNP_INSPEC_APPLY = "qcnp_inspecapply";
    private static final String QCBD_INSPEC_APPLY = "qcp_inspecapbill_example";

    public static void operationListener(String entity, List<Long> billids, String operation) {
        switch (operation) {
            case "audit": {
                InspectEventCenterUtil.updateInspApplyStatus(entity, billids, "audit");
                break;
            }
            case "unaudit": {
                InspectEventCenterUtil.updateInspApplyStatus(entity, billids, "unaudit");
                break;
            }
        }
    }

    private static void updateInspApplyStatus(String entity, List<Long> billids, String opr) {
        DynamicObjectCollection srcbillentryids = QueryServiceHelper.query((String)entity, (String)"id,matintoentity.srcbillentryid", (QFilter[])new QFilter("id", "in", billids).toArray());
        LinkedList<DynamicObject> materials = new LinkedList<DynamicObject>();
        for (Long id : billids) {
            Set<Long> billEnrySet = srcbillentryids.stream().filter(x -> id.equals(x.getLong("id"))).map(x -> x.getLong("matintoentity.srcbillentryid")).collect(Collectors.toSet());
            materials.addAll(InspectEventCenterUtil.auditUpdate(id, entity, opr, billEnrySet));
        }
        if (!materials.isEmpty()) {
            DynamicObject[] materialsArr = materials.toArray(new DynamicObject[materials.size()]);
            SaveServiceHelper.update((DynamicObject[])materialsArr);
        }
    }

    private static List<DynamicObject> auditUpdate(Long id, String srcBillType, String operate, Set<Long> billentryset) {
        LinkedList<DynamicObject> retList = new LinkedList<DynamicObject>();
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)srcBillType, (Long[])new Long[]{id});
        if (sourceBills == null || sourceBills.isEmpty()) {
            return retList;
        }
        List<String> sourceBillTypes = Arrays.asList(QCP_INSPEC_APPLY, QCPP_INSPEC_APPLY, QCAS_INSPEC_APPLY, QCNP_INSPEC_APPLY, QCBD_INSPEC_APPLY);
        sourceBills.keySet().stream().filter(sourceBillTypes::contains).forEach(key -> retList.addAll(InspectEventCenterUtil.updateInspecApply(sourceBills, key, operate, billentryset)));
        return retList;
    }

    private static List<DynamicObject> updateInspecApply(Map<String, HashSet<Long>> sourceBills, String billType, String operate, Set<Long> billentryset) {
        ArrayList<DynamicObject> materials = new ArrayList<DynamicObject>();
        for (Long sourceId : sourceBills.get(billType)) {
            DynamicObject applyitem = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)billType);
            DynamicObjectCollection materialentry = (DynamicObjectCollection)applyitem.get("materialentry");
            if ("audit".equals(operate)) {
                for (DynamicObject material : materialentry) {
                    BigDecimal joinqty = material.getBigDecimal("joinqty");
                    BigDecimal applyqty = material.getBigDecimal("applyqty");
                    if (joinqty.compareTo(BigDecimal.ZERO) <= 0 || joinqty.compareTo(applyqty) != 0 || !billentryset.contains(material.getPkValue())) continue;
                    material.set("inspectstatus", (Object)Character.valueOf('C'));
                    materials.add(material);
                }
                continue;
            }
            for (DynamicObject material : materialentry) {
                if (!billentryset.contains(material.getPkValue())) continue;
                material.set("inspectstatus", (Object)Character.valueOf('B'));
                materials.add(material);
            }
        }
        return materials;
    }
}

