/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.impl.ORMImpl;

public class MainEntityTypeUtil {
    public static String getTableName(MainEntityType mainEntityType, String entityName) {
        String tableName = "";
        Map entityTypeMap = mainEntityType.getAllEntities();
        EntityType entityType = (EntityType)entityTypeMap.get(entityName);
        if (entityType != null) {
            tableName = entityType.getAlias();
        }
        return tableName;
    }

    public static String getTableNameReal(MainEntityType mainEntityType, String entityName) {
        String tableName = "";
        Map entityTypeMap = mainEntityType.getAllEntities();
        DynamicObjectType entityType = (DynamicObjectType)entityTypeMap.get(entityName);
        if (entityType != null) {
            tableName = entityType.getAlias();
        }
        return tableName;
    }

    public static Boolean isInherit(String childName, String ancestorsName) {
        MainEntityType childEntityType = EntityMetadataCache.getDataEntityType((String)childName);
        String childInheritPath = childEntityType.getInheritPath();
        DBRoute route = new DBRoute("sys.meta");
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FID FROM T_META_ENTITYDESIGN ");
        sb.append("WHERE FNUMBER = '");
        sb.append(ancestorsName);
        sb.append("'");
        DataSet fids = DB.queryDataSet((String)"kd.qmc.qcbd.common.util.MainEntityTypeUtil", (DBRoute)route, (String)sb.toString());
        if (fids.hasNext()) {
            String fid = fids.next().getString("FID");
            return childInheritPath.contains(fid);
        }
        return Boolean.FALSE;
    }

    public static List<String> getInheritChildNumberLst(String ... parentEntityNumbers) {
        ArrayList<String> assDesignNumbers = new ArrayList<String>();
        for (String parentEntityNumber : parentEntityNumbers) {
            List<String> designFIDs = MainEntityTypeUtil.getEntityDesignFID("number", parentEntityNumber, new ArrayList<String>());
            ArrayList<String> assDesignFIDs = new ArrayList<String>();
            while ((designFIDs = MainEntityTypeUtil.getEntityDesignFID("fid", "", designFIDs)).size() > 0) {
                assDesignFIDs.addAll(designFIDs);
            }
            List<String> assDesignNumberSigle = MainEntityTypeUtil.getEntityDesignFNumber(assDesignFIDs);
            if (assDesignNumberSigle == null) continue;
            assDesignNumbers.addAll(assDesignNumberSigle);
        }
        return assDesignNumbers;
    }

    private static List<String> getEntityDesignFNumber(List<String> fids) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("SELECT FNumber FROM T_META_ENTITYDESIGN WHERE", new Object[0]);
        sb.appendIn("FID", fids.toArray());
        DataSet fidDS = DB.queryDataSet((String)"kd.qmc.qcbd.common.util.getEntityDesignFNumber", (DBRoute)DBRoute.meta, (SqlBuilder)sb);
        ORMImpl orm = new ORMImpl();
        DynamicObjectCollection fidObjs = orm.toPlainDynamicObjectCollection(fidDS);
        List<String> designFNumbers = fidObjs.stream().map(p -> p.getString("FNumber")).collect(Collectors.toList());
        return designFNumbers;
    }

    private static List<String> getEntityDesignFID(String type, String parentEntityNumber, List<String> fids) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("SELECT FID FROM T_META_ENTITYDESIGN WHERE", new Object[0]);
        if (StringUtils.equalsIgnoreCase((CharSequence)"number", (CharSequence)type)) {
            sb.appendIn("FNUMBER", new Object[]{parentEntityNumber});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"fid", (CharSequence)type)) {
            sb.appendIn("FPARENTID", fids.toArray());
        }
        DataSet fidDS = DB.queryDataSet((String)"kd.qmc.qcbd.common.util.getEntityDesignFID", (DBRoute)DBRoute.meta, (SqlBuilder)sb);
        ORMImpl orm = new ORMImpl();
        DynamicObjectCollection fidObjs = orm.toPlainDynamicObjectCollection(fidDS);
        List<String> designFIDs = fidObjs.stream().map(p -> p.getString("FID")).collect(Collectors.toList());
        return designFIDs;
    }
}

