/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;

public class OperationPrompt {
    public static List<String> getErrorMessage(OperationResult res) {
        ArrayList<String> errs = new ArrayList<String>(10);
        if (res.isSuccess()) {
            return errs;
        }
        List errInfos = res.getAllErrorOrValidateInfo();
        if (errInfos.size() > 0) {
            throw new KDBizException(((IOperateInfo)errInfos.get(0)).getMessage());
        }
        for (IOperateInfo errInfo : errInfos) {
            errs.add(errInfo.getMessage());
        }
        return errs;
    }

    public static String getErrorMessageStr(OperationResult res) {
        StringBuilder sbErr = new StringBuilder();
        List<String> errs = OperationPrompt.getErrorMessage(res);
        for (String err : errs) {
            sbErr.append(err);
            sbErr.append("\r\n");
        }
        return sbErr.toString();
    }

    public static String getOutErrMsgLog(OperationResult res) {
        StringBuilder sbErr = new StringBuilder();
        if (res.isSuccess()) {
            return "";
        }
        List errInfos = res.getAllErrorOrValidateInfo();
        for (IOperateInfo errInfo : errInfos) {
            sbErr.append(errInfo.getMessage());
            sbErr.append("\r\n");
        }
        String message = res.getMessage();
        if (message != null && message.length() > 0) {
            sbErr.append(message);
            sbErr.append("\r\n");
        }
        return sbErr.toString();
    }
}

