/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class ParameterUtil {
    private ParameterUtil() {
    }

    public static Boolean isPropertyTrue(IDataModel model, String property, Map<String, Boolean> cacheMap) {
        Long billType = DynamicObjDataUtil.getDataModelDynamicObjectData(model, "billtype").getLong("id");
        return ParameterUtil.isPropertyTrue((EntityType)model.getDataEntityType(), property, billType, cacheMap);
    }

    public static Boolean isPropertyTrue(EntityType entityType, String property, Long billType, Map<String, Boolean> cacheMap) {
        if (entityType instanceof BillEntityType) {
            String entityId = entityType.getName();
            String billTypePara = ((BillEntityType)entityType).getBillTypePara();
            if (null == billTypePara) {
                return null;
            }
            if (null == cacheMap) {
                return ParameterUtil.isPropertyTrue(entityId, billTypePara, billType, property);
            }
            String key = entityId.concat(billTypePara).concat(String.valueOf(billType)).concat(property);
            if (!cacheMap.containsKey(key)) {
                Boolean result = ParameterUtil.isPropertyTrue(entityId, billTypePara, billType, property);
                cacheMap.put(key, result);
            }
            return cacheMap.get(key);
        }
        return null;
    }

    public static Boolean isPropertyTrue(String entityId, String billTypePara, Long billType, String property) {
        DynamicObject paramObj;
        Object param = SystemParamServiceHelper.getBillTypeParameter((String)entityId, (String)billTypePara, (long)billType);
        if (param instanceof DynamicObject && (paramObj = (DynamicObject)param).containsProperty(property)) {
            return paramObj.getBoolean(property);
        }
        return null;
    }

    public static String getQmcSystemProp(String attrKey) {
        return ParameterUtil.getQmcSystemProp("qmcconfig_S", attrKey, null);
    }

    public static String getQmcSystemProp(String attrKey, Map<String, String> cacheMap) {
        return ParameterUtil.getQmcSystemProp("qmcconfig_S", attrKey, cacheMap);
    }

    public static String getQmcSystemProp(String number, String attrKey, Map<String, String> cacheMap) {
        if (StringUtils.isEmpty((CharSequence)number) || StringUtils.isEmpty((CharSequence)attrKey)) {
            return null;
        }
        if (null == cacheMap) {
            return ParameterUtil.getQmcSystemProp(number, attrKey);
        }
        String key = number.concat(attrKey);
        if (!cacheMap.containsKey(key)) {
            cacheMap.put(key, ParameterUtil.getQmcSystemProp(number, attrKey));
        }
        return cacheMap.get(key);
    }

    public static String getQmcSystemProp(String number, String attrKey) {
        String value = null;
        String field = String.format("%s.%s key, %s.%s value", "entryentity", "attrkey", "entryentity", "attrvalue");
        QFilter filter = new QFilter("number", "=", (Object)number).and("status", "=", (Object)"C").and(String.format("%s.%s", "entryentity", "attrkey"), "=", (Object)attrKey);
        DynamicObject propObj = QueryServiceHelper.queryOne((String)"qcbd_sysconfig", (String)field, (QFilter[])filter.toArray());
        if (null != propObj) {
            value = propObj.getString("value");
        }
        return value;
    }

    public static Map<String, String> getQmcSystemPropMap(String number) {
        return ParameterUtil.getQmcSystemPropMap(number, "attrvalue");
    }

    public static Map<String, String> getQmcSystemPropMapByTag(String number) {
        return ParameterUtil.getQmcSystemPropMap(number, "attrvalue_tag");
    }

    private static Map<String, String> getQmcSystemPropMap(String number, String value) {
        QFilter filter;
        Map<String, String> propMap = new HashMap<String, String>(16);
        String field = String.format("%s.%s key, %s.%s value", "entryentity", "attrkey", "entryentity", value);
        DynamicObjectCollection props = QueryServiceHelper.query((String)"qcbd_sysconfig", (String)field, (QFilter[])(filter = new QFilter("number", "=", (Object)number).and("status", "=", (Object)"C")).toArray());
        if (!props.isEmpty()) {
            propMap = props.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("key"))).collect(Collectors.toMap(x -> x.getString("key"), x -> x.getString("value"), (a, b) -> a));
        }
        return propMap;
    }
}

