/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class RptListUtil {
    private RptListUtil() {
    }

    public static DataSet buildDataSet(String algoKey, String[] fields, DataType[] dataTypes, Collection<Object[]> datas, String[] orders) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])dataTypes);
        CollectionInput inputs = new CollectionInput(rowMeta, datas);
        if (null != orders) {
            return Algo.create((String)algoKey).createDataSet(new Input[]{inputs}).orderBy(orders);
        }
        return Algo.create((String)algoKey).createDataSet(new Input[]{inputs});
    }

    public static DataSet groupByDatas(List<Object[]> resultCollection, String algoName, String[] fields, DataType[] dataTypes, String[] groups, String[] orders) {
        DataSet tempDateSet = RptListUtil.buildDataSet(algoName, fields, dataTypes, resultCollection, orders);
        GroupbyDataSet groupbyDataSet = tempDateSet.groupBy(groups);
        GroupbyDataSet count = groupbyDataSet.count();
        return count.finish();
    }

    public static Long getOrgId(List<QFilter> filter) {
        List org = filter.stream().filter(x -> "org".equals(x.getProperty())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(org) || ((List)((QFilter)org.get(0)).getValue()).size() > 1) {
            return -1L;
        }
        return (Long)((List)((QFilter)org.get(0)).getValue()).get(0);
    }

    public static List getSelects(DynamicObjectCollection collection, String keyId) {
        return collection.stream().map(x -> x.get(keyId)).collect(Collectors.toList());
    }

    public static List getSelects(DynamicObjectCollection collection) {
        return RptListUtil.getSelects(collection, "fbasedataid_id");
    }
}

