/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.qmc.qcbd.common.util.OrgUnitUtil;
import kd.qmc.qcbd.common.util.RptListUtil;

public class TargetConfUtil {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String ENTITYID = "entityid";
    private static final String ORG = "org";
    private static final String QCBD_TARGET_CONF = "qcbd_target_conf";

    private TargetConfUtil() {
    }

    public static Map<String, Object> getTargetSingle(String entityId, List<Long> orgIds) {
        Long orgId = -1L;
        if (null != orgIds && 1 == orgIds.size()) {
            orgId = orgIds.get(0);
        }
        return TargetConfUtil.getTarget(entityId, orgId);
    }

    public static Map<Long, Map<String, Object>> getTarget(String entityId, Object[] orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter(ENTITYID, "=", (Object)entityId), new QFilter(ORG, "in", (Object)orgIds)};
        return TargetConfUtil.queryTarget(filters);
    }

    private static Map<Long, Map<String, Object>> queryTarget(QFilter[] filters) {
        LinkedList<Target> targets = new LinkedList<Target>();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)QCBD_TARGET_CONF, (String)"org,confentry.name,confentry.value", (QFilter[])filters);
        for (DynamicObject target : collection) {
            Target tempTarget = new Target();
            tempTarget.org = target.getLong(ORG);
            tempTarget.name = target.getString("confentry.name");
            tempTarget.value = target.get("confentry.value");
            targets.add(tempTarget);
        }
        Map<Long, List<Target>> targetGroup = targets.stream().collect(Collectors.groupingBy(x -> ((Target)x).org));
        HashMap<Long, Map<String, Object>> retMap = new HashMap<Long, Map<String, Object>>(targetGroup.size());
        Set<Map.Entry<Long, List<Target>>> targetEntrySet = targetGroup.entrySet();
        for (Map.Entry<Long, List<Target>> targetEntry : targetEntrySet) {
            retMap.put(targetEntry.getKey(), TargetConfUtil.getTargetConf(targetEntry.getValue()));
        }
        return retMap;
    }

    public static Map<String, Object> getTarget(String entityId, Long orgId) {
        HashMap targetMap = TargetConfUtil.getTarget(entityId, new Long[]{orgId}).get(orgId);
        return null == targetMap ? new HashMap(16) : targetMap;
    }

    public static Map<String, Object> getTarget(String entityId, List<QFilter> filters) {
        HashMap targetMap = TargetConfUtil.getTarget(entityId, RptListUtil.getOrgId(filters));
        return null == targetMap ? new HashMap(16) : targetMap;
    }

    public static Map<Long, Map<String, Object>> getTargetByUser(String entityId, Long userId, Boolean chooseOrg) {
        if (!chooseOrg.booleanValue()) {
            return TargetConfUtil.getTarget(entityId, new Object[]{-1L});
        }
        if (!PermissionServiceHelper.isAdminUser((long)userId)) {
            List<Long> orgs = TargetConfUtil.getUserOrgs(entityId, userId);
            if (CollectionUtils.isEmpty(orgs)) {
                return new HashMap<Long, Map<String, Object>>(16);
            }
            return TargetConfUtil.getTarget(entityId, orgs.toArray());
        }
        return TargetConfUtil.getTarget(entityId, chooseOrg);
    }

    public static Map<Long, Map<String, Object>> getTargetByUser(String entityId, Long userId, Boolean chooseOrg, IFormView view) {
        if (!chooseOrg.booleanValue()) {
            return TargetConfUtil.getTarget(entityId, new Object[]{-1L});
        }
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
        String appId = view.getFormShowParameter().getAppId();
        if (!OrgUnitUtil.getHasAllOrgPer(userId, appId, entityTypeId)) {
            List<Long> orgs = TargetConfUtil.getUserOrgs(entityId, userId, view);
            if (CollectionUtils.isEmpty(orgs)) {
                return new HashMap<Long, Map<String, Object>>(16);
            }
            return TargetConfUtil.getTarget(entityId, orgs.toArray());
        }
        return TargetConfUtil.getTarget(entityId, chooseOrg);
    }

    public static List<Long> getUserOrgs(String entityId, Long userId) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
        String appId = FormMetadataCache.getFormConfig((String)entityId).getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityTypeId, (String)"47150e89000000ac");
        return allPermOrgs.getHasPermOrgs();
    }

    public static List<Long> getUserOrgs(String entityId, Long userId, IFormView view) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
        String appId = view.getFormShowParameter().getAppId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityTypeId, (String)"47150e89000000ac");
        return allPermOrgs.getHasPermOrgs();
    }

    public static Map<Long, Map<String, Object>> getTarget(String entityId, Boolean chooseOrg) {
        QFilter[] filters = new QFilter[]{new QFilter(ENTITYID, "=", (Object)entityId), chooseOrg != false ? new QFilter(ORG, "!=", (Object)-1L) : new QFilter(ORG, "=", (Object)-1L)};
        return TargetConfUtil.queryTarget(filters);
    }

    public static Map<String, Object> getTargetConf(List<Target> targets) {
        HashMap<String, Object> targetMap = new HashMap<String, Object>(16);
        targets.forEach(x -> targetMap.put(((Target)x).name, ((Target)x).value));
        return targetMap;
    }

    public static void saveTarget(String entityId, DynamicObjectCollection entryEntity, Boolean chooseOrg) {
        long userId = UserServiceHelper.getCurrentUserId();
        TargetConfUtil.deleteTargetsByUser(entityId, userId, chooseOrg);
        LinkedList datas = new LinkedList();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("userId", userId);
        params.put("chooseOrg", chooseOrg);
        params.put(ENTITYID, entityId);
        entryEntity.forEach(e -> TargetConfUtil.buildSingleTarget(params, datas, e));
        SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[datas.size()]));
    }

    public static void saveTarget(String entityId, DynamicObjectCollection entryEntity, Boolean chooseOrg, IFormView view) {
        long userId = UserServiceHelper.getCurrentUserId();
        TargetConfUtil.deleteTargetsByUser(entityId, userId, chooseOrg, view);
        LinkedList datas = new LinkedList();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("userId", userId);
        params.put("chooseOrg", chooseOrg);
        params.put(ENTITYID, entityId);
        entryEntity.forEach(e -> TargetConfUtil.buildSingleTarget(params, datas, e));
        SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[datas.size()]));
    }

    private static void buildSingleTarget(Map<String, Object> params, List<DynamicObject> datas, DynamicObject e) {
        DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)QCBD_TARGET_CONF);
        Object userId = params.get("userId");
        Boolean chooseOrg = (Boolean)params.get("chooseOrg");
        Long org = -1L;
        if (chooseOrg.booleanValue()) {
            org = (Long)e.getDynamicObject(ORG).getPkValue();
        }
        target.set("billno", (Object)org);
        target.set(ENTITYID, params.get(ENTITYID));
        target.set(ORG, (Object)org);
        target.set("creator", userId);
        target.set("auditor", userId);
        target.set("billstatus", (Object)"C");
        Date now = KDDateUtils.now();
        target.set("createtime", (Object)now);
        target.set("auditdate", (Object)now);
        target.set("modifytime", (Object)now);
        DynamicObjectCollection confentry = target.getDynamicObjectCollection("confentry");
        target.set("confentry", (Object)confentry);
        DynamicObjectType objType = confentry.getDynamicObjectType();
        DynamicObject batchpassrate = new DynamicObject(objType);
        batchpassrate.set(NAME, (Object)"batchpassrate");
        batchpassrate.set(VALUE, e.get("batchpassrate"));
        confentry.add((Object)batchpassrate);
        DynamicObject batchunpassrate = new DynamicObject(objType);
        batchunpassrate.set(NAME, (Object)"batchunpassrate");
        batchunpassrate.set(VALUE, e.get("batchunpassrate"));
        confentry.add((Object)batchunpassrate);
        DynamicObject passrate = new DynamicObject(objType);
        passrate.set(NAME, (Object)"passrate");
        passrate.set(VALUE, e.get("passrate"));
        confentry.add((Object)passrate);
        DynamicObject unpassrate = new DynamicObject(objType);
        unpassrate.set(NAME, (Object)"unpassrate");
        unpassrate.set(VALUE, e.get("unpassrate"));
        confentry.add((Object)unpassrate);
        DynamicObject ppmtarget = new DynamicObject(objType);
        ppmtarget.set(NAME, (Object)"ppmtarget");
        ppmtarget.set(VALUE, e.get("ppmtarget"));
        confentry.add((Object)ppmtarget);
        datas.add(target);
    }

    public static void deleteTargetsByUser(String entityId, Long userId, Boolean chooseOrg) {
        if (!PermissionServiceHelper.isAdminUser((long)userId)) {
            List<Long> orgs = TargetConfUtil.getUserOrgs(entityId, userId);
            if (!CollectionUtils.isEmpty(orgs)) {
                TargetConfUtil.deleteTargets(entityId, orgs, chooseOrg);
            }
        } else {
            TargetConfUtil.deleteTargets(entityId, chooseOrg);
        }
    }

    public static void deleteTargetsByUser(String entityId, Long userId, Boolean chooseOrg, IFormView view) {
        String entityTypeId = FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
        String appId = view.getFormShowParameter().getAppId();
        if (!OrgUnitUtil.getHasAllOrgPer(userId, appId, entityTypeId)) {
            List<Long> orgs = TargetConfUtil.getUserOrgs(entityId, userId, view);
            if (!CollectionUtils.isEmpty(orgs)) {
                TargetConfUtil.deleteTargets(entityId, orgs, chooseOrg);
            }
        } else {
            TargetConfUtil.deleteTargets(entityId, chooseOrg);
        }
    }

    public static void deleteTargets(String entityId, Boolean chooseOrg) {
        QFilter[] filters = new QFilter[]{new QFilter(ENTITYID, "=", (Object)entityId), chooseOrg != false ? new QFilter(ORG, "!=", (Object)-1L) : new QFilter(ORG, "=", (Object)-1L)};
        DeleteServiceHelper.delete((String)QCBD_TARGET_CONF, (QFilter[])filters);
    }

    public static void deleteTargets(String entityId, List<Long> orgId, Boolean chooseOrg) {
        QFilter[] filters = new QFilter[]{new QFilter(ENTITYID, "=", (Object)entityId), chooseOrg != false ? new QFilter(ORG, "in", orgId) : new QFilter(ORG, "=", (Object)-1L)};
        DeleteServiceHelper.delete((String)QCBD_TARGET_CONF, (QFilter[])filters);
    }

    private static class Target {
        private Long org;
        private String name;
        private Object value;

        private Target() {
        }
    }
}

