/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.common.util.ParameterUtil;

public class UpgradeSqlUtil {
    private static Log logger = LogFactory.getLog(UpgradeSqlUtil.class);
    private static final int rows = 50;
    private static final String dbRouteStr = "qmc";
    private static final String[] inspect_table_arr = new String[]{"t_qcp_inspbill", "t_qcpp_inspbill", "t_qcas_inspbill", "t_qcnp_inspbill"};

    public static Map<String, Object> buildSelectParam(String tab, List<String> fields, Map<String, Object> filterMap, String pkName, String afterFix) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append(String.join((CharSequence)",", fields)).append(",").append(pkName);
        sb.append(" FROM ").append(tab);
        return UpgradeSqlUtil.buildsqlRetParam(filterMap, sb, afterFix);
    }

    public static String buildUpdateStr(String tab, List<String> fields, String pkName) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(tab);
        sb.append(" SET ");
        sb.append(String.join((CharSequence)" =? ,", fields)).append(" =?");
        sb.append(" WHERE ").append(pkName).append(" =? ");
        return sb.toString();
    }

    private static Map<String, Object> buildsqlRetParam(Map<String, Object> filterMap, StringBuilder sb, String afterFix) {
        LinkedList valList = new LinkedList();
        sb.append(" WHERE 1 = 1 ");
        if (kd.bos.util.StringUtils.isNotEmpty((String)afterFix)) {
            sb.append(afterFix);
        }
        filterMap.forEach((fieldName, fieldVal) -> {
            sb.append(" AND ").append((String)fieldName).append(" =? ");
            valList.add(fieldVal);
        });
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        retMap.put("sqlStr", sb.toString());
        retMap.put("sqlParam", valList.toArray());
        return retMap;
    }

    public static UpgradeResult insertSelect(String className, String oldTab, String newTab, String pkName, List<String> fields, String parentTab, String parentPk, Map<String, Object> filters) {
        UpgradeResult result = new UpgradeResult();
        DBRoute dbRoute = new DBRoute(dbRouteStr);
        String batchSizeStr = ParameterUtil.getQmcSystemProp("repairedatacfg", "oncenumberbill");
        int batchSize = kd.bos.util.StringUtils.isEmpty((String)batchSizeStr) ? 10000 : Integer.parseInt(batchSizeStr);
        DataSet pkIdSet = UpgradeSqlUtil.getPkIds(className, oldTab, newTab, pkName, fields, parentTab, parentPk, filters);
        LinkedList<Object> pkIdList = new LinkedList<Object>();
        while (pkIdSet.hasNext()) {
            Row row = pkIdSet.next();
            pkIdList.add(row.get(pkName));
            if (batchSize != pkIdList.size()) continue;
            result = UpgradeSqlUtil.batchExecuteInsert(className, oldTab, newTab, pkName, fields, parentPk, dbRoute, pkIdList);
            pkIdList.clear();
        }
        if (!pkIdList.isEmpty()) {
            result = UpgradeSqlUtil.batchExecuteInsert(className, oldTab, newTab, pkName, fields, parentPk, dbRoute, pkIdList);
        }
        return result;
    }

    public static DataSet getPkIds(String className, String oldTab, String newTab, String pkName, List<String> fields, String parentTab, String parentPk, Map<String, Object> filters) {
        StringBuilder oldTabSqlStr = new StringBuilder();
        StringBuilder newTabSqlStr = new StringBuilder();
        oldTabSqlStr.append("SELECT ").append(pkName).append(" FROM ").append(oldTab).append(" WHERE 1=1 ");
        newTabSqlStr.append("SELECT ").append(pkName).append(" FROM ").append(newTab).append(" WHERE 1=1 ");
        if (kd.bos.util.StringUtils.isNotEmpty((String)parentTab) && kd.bos.util.StringUtils.isNotEmpty((String)parentPk)) {
            StringBuilder afBuilder = new StringBuilder();
            afBuilder.append("AND ").append(parentPk).append(" IN ").append(" ( SELECT ").append(parentPk).append(" FROM ").append(parentTab).append(" )");
            fields.add(parentPk);
            oldTabSqlStr.append((CharSequence)afBuilder);
            newTabSqlStr.append((CharSequence)afBuilder);
        } else if (filters.containsKey("fbilltype")) {
            oldTabSqlStr.append("AND FBILLTYPE = ").append(filters.get("fbilltype"));
            newTabSqlStr.append("AND FBILLTYPE = ").append(filters.get("fbilltype"));
        }
        DataSet oldTabSet = DB.queryDataSet((String)className, (DBRoute)new DBRoute(dbRouteStr), (String)oldTabSqlStr.toString());
        DataSet newTabSet = DB.queryDataSet((String)className, (DBRoute)new DBRoute(dbRouteStr), (String)newTabSqlStr.toString());
        DataSetBuilder dataSetBuilder = Algo.create((String)className).createDataSetBuilder(oldTabSet.getRowMeta());
        CachedDataSet newTabCache = newTabSet.cache(new CacheHint());
        Set newIdSet = newTabCache.getList(0, newTabCache.getRowCount()).stream().map(x -> x.get(pkName)).collect(Collectors.toSet());
        while (oldTabSet.hasNext()) {
            Row row = oldTabSet.next();
            if (newIdSet.contains(row.get(pkName))) continue;
            dataSetBuilder.append(row);
        }
        newTabCache.close();
        return dataSetBuilder.build();
    }

    private static UpgradeResult batchExecuteInsert(String className, String oldTab, String newTab, String pkName, List<String> fields, String parentPk, DBRoute dbRoute, List<Object> pkIdList) {
        Object pkValue;
        if (kd.bos.util.StringUtils.isNotNull((String)parentPk) && !fields.contains(parentPk)) {
            fields.add(parentPk);
        }
        String fieldFormatStr = String.join((CharSequence)",", fields);
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(newTab).append(" ( ").append(fieldFormatStr).append(" )");
        sb.append(" SELECT ").append(fieldFormatStr).append(" FROM ").append(oldTab);
        sb.append(" WHERE ").append(pkName).append(" IN ( ");
        int size = pkIdList.size();
        if (size > 1) {
            for (int i = 0; i < size - 1; ++i) {
                Object pkValue2 = pkIdList.get(i);
                if (pkValue2 instanceof String) {
                    sb.append("'").append(pkValue2).append("'").append(",");
                    continue;
                }
                sb.append(pkValue2).append(",");
            }
        }
        if ((pkValue = pkIdList.get(size - 1)) instanceof String) {
            sb.append("'").append(pkValue).append("'");
        } else {
            sb.append(pkValue);
        }
        sb.append(" )");
        return UpgradeSqlUtil.excuteSqlNoTransaction(sb.toString(), dbRoute, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UpgradeResult batchUpdate(String className, List<String> fields, String oldTab, Map<String, Object> oldFilter, String newTab, String pkName) {
        DBRoute dbRoute = new DBRoute(dbRouteStr);
        UpgradeResult result = new UpgradeResult();
        LinkedList<Object[]> paramList = new LinkedList<Object[]>();
        StringBuilder afterFixSb = new StringBuilder();
        afterFixSb.append(" AND ").append(pkName).append(" IN ( SELECT ").append(pkName);
        afterFixSb.append(" FROM ").append(newTab).append(" )");
        Map<String, Object> selectParam = UpgradeSqlUtil.buildSelectParam(oldTab, fields, oldFilter, pkName, afterFixSb.toString());
        String updStr = UpgradeSqlUtil.buildUpdateStr(newTab, fields, pkName);
        try (DataSet ds = DB.queryDataSet((String)className, (DBRoute)dbRoute, (String)((String)selectParam.get("sqlStr")), (Object[])((Object[])selectParam.get("sqlParam")));){
            if (ds.isEmpty()) {
                UpgradeResult upgradeResult = UpgradeSqlUtil.buildResult(result, true, "query data is empty.");
                return upgradeResult;
            }
            logger.info("query execute successful.");
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                LinkedList<Object> params = new LinkedList<Object>();
                fields.forEach(fieldName -> params.add(row.get(fieldName)));
                params.add(row.get(pkName));
                paramList.add(params.toArray());
                if (paramList.size() < 50 && ds.hasNext()) continue;
                result = UpgradeSqlUtil.excuteSqlBatch(className, updStr, dbRoute, paramList);
            }
            return UpgradeSqlUtil.buildResult(result, true, "batchUpdate success.");
        }
        catch (Exception e) {
            return UpgradeSqlUtil.buildResult(result, false, "query data field failed,errorMsgInfo\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static UpgradeResult excuteSqlBatch(String className, String executeSqlStr, DBRoute dbRoute, List<Object[]> paramList) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle h = TX.required((String)className);){
            try {
                DB.executeBatch((DBRoute)dbRoute, (String)executeSqlStr, paramList);
                paramList.clear();
            }
            catch (Exception e) {
                h.markRollback();
                UpgradeResult upgradeResult = UpgradeSqlUtil.buildResult(result, false, "database execution failed,errorInfo\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                if (h != null) {
                    if (var6_6 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
            UpgradeResult upgradeResult = UpgradeSqlUtil.buildResult(result, true, "database execution sucess");
            return upgradeResult;
        }
    }

    public static UpgradeResult excuteSqlBatchNoTransaction(String executeSqlStr, DBRoute dbRoute, List<Object[]> paramList) {
        UpgradeResult result = new UpgradeResult();
        try {
            DB.executeBatch((DBRoute)dbRoute, (String)executeSqlStr, paramList);
            paramList.clear();
        }
        catch (Exception e) {
            return UpgradeSqlUtil.buildResult(result, false, "database execution failed,errorInfo\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return UpgradeSqlUtil.buildResult(result, true, "database execution sucess");
    }

    public static UpgradeResult excuteSqlNoTransaction(String executeSqlStr, DBRoute dbRoute, Object[] params) {
        UpgradeResult result = new UpgradeResult();
        try {
            DB.execute((DBRoute)dbRoute, (String)executeSqlStr, (Object[])params);
        }
        catch (Exception e) {
            return UpgradeSqlUtil.buildResult(result, false, "database execution failed,errorInfo\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return UpgradeSqlUtil.buildResult(result, true, "database execution sucess");
    }

    public static UpgradeResult excuteSql(String className, String executeSqlStr, DBRoute dbRoute, Object[] params) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle h = TX.required((String)className);){
            try {
                DB.execute((DBRoute)dbRoute, (String)executeSqlStr, (Object[])params);
            }
            catch (Exception e) {
                h.markRollback();
                UpgradeResult upgradeResult = UpgradeSqlUtil.buildResult(result, false, "database execution failed,errorInfo\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                if (h != null) {
                    if (var6_6 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
            UpgradeResult upgradeResult = UpgradeSqlUtil.buildResult(result, true, "database execution sucess");
            return upgradeResult;
        }
    }

    public static UpgradeResult buildResult(UpgradeResult result, boolean isSucess, String message) {
        result.setSuccess(isSucess);
        result.setLog(message);
        logger.info(message);
        if (!isSucess) {
            result.setErrorInfo(message);
        }
        return result;
    }

    public static DataSet queryDataSet(String alogKey, String selectFields, String tabName, String filter) {
        DBRoute dbRoute = new DBRoute(dbRouteStr);
        StringBuilder sql = new StringBuilder("select ");
        sql.append(selectFields);
        sql.append(" from ");
        sql.append(tabName);
        if (StringUtils.isNotBlank((CharSequence)"filter")) {
            sql.append(filter);
        }
        return DB.queryDataSet((String)alogKey, (DBRoute)dbRoute, (String)sql.toString());
    }

    public static UpgradeResult updateBySqlBuild(DBRoute dbRoute, SqlBuilder updateSql) {
        UpgradeResult result = new UpgradeResult();
        try {
            DB.update((DBRoute)dbRoute, (SqlBuilder)updateSql);
        }
        catch (Exception e) {
            return UpgradeSqlUtil.buildResult(result, false, "database execution failed,errorInfo\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return UpgradeSqlUtil.buildResult(result, true, "database execution sucess");
    }

    public static boolean existRecord(String alogKey, DBRoute dbRoute, String tableName) {
        boolean result = false;
        boolean exitsTable = DB.exitsTable((DBRoute)dbRoute, (String)tableName);
        if (exitsTable) {
            SqlBuilder sql = new SqlBuilder();
            sql.append(String.format("select top 1 fid from %s", tableName), new Object[0]);
            DataSet rows = DB.queryDataSet((String)alogKey, (DBRoute)dbRoute, (SqlBuilder)sql);
            if (rows.iterator().hasNext()) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isNewCustomer(String alogkey) {
        DBRoute dbRoute = new DBRoute(dbRouteStr);
        for (String inspectTableStr : inspect_table_arr) {
            if (!UpgradeSqlUtil.existRecord(alogkey, dbRoute, inspectTableStr)) continue;
            return false;
        }
        return true;
    }
}

