/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.common.enums.BizTypeEnum;

public class WideStrictRecUtil {
    public static Map<String, Object> getWsInfoByMat(DynamicObject inspect, DynamicObject inspectEntry) {
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        long orgId = inspect.getDynamicObject("org").getLong("id");
        long wsId = inspectEntry.getDynamicObject("wsrule").getLong("id");
        DynamicObject wsRuleEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)wsId, (String)"qcbd_widstrict_rule");
        DynamicObjectCollection wsRuleEntrys = wsRuleEntity.getDynamicObjectCollection("entryentity");
        DynamicObject bizTypeObj = inspect.getDynamicObject("biztype");
        String bizType = bizTypeObj.getString("number");
        if (!BizTypeEnum.QCP_001.getValue().equals(bizType) && !BizTypeEnum.QCPP_004.getValue().equals(bizType)) {
            return retMap;
        }
        String selectFields = "material, supplier, oprworkshop, org, billtype, biztype, wsrule, createtime, resettime, billno, billstatus, inspectauditdate, curstage, nexstage, sapplan, jpendtm, jpleftnum";
        QFilter[] qFilters = WideStrictRecUtil.buildFilters(bizType, orgId, inspectEntry);
        DynamicObject wsRec = BusinessDataServiceHelper.loadSingle((String)"qcbd_widestrict_rec", (String)selectFields, (QFilter[])qFilters);
        if (null == wsRec) {
            WideStrictRecUtil.setDefaultStage(wsId, retMap);
        } else {
            Date matIncomeTime = inspect.getDate("createtime");
            DynamicObject nexstage = wsRec.getDynamicObject("nexstage");
            Date jpendtm = wsRec.getDate("jpendtm");
            Date resettime = wsRec.getDate("resettime");
            long recWsruleId = wsRec.getDynamicObject("wsrule").getLong("id");
            if (wsId != recWsruleId) {
                WideStrictRecUtil.setDefaultStage(wsId, retMap);
                return retMap;
            }
            if (null == matIncomeTime) {
                return retMap;
            }
            if (Objects.nonNull(resettime) && matIncomeTime.compareTo(resettime) > 0) {
                WideStrictRecUtil.setDefaultStage(wsId, retMap);
            } else if (null != jpendtm && matIncomeTime.compareTo(jpendtm) > 0 && "4".equals(nexstage.getString("number"))) {
                DynamicObject jumpRow = wsRuleEntrys.stream().filter(o -> o.getDynamicObject("currentstage").getLong("id") == nexstage.getLong("id")).findFirst().get();
                DynamicObject newNextStage = jumpRow.getDynamicObject("nextstage");
                if (Objects.nonNull(newNextStage)) {
                    retMap.put("currentstage", newNextStage);
                }
                retMap.put("sapplan", jumpRow.getDynamicObject("sapplan"));
            } else {
                retMap.put("currentstage", nexstage);
                retMap.put("sapplan", wsRec.getDynamicObject("sapplan"));
            }
        }
        return retMap;
    }

    private static void setDefaultStage(Long wsId, Map<String, Object> retMap) {
        DynamicObject startStage = WideStrictRecUtil.getDefaultStage(wsId);
        retMap.put("currentstage", startStage.getDynamicObject("currentstage"));
        retMap.put("sapplan", startStage.getDynamicObject("sapplan"));
    }

    private static DynamicObject getDefaultStage(Long wsId) {
        DynamicObject wsRuleObj = BusinessDataServiceHelper.loadSingle((Object)wsId, (String)"qcbd_widstrict_rule");
        DynamicObjectCollection stages = wsRuleObj.getDynamicObjectCollection("entryentity");
        return stages.stream().filter(x -> x.getBoolean("starttage")).findFirst().get();
    }

    public static QFilter[] buildFilters(String bizType, Long orgId, DynamicObject inspectEntry) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject material = inspectEntry.getDynamicObject("materialid");
        if (Objects.nonNull(material)) {
            qFilter.and("material", "=", material.getPkValue());
        }
        qFilter.and("biztype.number", "=", (Object)bizType);
        qFilter.and("billstatus", "=", (Object)"C");
        if (BizTypeEnum.QCP_001.getValue().equals(bizType)) {
            IDataEntityProperty supplierPro = (IDataEntityProperty)inspectEntry.getDataEntityType().getProperties().get((Object)"supplier");
            if (Objects.nonNull(supplierPro)) {
                DynamicObject supplier = inspectEntry.getDynamicObject("supplier");
                if (Objects.nonNull(supplier)) {
                    qFilter.and("supplier", "=", supplier.getPkValue());
                } else {
                    qFilter.and(new QFilter("supplier", "=", (Object)0L));
                }
            }
        } else if (BizTypeEnum.QCPP_004.getValue().equals(bizType)) {
            DynamicObject oprworkshop = inspectEntry.getDynamicObject("oprworkshop");
            if (Objects.nonNull(oprworkshop)) {
                qFilter.and("oprworkshop", "=", oprworkshop.getPkValue());
            } else {
                qFilter.and(new QFilter("oprworkshop", "=", (Object)0L));
            }
        }
        return new QFilter[]{qFilter};
    }

    public static void updateOldRec(String entity, List<String> billids) {
        DynamicObjectCollection inspects = WideStrictRecUtil.getInspectInfos(entity, billids);
        DynamicObject[] recInfoArray = WideStrictRecUtil.getRecInfos(inspects);
        List inspectEntryIds = inspects.stream().map(o -> o.getString("matintoentity.id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("entryentity.billid", "in", billids);
        DynamicObject[] recInfoOldCol = BusinessDataServiceHelper.load((String)"qcbd_widestrict_rec", (String)"id,entryentity.billid,entryentity.billentry,entryentity.status,entryentity.deletedt", (QFilter[])qFilter.toArray());
        for (DynamicObject recInfo : recInfoOldCol) {
            DynamicObjectCollection renEntrys = recInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject renEntry : renEntrys) {
                if (inspectEntryIds.contains(renEntry.getString("billentry")) || !billids.contains(renEntry.getString("billid"))) continue;
                renEntry.set("status", (Object)"delete");
                renEntry.set("deletedt", (Object)new Date());
            }
        }
        SaveServiceHelper.save((DynamicObject[])recInfoOldCol);
        block2: for (DynamicObject inspect : inspects) {
            String billno = inspect.getString("billno");
            if (Objects.isNull(inspect.get("matintoentity.wsrule"))) continue;
            for (DynamicObject recInfo : recInfoArray) {
                boolean matchRec = WideStrictRecUtil.matchRec(inspect, recInfo, entity);
                if (!matchRec) continue;
                DynamicObjectCollection wsRecEntrys = recInfo.getDynamicObjectCollection("entryentity");
                DynamicObject wsRecEntry = wsRecEntrys.stream().filter(o -> StringUtils.equals((CharSequence)inspect.getString("matintoentity.id"), (CharSequence)o.getString("billentry"))).findFirst().get();
                wsRecEntry.set("etybillno", (Object)billno);
                continue block2;
            }
        }
        SaveServiceHelper.save((DynamicObject[])recInfoArray);
    }

    public static void addRec(String entity, List<String> billids, String operation) {
        DynamicObjectCollection inspects = WideStrictRecUtil.getInspectInfos(entity, billids);
        LinkedList<DynamicObject> recObjList = new LinkedList<DynamicObject>();
        if (CollectionUtils.isEmpty((Collection)inspects)) {
            return;
        }
        DynamicObject[] recInfoArray = WideStrictRecUtil.getRecInfos(inspects);
        List recInfoList = Arrays.stream(recInfoArray).collect(Collectors.toList());
        for (DynamicObject inspect : inspects) {
            Date recvDate = inspect.getDate("createtime");
            if (inspect.getBoolean("matintoentity.secondck")) continue;
            DynamicObject recObj = new DynamicObject();
            boolean matchRec = false;
            for (DynamicObject recInfo : recInfoList) {
                matchRec = WideStrictRecUtil.matchRec(inspect, recInfo, entity);
                if (!matchRec) continue;
                recObj = recInfo;
                break;
            }
            if (!matchRec) {
                if ("unaudit".equals(operation)) {
                    return;
                }
                recObj = WideStrictRecUtil.buildWsRecObj(entity, inspect, recvDate, operation);
                recInfoList.add(recObj);
            } else {
                Iterator iterator = recObjList.iterator();
                while (iterator.hasNext()) {
                    DynamicObject next = (DynamicObject)iterator.next();
                    if (!Objects.equals(next.getPkValue(), recObj.getPkValue())) continue;
                    DynamicObjectCollection entrys = next.getDynamicObjectCollection("entryentity");
                    recObj.set("entryentity", (Object)entrys);
                    iterator.remove();
                }
                WideStrictRecUtil.dealWsRecEtys(entity, inspect, recvDate, recObj, operation);
            }
            recObjList.add(recObj);
        }
        for (DynamicObject recObj : recObjList) {
            WideStrictRecUtil.dealNextStage(recObj, operation);
        }
        SaveServiceHelper.save((DynamicObject[])recObjList.toArray(new DynamicObject[0]));
    }

    private static void dealNextStage(DynamicObject recObj, String operation) {
        DynamicObjectCollection inspectRecEntrys = recObj.getDynamicObjectCollection("entryentity");
        List<DynamicObject> entrys = inspectRecEntrys.stream().filter(o -> StringUtils.equals((CharSequence)"audit", (CharSequence)o.getString("status"))).collect(Collectors.toList());
        if (entrys.size() == 0) {
            WideStrictRecUtil.dealNoAuditRec(recObj);
            return;
        }
        Collections.reverse(entrys);
        DynamicObject recEntryFirst = (DynamicObject)entrys.get(0);
        DynamicObject wsRule = recEntryFirst.getDynamicObject("etywsrule");
        long wsRuleId = wsRule.getLong("id");
        long recFirstStageId = recEntryFirst.getDynamicObject("wsstagec").getLong("id");
        DynamicObject currentStageRow = WideStrictRecUtil.getStageObj(wsRuleId, recFirstStageId);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("isReSet", false);
        map.put("emptyBill", false);
        DynamicObject recNexStage = recObj.getDynamicObject("nexstage");
        if (Objects.isNull(recNexStage)) {
            map.put("curStageId", currentStageRow.getLong("entryentity.currentstage"));
            map.put("nextStageId", currentStageRow.getLong("entryentity.currentstage"));
        } else {
            map.put("curStageId", recObj.getLong("curstage.id"));
            map.put("nextStageId", recNexStage.getLong("id"));
        }
        WideStrictRecUtil.acceptNextStage(entrys, currentStageRow, recObj, map);
        if (!((Boolean)map.get("isReSet")).booleanValue()) {
            WideStrictRecUtil.rejectNextStage(entrys, currentStageRow, recObj, map);
        }
        long nextStageId = (Long)map.get("nextStageId");
        long curStageId = (Long)map.get("curStageId");
        recObj.set("curstage", (Object)curStageId);
        recObj.set("nexstage", (Object)nextStageId);
        if (!((Boolean)map.get("emptyBill")).booleanValue()) {
            recObj.set("billno", (Object)recEntryFirst.getString("etybillno"));
            recObj.set("inspectauditdate", (Object)recEntryFirst.getDate("auditdtlast"));
        }
        recObj.set("inspectpro", (Object)recEntryFirst.getDynamicObject("etyinspectpro"));
        if ("audit".equals(operation)) {
            recObj.set("wsrule", (Object)recEntryFirst.getDynamicObject("etywsrule"));
        }
        DynamicObject matchStage = wsRule.getDynamicObjectCollection("entryentity").stream().filter(o -> o.getLong("currentstage.id") == nextStageId).findFirst().get();
        recObj.set("sapplan", (Object)matchStage.getDynamicObject("sapplan"));
        if ((Long)map.get("nextStageId") != 1144849808217878528L && (Long)map.get("curStageId") != 1144849808217878528L) {
            recObj.set("jpendtm", null);
            recObj.set("jpleftnum", (Object)0);
        }
        WideStrictRecUtil.computeResetTime(recObj);
    }

    private static void dealNoAuditRec(DynamicObject recObj) {
        DynamicObject curstage = recObj.getDynamicObject("curstage");
        recObj.set("nexstage", (Object)curstage);
        long wsRuleId = recObj.getDynamicObject("wsrule").getLong("id");
        DynamicObject curStageRow = WideStrictRecUtil.getStageObj(wsRuleId, curstage.getLong("id"));
        recObj.set("sapplan", (Object)curStageRow.getLong("entryentity.sapplan"));
        recObj.set("billno", null);
        recObj.set("inspectauditdate", null);
        if ("4".equals(curstage.getString("number"))) {
            recObj.set("jpleftnum", (Object)curStageRow.getLong("entryentity.contacceptnum"));
        } else {
            recObj.set("jpendtm", null);
            recObj.set("jpleftnum", (Object)0);
        }
    }

    private static DynamicObject getStageObj(long wsRuleId, long wsStage) {
        return QueryServiceHelper.queryOne((String)"qcbd_widstrict_rule", (String)"id, resetprd, entryentity.currentstage, entryentity.currentstage.number, entryentity.sapplan, entryentity.contacceptnum,entryentity.acceptvaliddt, entryentity.nextstage, entryentity.nextstage.number, entryentity.continspectnum, entryentity.rejectnum, entryentity.rnextstage", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)wsRuleId).and("entryentity.currentstage", "=", (Object)wsStage)});
    }

    private static void computeResetTime(DynamicObject recObj) {
        int resetPrd = recObj.getInt("wsrule.resetprd");
        if (0 != resetPrd) {
            DynamicObjectCollection entrys = recObj.getDynamicObjectCollection("entryentity");
            List auditDateLastList = entrys.stream().filter(o -> !"delete".equals(o.getString("status"))).map(o -> o.getDate("auditdtfst")).collect(Collectors.toList());
            Date endTime = (Date)Collections.max(auditDateLastList);
            Date resetTime = recObj.getDate("resettime");
            Date curResetTime = KDDateUtils.addDays((Date)endTime, (int)(resetPrd + 1));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curResetTime);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            curResetTime = calendar.getTime();
            if (null == resetTime || resetTime.compareTo(curResetTime) < 0) {
                recObj.set("resettime", (Object)curResetTime);
            }
        }
    }

    private static void acceptNextStage(List<DynamicObject> entrys, DynamicObject currentStageRow, DynamicObject recObj, Map<String, Object> map) {
        Date jpendTime;
        map.put("isReSet", false);
        long contAcceptNum = currentStageRow.getLong("entryentity.contacceptnum");
        long acceptValidDt = currentStageRow.getLong("entryentity.acceptvaliddt");
        long nextStageId = currentStageRow.getLong("entryentity.nextstage");
        String nextStageNum = currentStageRow.getString("entryentity.nextstage.number");
        DynamicObjectCollection entrysAll = recObj.getDynamicObjectCollection("entryentity");
        boolean isJumpStart = entrysAll.stream().allMatch(o -> "4".equals(o.getString("wsstagec.number")));
        if (isJumpStart && Objects.isNull(recObj.get("jpendtm"))) {
            List auditDateLastList = entrysAll.stream().filter(o -> !"delete".equals(o.getString("status"))).map(o -> o.getDate("auditdtfst")).collect(Collectors.toList());
            jpendTime = KDDateUtils.addDays((Date)((Date)Collections.min(auditDateLastList)), (int)((int)acceptValidDt - 1));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(jpendTime);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            jpendTime = calendar.getTime();
            recObj.set("jpendtm", (Object)jpendTime);
        }
        long recNextStageId = (Long)map.get("nextStageId");
        long recCurStageId = (Long)map.get("curStageId");
        long recFirstStageId = entrys.get(0).getLong("wsstagec.id");
        long compareStageId = 0L;
        if (recFirstStageId == recNextStageId) {
            map.put("curStageId", recNextStageId);
            compareStageId = recNextStageId;
        } else if (recFirstStageId == recCurStageId) {
            compareStageId = recCurStageId;
        } else {
            recObj.set("billno", null);
            recObj.set("inspectauditdate", null);
            map.put("emptyBill", true);
        }
        if (contAcceptNum > 0L) {
            long leftNum = contAcceptNum;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = entrys.get(i);
                String entryStageNum = entry.getString("wsstagec.number");
                long entryStageId = entry.getLong("wsstagec.id");
                String samplingresult = entry.getString("samplingresult");
                if (entryStageId != recNextStageId && entryStageId != recCurStageId) {
                    if (1144849808217878528L == (Long)map.get("curStageId") && i == 0) {
                        DynamicObject jpStage = WideStrictRecUtil.getStageObj(currentStageRow.getLong("id"), 1144849808217878528L);
                        long jpContacceptnum = jpStage.getLong("entryentity.contacceptnum");
                        recObj.set("jpleftnum", (Object)jpContacceptnum);
                    }
                    map.put("nextStageId", map.get("curStageId"));
                    break;
                }
                if (entryStageId != compareStageId || !"B".equals(samplingresult) && !"4".equals(entryStageNum)) break;
                if ("4".equals(entryStageNum)) {
                    recObj.set("jpleftnum", (Object)(--leftNum));
                }
                if (contAcceptNum == (long)(i + 1)) {
                    if (StringUtils.equals((CharSequence)"4", (CharSequence)nextStageNum)) {
                        DynamicObject jpStage = WideStrictRecUtil.getStageObj(currentStageRow.getLong("id"), nextStageId);
                        long jpContacceptnum = jpStage.getLong("entryentity.contacceptnum");
                        long jpAcceptvaliddt = jpStage.getLong("entryentity.acceptvaliddt");
                        if (jpAcceptvaliddt > 0L) {
                            jpendTime = WideStrictRecUtil.computeJpendTime(recObj, jpAcceptvaliddt);
                            recObj.set("jpendtm", (Object)jpendTime);
                        }
                        if (0L != jpContacceptnum) {
                            recObj.set("jpleftnum", (Object)jpContacceptnum);
                        }
                    }
                    map.put("isReSet", true);
                    map.put("nextStageId", nextStageId);
                    return;
                }
                map.put("nextStageId", map.get("curStageId"));
            }
        }
    }

    public static Date computeJpendTime(DynamicObject recObj, long acceptvaliddt) {
        DynamicObject entry;
        DynamicObjectCollection entrys = recObj.getDynamicObjectCollection("entryentity");
        Collections.reverse(entrys);
        long wsStageId = ((DynamicObject)entrys.get(0)).getLong("wsstagec.id");
        Date endTime = null;
        Iterator iterator = entrys.iterator();
        while (iterator.hasNext() && !"delete".equals((entry = (DynamicObject)iterator.next()).getString("status")) && entry.getLong("wsstagec.id") == wsStageId) {
            if (Objects.nonNull(endTime) && entry.getDate("auditdtlast").after(endTime)) {
                endTime = entry.getDate("auditdtlast");
                continue;
            }
            if (!Objects.isNull(endTime)) continue;
            endTime = entry.getDate("auditdtlast");
        }
        if (Objects.isNull(endTime)) {
            return null;
        }
        Date jpendTime = KDDateUtils.addDays(endTime, (int)((int)acceptvaliddt - 1));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(jpendTime);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        jpendTime = calendar.getTime();
        return jpendTime;
    }

    private static void rejectNextStage(List<DynamicObject> entrys, DynamicObject currentStageRow, DynamicObject recObj, Map<String, Object> map) {
        long continspectnum = currentStageRow.getLong("entryentity.continspectnum");
        long rejectnum = currentStageRow.getLong("entryentity.rejectnum");
        long rnextstage = currentStageRow.getLong("entryentity.rnextstage");
        long pass = 0L;
        long reject = 0L;
        long recCurStageId = (Long)map.get("curStageId");
        long recNextStageId = (Long)map.get("nextStageId");
        long recFirstStageId = entrys.get(0).getLong("wsstagec.id");
        long compareStageId = 0L;
        if (recFirstStageId == recNextStageId) {
            compareStageId = recNextStageId;
        } else if (recFirstStageId == recCurStageId) {
            compareStageId = recCurStageId;
        } else {
            recObj.set("billno", null);
            recObj.set("inspectauditdate", null);
            map.put("emptyBill", true);
        }
        for (DynamicObject obj : entrys) {
            long entryStageId = obj.getLong("wsstagec.id");
            String samplingresult = obj.getString("samplingresult");
            if (entryStageId == compareStageId) {
                if ("B".equals(samplingresult)) {
                    ++pass;
                } else {
                    ++reject;
                }
            } else {
                map.put("nextStageId", map.get("curStageId"));
                break;
            }
            if (pass + reject <= continspectnum) {
                if (reject >= rejectnum) {
                    map.put("nextStageId", rnextstage);
                    return;
                }
                map.put("nextStageId", map.get("curStageId"));
                continue;
            }
            if (pass + reject != continspectnum) continue;
            map.put("nextStageId", map.get("curStageId"));
            break;
        }
    }

    private static void dealWsRecEtys(String entity, DynamicObject inspect, Date recvDate, DynamicObject recObj, String operation) {
        DynamicObjectCollection entrys = recObj.getDynamicObjectCollection("entryentity");
        Optional<DynamicObject> findHis = entrys.stream().filter(x -> inspect.getLong("matintoentity.id") == x.getLong("billentry")).findAny();
        if (findHis.isPresent()) {
            DynamicObject entryHis = findHis.get();
            entryHis.set("status", (Object)operation);
            entryHis.set("samplingresult", (Object)inspect.getString("matintoentity.samplingresult"));
            if (StringUtils.equals((CharSequence)"audit", (CharSequence)operation)) {
                entryHis.set("auditnum", (Object)(entryHis.getInt("auditnum") + 1));
                Date auditdate = inspect.getDate("auditdate");
                entryHis.set("auditdtlast", (Object)auditdate);
                entryHis.set("etybillno", (Object)inspect.getString("billno"));
            } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operation)) {
                Date modifyTime = inspect.getDate("modifytime");
                entryHis.set("unauditdtlast", (Object)modifyTime);
            } else {
                Date modifyTime = inspect.getDate("modifytime");
                entryHis.set("deletedt", (Object)modifyTime);
            }
        } else {
            long inspectWsrule;
            if ("unaudit".equals(operation)) {
                return;
            }
            long curWsrule = recObj.getDynamicObject("wsrule").getLong("id");
            if (curWsrule != (inspectWsrule = inspect.getLong("matintoentity.wsrule"))) {
                recObj.set("createtime", (Object)inspect.getDate("createtime"));
            }
            Map<String, DynamicObject> inspectDynObj = WideStrictRecUtil.getInspectDynObj(entity, inspect);
            WideStrictRecUtil.buildWsEtyObj(entrys, inspectDynObj.get("bill"), inspectDynObj.get("entry"), recObj, recvDate, operation);
        }
    }

    private static DynamicObject buildWsRecObj(String entity, DynamicObject inspect, Date recvDate, String operation) {
        Map<String, DynamicObject> inspectDynObj = WideStrictRecUtil.getInspectDynObj(entity, inspect);
        DynamicObject inspectBill = inspectDynObj.get("bill");
        DynamicObject entry = inspectDynObj.get("entry");
        DynamicObject wsRecObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"qcbd_widestrict_rec"));
        wsRecObj.set("id", (Object)ORM.create().genLongId("qcbd_widestrict_rec"));
        wsRecObj.set("material", (Object)entry.getDynamicObject("materialid"));
        wsRecObj.set("org", (Object)inspectBill.getDynamicObject("org"));
        wsRecObj.set("srcbill", (Object)entity);
        wsRecObj.set("billtypeid", (Object)inspectBill.getLong("billtype.id"));
        wsRecObj.set("biztype", (Object)inspectBill.getDynamicObject("biztype"));
        wsRecObj.set("wsrule", (Object)entry.getDynamicObject("wsrule"));
        wsRecObj.set("billstatus", (Object)inspectBill.getString("billstatus"));
        wsRecObj.set("createtime", (Object)inspectBill.getDate("createtime"));
        String bizTypeNum = inspectBill.getString("biztype.number");
        if (BizTypeEnum.QCP_001.getValue().equals(bizTypeNum)) {
            if (Objects.nonNull(entry.getDataEntityType().getProperties().get((Object)"supplier"))) {
                wsRecObj.set("supplier", (Object)entry.getDynamicObject("supplier"));
            }
        } else if (BizTypeEnum.QCPP_004.getValue().equals(bizTypeNum)) {
            wsRecObj.set("oprworkshop", (Object)entry.getDynamicObject("oprworkshop"));
        }
        DynamicObjectCollection entryEntity = wsRecObj.getDynamicObjectCollection("entryentity");
        WideStrictRecUtil.buildWsEtyObj(entryEntity, inspectBill, entry, wsRecObj, recvDate, operation);
        return wsRecObj;
    }

    private static void buildWsEtyObj(DynamicObjectCollection entryEntity, DynamicObject inspect, DynamicObject inspectEntry, DynamicObject wsRecObj, Date recvDate, String operation) {
        DynamicObject entryObj = new DynamicObject(entryEntity.getDynamicObjectType());
        entryObj.set("billid", (Object)inspect.getLong("id"));
        entryObj.set("billentry", (Object)inspectEntry.getLong("id"));
        entryObj.set("etybillno", (Object)inspect.getString("billno"));
        entryObj.set("samplingresult", (Object)inspectEntry.getString("samplingresult"));
        entryObj.set("status", (Object)operation);
        entryObj.set("recvdate", (Object)recvDate);
        entryObj.set("auditdtfst", (Object)inspect.getDate("auditdate"));
        entryObj.set("auditdtlast", (Object)inspect.getDate("auditdate"));
        entryObj.set("etywsrule", (Object)inspectEntry.getDynamicObject("wsrule"));
        entryObj.set("etyinspectpro", (Object)inspectEntry.getDynamicObject("inspectpro"));
        entryObj.set("auditnum", (Object)1L);
        entryObj.set("seq", (Object)entryEntity.size());
        entryObj.set("wsstage", (Object)inspectEntry.getDynamicObject("wsstage"));
        Object recNexStage = wsRecObj.get("nexstage");
        if (Objects.isNull(recNexStage)) {
            entryObj.set("wsstagec", (Object)inspectEntry.getDynamicObject("wsstage"));
        } else {
            entryObj.set("wsstagec", recNexStage);
        }
        entryEntity.add((Object)entryObj);
    }

    private static Map<String, DynamicObject> getInspectDynObj(String entity, DynamicObject inspect) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(2);
        DynamicObject inspectObj = BusinessDataServiceHelper.loadSingle((Object)inspect.getLong("id"), (String)entity);
        map.put("bill", inspectObj);
        String inspectEntryId = inspect.getString("matintoentity.id");
        DynamicObject entry = inspectObj.getDynamicObjectCollection("matintoentity").stream().filter(x -> x.getString("id").equals(inspectEntryId)).findFirst().get();
        map.put("entry", entry);
        return map;
    }

    private static DynamicObject[] getRecInfos(DynamicObjectCollection inspect) {
        List materialIds = inspect.stream().map(o -> o.getLong("matintoentity.materialid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("material", "in", materialIds);
        return BusinessDataServiceHelper.load((String)"qcbd_widestrict_rec", (String)"id, material, supplier, oprworkshop, org, srcbill, billtypeid, biztype, wsrule, inspectpro, createtime, resettime, billno, billstatus, inspectauditdate, curstage, jpendtm, jpleftnum,nexstage,sapplan,billstatus, entryentity.billid, entryentity.billentry, entryentity.etybillno, entryentity.samplingresult ,entryentity.status ,entryentity.recvdate ,entryentity.wsstage,entryentity.auditdtfst, entryentity.auditdtlast, entryentity.unauditdtlast,entryentity.deletedt,entryentity.auditnum,entryentity.etyinspectpro,entryentity.etywsrule,entryentity.wsstagec,entryentity.seq", (QFilter[])new QFilter[]{qFilter}, (String)"entryentity.auditdtfst desc");
    }

    private static DynamicObjectCollection getInspectInfos(String entity, List<String> billIds) {
        List billIdsL = billIds.stream().map(Long::valueOf).collect(Collectors.toList());
        String selectFields = "id, billno, billstatus, org, billtype, biztype, biztype.number, auditdate, createtime, modifytime, matintoentity.id, matintoentity.materialid, matintoentity.wsrule, matintoentity.wsrule.auditdate, matintoentity.wsstage, matintoentity.samplingresult, matintoentity.srcbillentity, matintoentity.srcbillid, matintoentity.srcbillentryid, matintoentity.sampscheme, matintoentity.inspectpro, matintoentity.secondck, matintoentity.seq";
        QFilter qFilter = new QFilter("id", "in", billIdsL);
        qFilter.and(new QFilter("matintoentity.wsrule", ">", (Object)0L));
        Object[] entityArr = new String[]{"qcp_incominginspct", "qcp_taiguinspct"};
        if (ArrayUtils.contains((Object[])entityArr, (Object)entity)) {
            selectFields = selectFields + ", matintoentity.supplier";
        }
        if ("qcpp_manuinspec".equals(entity)) {
            selectFields = selectFields + ", matintoentity.oprworkshop";
        }
        return QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"createtime,matintoentity.samplingresult,matintoentity.seq");
    }

    private static boolean matchRec(DynamicObject inspect, DynamicObject recObj, String entity) {
        boolean match = WideStrictRecUtil.eqaulsDyoPro(inspect, recObj, "matintoentity.materialid", "material");
        if (!match) {
            return false;
        }
        IDataEntityProperty supplierPro = (IDataEntityProperty)inspect.getDataEntityType().getProperties().get((Object)"matintoentity.supplier");
        if (Objects.nonNull(supplierPro) && !(match = WideStrictRecUtil.eqaulsDyoPro(inspect, recObj, "matintoentity.supplier", "supplier"))) {
            return false;
        }
        IDataEntityProperty oprworkshopPro = (IDataEntityProperty)inspect.getDataEntityType().getProperties().get((Object)"matintoentity.oprworkshop");
        if (Objects.nonNull(oprworkshopPro) && !(match = WideStrictRecUtil.eqaulsDyoPro(inspect, recObj, "matintoentity.oprworkshop", "oprworkshop"))) {
            return false;
        }
        match = WideStrictRecUtil.eqaulsDyoPro(inspect, recObj, "org", "org");
        if (!match) {
            return false;
        }
        match = Objects.equals(entity, recObj.getString("srcbill"));
        return match;
    }

    private static boolean eqaulsDyoPro(DynamicObject dyo1, DynamicObject dyo2, String pro1, String pro2) {
        return dyo1.getLong(pro1) != 0L && Objects.nonNull(dyo2.getDynamicObject(pro2)) && Objects.equals(dyo1.getLong(pro1), dyo2.getDynamicObject(pro2).getPkValue()) || dyo1.getLong(pro1) == 0L && Objects.isNull(dyo2.getDynamicObject(pro2));
    }
}

