/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.common.util.mathformaul;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.common.enums.SelfMathFormulaEnum;

public class MathCalculatorUtil {
    private static final Log log = LogFactory.getLog(MathCalculatorUtil.class);
    private static final Set<Character> OPERATE_SET = new HashSet<Character>();

    private MathCalculatorUtil() {
    }

    public static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void checkArg(String arg) {
        MathCalculatorUtil.checkArg(arg, true);
    }

    private static void checkArg(String arg, boolean isZero) {
        if (StringUtils.isEmpty((CharSequence)arg) || !MathCalculatorUtil.isNumber(arg) || !isZero && new BigDecimal(arg).compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u53c2\u6570\u975e\u6cd5\u3002", (String)"MathCalculatorUtil_0", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
    }

    private static void checkFormulaExpression(String expression) {
        expression = expression.replace(" ", "");
        char[] arr = expression.toCharArray();
        int len = arr.length;
        int checkNum = 0;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb0 = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(arr[i]) || arr[i] == '.') {
                sb.append(arr[i]);
                continue;
            }
            if (Character.isLetter(arr[i])) {
                sb0.append(arr[i]);
                continue;
            }
            if (sb.length() > 0) {
                if (MathCalculatorUtil.isNumber(sb.toString())) {
                    sb.setLength(0);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u5b57\u53c2\u6570\u975e\u6cd5\u3002", (String)"MathCalculatorUtil_1", (String)"qmc-qcbd-common", (Object[])new Object[0]));
                }
            }
            if (arr[i] == '+' || arr[i] == '*' || arr[i] == '/' || arr[i] == '%') {
                if (i != 0 && i != len - 1 && arr[i + 1] != '+' && arr[i + 1] != '*' && arr[i + 1] != '/' && arr[i + 1] != '%' && arr[i + 1] != ')') continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7b26\u53f7 : '+' or '*' or '/' ==> %s\u3002", (String)"MathCalculatorUtil_2", (String)"qmc-qcbd-common", (Object[])new Object[0]), Character.valueOf(arr[i])));
            }
            if (arr[i] == '-') {
                if (i != len - 1 && arr[i + 1] != '+' && arr[i + 1] != '*' && arr[i + 1] != '/' && arr[i + 1] != '%' && arr[i + 1] != ')') continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7b26\u53f7 : '-'  ==> %s\u3002", (String)"MathCalculatorUtil_3", (String)"qmc-qcbd-common", (Object[])new Object[0]), Character.valueOf(arr[i])));
            }
            if (arr[i] == '(') {
                if (sb0.length() > 0) {
                    int beginIndex = expression.indexOf(arr[i], i);
                    int endIndex = MathCalculatorUtil.matchBracketIndex(expression, i, arr[i]);
                    if (endIndex == -1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u6570\u5b66\u516c\u5f0f\u7b26\u53f7: ==> %s\u3002", (String)"MathCalculatorUtil_4", (String)"qmc-qcbd-common", (Object[])new Object[0]), sb0.length()));
                    }
                    String selfMathBracketContentStr = expression.substring(beginIndex + 1, endIndex);
                    if (StringUtils.isEmpty((CharSequence)selfMathBracketContentStr)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u81ea\u5b9a\u4e49\u6570\u5b66\u516c\u5f0f\u7b26\u53f7: ==> %s\u3002", (String)"MathCalculatorUtil_5", (String)"qmc-qcbd-common", (Object[])new Object[0]), sb0.length()));
                    }
                    StringBuilder selfMathBracketContentSb = new StringBuilder(selfMathBracketContentStr);
                    int argCounts = MathCalculatorUtil.getSelfMathMarkArgCounts(selfMathBracketContentSb, ",");
                    MathCalculatorUtil.checkSelfMathMark(sb0.toString(), argCounts);
                    sb0.setLength(0);
                }
                ++checkNum;
                if (i != len - 1 && arr[i + 1] != '+' && arr[i + 1] != '*' && arr[i + 1] != '/' && arr[i + 1] != '%' && arr[i + 1] != ')' && (i == 0 || !Character.isDigit(arr[i - 1]))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7b26\u53f7 : '('  ==> %s\u3002", (String)"MathCalculatorUtil_6", (String)"qmc-qcbd-common", (Object[])new Object[0]), Character.valueOf(arr[i])));
            }
            if (arr[i] == ')') {
                if (i != 0 && (i >= len - 1 || arr[i + 1] != '(') && --checkNum >= 0) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7b26\u53f7 : ')'  ==> %s\u3002", (String)"MathCalculatorUtil_7", (String)"qmc-qcbd-common", (Object[])new Object[0]), Character.valueOf(arr[i])));
            }
            if (arr[i] == ',') {
                MathCalculatorUtil.checkComma(expression, i, i);
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u975e\u6570\u5b57\u548c\u8fd0\u7b97\u7b26 : ==> %s\u3002", (String)"MathCalculatorUtil_8", (String)"qmc-qcbd-common", (Object[])new Object[0]), Character.valueOf(arr[i])));
        }
        if (checkNum != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62ec\u53f7\u4e2a\u6570\u4e0d\u5339\u914d\u3002", (String)"MathCalculatorUtil_9", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
    }

    private static void checkComma(String str, int currentCommaIndex, int constCommaIndex) {
        int beginIndex = MathCalculatorUtil.indexOfBefore(str, currentCommaIndex);
        String errInfo = ResManager.loadKDString((String)"\u975e\u6cd5\u9017\u53f7\u3002", (String)"MathCalculatorUtil_10", (String)"qmc-qcbd-common", (Object[])new Object[0]);
        if (beginIndex == -1) {
            throw new KDBizException(errInfo);
        }
        int endIndex = MathCalculatorUtil.matchBracketIndex(str, beginIndex, '(');
        if (endIndex == -1) {
            throw new KDBizException(errInfo);
        }
        if (endIndex <= constCommaIndex) {
            MathCalculatorUtil.checkComma(str, beginIndex, constCommaIndex);
        } else {
            char[] chars = str.toCharArray();
            StringBuilder sb = new StringBuilder();
            for (int i = beginIndex - 1; i >= 0 && (Character.isLetter(chars[i]) || Character.isDigit(chars[i])); --i) {
                sb.append(chars[i]);
            }
            List<String> selfMathFormulaNames = SelfMathFormulaEnum.getSelfMathFormulaNames();
            if (!selfMathFormulaNames.contains(sb.reverse().toString())) {
                throw new KDBizException(errInfo);
            }
        }
    }

    private static int indexOfBefore(String str, int endIndex) {
        char[] chars = str.trim().toCharArray();
        int len = chars.length;
        int index0 = endIndex;
        if (len - 1 < endIndex) {
            index0 = len;
        }
        for (int i = index0 - 1; i >= 0; --i) {
            if (chars[i] != '(') continue;
            return i;
        }
        return -1;
    }

    private static int getSelfMathMarkArgCounts(StringBuilder mathArgStr, String regex) {
        int beginIndex = mathArgStr.indexOf("(");
        if (beginIndex != -1) {
            int endIndex = MathCalculatorUtil.matchBracketIndex(mathArgStr.toString(), beginIndex, '(');
            if (endIndex == -1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62ec\u53f7\u4e0d\u5339\u914d\u3002", (String)"MathCalculatorUtil_11", (String)"qmc-qcbd-common", (Object[])new Object[0]));
            }
            mathArgStr.replace(beginIndex, endIndex + 1, "");
            return MathCalculatorUtil.getSelfMathMarkArgCounts(mathArgStr, regex);
        }
        String[] argsArr = mathArgStr.toString().split(regex, -1);
        return argsArr.length;
    }

    private static void checkSelfMathMark(String mathStr, int argCount) {
        SelfMathFormulaEnum selfMathFormulaEnum = SelfMathFormulaEnum.getSelfMathFormulaEnum(mathStr, argCount);
        if (selfMathFormulaEnum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u5b66\u516c\u5f0f\u4e0d\u5339\u914d\u3002", (String)"MathCalculatorUtil_12", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
    }

    private static int matchBracketIndex(String s, int fromIndex, char leftDest) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return -1;
        }
        int index0 = s.indexOf(leftDest, fromIndex);
        if (index0 != -1) {
            Stack<Character> stack = new Stack<Character>();
            for (int i = index0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '{' || c == '[' || c == '(') {
                    stack.push(Character.valueOf(c));
                    continue;
                }
                if (c != '}' && c != ']' && c != ')') continue;
                if (stack.isEmpty()) {
                    return -1;
                }
                char topChar = ((Character)stack.pop()).charValue();
                if (!(topChar == '[' && c == ']' || topChar == '(' && c == ')') && (topChar != '{' || c != '}') || !stack.isEmpty()) continue;
                return i;
            }
        }
        return -1;
    }

    private static String add(String v1, String v2) {
        MathCalculatorUtil.checkArg(v1);
        MathCalculatorUtil.checkArg(v2);
        BigDecimal v1Bd = new BigDecimal(v1);
        BigDecimal v2Bd = new BigDecimal(v2);
        return v1Bd.add(v2Bd).toString();
    }

    private static String sub(String v1, String v2) {
        MathCalculatorUtil.checkArg(v1);
        MathCalculatorUtil.checkArg(v2);
        BigDecimal v1Bd = new BigDecimal(v1);
        BigDecimal v2Bd = new BigDecimal(v2);
        return v1Bd.subtract(v2Bd).toString();
    }

    private static String mul(String v1, String v2) {
        MathCalculatorUtil.checkArg(v1);
        MathCalculatorUtil.checkArg(v2);
        BigDecimal v1Bd = new BigDecimal(v1);
        BigDecimal v2Bd = new BigDecimal(v2);
        return v1Bd.multiply(v2Bd).toString();
    }

    private static String div(String v1, String v2) {
        MathCalculatorUtil.checkArg(v1);
        MathCalculatorUtil.checkArg(v2, false);
        BigDecimal v1Bd = new BigDecimal(v1);
        BigDecimal v2Bd = new BigDecimal(v2);
        return v1Bd.divide(v2Bd, 2, RoundingMode.HALF_UP).toString();
    }

    private static String mod(String v1, String v2) {
        MathCalculatorUtil.checkArg(v1);
        MathCalculatorUtil.checkArg(v2, false);
        BigDecimal v1Bd = new BigDecimal(v1);
        BigDecimal v2Bd = new BigDecimal(v2);
        return v1Bd.remainder(v2Bd).toString();
    }

    public static BigDecimal calculator(String mathFormula) {
        if (StringUtils.isEmpty((CharSequence)mathFormula)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e3a\u7a7a\u3002", (String)"MathCalculatorUtil_13", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        mathFormula = mathFormula.replace(" ", "");
        int bracket = mathFormula.indexOf("[");
        int brace = mathFormula.indexOf("{");
        if (bracket != -1 || brace != -1) {
            log.info("\u8ba1\u7b97\u516c\u5f0f\uff1a{}", (Object)mathFormula);
            mathFormula = mathFormula.replace("[\\[{]", "(").replaceAll("[]}]", ")");
            log.info("\u6807\u51c6\u6570\u5b66\u8ba1\u7b97\u516c\u5f0f '{,[':" + mathFormula);
        }
        MathCalculatorUtil.checkFormulaExpression(mathFormula);
        String result = MathCalculatorUtil.calculatorSelfMathFormula(mathFormula);
        return new BigDecimal(result);
    }

    private static String calculatorSelfMathFormula(String mathFormula) {
        if (StringUtils.isEmpty((CharSequence)mathFormula)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MathCalculatorUtil_14", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        mathFormula = mathFormula.replace(" ", "");
        List<SelfMathFormulaEnum> selfMathFormulaEnums = SelfMathFormulaEnum.getSelfMathFormulas();
        boolean flag = false;
        for (SelfMathFormulaEnum mathFormulaEnum : selfMathFormulaEnums) {
            if (!mathFormula.contains(mathFormulaEnum.getFormulaName())) continue;
            flag = true;
            break;
        }
        if (flag) {
            int i = 0;
            while (i < selfMathFormulaEnums.size()) {
                boolean repeat = false;
                SelfMathFormulaEnum mathFormulaEnum = selfMathFormulaEnums.get(i);
                if (mathFormula.contains(mathFormulaEnum.getFormulaName())) {
                    int index0 = mathFormula.indexOf(mathFormulaEnum.getFormulaName());
                    String left = mathFormula.substring(0, index0);
                    int index1 = MathCalculatorUtil.matchBracketIndex(mathFormula, index0, '(');
                    String right = mathFormula.substring(index1 + 1);
                    String bracketsContent = mathFormula.substring(index0 + mathFormulaEnum.getFormulaNameLength() + 1, index1);
                    mathFormula = left + MathCalculatorUtil.selfMathCalculation(mathFormulaEnum.getFormulaName(), MathCalculatorUtil.calculatorSelfMathFormula(bracketsContent)) + right;
                    repeat = true;
                }
                if (repeat) continue;
                ++i;
            }
        }
        return MathCalculatorUtil.standardCalculation(mathFormula);
    }

    private static String selfMathCalculation(String mathFormulaName, String digitStr) {
        double result;
        if (StringUtils.isEmpty((CharSequence)digitStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MathCalculatorUtil_14", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        String[] args = digitStr.split(",", -1);
        SelfMathFormulaEnum selfMathFormulaEnum = SelfMathFormulaEnum.getSelfMathFormulaEnum(mathFormulaName);
        if (selfMathFormulaEnum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u5b66\u516c\u5f0f\u540d\u79f0\u975e\u6cd5\u3002", (String)"MathCalculatorUtil_15", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        switch (selfMathFormulaEnum) {
            case abs: {
                result = Math.abs(Double.parseDouble(args[0]));
                break;
            }
            case acos: {
                result = Math.acos(Double.parseDouble(args[0]));
                break;
            }
            case asin: {
                result = Math.asin(Double.parseDouble(args[0]));
                break;
            }
            case atan: {
                result = Math.atan(Double.parseDouble(args[0]));
                break;
            }
            case ceil: {
                result = Math.ceil(Double.parseDouble(args[0]));
                break;
            }
            case cos: {
                result = Math.cos(Double.parseDouble(args[0]));
                break;
            }
            case exp: {
                result = Math.exp(Double.parseDouble(args[0]));
                break;
            }
            case floor: {
                result = Math.floor(Double.parseDouble(args[0]));
                break;
            }
            case log: {
                result = Math.log(Double.parseDouble(args[0]));
                break;
            }
            case max: {
                result = Math.max(Double.parseDouble(args[0]), Double.parseDouble(args[1]));
                break;
            }
            case min: {
                result = Math.min(Double.parseDouble(args[0]), Double.parseDouble(args[1]));
                break;
            }
            case pow: {
                result = Math.pow(Double.parseDouble(args[0]), Double.parseDouble(args[1]));
                break;
            }
            case round: {
                result = Math.round(Double.parseDouble(args[0]));
                break;
            }
            case sin: {
                result = Math.sin(Double.parseDouble(args[0]));
                break;
            }
            case sqrt: {
                result = Math.sqrt(Double.parseDouble(args[0]));
                break;
            }
            case tan: {
                result = Math.tan(Double.parseDouble(args[0]));
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u8ba1\u7b97\u516c\u5f0f\u3002", (String)"MathCalculatorUtil_18", (String)"qmc-qcbd-common", (Object[])new Object[0]));
            }
        }
        return String.valueOf(result);
    }

    private static String standardCalculation(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MathCalculatorUtil_14", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        String[] args = str.split(",", -1);
        ArrayList<String> argResult = new ArrayList<String>();
        for (String arg : args) {
            int hasBrackets = arg.lastIndexOf(40);
            if (hasBrackets == -1) {
                argResult.add(MathCalculatorUtil.cac(arg));
                continue;
            }
            int cr = arg.indexOf(41, hasBrackets);
            String left = arg.substring(0, hasBrackets);
            String right = arg.substring(cr + 1);
            String middle = arg.substring(hasBrackets + 1, cr);
            argResult.add(MathCalculatorUtil.standardCalculation(left + MathCalculatorUtil.cac(middle) + right));
        }
        return String.join((CharSequence)",", argResult);
    }

    private static String cac(String str) {
        int mulIndex = str.indexOf(42);
        int divIndex = str.indexOf(47);
        int modIndex = str.indexOf(37);
        if (mulIndex == -1 && divIndex == -1 && modIndex == -1) {
            return MathCalculatorUtil.aasOperation(str);
        }
        String result0 = "0";
        int index0 = MathCalculatorUtil.getMin(mulIndex, divIndex, modIndex);
        try {
            String left = str.substring(0, index0);
            String v1 = MathCalculatorUtil.lastNumber(left);
            left = left.substring(0, left.length() - v1.length());
            String right = str.substring(index0 + 1);
            String v2 = MathCalculatorUtil.firstNumber(right);
            right = right.substring(v2.length());
            if (index0 == mulIndex) {
                result0 = MathCalculatorUtil.mul(v1, v2);
            } else if (index0 == divIndex) {
                result0 = MathCalculatorUtil.div(v1, v2);
            } else if (index0 == modIndex) {
                result0 = MathCalculatorUtil.mod(v1, v2);
            }
            return MathCalculatorUtil.cac(left + result0 + right);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u5b66\u8ba1\u7b97\u516c\u5f0f\u9519\u8bef\uff1a%s", (String)"MathCalculatorUtil_16", (String)"qmc-qcbd-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
    }

    private static int getMin(int ... a) {
        if (a == null || a.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MathCalculatorUtil_14", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        int min = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (min != -1 && (min <= a[i] || a[i] == -1)) continue;
            min = a[i];
        }
        if (min == -1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ef\u53d8\u53c2\u6570\u975e\u6cd5\u3002", (String)"MathCalculatorUtil_17", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        return min;
    }

    private static String lastNumber(String str) {
        char c;
        StringBuilder sb = new StringBuilder();
        for (int i = str.length() - 1; i >= 0 && (Character.isDigit(c = str.charAt(i)) || i != 0 && c == '.' || (i == 0 || OPERATE_SET.contains(Character.valueOf(str.charAt(i - 1)))) && c == '-'); --i) {
            sb.append(c);
        }
        return sb.reverse().toString();
    }

    private static String firstNumber(String str) {
        char c;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length() && (Character.isDigit(c = str.charAt(i)) || i != 0 && c == '.' || i == 0 && c == '-'); ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static String aasOperation(String mathStr) {
        if (StringUtils.isEmpty((CharSequence)mathStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MathCalculatorUtil_14", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        char[] options = (mathStr + "+").replace(" ", "").toCharArray();
        String result0 = "0";
        StringBuilder sb = new StringBuilder();
        int sign = 43;
        for (int i = 0; i < options.length; ++i) {
            if (Character.isDigit(options[i]) || options[i] == '.') {
                sb.append(options[i]);
                continue;
            }
            if (i == 0 && options[i] == '-' || i > 1 && OPERATE_SET.contains(Character.valueOf(options[i - 1]))) {
                sb.append(options[i]);
                continue;
            }
            if (sb.length() > 0) {
                result0 = sign == 43 ? MathCalculatorUtil.add(result0, sb.toString()) : MathCalculatorUtil.sub(result0, sb.toString());
                sb.setLength(0);
                sign = options[i];
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u53c2\u6570\u975e\u6cd5\u3002", (String)"MathCalculatorUtil_0", (String)"qmc-qcbd-common", (Object[])new Object[0]));
        }
        return result0;
    }

    static {
        OPERATE_SET.add(Character.valueOf('+'));
        OPERATE_SET.add(Character.valueOf('-'));
        OPERATE_SET.add(Character.valueOf('*'));
        OPERATE_SET.add(Character.valueOf('/'));
        OPERATE_SET.add(Character.valueOf('%'));
    }
}

