/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.custom.ext;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.qmc.qcbd.business.custom.ext.IJoinInspAfterUpdateMeasureVal;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.business.inspbill.project.CheckProjectCaleFactory;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.common.constant.inspect.InspItemInfo;
import kd.qmc.qcbd.common.constant.inspect.JoinInspUpdateMeasureArgs;
import kd.qmc.qcbd.common.model.inspbill.project.CheckProjectCaleModel;
import kd.qmc.qcbd.common.util.DataModelUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class JoinInspUpdateMeasureValImpl
implements IJoinInspAfterUpdateMeasureVal {
    private static final String SYSTEM_TYPE = "qmc-qcbd-business";

    @Override
    public void beforeBuildListShowParameter(JoinInspUpdateMeasureArgs args) {
        int matRowIndex;
        AbstractFormPlugin plugin = args.getPlugin();
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        BigDecimal rinsQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqty", (int)(matRowIndex = model.getEntryCurrentRowIndex("matintoentity")));
        if (null == rinsQty || BigDecimal.ZERO.compareTo(rinsQty) >= 0) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6837\u672c\u6570\u91cf\u3002", (String)"JoinInspUpdateMeasureValImpl_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            args.setCancel(true);
        }
        EntryGrid inspSubGrid = (EntryGrid)view.getControl("inspsubentity");
        int[] selectRows = inspSubGrid.getSelectRows();
        int rowsCount = selectRows.length;
        if (-1 == matRowIndex || 0 == rowsCount) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u68c0\u9a8c\u9879\u76ee\u5206\u5f55\u3002", (String)"JoinInspUpdateMeasureValImpl_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            LinkedList<String> errSeqs = new LinkedList<String>();
            for (int i = 0; i < rowsCount; ++i) {
                int rowIndex = selectRows[i];
                String normTypeCurrent = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)"normtype", (int)rowIndex);
                if (!StringUtils.isEmpty((CharSequence)normTypeCurrent)) continue;
                errSeqs.add(String.valueOf(rowIndex + 1));
            }
            if (!errSeqs.isEmpty()) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55%s\uff1a\u6307\u6807\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"JoinInspUpdateMeasureValImpl_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), String.join((CharSequence)",", errSeqs)));
                args.setCancel(true);
            }
        }
        Map listLayOutReflex = args.getListLayOutReflex();
        listLayOutReflex.put("qcp_joininspect", "qcp_joininspect_val_sel");
        listLayOutReflex.put("qcpp_joininspect", "qcpp_joininspect_val_sel");
    }

    @Override
    public void afterBuildListShowParameter(JoinInspUpdateMeasureArgs args) {
        ListShowParameter listShowParameter = args.getListShowParameter();
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)args.getPlugin(), "selectdata"));
        listShowParameter.setSelectedEntity("inspsubentity");
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("transactype.ckvalflag", "=", (Object)"1"));
        qFilters.add(new QFilter("matintoentity.inspsubentity.id", "!=", (Object)0));
    }

    @Override
    public void afterSelectData(JoinInspUpdateMeasureArgs args) {
        LinkedList inspItemInfos;
        IFormView view = args.getPlugin().getView();
        IDataModel model = view.getModel();
        EntryGrid inspSubGrid = (EntryGrid)view.getControl("inspsubentity");
        int[] selectRows = inspSubGrid.getSelectRows();
        int rowsCount = selectRows.length;
        if (rowsCount > (inspItemInfos = args.getInspItemInfos()).size()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u68c0\u9a8c\u9879\u76ee\u884c\u6570\u5c11\u4e8e\u52fe\u9009\u884c\u6570\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"JoinInspUpdateMeasureValImpl_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            LinkedList<String> errSeqs = new LinkedList<String>();
            for (int i = 0; i < rowsCount; ++i) {
                int rowIndex;
                String normTypeCurrent;
                String normType = ((InspItemInfo)inspItemInfos.get(i)).getNormType();
                if (normType.equals(normTypeCurrent = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)"normtype", (int)(rowIndex = selectRows[i])))) continue;
                errSeqs.add(String.valueOf(rowIndex + 1));
            }
            if (!errSeqs.isEmpty()) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55%s\uff1a\u6307\u6807\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u672a\u66f4\u65b0\u5b9e\u6d4b\u503c\u3002", (String)"JoinInspUpdateMeasureValImpl_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), String.join((CharSequence)",", errSeqs)));
            }
        }
    }

    @Override
    public void afterUpdateView(JoinInspUpdateMeasureArgs args) {
        IFormView view = args.getPlugin().getView();
        IDataModel model = view.getModel();
        int matRowIndex = model.getEntryCurrentRowIndex("matintoentity");
        EntryGrid inspSubGrid = (EntryGrid)view.getControl("inspsubentity");
        int[] selectRows = inspSubGrid.getSelectRows();
        LinkedList inspItemInfos = args.getInspItemInfos();
        int updateCount = 0;
        int selectInspLength = selectRows.length;
        DynamicObjectCollection subSampEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"subsampleresentity", (int)matRowIndex);
        if ("update".equalsIgnoreCase(args.getOperate())) {
            int sampQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqty", (int)matRowIndex).intValue();
            int subSampSize = subSampEntry.size();
            InspectCkvalHelper.batchAddSamples(model, view, sampQty - subSampSize);
        }
        int subSampSize = subSampEntry.size();
        DynamicObjectCollection inspSubEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)matRowIndex);
        DynamicObjectCollection measureEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"submeasuredvalentity", (int)matRowIndex);
        CheckProjectCaleFactory ckProjFactory = CheckProjectCaleFactory.getInstance();
        for (int i = 0; i < selectInspLength; ++i) {
            int insbSubRowIndex = selectRows[i];
            DynamicObject inspSubRow = (DynamicObject)inspSubEntry.get(insbSubRowIndex);
            InspItemInfo inspItemInfo = (InspItemInfo)inspItemInfos.get(i);
            if ("update".equalsIgnoreCase(args.getOperate()) && !inspSubRow.getString("normtype").equalsIgnoreCase(inspItemInfo.getNormType())) continue;
            ++updateCount;
            measureEntry.removeIf(x -> inspSubRow.getString("uquuid").equals(x.getString("projuuid")));
            int projqualifiyqty = 0;
            int projunqualifiyqty = 0;
            int projckval = 0;
            int chooseSampQty = 0;
            LinkedList measureValues = inspItemInfo.getMeasureValues();
            int measureValueSize = measureValues.size();
            for (int j = 0; j < subSampSize && j < measureValueSize; ++j) {
                String measureJudge;
                ++chooseSampQty;
                InspItemInfo.MeasureValue measureValue = (InspItemInfo.MeasureValue)measureValues.get(j);
                String measureValueDeter = measureValue.getMeasureValueDeter();
                BigDecimal measureValueRat = measureValue.getMeasureValueRat();
                if (StringUtils.isNotEmpty((CharSequence)measureValueDeter) || null != measureValueRat) {
                    ++projckval;
                }
                if ("Y".equalsIgnoreCase(measureJudge = this.getMeasureJudge(ckProjFactory, inspSubRow, measureValueDeter, measureValueRat))) {
                    ++projqualifiyqty;
                } else if ("N".equalsIgnoreCase(measureJudge)) {
                    ++projunqualifiyqty;
                }
                this.addMeasureRow(measureEntry, subSampEntry, inspSubRow, j, measureValue, measureJudge);
            }
            inspSubRow.set("projqualifiyqty", (Object)projqualifiyqty);
            inspSubRow.set("projunqualifiyqty", (Object)projunqualifiyqty);
            inspSubRow.set("projckval", (Object)projckval);
            inspSubRow.set("choosesampqty", (Object)chooseSampQty);
            String projCkValStr = String.format(ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c(%1$s/%2$s)", (String)"JoinInspUpdateMeasureValImpl_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), projckval, chooseSampQty);
            inspSubRow.set("projckvalstr", (Object)projCkValStr);
            InspectCkvalHelper.projqulifyChange(model, view, insbSubRowIndex);
        }
        int seq = 0;
        for (DynamicObject measureRow : measureEntry) {
            measureRow.set("seq", (Object)(++seq));
        }
        model.updateEntryCache(measureEntry);
        model.updateEntryCache(inspSubEntry);
        for (int i = 0; i < selectInspLength; ++i) {
            int rowIndex = selectRows[i];
            view.updateView("projqualifiyqty", rowIndex);
            view.updateView("projunqualifiyqty", rowIndex);
            view.updateView("projckresult", rowIndex);
            view.updateView("projckvalstr", rowIndex);
        }
        if ("update".equalsIgnoreCase(args.getOperate())) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210%s\u4e2a\u68c0\u9a8c\u9879\u76ee\u7684\u5b9e\u6d4b\u503c\u66f4\u65b0\u3002", (String)"JoinInspUpdateMeasureValImpl_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), updateCount));
        }
    }

    private void addMeasureRow(DynamicObjectCollection measureEntry, DynamicObjectCollection subSampEntry, DynamicObject inspSubRow, int j, InspItemInfo.MeasureValue measureValue, String measureJudge) {
        DynamicObject measureRow = measureEntry.addNew();
        String measureValueDeter = measureValue.getMeasureValueDeter();
        BigDecimal measureValueRat = measureValue.getMeasureValueRat();
        measureRow.set("projuuid", (Object)inspSubRow.getString("uquuid"));
        measureRow.set("exmapleid", (Object)((DynamicObject)subSampEntry.get(j)).getLong("samplenumid"));
        measureRow.set("samp_seq", (Object)(j + 1));
        measureRow.set("measuredval_deter", (Object)measureValueDeter);
        measureRow.set("measuredval_rat", (Object)measureValueRat);
        measureRow.set("measuredval_judge", (Object)measureJudge);
        measureRow.set("measure_comment", (Object)measureValue.getMeasureComment());
    }

    private String getMeasureJudge(CheckProjectCaleFactory ckProjFactory, DynamicObject inspSubRow, String measureValueDeter, BigDecimal measureValueRat) {
        ICheckProjectCaleStrategy ckProjStrategy;
        String normType = inspSubRow.getString("normtype");
        String matchFlag = "";
        DynamicObject matchFlagObj = inspSubRow.getDynamicObject("matchflag");
        if (null != matchFlagObj) {
            matchFlag = matchFlagObj.getString("number");
        }
        if (null == (ckProjStrategy = ckProjFactory.getCkProjectStrategy(matchFlag, normType))) {
            return "";
        }
        String specValue = inspSubRow.getString("specvalue");
        BigDecimal topValue = inspSubRow.getBigDecimal("topvalue");
        BigDecimal downValue = inspSubRow.getBigDecimal("downvalue");
        CheckProjectCaleModel paramModel = new CheckProjectCaleModel(normType, matchFlag, specValue, topValue, downValue, measureValueDeter, measureValueRat);
        return ckProjStrategy.judgmentResultMain(paramModel);
    }
}

