/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.insobj.InspObjectBase;
import kd.qmc.qcbd.business.inspbill.project.CheckProjectCaleFactory;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.common.model.inspbill.project.CheckProjectCaleModel;
import kd.qmc.qcbd.common.util.AverageAssignUtil;
import kd.qmc.qcbd.common.util.CacheManagerQmcUtil;
import kd.qmc.qcbd.common.util.DynamicObjPropUtil;
import kd.qmc.qcbd.common.util.DynamicObjUtil;
import kd.qmc.qcbd.common.util.ParameterUtil;
import kd.qmc.qcbd.common.util.UpgradeSqlUtil;
import org.apache.commons.collections.map.HashedMap;

public class DataMigratHelper {
    private static Log logger = LogFactory.getLog(InspObjectBase.class);
    private static String[] entitys = new String[]{"qcp_inspecapply", "qcp_baddeal", "qcpp_manuinspecapply", "qcpp_manubaddeal"};
    private static final String SYSTEM_TYPE = "qmc-qcbd-business";

    private DataMigratHelper() {
    }

    public static List<Object> autoCreateData() {
        logger.info("\u5f00\u59cb\u81ea\u52a8\u751f\u6210\u5355\u636e");
        int length = entitys.length;
        DynamicObject[] objs = new DynamicObject[length];
        for (int i = 0; i < length; ++i) {
            DataMigratHelper.createSingle(objs, i);
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"qcbd_datamigrat", (QFilter[])new QFilter("number", "in", (Object)entitys).and("status", "=", (Object)"C").toArray(), (String)"createtime", (int)1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSingle(DynamicObject[] objs, int i) {
        String errMsg;
        OperationResult delResult;
        Object[] saveRet;
        DynamicObject datamigratObj;
        block9: {
            String entity = entitys[i];
            boolean exists = QueryServiceHelper.exists((String)"qcbd_datamigrat", (QFilter[])new QFilter("number", "=", (Object)entity).toArray());
            if (exists) {
                return;
            }
            logger.info("\u65b0\u589e\u6570\u636e\u8fc1\u79fb\u5355\u636e" + i);
            datamigratObj = BusinessDataServiceHelper.newDynamicObject((String)"qcbd_datamigrat");
            ORM create = ORM.create();
            Long id = create.genLongId("qcbd_datamigrat");
            objs[i] = datamigratObj;
            datamigratObj.set("id", (Object)id);
            datamigratObj.set("number", (Object)entity);
            datamigratObj.set("name", (Object)entity);
            datamigratObj.set("entitynumber", (Object)entity);
            datamigratObj.set("status", (Object)"A");
            datamigratObj.set("enable", (Object)"1");
            DynamicObjectCollection colls = datamigratObj.getDynamicObjectCollection("entryentity");
            MainEntityType mBillMainType = MetadataServiceHelper.getDataEntityType((String)entity);
            Map mapEntrys = mBillMainType.getAllEntities();
            for (EntityType entityType : mapEntrys.values()) {
                DataMigratHelper.buildRowData(colls, entityType);
            }
            DataMigratHelper.autoBuildRef(datamigratObj);
            saveRet = null;
            delResult = null;
            errMsg = "";
            try {
                logger.debug("\u5f00\u59cb\u4fdd\u5b58\u5355\u636e");
                logger.debug("\u5f00\u59cb\u4fdd\u5b58\u5355\u636e");
                saveRet = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datamigratObj});
                OperationServiceImpl delService = new OperationServiceImpl();
                logger.debug("\u5355\u636e\u4fdd\u5b58\u7ed3\u679c" + saveRet.length);
                logger.debug("\u5f00\u59cb\u63d0\u4ea4\u5355\u636e");
                delResult = delService.localInvokeOperation("submit", "qcbd_datamigrat", new Object[]{id}, OperateOption.create());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datamigratObj});
                logger.debug("\u5355\u636e\u63d0\u4ea4\u7ed3\u679c" + delResult.isSuccess() + delResult.getMessage());
                if (!delResult.isSuccess()) break block9;
                logger.debug("\u5f00\u59cb\u5ba1\u6838\u5355\u636e");
                delResult = delService.localInvokeOperation("audit", "qcbd_datamigrat", new Object[]{id}, OperateOption.create());
                logger.debug("\u5355\u636e\u5ba1\u6838\u7ed3\u679c" + delResult.isSuccess() + delResult.getMessage());
            }
            catch (Exception e) {
                try {
                    errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    logger.error("\u5355\u636e\u64cd\u4f5c\u5f02\u5e38" + errMsg);
                }
                catch (Throwable throwable) {
                    if (!(null == saveRet || null != delResult && delResult.isSuccess())) {
                        datamigratObj.set("issuncess", (Object)Boolean.FALSE);
                        errMsg = null == delResult ? errMsg : delResult.getMessage() + errMsg;
                        datamigratObj.set("errdesc_tag", (Object)String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u9519\u8bef\uff0c\u65e0\u6cd5\u5b8c\u6210\u4fee\u590d\uff0c\u81ea\u52a8\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataMigratHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), errMsg));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datamigratObj});
                    }
                    throw throwable;
                }
                if (!(null == saveRet || null != delResult && delResult.isSuccess())) {
                    datamigratObj.set("issuncess", (Object)Boolean.FALSE);
                    errMsg = null == delResult ? errMsg : delResult.getMessage() + errMsg;
                    datamigratObj.set("errdesc_tag", (Object)String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u9519\u8bef\uff0c\u65e0\u6cd5\u5b8c\u6210\u4fee\u590d\uff0c\u81ea\u52a8\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataMigratHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), errMsg));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datamigratObj});
                }
            }
        }
        if (!(null == saveRet || null != delResult && delResult.isSuccess())) {
            datamigratObj.set("issuncess", (Object)Boolean.FALSE);
            errMsg = null == delResult ? errMsg : delResult.getMessage() + errMsg;
            datamigratObj.set("errdesc_tag", (Object)String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u9519\u8bef\uff0c\u65e0\u6cd5\u5b8c\u6210\u4fee\u590d\uff0c\u81ea\u52a8\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataMigratHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), errMsg));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datamigratObj});
        }
    }

    private static void buildRowData(DynamicObjectCollection colls, EntityType entityType) {
        DataEntityPropertyCollection props = entityType.getProperties();
        String tableName = entityType.getAlias();
        List<String> colNames = DataMigratHelper.toUpperList(DataMigratHelper.getTableCols(tableName));
        if (StringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        for (IDataEntityProperty prop : props) {
            String fieldName = entityType.getProperty(prop.getName()).getAlias();
            if (!colNames.contains(fieldName.toUpperCase()) || !DynamicObjPropUtil.validProp((EntityType)entityType, (String)prop.getName()).booleanValue()) continue;
            DynamicObject coll = colls.addNew();
            DataMigratHelper.setEntryRowData(entityType, prop.getName(), coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpgradeResult repairDatas(String className, Object[] pkValues) {
        logger.info("\u5f00\u59cb\u4fee\u590d\u6570\u636e");
        UpgradeResult result = new UpgradeResult();
        LinkedList<DynamicObject> dataMigratList = new LinkedList<DynamicObject>();
        CacheManagerQmcUtil datarepaireUtil = new CacheManagerQmcUtil("datarepaire");
        datarepaireUtil.remove("timeout");
        for (Object pkValue : pkValues) {
            logger.info("\u4fee\u590d\u914d\u7f6e\u5185\u7801\uff1a" + pkValue);
            DynamicObject dataMigratObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"qcbd_datamigrat");
            String errMsg = "";
            dataMigratList.add(dataMigratObj);
            try {
                DynamicObjectCollection colls = dataMigratObj.getDynamicObjectCollection("entryentity");
                Map mapDataMigrObj = DynamicObjUtil.getOnlyObjMap((DynamicObjectCollection)colls, (String[])new String[]{"reflexcfg"});
                Map<String, String> tablePkConf = DataMigratHelper.getTablePkConf();
                logger.info("\u5f00\u59cb\u63d2\u5165\u4e3b\u8868");
                result = DataMigratHelper.insertMainTab(colls, mapDataMigrObj, tablePkConf, className);
                logger.info("\u4e3b\u8868\u63d2\u5165\u7ed3\u675f\uff1a" + result.isSuccess());
                for (Map.Entry entry : mapDataMigrObj.entrySet()) {
                    logger.info("\u5f00\u59cb\u63d2\u5165\u5176\u4ed6\u8868");
                    List dataMigrObjs = (List)entry.getValue();
                    if (null == dataMigrObjs || dataMigrObjs.isEmpty()) continue;
                    DynamicObject dataMigObj = (DynamicObject)dataMigrObjs.get(0);
                    DynamicObject reflexcfgObj = dataMigObj.getDynamicObject("reflexcfg");
                    String targetTable = reflexcfgObj.getString("destabkey");
                    String srcTable = reflexcfgObj.getString("number");
                    String pkField = tablePkConf.get(targetTable);
                    if (StringUtils.isEmpty((CharSequence)pkField)) {
                        UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u914d\u7f6e\u4e3b\u952e", (String)"DataMigratHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), srcTable));
                    }
                    List<String> updField = DataMigratHelper.getTabFields(dataMigrObjs);
                    String type = reflexcfgObj.getString("type");
                    HashMap<String, Object> filters = new HashMap<String, Object>(16);
                    if (!result.isSuccess()) continue;
                    switch (type) {
                        case "1": {
                            result = DataMigratHelper.splitByApp(className, tablePkConf, dataMigrObjs, targetTable, srcTable, updField, filters);
                            break;
                        }
                        case "3": {
                            result = UpgradeSqlUtil.batchUpdate((String)className, updField, (String)srcTable, filters, (String)targetTable, (String)pkField);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error(errMsg);
                UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)errMsg);
            }
            finally {
                if (result.isSuccess()) {
                    dataMigratObj.set("issuncess", (Object)Boolean.TRUE);
                    dataMigratObj.set("errdesc_tag", (Object)"");
                    dataMigratObj.set("errdesc", (Object)"");
                } else {
                    dataMigratObj.set("issuncess", (Object)Boolean.FALSE);
                    dataMigratObj.set("errdesc_tag", (Object)(result.getErrorInfo() + errMsg));
                    dataMigratObj.set("errdesc", (Object)(result.getErrorInfo() + errMsg).substring(0, 50));
                }
                logger.info("\u6267\u884c\u7ed3\u679c\uff1a" + result.isSuccess() + result.getLog() + result.getErrorInfo());
            }
        }
        logger.info("\u4fdd\u5b58\u7ed3\u679c\uff1a" + dataMigratList.size());
        try (TXHandle h2 = TX.notSupported();){
            SaveServiceHelper.save((DynamicObject[])dataMigratList.toArray(new DynamicObject[dataMigratList.size()]));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpgradeResult repairDatasVal(String className, Object[] pkValues) {
        UpgradeResult result = new UpgradeResult();
        LinkedList<DynamicObject> dataMigratList = new LinkedList<DynamicObject>();
        for (Object pkValue : pkValues) {
            logger.info("\u5f00\u59cb\u4fee\u590d\u5b9e\u6d4b\u503c\u6570\u636e");
            DynamicObject dataMigratObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"qcbd_datamigrat");
            String errMsg = "";
            dataMigratList.add(dataMigratObj);
            CacheHint hint = new CacheHint();
            hint.setTimeout(3600000L);
            CachedDataSet rinsqtyCache = null;
            try {
                if (!dataMigratObj.getBoolean("isexeinspec")) continue;
                DataMigratHelper.repaireSampVal(className, dataMigratObj, result, rinsqtyCache, hint);
            }
            catch (Exception e) {
                errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error(errMsg);
                UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)errMsg);
            }
            finally {
                if (result.isSuccess()) {
                    dataMigratObj.set("issuncess", (Object)Boolean.TRUE);
                    dataMigratObj.set("errdesc_tag", (Object)"");
                    dataMigratObj.set("errdesc", (Object)"");
                } else {
                    dataMigratObj.set("issuncess", (Object)Boolean.FALSE);
                    dataMigratObj.set("errdesc_tag", (Object)(result.getErrorInfo() + errMsg));
                    dataMigratObj.set("errdesc", (Object)(result.getErrorInfo() + errMsg).substring(0, 50));
                }
                logger.info("\u7ed3\u675f\u4fee\u590d\u5b9e\u6d4b\u503c\uff0c\u7ed3\u679c\uff1a" + result.isSuccess() + result.getLog() + result.getErrorInfo());
            }
        }
        logger.info("\u4fdd\u5b58\u5b9e\u6d4b\u503c\u7ed3\u679c\uff1a" + dataMigratList.size());
        SaveServiceHelper.save((DynamicObject[])dataMigratList.toArray(new DynamicObject[dataMigratList.size()]));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void repaireSampVal(String className, DynamicObject dataMigratObj, UpgradeResult result, CachedDataSet rinsqtyCache, CacheHint hint) {
        String entity = dataMigratObj.getString("entitynumber.number");
        DynamicObject billtype = dataMigratObj.getDynamicObject("billtype");
        if (null == billtype) {
            throw new KDException(new ErrorCode("9998", "billtype empty exception"), new Object[0]);
        }
        String billtypeid = billtype.getPkValue().toString();
        QFilter reflexFilter = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1").and("billtypeid", "=", (Object)billtypeid);
        DynamicObjectCollection reflexCollection = QueryServiceHelper.query((String)"qcbd_tablereflexcfg", (String)"number, destabkey", (QFilter[])reflexFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)reflexCollection)) {
            throw new KDException(new ErrorCode("9997", "reflex no match exception"), new Object[0]);
        }
        String mainOldTable = ((DynamicObject)reflexCollection.get(0)).getString("number");
        Map repairedataCfgMap = ParameterUtil.getQmcSystemPropMap((String)"repairedatacfg");
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        String mainTableName = mainEntityType.getAlias();
        String appId = mainEntityType.getAppId();
        String matTable = "t_" + appId + "_inspentry";
        int i = 0;
        Boolean finish = Boolean.FALSE;
        ORMImpl orm = new ORMImpl();
        while (!finish.booleanValue()) {
            logger.info("billval row index" + ++i);
            try {
                TXHandle h1 = TX.requiresNew();
                Throwable throwable = null;
                try {
                    DataSet fidDs;
                    Long beginIndex = 0L;
                    DynamicObject dataRepaireCfg = BusinessDataServiceHelper.loadSingle((Object)1552809990937469952L, (String)"qcbd_sysconfig");
                    DynamicObjectCollection entryentity = dataRepaireCfg.getDynamicObjectCollection("entryentity");
                    Optional<DynamicObject> optional = entryentity.stream().filter(x -> billtypeid.equalsIgnoreCase(x.getString("attrkey"))).findAny();
                    if (optional.isPresent()) {
                        String lastIndex = optional.get().getString("attrvalue");
                        beginIndex = Long.parseLong(lastIndex);
                    } else {
                        DynamicObject indexEntry = entryentity.addNew();
                        indexEntry.set("attrkey", (Object)billtypeid);
                    }
                    String testbillnos = dataMigratObj.getString("testbillnos");
                    if (StringUtils.isBlank((CharSequence)testbillnos)) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("SELECT FID FROM ");
                        sb.append(mainOldTable);
                        sb.append(" WHERE FID > ");
                        sb.append(beginIndex);
                        sb.append(" AND FBILLTYPE = ");
                        sb.append(billtypeid);
                        sb.append(" ORDER BY FID");
                        fidDs = DataMigratHelper.getLimitFids(className, repairedataCfgMap, sb);
                    } else {
                        finish = Boolean.TRUE;
                        String[] split = testbillnos.split(",");
                        StringBuilder filter = new StringBuilder(" where fbillno in(");
                        for (String s : split) {
                            filter.append("'");
                            filter.append(s);
                            filter.append("',");
                        }
                        filter.deleteCharAt(filter.length() - 1);
                        filter.append(")");
                        fidDs = UpgradeSqlUtil.queryDataSet((String)className, (String)"fid", (String)mainTableName, (String)filter.toString());
                    }
                    DynamicObjectCollection objs = DataMigratHelper.getDyoByDataSet((ORM)orm, fidDs);
                    if (objs.isEmpty()) {
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)testbillnos)) {
                        Long maxFid = ((DynamicObject)objs.get(objs.size() - 1)).getLong("fid");
                        entryentity.stream().filter(x -> billtypeid.equalsIgnoreCase(x.getString("attrkey"))).findFirst().get().set("attrvalue", (Object)String.valueOf(maxFid));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRepaireCfg});
                    }
                    List assignShardList = AverageAssignUtil.getAssignListByMaxSize(objs.stream().collect(Collectors.toList()), (int)Integer.parseInt((String)repairedataCfgMap.get("oncenumberbill")));
                    if (!result.isSuccess()) continue;
                    if (i == 1) {
                        DataMigratHelper.updateUquuid(appId);
                    }
                    for (List dyos : assignShardList) {
                        try {
                            Set<Long> fids = dyos.stream().map(o -> o.getLong("fid")).collect(Collectors.toSet());
                            DataSet rinsqtyRows = UpgradeSqlUtil.queryDataSet((String)className, (String)"fentryid,frinsqty", (String)matTable, (String)(" where fid in(" + DataMigratHelper.getStringBySet(fids) + ")"));
                            rinsqtyCache = rinsqtyRows.cache(hint);
                            DataMigratHelper.deleteOld(appId, rinsqtyCache);
                            result = DataMigratHelper.repairSampleCol(className, rinsqtyCache, appId, matTable, Integer.parseInt((String)repairedataCfgMap.get("oncenumberentry")));
                        }
                        finally {
                            if (!result.isSuccess()) {
                                h1.markRollback();
                            }
                            rinsqtyCache.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h1 == null) continue;
                    if (throwable != null) {
                        try {
                            h1.close();
                        }
                        catch (Throwable filter) {
                            throwable.addSuppressed(filter);
                        }
                        continue;
                    }
                    h1.close();
                }
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("9996", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)), new Object[0]);
            }
        }
    }

    private static void deleteOld(String appId, CachedDataSet rinsqtyCache) {
        DBRoute dbRoute = new DBRoute("qmc");
        String fentryIds = DataMigratHelper.getStringBySet(rinsqtyCache.getList(0, rinsqtyCache.getRowCount()).stream().map(o -> o.getLong("fentryid")).collect(Collectors.toSet()));
        StringBuilder deleteSql = new StringBuilder("delete from t_");
        deleteSql.append(appId).append("_inspsubressamp").append(" where fentryid in(").append(fentryIds).append(");");
        deleteSql.append("delete from t_");
        deleteSql.append(appId).append("_inspsubresrela").append(" where fentryid in(").append(fentryIds).append(");");
        deleteSql.append("delete from t_");
        deleteSql.append(appId).append("_inspentry_l").append(" where fentryid in(").append(fentryIds).append(");");
        DB.execute((DBRoute)dbRoute, (String)deleteSql.toString(), null);
    }

    private static void updateUquuid(String appId) {
        DBRoute dbRoute = new DBRoute("qmc");
        String updateProjUuid = "update t_" + appId + "_inspsubresproj set fuquuid = fdetailid where fuquuid = ' '";
        DB.execute((DBRoute)dbRoute, (String)updateProjUuid, null);
    }

    private static UpgradeResult splitByApp(String className, Map<String, String> tablePkConf, List<DynamicObject> dataMigObjs, String targetTable, String srcTable, List<String> updField, Map<String, Object> filters) {
        UpgradeResult result = new UpgradeResult();
        String parentTab = dataMigObjs.get(0).getString("parentdestable");
        if (StringUtils.isEmpty((CharSequence)parentTab)) {
            result = UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u7236\u8868\u65e0\u6cd5\u8fdb\u884c\u5173\u8054\u63d2\u5165\u3002", (String)"DataMigratHelper_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), srcTable));
            return result;
        }
        String parentPk = tablePkConf.get(parentTab);
        if (StringUtils.isEmpty((CharSequence)parentPk)) {
            UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u914d\u7f6e\u4e3b\u952e\u3002", (String)"DataMigratHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), parentPk));
            return result;
        }
        String targetPk = tablePkConf.get(targetTable);
        result = UpgradeSqlUtil.insertSelect((String)className, (String)srcTable, (String)targetTable, (String)targetPk, updField, (String)parentTab, (String)parentPk, filters);
        if (result.isSuccess()) {
            result = DataMigratHelper.multilingualTabDel(className, tablePkConf, dataMigObjs, targetTable, srcTable, filters, result, targetPk);
        }
        return result;
    }

    private static UpgradeResult multilingualTabDel(String className, Map<String, String> tablePkConf, List<DynamicObject> dataMigObjs, String targetTable, String srcTable, Map<String, Object> filters, UpgradeResult result, String targetPk) {
        List<String> updField = DataMigratHelper.getTabFields(dataMigObjs.stream().filter(x -> x.getBoolean("ismutilan")).collect(Collectors.toList()));
        if (updField.size() > 0) {
            updField.add("fpkid");
            updField.add("flocaleid");
            String pkName = tablePkConf.get(targetTable + "_L");
            if (StringUtils.isEmpty((CharSequence)pkName)) {
                pkName = "fpkid";
            }
            result = UpgradeSqlUtil.insertSelect((String)className, (String)(srcTable + "_L"), (String)(targetTable + "_L"), (String)pkName, updField, (String)targetTable, (String)targetPk, filters);
        }
        return result;
    }

    private static UpgradeResult insertMainTab(DynamicObjectCollection colls, Map<String, List<DynamicObject>> mapDataMigrObj, Map<String, String> tablePkConf, String className) {
        UpgradeResult result = new UpgradeResult();
        if (CollectionUtils.isEmpty((Collection)colls)) {
            return result;
        }
        DynamicObject mainTabRow = colls.stream().filter(x -> StringUtils.isEmpty((CharSequence)x.getString("parentdestable"))).findFirst().get();
        if (null == mainTabRow) {
            return result;
        }
        DynamicObject mainTabReflexCfg = mainTabRow.getDynamicObject("reflexcfg");
        List<DynamicObject> mainTabFields = mapDataMigrObj.remove(mainTabReflexCfg.getPkValue().toString());
        String mainTarget = mainTabReflexCfg.getString("destabkey");
        String mainSrc = mainTabReflexCfg.getString("number");
        HashMap<String, Object> filters = new HashMap<String, Object>(16);
        String billTypeId = mainTabReflexCfg.getString("billtypeid");
        if (StringUtils.isBlank((CharSequence)billTypeId)) {
            UpgradeSqlUtil.buildResult((UpgradeResult)result, (boolean)Boolean.FALSE, (String)String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u914d\u7f6e\u6620\u5c04\u5355\u636e\u7c7b\u578b\u3002", (String)"DataMigratHelper_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), mainTarget));
            return result;
        }
        Long billTypeIdL = mainTabReflexCfg.getLong("billtypeid");
        filters.put("fbilltype", billTypeIdL);
        List<String> updField = DataMigratHelper.getTabFields(mainTabFields);
        String mainTargetPk = tablePkConf.get(mainTarget);
        result = UpgradeSqlUtil.insertSelect((String)className, (String)mainSrc, (String)mainTarget, (String)mainTargetPk, updField, null, null, filters);
        if (result.isSuccess()) {
            filters.clear();
            result = DataMigratHelper.multilingualTabDel(className, tablePkConf, mainTabFields, mainTarget, mainSrc, filters, result, mainTargetPk);
            if (result.isSuccess()) {
                Set cfgs = colls.stream().filter(x -> mainTarget.equals(x.getString("parentdestable")) && "1".equals(x.getDynamicObject("reflexcfg").getString("type"))).map(x -> x.getDynamicObject("reflexcfg")).collect(Collectors.toSet());
                for (DynamicObject cfg : cfgs) {
                    List<DynamicObject> entryFields = mapDataMigrObj.remove(cfg.getPkValue().toString());
                    List<String> entryFieldList = DataMigratHelper.getTabFields(entryFields);
                    String destTab = cfg.getString("destabkey");
                    String destTabPk = String.valueOf(tablePkConf.get(destTab));
                    result = UpgradeSqlUtil.insertSelect((String)className, (String)cfg.getString("number"), (String)destTab, (String)destTabPk, entryFieldList, (String)mainTarget, (String)mainTargetPk, filters);
                }
            }
        }
        return result;
    }

    private static List<String> getTabFields(List<DynamicObject> mainTabFields) {
        Set fieldSet = DynamicObjUtil.getFieldSetStr(mainTabFields, (String)"desfield");
        ArrayList<String> updField = new ArrayList<String>(fieldSet);
        return updField;
    }

    private static Map<String, String> getTablePkConf() {
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"qcbd_tablepkconf", (String)"number, billentity.tabkey", (QFilter[])new QFilter("status", "=", (Object)"C").toArray());
        return configs.stream().collect(Collectors.toMap(x -> x.getString("billentity.tabkey"), x -> x.getString("number")));
    }

    private static void setEntryRowData(EntityType entityType, String fieldID, DynamicObject coll) {
        String tableName = entityType.getAlias();
        DynamicProperty prop = entityType.getProperty(fieldID);
        if (prop == null || StringUtils.isBlank((CharSequence)tableName)) {
            return;
        }
        String groupName = prop.getTableGroup();
        String fieldName = prop.getAlias();
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            tableName = tableName + "_" + groupName;
            coll.set("expfix", (Object)groupName);
        }
        String fieldCap = DynamicObjPropUtil.getPropCap((IDataEntityProperty)prop);
        coll.set("destable", (Object)tableName);
        coll.set("desfield", (Object)fieldName);
        coll.set("srctable", (Object)"");
        coll.set("srcfield", (Object)fieldName);
        coll.set("srcfieldtagname", (Object)fieldCap);
        coll.set("srcfieldtag", (Object)prop.getName());
        IDataEntityType parentProp = null;
        if (prop.getParent() != null) {
            parentProp = prop.getParent().getParent();
        }
        if (parentProp != null) {
            coll.set("parentdestable", (Object)parentProp.getAlias());
        }
        if (prop instanceof MuliLangTextProp) {
            coll.set("ismutilan", (Object)true);
        }
    }

    public static void autoBuildRef(DynamicObject dataEntitie) {
        DynamicObjectCollection colls = dataEntitie.getDynamicObjectCollection("entryentity");
        DynamicObject[] reflexCfgs = DataMigratHelper.getTableReflexCfg(colls);
        for (DynamicObject coll : colls) {
            DynamicObject reflexCfg = DataMigratHelper.getReflexCfg(reflexCfgs, coll);
            if (null == reflexCfg) continue;
            coll.set("reflexcfg", (Object)reflexCfg.getLong("id"));
            coll.set("srctable", (Object)reflexCfg.getString("number"));
        }
    }

    private static DynamicObject[] getTableReflexCfg(DynamicObjectCollection fieldColls) {
        Set destTabs = fieldColls.stream().filter(x -> null != x.getString("destable")).map(x -> x.getString("destable")).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("destabkey", "in", destTabs);
        qfilters.and("status", "=", (Object)"C");
        return BusinessDataServiceHelper.load((String)"qcbd_tablereflexcfg", (String)"id, number, destabkey, type, billentity.fieldkey", (QFilter[])qfilters.toArray());
    }

    private static DynamicObject getReflexCfg(DynamicObject[] reflexCfgs, DynamicObject coll) {
        String tabKey = coll.getString("destable");
        String fieldKey = coll.getString("srcfieldtag");
        for (DynamicObject reflexCfg : reflexCfgs) {
            DynamicObjectCollection billentitys = reflexCfg.getDynamicObjectCollection("billentity");
            if (!tabKey.equals(reflexCfg.getString("destabkey")) || billentitys.isEmpty() || !billentitys.stream().filter(x -> fieldKey.equals(x.getString("fieldkey"))).findAny().isPresent()) continue;
            return reflexCfg;
        }
        for (DynamicObject reflexCfg : reflexCfgs) {
            if (!tabKey.equals(reflexCfg.getString("destabkey")) || "3".equals(reflexCfg.getString("type"))) continue;
            return reflexCfg;
        }
        return null;
    }

    public static List<String> getTableCols(String targetTab) {
        LinkedList<String> retList = new LinkedList<String>();
        DBRoute dbRoute = new DBRoute("qmc");
        DynamicObjectCollection numbers = QueryServiceHelper.query((String)"qcbd_tablereflexcfg", (String)"number", (QFilter[])new QFilter("destabkey", "=", (Object)targetTab).and("status", "=", (Object)"C").toArray());
        for (DynamicObject numberObj : numbers) {
            DataMigratHelper.buildCols(retList, dbRoute, numberObj);
        }
        return retList;
    }

    private static void buildCols(List<String> retList, DBRoute dbRoute, DynamicObject numberObj) {
        String srcTab = numberObj.getString("number");
        retList.addAll(DB.getColumnNames((DBRoute)dbRoute, (String)srcTab));
    }

    public static List<String> toUpperList(List<String> colNames) {
        LinkedList<String> retList = new LinkedList<String>();
        for (String colName : colNames) {
            retList.add(colName.toUpperCase());
        }
        return retList;
    }

    private static UpgradeResult repairSampleCol(String className, CachedDataSet rinsqtyCache, String appId, String matTable, int oncenumberentry) {
        UpgradeResult result = new UpgradeResult();
        DBRoute dbRoute = new DBRoute("qmc");
        ORMImpl orm = new ORMImpl();
        String fieldPre = "ftext";
        Map matchFlagMap = BusinessDataServiceHelper.loadFromCache((String)"qcbd_matchflag", (String)"id,number", null);
        CacheManagerQmcUtil datarepaireUtil = new CacheManagerQmcUtil("datarepaire");
        int i = 0;
        while (rinsqtyCache.iterator(oncenumberentry * i, oncenumberentry * (i + 1)).hasNext()) {
            if ("true".equalsIgnoreCase(datarepaireUtil.get("timeout"))) {
                throw new KDException(new ErrorCode("9999", "qmc custome time out error"), new Object[0]);
            }
            List matDyos = rinsqtyCache.getList(oncenumberentry * i, oncenumberentry);
            Set<Long> fentryids = matDyos.stream().map(o -> o.getLong("fentryid")).collect(Collectors.toSet());
            String fentryIdsIn = DataMigratHelper.getStringBySet(fentryids);
            DataSet insResultRows = UpgradeSqlUtil.queryDataSet((String)className, (String)"a.fentryid,a.fdetailid,a.fseq,a.finspectioncontent,a.fnormtype,a.fcomparison,a.fspecvalue,a.ftopvalue,a.fdownvalue,b.fuquuid", (String)("t_qcp_inspsubentity a inner join t_" + appId + "_inspsubresproj b"), (String)(" on a.fdetailid = b.fdetailid where a.fentryid in (" + fentryIdsIn + ")"));
            DynamicObjectCollection insResultDyos = DataMigratHelper.getInsResultDyos((ORM)orm, insResultRows);
            Map<Long, DynamicObject> insResultDyosDetailIdMap = insResultDyos.stream().collect(Collectors.toMap(item -> item.getLong("fdetailid"), item -> item, (a, b) -> a));
            Map<Long, List<DynamicObject>> insResultDyosEntryIdMap = insResultDyos.stream().collect(Collectors.groupingBy(item -> item.getLong("fentryid")));
            insResultRows.close();
            Map<Integer, Map<Long, List<DynamicObject>>> sampleSplitMap = DataMigratHelper.querySplitDatasetMap(className, fieldPre, " where fentryid in (" + fentryIdsIn + ")");
            logger.info("\u5f00\u59cb\u4fee\u590d\u6837\u672c\u548c\u6837\u672c\u5173\u7cfb\u8868");
            result = DataMigratHelper.insertInsResultRelAndSam(fieldPre, matDyos, insResultDyosDetailIdMap, insResultDyosEntryIdMap, sampleSplitMap, matchFlagMap, className, appId);
            if (!result.isSuccess()) break;
            logger.info("\u4fee\u590d\u6837\u672c\u548c\u6837\u672c\u5173\u7cfb\u8868\u7ed3\u679c\uff1a" + result.isSuccess() + result.getLog() + result.getErrorInfo());
            logger.info("\u5f00\u59cb\u4fee\u590d\u9879\u76ee\u8868");
            result = DataMigratHelper.updateInsResultPro(matDyos, insResultDyos, className, appId);
            if (!result.isSuccess()) break;
            logger.info("\u4fee\u590d\u9879\u76ee\u8868\uff1a" + result.isSuccess() + result.getLog() + result.getErrorInfo());
            ++i;
            String sqlEnd = ");";
            if (result.isSuccess()) {
                logger.info("\u5f00\u59cb\u4fee\u590d\u5c55\u793a\u65b9\u5f0f");
                StringBuilder updateMatEntrySql = new StringBuilder("update ");
                updateMatEntrySql.append(matTable);
                updateMatEntrySql.append(" set fshowtype = '0' where fshowtype = ' ' and fentryid in(").append(fentryIdsIn).append(sqlEnd);
                updateMatEntrySql.append("update ");
                updateMatEntrySql.append(matTable);
                updateMatEntrySql.append(" a set fsubcomment = (select b.fsubcomment from t_qcp_decisubentity b where b.fentryid = a.fentryid) where exists (select 1 from t_qcp_decisubentity b where b.fentryid = a.fentryid) and fentryid in(").append(fentryIdsIn).append(sqlEnd);
                result = UpgradeSqlUtil.excuteSqlNoTransaction((String)updateMatEntrySql.toString(), (DBRoute)dbRoute, null);
                logger.info("\u4fee\u590d\u5c55\u793a\u65b9\u5f0f\uff1a" + result.isSuccess() + result.getLog() + result.getErrorInfo());
            }
            if (!result.isSuccess()) continue;
            StringBuilder insertMatMulTable = new StringBuilder("insert into ").append(matTable).append("_l (fpkid,fentryid,flocaleid,fsubcomment)").append("select a.fpkid,b.fentryid,a.flocaleid,a.fsubcomment from t_qcp_decisubentity_l a left join t_qcp_decisubentity b on a.fdetailid = b.fdetailid ").append("where b.fentryid in (").append(fentryIdsIn).append(sqlEnd);
            result = UpgradeSqlUtil.excuteSqlNoTransaction((String)insertMatMulTable.toString(), (DBRoute)dbRoute, null);
        }
        return result;
    }

    private static String getStringBySet(Set<Long> fentryids) {
        String str = "";
        if (!CollectionUtils.isEmpty(fentryids)) {
            str = StringUtils.join((Object[])new Set[]{fentryids}).replace("[", "").replace("]", "");
        }
        return str;
    }

    private static Map<Integer, Map<Long, List<DynamicObject>>> querySplitDatasetMap(String className, String fieldPre, String filter) {
        HashedMap map = new HashedMap(6);
        map.put(1, "a");
        map.put(2, "b");
        map.put(3, "c");
        map.put(4, "d");
        map.put(5, "e");
        map.put(6, "f");
        ORMImpl orm = new ORMImpl();
        HashedMap sampleSetMap = new HashedMap(6);
        for (Map.Entry entry : map.entrySet()) {
            StringBuilder selectFieldsBuild = new StringBuilder("fentryid,fdetailid,");
            Integer key = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            for (int i = 1 + 50 * (key - 1); i <= 50 * key; ++i) {
                selectFieldsBuild.append(fieldPre);
                selectFieldsBuild.append(i);
                selectFieldsBuild.append(",");
            }
            String selectFields = selectFieldsBuild.deleteCharAt(selectFieldsBuild.length() - 1).toString();
            DataSet sampleRows = UpgradeSqlUtil.queryDataSet((String)className, (String)selectFields, (String)("t_qcp_inspsubentity_" + value), (String)filter);
            sampleSetMap.put(key, DataMigratHelper.getDyoByDataSet((ORM)orm, sampleRows));
            sampleRows.close();
        }
        HashMap<Integer, Map<Long, List<DynamicObject>>> sampleResultGroupMap = new HashMap<Integer, Map<Long, List<DynamicObject>>>(6);
        for (Map.Entry entry : sampleSetMap.entrySet()) {
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)entry.getValue();
            Map<Long, List<DynamicObject>> fentryIdMap = dynamicObjects.stream().collect(Collectors.groupingBy(o -> o.getLong("fentryid")));
            sampleResultGroupMap.put((Integer)entry.getKey(), fentryIdMap);
        }
        return sampleResultGroupMap;
    }

    private static UpgradeResult insertInsResultRelAndSam(String fieldPre, List<Row> matDyos, Map<Long, DynamicObject> insResultDetailIdDyosMap, Map<Long, List<DynamicObject>> insResultDyosEntryIdMap, Map<Integer, Map<Long, List<DynamicObject>>> sampleSetMap, Map<Object, DynamicObject> matchFlagMap, String className, String appId) {
        ORM orm = ORM.create();
        DBRoute dbRoute = new DBRoute("qmc");
        String entityTableRela = "t_" + appId + "_inspsubresrela";
        String entityTableSamp = "t_" + appId + "_inspsubressamp";
        String insertRelSql = "insert into " + entityTableRela + "(fentryid,fdetailid,fseq,fexmapleid,fvaldeter,fvalratstr,fprojuuid,fsamp_seq,fjudge) values (?,?,?,?,?,?,?,?,?)";
        LinkedList<Object[]> relParamList = new LinkedList<Object[]>();
        String insertSamSql = "insert into " + entityTableSamp + "(fentryid,fdetailid,fseq,fsamplenumid,fsamplenum,fsampckval,fsampleres) values (?,?,?,?,?,?,?)";
        LinkedList<Object[]> samParamList = new LinkedList<Object[]>();
        int matSize = matDyos.size();
        ArrayList<Long> allGuidId_qcpinspbill = new ArrayList<Long>(16);
        block0: for (int m = 0; m < matSize; ++m) {
            Row matRow = matDyos.get(m);
            int rinsQty = matRow.getInteger("frinsqty");
            long entryId = matRow.getLong("fentryid");
            for (int i = 1; i <= rinsQty; ++i) {
                int rowCount;
                LinkedList<Object> samRowParam = new LinkedList<Object>();
                if (i > 300) continue block0;
                List<DynamicObject> insResultSplitList = i % 50 == 0 ? sampleSetMap.get(i / 50).get(entryId) : sampleSetMap.get(i / 50 + 1).get(entryId);
                long exmapleId = DataMigratHelper.getGuidID(allGuidId_qcpinspbill, orm);
                if (Objects.nonNull(insResultSplitList)) {
                    for (DynamicObject insResultSplitDyo : insResultSplitList) {
                        LinkedList<Object> relRowParam = new LinkedList<Object>();
                        DataMigratHelper.buildInsResultRel(fieldPre, insResultDetailIdDyosMap, insResultSplitDyo, entryId, relRowParam, i, exmapleId, matchFlagMap, allGuidId_qcpinspbill);
                        if (relRowParam.isEmpty()) continue;
                        relParamList.add(relRowParam.toArray());
                    }
                }
                int n = rowCount = Objects.isNull(insResultSplitList) ? 0 : insResultSplitList.size();
                if (rowCount <= 0) continue;
                DataMigratHelper.buildInsResultSam(fieldPre, insResultDyosEntryIdMap, insResultSplitList, entryId, samRowParam, i, exmapleId, rowCount, DataMigratHelper.getGuidID(allGuidId_qcpinspbill, orm));
                samParamList.add(samRowParam.toArray());
            }
        }
        UpgradeResult result = new UpgradeResult();
        if (!CollectionUtils.isEmpty(relParamList) && (result = UpgradeSqlUtil.excuteSqlBatchNoTransaction((String)insertRelSql, (DBRoute)dbRoute, relParamList)).isSuccess() && !CollectionUtils.isEmpty(samParamList)) {
            result = UpgradeSqlUtil.excuteSqlBatchNoTransaction((String)insertSamSql, (DBRoute)dbRoute, samParamList);
        }
        return result;
    }

    private static void buildInsResultSam(String fieldPre, Map<Long, List<DynamicObject>> insResultDyosEntryIdMap, List<DynamicObject> insResultSplitDyos, long entryId, List<Object> samRowParam, int i, long exmapleId, int proNum, long detailId) {
        Optional<DynamicObject> insResultRow;
        List<DynamicObject> projDyos = insResultDyosEntryIdMap.get(entryId);
        String insResult = "";
        if (!CollectionUtils.isEmpty(projDyos) && (insResultRow = projDyos.stream().filter(o -> ResManager.loadKDString((String)"\u6837\u672c\u68c0\u9a8c\u7ed3\u679c", (String)"DataMigratHelper_6", (String)SYSTEM_TYPE, (Object[])new Object[0]).equals(o.get("finspectioncontent"))).findFirst()).isPresent()) {
            long fdetailid = insResultRow.get().getLong("fdetailid");
            Optional<DynamicObject> insResultSplitRow = insResultSplitDyos.stream().filter(o -> o.getLong("fdetailid") == fdetailid).findFirst();
            if (insResultSplitRow.isPresent()) {
                insResult = StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u5408\u683c", (String)"DataMigratHelper_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), (CharSequence)insResultSplitRow.get().getString(fieldPre + i)) ? "Y" : "N";
            }
        }
        samRowParam.add(entryId);
        samRowParam.add(detailId);
        samRowParam.add(i);
        samRowParam.add(exmapleId);
        samRowParam.add(i);
        samRowParam.add(proNum == 0 ? 0 : proNum - 1);
        samRowParam.add(insResult);
    }

    private static void buildInsResultRel(String fieldPre, Map<Long, DynamicObject> insResultDyosMap, DynamicObject insResultSplitDyo, long entryId, List<Object> relRowParam, int i, long exmapleId, Map<Object, DynamicObject> matchFlagMap, List<Long> allGuidId_qcpinspbill) {
        ICheckProjectCaleStrategy ckProjStrategy;
        long detailId = insResultSplitDyo.getLong("fdetailid");
        DynamicObject insResultDyo = insResultDyosMap.get(detailId);
        if (Objects.isNull(insResultDyo) || ResManager.loadKDString((String)"\u6837\u672c\u68c0\u9a8c\u7ed3\u679c", (String)"DataMigratHelper_6", (String)SYSTEM_TYPE, (Object[])new Object[0]).equals(insResultDyo.getString("finspectioncontent"))) {
            return;
        }
        relRowParam.add(entryId);
        long pkId = DataMigratHelper.getGuidID(allGuidId_qcpinspbill, ORM.create());
        relRowParam.add(pkId);
        relRowParam.add(i);
        relRowParam.add(exmapleId);
        String valDeter = "";
        BigDecimal valRat = null;
        String result = insResultSplitDyo.getString(fieldPre + i);
        String normType = insResultDyo.getString("fnormtype");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)normType)) {
            if (StringUtils.isNotBlank((CharSequence)result) && result.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
                valRat = new BigDecimal(result);
            }
            relRowParam.add("");
            relRowParam.add(result);
        } else {
            if (StringUtils.isNotBlank((CharSequence)result)) {
                valDeter = result.toUpperCase();
            }
            relRowParam.add(valDeter);
            relRowParam.add("");
        }
        relRowParam.add(insResultDyo.getString("fuquuid"));
        relRowParam.add(i);
        CheckProjectCaleFactory ckProjFactory = CheckProjectCaleFactory.getInstance();
        String matchFlag = "";
        Object matchFlagId = insResultDyo.get("fcomparison");
        if ((Long)matchFlagId != 0L) {
            matchFlag = matchFlagMap.get(matchFlagId).getString("number");
        }
        if (Objects.nonNull(ckProjStrategy = ckProjFactory.getCkProjectStrategy(matchFlag, normType))) {
            CheckProjectCaleModel paramModel = new CheckProjectCaleModel(normType, matchFlag, insResultDyo.getString("fspecvalue"), insResultDyo.getBigDecimal("ftopvalue"), insResultDyo.getBigDecimal("fdownvalue"), valDeter, valRat);
            String measureJudgeRes = ckProjStrategy.judgmentResultMain(paramModel);
            relRowParam.add(measureJudgeRes);
        } else {
            relRowParam.add("");
        }
    }

    private static UpgradeResult updateInsResultPro(List<Row> matRows, DynamicObjectCollection insResultDyos, String className, String appId) {
        DBRoute dbRoute = new DBRoute("qmc");
        String entityTableProj = "t_" + appId + "_inspsubresproj";
        String updateProSql = "update " + entityTableProj + " set fprojckval = ?,fchoosesampqty = ? where fentryid = ?";
        StringBuilder deleteProSql = new StringBuilder(String.format(ResManager.loadKDString((String)"delete from %s where finspectioncontent = '\u6837\u672c\u68c0\u9a8c\u7ed3\u679c'", (String)"DataMigratHelper_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), entityTableProj));
        deleteProSql.append(" and fentryid in (");
        deleteProSql.append(DataMigratHelper.getStringBySet(insResultDyos.stream().map(o -> o.getLong("fentryid")).collect(Collectors.toSet()))).append(")");
        LinkedList<Object[]> proParamList = new LinkedList<Object[]>();
        for (DynamicObject insResultDyo : insResultDyos) {
            LinkedList<Long> proRowParam = new LinkedList<Long>();
            long entryId = insResultDyo.getLong("fentryid");
            Optional<Row> matRowOpt = matRows.stream().filter(o -> o.getLong("fentryid") == entryId).findFirst();
            if (!matRowOpt.isPresent()) continue;
            long rinsQty = matRowOpt.get().getLong("frinsqty");
            proRowParam.add(rinsQty);
            proRowParam.add(rinsQty);
            proRowParam.add(entryId);
            proParamList.add(proRowParam.toArray());
        }
        UpgradeResult result = new UpgradeResult();
        if (!CollectionUtils.isEmpty(proParamList) && (result = UpgradeSqlUtil.excuteSqlBatchNoTransaction((String)updateProSql, (DBRoute)dbRoute, proParamList)).isSuccess()) {
            result = UpgradeSqlUtil.excuteSqlNoTransaction((String)deleteProSql.toString(), (DBRoute)dbRoute, null);
        }
        return result;
    }

    private static DataSet getLimitFids(String className, Map<String, String> repairedataCfgMap, StringBuilder sb) {
        return DB.queryDataSet((String)className, (DBRoute)new DBRoute("qmc"), (String)sb.toString()).limit(0, Integer.parseInt(repairedataCfgMap.get("oncenumberbill")));
    }

    private static DynamicObjectCollection getDyoByDataSet(ORM orm, DataSet sampleRows) {
        return orm.toPlainDynamicObjectCollection(sampleRows);
    }

    private static DynamicObjectCollection getInsResultDyos(ORM orm, DataSet insResultRows) {
        DynamicObjectCollection dynamicObjects = DataMigratHelper.getDyoByDataSet(orm, insResultRows);
        dynamicObjects.forEach(o -> {
            DynamicSimpleProperty ftopvalue = (DynamicSimpleProperty)o.getDynamicObjectType().getProperties().get((Object)"ftopvalue");
            DynamicSimpleProperty fdownvalue = (DynamicSimpleProperty)o.getDynamicObjectType().getProperties().get((Object)"fdownvalue");
            ftopvalue.setEnableNull(true);
            fdownvalue.setEnableNull(true);
        });
        return dynamicObjects;
    }

    private static Long getGuidID(List<Long> allGuidID, ORM orm) {
        Long guidid = 0L;
        if (allGuidID.isEmpty()) {
            long[] guidIDLs = orm.genLongIds("qcp_inspecpbill", 10000);
            int idsLen = guidIDLs.length;
            ArrayList<Long> idLst = new ArrayList<Long>(10000);
            for (int i = 0; i < idsLen; ++i) {
                Long id = guidIDLs[i];
                idLst.add(id);
            }
            allGuidID.addAll(idLst);
        }
        if (allGuidID.size() > 0) {
            guidid = allGuidID.get(0);
            allGuidID.remove(0);
        }
        return guidid;
    }
}

