/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.qmc.qcbd.common.model.insobj.InspObjAssModel;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class InspObjectCovertHelper {
    private MainEntityType mMainEntityType = null;
    private Map<String, Set<String>> mSearchFieldMap = new HashMap<String, Set<String>>(16);

    public InspObjectCovertHelper(String entityNumber) {
        this.mMainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        this.mSearchFieldMap = this.getSearchFieldMap();
    }

    public DynamicObject[] getInsObjects(List<InspObjAssModel> assModels) {
        Set pkVals = assModels.stream().filter(p -> p.getObjectId() > 0L).map(p -> p.getObjectId()).collect(Collectors.toSet());
        Set assIdSet = assModels.stream().filter(p -> p.getAssId() > 0L).map(p -> p.getAssId()).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("id", "in", pkVals).and("entryentity.id", "in", assIdSet);
        return BusinessDataServiceHelper.load((String)this.mMainEntityType.getName(), (String)(this.getSearchFieldStr() + this.getNoBuildStr()), (QFilter[])qfilters.toArray());
    }

    private String getSearchFieldStr() {
        StringBuilder sbField = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : this.mSearchFieldMap.entrySet()) {
            Set<String> fieldSet = entry.getValue();
            String fieldStr = StringQMCUtil.getFieldStr(fieldSet);
            sbField.append(fieldStr);
            sbField.append(",");
        }
        sbField.deleteCharAt(sbField.length() - 1);
        return sbField.toString();
    }

    private String getNoBuildStr() {
        return ", batchretflg, batchretmsg_tag";
    }

    public JSONObject getInspObjectJSON(DynamicObject dyncObj, Long assEntryID) {
        JSONObject jsObject = new JSONObject();
        Set<String> headSet = this.mSearchFieldMap.get(this.mMainEntityType.getName());
        for (String field : headSet) {
            jsObject.put(field, this.getVal(dyncObj.get(field)));
        }
        if (null == assEntryID) {
            return jsObject;
        }
        Set<String> assSet = this.mSearchFieldMap.get("entryentity");
        DynamicObjectCollection colls = dyncObj.getDynamicObjectCollection("entryentity");
        JSONArray jsEntryArry = new JSONArray();
        for (DynamicObject coll : colls) {
            JSONObject jsEntryObject = new JSONObject();
            Long curassID = (Long)coll.getPkValue();
            if (!curassID.equals(assEntryID)) continue;
            for (String field : assSet) {
                jsEntryObject.put(field, this.getVal(coll.get(field)));
            }
            jsEntryArry.add((Object)jsEntryObject);
        }
        jsObject.put("entryentity", (Object)jsEntryArry);
        return jsObject;
    }

    private Map<String, Set<String>> getSearchFieldMap() {
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(20);
        Set<String> ignoreFieldSet = this.getIngoreField();
        Set<String> containFieldSet = this.getContainField();
        Map mapEntrys = this.mMainEntityType.getAllEntities();
        for (Map.Entry entry : mapEntrys.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            String entryKey = (String)entry.getKey();
            HashSet<String> fieldSet = new HashSet<String>(16);
            DataEntityPropertyCollection props = entityType.getProperties();
            for (IDataEntityProperty prop : props) {
                String propKey = prop.getName();
                if (ignoreFieldSet.contains(propKey) || propKey.contains("_id") || !containFieldSet.contains(propKey)) continue;
                fieldSet.add(propKey);
            }
            fieldMap.put(entryKey, fieldSet);
        }
        return fieldMap;
    }

    private Set<String> getIngoreField() {
        HashSet<String> ignoreField = new HashSet<String>(10);
        ignoreField.add("entryentity");
        ignoreField.add("multilanguagetext");
        ignoreField.add("seq");
        return ignoreField;
    }

    private Set<String> getContainField() {
        HashSet<String> containFieldSet = new HashSet<String>(20);
        containFieldSet.add("id");
        containFieldSet.add("srcentitynumber");
        containFieldSet.add("srcbillid");
        containFieldSet.add("srcentryid");
        containFieldSet.add("srcqty");
        containFieldSet.add("srcbaseqty");
        containFieldSet.add("sumsrcqualifqty");
        containFieldSet.add("sumqualifbaseqty");
        containFieldSet.add("sumsrcunqualifqty");
        containFieldSet.add("sumunqualifbaseqty");
        containFieldSet.add("ass_qualifbaseqty");
        containFieldSet.add("ass_qualifsrcqty");
        containFieldSet.add("ass_unqualifbaseqty");
        containFieldSet.add("ass_unqualifsrcqty");
        containFieldSet.add("ass_custtextval");
        containFieldSet.add("ass_secondck");
        containFieldSet.add("ass_billentryid");
        containFieldSet.add("ass_entitynumber");
        containFieldSet.add("ass_updtime");
        containFieldSet.add("ass_handmethed");
        return containFieldSet;
    }

    private Object getVal(Object valObj) {
        if (valObj instanceof BigDecimal && ((BigDecimal)valObj).intValue() == 0) {
            valObj = BigDecimal.ZERO;
        }
        if (valObj instanceof DynamicObject && null != valObj) {
            return ((DynamicObject)valObj).getString("number");
        }
        return valObj;
    }
}

