/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.common.args.insobj.IniInspObjectEventArgs;
import kd.qmc.qcbd.common.factory.InspObjectFactory;
import kd.qmc.qcbd.common.model.insobj.InspObjAssModel;

public class InspObjectHelper {
    private static Log logger = LogFactory.getLog(InspObjectHelper.class);

    public static InspObjectFactory getInspObjectFactory(String billType) {
        logger.info("InspObjectFactory billtype " + billType);
        DynamicObject pluginCfg = QueryServiceHelper.queryOne((String)"qcbd_plugin_cfg", (String)"route", (QFilter[])new QFilter[]{new QFilter("entitytype", "=", (Object)billType).and("plugintype", "=", (Object)"A")});
        logger.info("pluginCfg" + pluginCfg);
        if (null != pluginCfg && StringUtils.isNotBlank((CharSequence)pluginCfg.getString("route"))) {
            String className = pluginCfg.getString("route");
            logger.info("className" + className);
            Object factory = TypesContainer.createInstance((String)className);
            if (factory instanceof InspObjectFactory) {
                return (InspObjectFactory)factory;
            }
        }
        return null;
    }

    public static IniInspObjectEventArgs getIniInspObjectEventArgsModel(String argStr) {
        IniInspObjectEventArgs argModel = new IniInspObjectEventArgs();
        if (StringUtils.isNotBlank((CharSequence)argStr)) {
            argModel = (IniInspObjectEventArgs)JSON.parseObject((String)argStr, IniInspObjectEventArgs.class);
        }
        return argModel;
    }

    public static String getIniInspObjectEventArgsModelStr(IniInspObjectEventArgs args) {
        String argStr = "";
        if (args != null) {
            argStr = JSON.toJSONString((Object)args);
        }
        return argStr;
    }

    public static void setDeleteAssID(IPageCache pc, FormOperate formOperate) {
        OperateOption option = formOperate.getOption();
        String deleteAssIDStr = pc.get("Option_DeleteAssID");
        Set<Object> assIdSet = InspObjectHelper.getDeleteAssIDSet(deleteAssIDStr);
    }

    private static Set<Object> getDeleteAssIDSet(String deleteAssIDStr) {
        Set<Object> deleteAssIDs = new HashSet<Object>(16);
        if (StringUtils.isNotBlank((CharSequence)deleteAssIDStr)) {
            deleteAssIDs = (Set)JSON.parseObject((String)deleteAssIDStr, (TypeReference)new TypeReference<Set<Object>>(){}, (Feature[])new Feature[0]);
        }
        return deleteAssIDs;
    }

    public static IniInspObjectEventArgs getIniInspObjectEventArgsModel(OperateOption option) {
        String argStr = option.getVariableValue("IniInspObjectEventArgs", "");
        return InspObjectHelper.getIniInspObjectEventArgsModel(argStr);
    }

    public static void setIniInspObjectEventArgsModel(IniInspObjectEventArgs model, OperateOption option) {
        String argStr = InspObjectHelper.getIniInspObjectEventArgsModelStr(model);
        option.setVariableValue("IniInspObjectEventArgs", argStr);
    }

    public static String getInspObjEntityNumberByAppid(String appid) {
        String entityNumber = "";
        switch (appid) {
            case "qcp": {
                entityNumber = "qcbd_insobj_qcp";
                break;
            }
            case "qcpp": {
                entityNumber = "qcbd_insobj_qcpp";
                break;
            }
            case "qcas": {
                entityNumber = "qcbd_insobj_qcas";
                break;
            }
            default: {
                entityNumber = "qcbd_insobj_other";
            }
        }
        return entityNumber;
    }

    public static Map<String, List<InspObjAssModel>> getInspObjAssModelByID(List<InspObjAssModel> assModels) {
        HashMap<String, List<InspObjAssModel>> assModelMap = new HashMap<String, List<InspObjAssModel>>(16);
        for (InspObjAssModel assModel : assModels) {
            ArrayList<InspObjAssModel> billEntryModels = (ArrayList<InspObjAssModel>)assModelMap.get(assModel.getBillId());
            if (billEntryModels == null) {
                billEntryModels = new ArrayList<InspObjAssModel>();
                assModelMap.put(assModel.getBillId(), billEntryModels);
            }
            billEntryModels.add(assModel);
        }
        return assModelMap;
    }

    public static Boolean isOperateOnList(OperateOption operation) {
        return "true".equals(operation.getVariableValue("listFlag", "false"));
    }
}

