/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.common.util.CopyUtil;

public class RouteSyncHelper {
    private static final String ENTITY_PDM_ROUTE = "pdm_route";
    private static final String ENTITY_QCBD_ROUTE = "qcbd_qmcroute";

    public void dealRoute(List<String> businesskeys, String operation) {
        if (businesskeys == null || businesskeys.isEmpty()) {
            return;
        }
        DynamicObject[] processroutes = BusinessDataServiceHelper.load((Object[])businesskeys.stream().map(Long::parseLong).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_PDM_ROUTE));
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY_QCBD_ROUTE, (String)ENTITY_QCBD_ROUTE, (String)"manurouteid", (QFilter[])new QFilter[]{new QFilter("manurouteid", "in", businesskeys)}, null);
        List updateIdList = query.stream().map(a -> a.getLong("manurouteid")).collect(Collectors.toList());
        ArrayList<DynamicObject> qmcRouteSl = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> qmcRouteUl = new ArrayList<DynamicObject>();
        if (processroutes != null && processroutes.length != 0) {
            for (DynamicObject dynamicObject : processroutes) {
                if (!StringUtils.equals((CharSequence)"unaudit", (CharSequence)operation) && !this.checktype(dynamicObject)) break;
                DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_QCBD_ROUTE);
                CopyUtil.copyPropertiesWithId((DynamicObject)dataEntity, (DynamicObject)dynamicObject);
                this.dealSpecialField(dataEntity, dynamicObject);
                if (updateIdList.contains(Long.parseLong(dynamicObject.getPkValue().toString()))) {
                    qmcRouteUl.add(dataEntity);
                    continue;
                }
                qmcRouteSl.add(dataEntity);
            }
        }
        switch (operation) {
            case "audit": {
                this.save(qmcRouteSl);
                this.update(qmcRouteUl);
                break;
            }
            case "unaudit": {
                this.unAudit(qmcRouteUl);
                break;
            }
            case "enable": 
            case "disable": {
                this.update(qmcRouteUl);
                break;
            }
        }
    }

    private void save(List<DynamicObject> qmcRouteSl) {
        if (qmcRouteSl == null || qmcRouteSl.isEmpty()) {
            return;
        }
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("strictvalidation", String.valueOf(false));
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)ENTITY_QCBD_ROUTE, (DynamicObject[])qmcRouteSl.toArray(new DynamicObject[0]), (OperateOption)saveOption);
        if (!saveResult.isSuccess()) {
            ValidateResultCollection validateResult = saveResult.getValidateResult();
            StringBuilder stringBuild = new StringBuilder();
            List validateErrors = validateResult.getValidateErrors();
            for (ValidateResult v : validateErrors) {
                List allErrorInfo = v.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    String message = operateErrorInfo.getMessage();
                    stringBuild.append(message);
                }
            }
            throw new KDException((Throwable)new Exception(ResManager.loadKDString((String)"\u540c\u6b65\u5de5\u827a\u8def\u7ebf\u5931\u8d25\u3002", (String)"RouteEventService_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0])), new ErrorCode("synRouteFailed", stringBuild.toString()), new Object[0]);
        }
    }

    private void update(List<DynamicObject> qmcRouteUl) {
        if (qmcRouteUl == null || qmcRouteUl.isEmpty()) {
            return;
        }
        try {
            SaveServiceHelper.update((DynamicObject[])qmcRouteUl.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("synRouteFailed", ResManager.loadKDString((String)"\u540c\u6b65\u5de5\u827a\u8def\u7ebf\u5931\u8d25\u3002", (String)"RouteEventService_0", (String)"qmc-qcbd-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void delete(List<DynamicObject> qmcRouteSl) {
        if (qmcRouteSl == null || qmcRouteSl.isEmpty()) {
            return;
        }
        try {
            DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_QCBD_ROUTE);
            DeleteServiceHelper.delete((IDataEntityType)dataEntity.getDynamicObjectType(), (Object[])qmcRouteSl.stream().map(DataEntityBase::getPkValue).toArray());
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("synRouteFailed", ResManager.loadKDString((String)"\u540c\u6b65\u5220\u9664\u5de5\u827a\u8def\u7ebf\u5931\u8d25\u3002", (String)"RouteEventService_1", (String)"qmc-qcbd-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void dealSpecialField(DynamicObject data, DynamicObject sourceData) {
        data.set("origin", (Object)"A");
        data.set("qauditor", data.get("auditor"));
        data.set("manurouteid", sourceData.get("id"));
        data.set("syntime", (Object)TimeServiceHelper.now());
        DynamicObject bomversion = sourceData.getDynamicObject("bomversion");
        if (bomversion != null) {
            data.set("bomversionstr", (Object)bomversion.getString("number"));
            DynamicObject version = bomversion.getDynamicObject("version");
            if (version != null) {
                data.set("bomtypestr", (Object)version.getString("number"));
            }
        }
        data.set("bomversion", null);
        DynamicObjectCollection srcProcessentrys = sourceData.getDynamicObjectCollection("processentry");
        DynamicObjectCollection tarProcessentrys = data.getDynamicObjectCollection("processentry");
        if (srcProcessentrys != null && tarProcessentrys != null && srcProcessentrys.size() == tarProcessentrys.size()) {
            for (int i = 0; i < tarProcessentrys.size(); ++i) {
                DynamicObject tarProcessentry = (DynamicObject)tarProcessentrys.get(i);
                DynamicObject srcProcessentry = (DynamicObject)srcProcessentrys.get(i);
                if (tarProcessentry == null || srcProcessentry == null) continue;
                tarProcessentry.set("route_procentryid", srcProcessentry.get("id"));
            }
        }
    }

    private void unAudit(List<DynamicObject> qmcRouteUl) {
        ArrayList<DynamicObject> qmcRouteDl = new ArrayList<DynamicObject>(qmcRouteUl.size());
        for (DynamicObject dynamicObject : qmcRouteUl) {
            boolean refrenced = BaseDataRefrenceHelper.isRefrenced((String)ENTITY_QCBD_ROUTE, (Object)dynamicObject.getPkValue());
            if (refrenced) continue;
            qmcRouteDl.add(dynamicObject);
        }
        this.delete(qmcRouteDl);
    }

    private boolean checktype(DynamicObject route) {
        boolean f;
        block1: {
            DynamicObject d;
            f = false;
            DynamicObjectCollection processentry = route.getDynamicObjectCollection("processentry");
            if (CollectionUtils.isEmpty((Collection)processentry)) break block1;
            Iterator iterator = processentry.iterator();
            while (iterator.hasNext() && !(f = "1013".equals((d = (DynamicObject)iterator.next()).getString("checktype")) || d.getBoolean("firstcheck"))) {
            }
        }
        return f;
    }
}

