/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class RouteSyncInspectSchemHelper {
    public static void excuteSync(List<Long> pkVals) {
        QFilter qfilter = new QFilter("entryentity.qroute", "in", pkVals);
        String selectProp = StringQMCUtil.getCombStr((String)",", (String[])new String[]{"qroute", "processseq", "operationno", "oproperation", "entryvaliddate", "entryinvaliddate", "route_procentryid"});
        DynamicObject[] inspectproObjs = BusinessDataServiceHelper.load((String)"qcbd_inspectpro", (String)selectProp, (QFilter[])qfilter.toArray());
        if (inspectproObjs == null || inspectproObjs.length <= 0) {
            return;
        }
        Set pkValSet = pkVals.stream().collect(Collectors.toSet());
        qfilter = new QFilter("id", "in", pkVals);
        selectProp = StringQMCUtil.getCombStr((String)",", (String[])new String[]{"parent", "operationno", "operation", "entryvaliddate", "entryinvaliddate", "srcopentryid", "oproperation"});
        DynamicObject[] routeObjsObjs = BusinessDataServiceHelper.load((String)"qcbd_qmcroute", (String)selectProp, (QFilter[])qfilter.toArray());
        Map<Long, List<DynamicObject>> routeMap = Arrays.stream(routeObjsObjs).collect(Collectors.groupingBy(p -> p.getLong("id")));
        for (DynamicObject proObj : inspectproObjs) {
            DynamicObjectCollection proEntrys = proObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject proEntry : proEntrys) {
                List<DynamicObject> routeObjs;
                DynamicObject routeObj;
                DynamicObject processEntryRow;
                DynamicObject qrouteObj = proEntry.getDynamicObject("qroute");
                Long qrouteId = 0L;
                if (qrouteObj != null) {
                    qrouteId = qrouteObj.getLong("id");
                }
                if (!pkValSet.contains(qrouteId) || (processEntryRow = RouteSyncInspectSchemHelper.getProcessEntryRow(routeObj = (routeObjs = routeMap.get(qrouteId)).get(0), proEntry)) == null) continue;
                proEntry.set("operationno", processEntryRow.get("operationno"));
                proEntry.set("oproperation", processEntryRow.get("operation"));
                proEntry.set("entryvaliddate", processEntryRow.get("entryvaliddate"));
                proEntry.set("entryinvaliddate", processEntryRow.get("entryinvaliddate"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])inspectproObjs);
    }

    private static DynamicObject getProcessEntryRow(DynamicObject routeObj, DynamicObject proEntry) {
        DynamicObject processEntryRow = null;
        String processseq = proEntry.getString("processseq");
        DynamicObject routerocentryidObj = proEntry.getDynamicObject("route_procentryid");
        if (routerocentryidObj == null) {
            return processEntryRow;
        }
        Long routerocentryid = routerocentryidObj.getLong("id");
        DynamicObjectCollection processentrys = routeObj.getDynamicObjectCollection("processentry");
        List processentryLst = processentrys.stream().filter(p -> routerocentryid.compareTo(p.getLong("srcopentryid")) == 0 && StringUtils.equalsIgnoreCase((CharSequence)p.getString("parent"), (CharSequence)processseq)).collect(Collectors.toList());
        if (processentryLst.size() == 1) {
            processEntryRow = (DynamicObject)processentryLst.get(0);
        }
        return processEntryRow;
    }
}

