/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.common.util.ParameterUtil;

public class ZJMaterialHelper {
    private Log log = LogFactory.getLog(ZJMaterialHelper.class);
    private static Map<String, Set<String>> mValidBillEntitys = null;
    public static final String KEY_ENTITYENTITY = "EntityEntity";
    public static final String KEY_ENTRYID = "entryid";
    public static final String KEY_MATERIEL = "materiel";
    public static final String KEY_MATERIEL_NUMBER = "materielNumber";
    public static final String KEY_MATERIALCFG = "materialcfg";
    public static final String KEY_MASTERID = "masterid";

    public String validZJ(String entityNumber, List<Long> pkVals) {
        if (!"true".equalsIgnoreCase(ParameterUtil.getQmcSystemProp((String)"verifymaterialcfg"))) {
            return "";
        }
        StringBuilder sbErr = new StringBuilder();
        if (pkVals.size() <= 0) {
            return sbErr.toString();
        }
        ORM orm = ORM.create();
        Map<String, String> filedMap = this.getBillFieldMap(entityNumber);
        if (filedMap.size() <= 0) {
            return sbErr.toString();
        }
        QFilter qfilter = this.getBillQfilter(entityNumber);
        qfilter.and("id", "in", pkVals);
        StringBuilder sbField = new StringBuilder();
        sbField.append(String.format("%s as %s,", filedMap.get(KEY_MATERIEL), KEY_MATERIEL));
        sbField.append(String.format("%s as %s", filedMap.get(KEY_MATERIEL) + ".number", KEY_MATERIEL_NUMBER));
        DataSet dsMaterial = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityNumber, (String)sbField.toString(), (QFilter[])qfilter.toArray(), null).groupBy(new String[]{KEY_MATERIEL, KEY_MATERIEL_NUMBER}).finish();
        DynamicObjectCollection materialObjs = orm.toPlainDynamicObjectCollection(dsMaterial);
        if (materialObjs.size() <= 0) {
            return sbErr.toString();
        }
        Map<Long, String> materialIDMap = this.getMaterialMap(materialObjs);
        Set<Long> materialIDSet = this.getMaterialSet(materialIDMap);
        qfilter = this.getFilterMaterialCFG(materialIDSet);
        DataSet dscfgMaterial = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_inspect_cfg", (String)KEY_MASTERID, (QFilter[])qfilter.toArray(), null).groupBy(new String[]{KEY_MASTERID}).finish();
        DynamicObjectCollection cfgMaterialObjs = orm.toPlainDynamicObjectCollection(dscfgMaterial);
        Set cfgMaterialIDs = cfgMaterialObjs.stream().map(p -> p.getLong(KEY_MASTERID)).collect(Collectors.toSet());
        for (Map.Entry<Long, String> entry : materialIDMap.entrySet()) {
            Long materialID = entry.getKey();
            String number = entry.getValue();
            if (cfgMaterialIDs.contains(materialID)) continue;
            String errLine = "\r\n" + String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u672a\u7ef4\u62a4\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u3002", (String)"ZJMaterialHelper_0", (String)"qmc-qcbd-business", (Object[])new Object[0]), number);
            sbErr.append(errLine);
        }
        return sbErr.toString();
    }

    public void repairZJMaterial() {
        try {
            Set<String> billEntitys = this.getSetValidBillEntitys();
            for (String entityNumber : billEntitys) {
                this.repairZJMaterial(entityNumber);
            }
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            String err = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u4fee\u590d\u5931\u8d25\uff0c\u51fa\u9519\u539f\u56e0\uff1a", (String)"ZJMaterialHelper_1", (String)"qmc-qcbd-business", (Object[])new Object[0]);
            throw new KDException((Throwable)e, new ErrorCode("repairZJMaterial", e.getMessage() != null ? err + e.getMessage() : err + e.toString()), new Object[0]);
        }
    }

    private void repairZJMaterial(String entityNumber) {
        DynamicObject[] colls;
        Map<String, String> fieldKeyMap = this.getBillFieldKeyMap(entityNumber);
        String entryKey = fieldKeyMap.get(KEY_ENTITYENTITY);
        String materialKey = fieldKeyMap.get(KEY_MATERIEL);
        String materialcfgKey = fieldKeyMap.get(KEY_MATERIALCFG);
        QFilter qfilter = this.getBillQfilter(entityNumber);
        StringBuilder sbField = new StringBuilder();
        sbField.append(materialKey);
        sbField.append(",");
        sbField.append(materialcfgKey);
        sbField.append(",");
        sbField.deleteCharAt(sbField.length() - 1);
        for (DynamicObject coll : colls = BusinessDataServiceHelper.load((String)entityNumber, (String)sbField.toString(), (QFilter[])qfilter.toArray(), (String)"", (int)10000)) {
            DynamicObjectCollection entryObjs = coll.getDynamicObjectCollection(entryKey);
            if (entryObjs == null) continue;
            for (DynamicObject entryObj : entryObjs) {
                Long materialID;
                DynamicObject materialObj = entryObj.getDynamicObject(materialKey);
                DynamicObject materialCfgObj = entryObj.getDynamicObject(materialcfgKey);
                if (materialCfgObj != null || materialObj == null || (materialCfgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_inspect_cfg", (String)"id", (QFilter[])(qfilter = this.getFilterMaterialCFG(materialID = (Long)materialObj.getPkValue())).toArray())) == null) continue;
                entryObj.set(KEY_MATERIALCFG, (Object)materialCfgObj);
            }
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bd_inspect_cfg");
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
        cacheManager.removeByDt();
        if (colls.length > 0) {
            SaveServiceHelper.save((DynamicObject[])colls);
        }
    }

    private QFilter getBillQfilter(String entityNumber) {
        Map<String, String> filedMap = this.getBillFieldMap(entityNumber);
        String materialcfgField = filedMap.get(KEY_MATERIALCFG);
        String materialField = filedMap.get(KEY_MATERIEL);
        QFilter qfilter = new QFilter(materialcfgField, "<=", (Object)0);
        qfilter.and(materialField, ">", (Object)0);
        return qfilter;
    }

    private QFilter getFilterMaterialCFG(Set<Long> materialIDSet) {
        QFilter qfilter = new QFilter(KEY_MASTERID, "in", materialIDSet);
        qfilter.and("status", "=", (Object)"C");
        qfilter.and("enable", "=", (Object)"1");
        return qfilter;
    }

    private QFilter getFilterMaterialCFG(Long materialId) {
        QFilter qfilter = new QFilter(KEY_MASTERID, "=", (Object)materialId);
        qfilter.and("status", "=", (Object)"C");
        qfilter.and("enable", "=", (Object)"1");
        return qfilter;
    }

    private Map<Long, String> getMaterialMap(DynamicObjectCollection materialObjs) {
        HashMap<Long, String> materialIDs = new HashMap<Long, String>(16);
        for (DynamicObject materialObj : materialObjs) {
            Long materialid = materialObj.getLong(KEY_MATERIEL);
            String materialNumber = materialObj.getString(KEY_MATERIEL_NUMBER);
            if (materialid.equals(0L) || materialNumber == null) continue;
            materialIDs.put(materialid, materialNumber);
        }
        return materialIDs;
    }

    private Map<String, String> getBillFieldKeyMap(String billentityNumber) {
        HashMap<String, String> mapField = new HashMap<String, String>();
        Set<String> applyEntitys = mValidBillEntitys.get("qcp_inspecapplypbill");
        Set<String> inspeEntitys = mValidBillEntitys.get("qcp_inspecpbill");
        Set<String> baddealEntitys = mValidBillEntitys.get("qcp_baddealpbill");
        if (applyEntitys.contains(billentityNumber) || baddealEntitys.contains(billentityNumber)) {
            mapField.put(KEY_ENTITYENTITY, "materialentry");
            mapField.put(KEY_MATERIEL, "materielid");
            mapField.put(KEY_MATERIALCFG, KEY_MATERIALCFG);
            mapField.put(KEY_ENTRYID, "id");
        } else if (inspeEntitys.contains(billentityNumber)) {
            mapField.put(KEY_ENTITYENTITY, "matintoentity");
            mapField.put(KEY_MATERIEL, "materialid");
            mapField.put(KEY_MATERIALCFG, KEY_MATERIALCFG);
            mapField.put(KEY_ENTRYID, "id");
        }
        return mapField;
    }

    private Map<String, String> getBillFieldMap(String billentityNumber) {
        HashMap<String, String> mapField = new HashMap<String, String>();
        Map<String, String> fieldKeyMap = this.getBillFieldKeyMap(billentityNumber);
        if (fieldKeyMap.size() <= 0) {
            return mapField;
        }
        String entryKey = fieldKeyMap.get(KEY_ENTITYENTITY) + ".%s";
        String materialKey = String.format(entryKey, fieldKeyMap.get(KEY_MATERIEL));
        String materialcfgKey = String.format(entryKey, fieldKeyMap.get(KEY_MATERIALCFG));
        String entryIDKey = String.format(entryKey, fieldKeyMap.get(KEY_ENTRYID));
        mapField.put(KEY_MATERIEL, materialKey);
        mapField.put(KEY_MATERIALCFG, materialcfgKey);
        mapField.put(KEY_ENTRYID, entryIDKey);
        return mapField;
    }

    private static void iniParas() {
        mValidBillEntitys = new HashMap<String, Set<String>>(16);
        HashSet<String> mApplyEntitys = new HashSet<String>(16);
        mApplyEntitys.add("qcp_inspecapply");
        mApplyEntitys.add("qcpp_manuinspecapply");
        mValidBillEntitys.put("qcp_inspecapplypbill", mApplyEntitys);
        HashSet<String> mInsPectEntitys = new HashSet<String>(16);
        mInsPectEntitys.add("qcp_incominginspct");
        mInsPectEntitys.add("qcpp_manuinspec");
        mInsPectEntitys.add("qcp_inspecpbill_example");
        mValidBillEntitys.put("qcp_inspecpbill", mInsPectEntitys);
        HashSet<String> mBadBillEntitys = new HashSet<String>(16);
        mBadBillEntitys.add("qcp_baddeal");
        mBadBillEntitys.add("qcpp_manubaddeal");
        mBadBillEntitys.add("qcp_baddealpbill_example");
        mValidBillEntitys.put("qcp_baddealpbill", mBadBillEntitys);
    }

    private Set<String> getSetValidBillEntitys() {
        HashSet<String> setValidEntity = new HashSet<String>(16);
        for (Map.Entry<String, Set<String>> entry : mValidBillEntitys.entrySet()) {
            Set<String> billEntitys = entry.getValue();
            for (String billEntity : billEntitys) {
                setValidEntity.add(billEntity);
            }
        }
        return setValidEntity;
    }

    private Set<Long> getMaterialSet(Map<Long, String> materialIDMap) {
        HashSet<Long> materialSet = new HashSet<Long>(100);
        for (Map.Entry<Long, String> entry : materialIDMap.entrySet()) {
            materialSet.add(entry.getKey());
        }
        return materialSet;
    }

    static {
        ZJMaterialHelper.iniParas();
    }
}

