/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper.inspectexecute;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.qmc.qcbd.common.constant.InspectCfgConst;

public class CkInspectInfoHelper {
    private static final String mSpliteChar = "_";
    private static final String BIZTYPE = "bizType";
    private static final String MATERIALCFG = "materialCfg";
    private static final String USERORG = "userOrg";

    public void setSingleInspectInfo(Map<String, JSONObject> reResult, List<JSONObject> lstReqObj) {
        if (lstReqObj == null || lstReqObj.size() <= 0) {
            return;
        }
        JSONObject reqObj = lstReqObj.get(0);
        String userOrgID = reqObj.getString("userorg");
        Long userOrgIDL = reqObj.getLong("userorg");
        String bizTypeNumber = reqObj.getString("biztype");
        Map mapBizType = InspectCfgConst.transMap;
        Set materialID = lstReqObj.stream().map(p -> p.getLong("materialid")).collect(Collectors.toSet());
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)userOrgIDL);
        qfilter.and("status", "=", (Object)"C");
        qfilter.and("enable", "=", (Object)"1");
        Set<Long> bizTypeIdSet = this.getBizTypeId(bizTypeNumber);
        if (bizTypeIdSet == null || bizTypeIdSet.isEmpty()) {
            return;
        }
        qfilter.and("entryentity.inspecttype", "in", bizTypeIdSet);
        qfilter.and("masterid", "in", materialID);
        String sbField = this.getInsPectCFG();
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"bd_inspect_cfg", (String)sbField, (QFilter[])qfilter.toArray());
        for (DynamicObject coll : colls) {
            String masterialID = coll.getString("masterid");
            String resKey = this.getResultKey(userOrgID, bizTypeNumber, masterialID);
            JSONObject reResultObj = reResult.get(resKey);
            if (reResultObj == null) continue;
            Set materialCfgIds = (Set)reResultObj.getObject("materialcfgids", (TypeReference)new TypeReference<Set<Long>>(){});
            materialCfgIds.add(coll.getLong("id"));
            reResultObj.put("successful", (Object)Boolean.TRUE);
            reResultObj.put("materialcfgids", (Object)materialCfgIds);
        }
    }

    public DynamicObjectCollection judgeInspectInfo(List<JSONObject> lstReqObj) {
        DynamicObjectCollection invalMaterialCfg = null;
        ArrayList<Object> invalCfgIdList = new ArrayList<Object>(10);
        if (lstReqObj == null || lstReqObj.isEmpty()) {
            return null;
        }
        Set materialCfg = lstReqObj.stream().map(p -> p.getLong(MATERIALCFG)).collect(Collectors.toSet());
        Long userOrgIDL = lstReqObj.get(0).getLong(USERORG);
        String bizTypeNumber = lstReqObj.get(0).getString(BIZTYPE);
        Map mapBizType = InspectCfgConst.transMap;
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_inspect_cfg", (Long)userOrgIDL);
        qfilter.and("status", "=", (Object)"C");
        qfilter.and("enable", "=", (Object)"1");
        Set<Long> bizTypeIdSet = this.getBizTypeId(bizTypeNumber);
        if (bizTypeIdSet == null || bizTypeIdSet.isEmpty()) {
            return null;
        }
        qfilter.and("entryentity.inspecttype", "in", bizTypeIdSet);
        qfilter.and("id", "in", materialCfg);
        String sbField = this.getInsPectCFG();
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"bd_inspect_cfg", (String)sbField, (QFilter[])qfilter.toArray());
        if (colls.isEmpty()) {
            invalCfgIdList.addAll(materialCfg);
            QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", invalCfgIdList)};
            invalMaterialCfg = QueryServiceHelper.query((String)"bd_inspect_cfg", (String)"id inspectcfgid,masterid.number,masterid.name", (QFilter[])qFilter, null);
            return invalMaterialCfg;
        }
        HashSet<Long> materialCfgIds = new HashSet<Long>(10);
        for (DynamicObject dynamicObject : colls) {
            Long id = dynamicObject.getLong("id");
            materialCfgIds.add(id);
        }
        for (Long materialCfgId : materialCfg) {
            if (materialCfgIds.isEmpty() || materialCfgIds.contains(materialCfgId)) continue;
            invalCfgIdList.add(materialCfgId);
        }
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", invalCfgIdList)};
        invalMaterialCfg = QueryServiceHelper.query((String)"bd_inspect_cfg", (String)"id inspectcfgid,masterid.number,masterid.name", (QFilter[])qFilter, null);
        return invalMaterialCfg;
    }

    public void iniResReqObjs(List<JSONObject> reqObjs, Map<String, JSONObject> mapRes) {
        for (int i = reqObjs.size() - 1; i >= 0; --i) {
            JSONObject reqObj = reqObjs.get(i);
            String reqKey = this.getResultKey(reqObj);
            JSONObject resEmptyObj = this.getEmptyResJsObj();
            String materialId = reqObj.getString("materialid");
            String userOrg = reqObj.getString("userorg");
            String bizType = reqObj.getString("biztype");
            String errMessage = "";
            if (StringUtils.isBlank((CharSequence)materialId)) {
                errMessage = ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CkInspectInfoHelper_0", (String)"qmc-qcbd-business", (Object[])new Object[0]);
            } else if (StringUtils.isBlank((CharSequence)userOrg)) {
                errMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"CkInspectInfoHelper_1", (String)"qmc-qcbd-business", (Object[])new Object[0]);
            } else if (StringUtils.isBlank((CharSequence)bizType)) {
                errMessage = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CkInspectInfoHelper_2", (String)"qmc-qcbd-business", (Object[])new Object[0]);
            }
            if (errMessage.length() > 0) {
                resEmptyObj.put("successful", (Object)Boolean.FALSE);
                resEmptyObj.put("message", (Object)errMessage);
                reqObjs.remove(reqObj);
            }
            resEmptyObj.put("materialid", (Object)materialId);
            resEmptyObj.put("userorg", (Object)userOrg);
            resEmptyObj.put("biztype", (Object)bizType);
            mapRes.put(reqKey, resEmptyObj);
        }
    }

    public Map<String, List<JSONObject>> getReqObjsByOrg(List<JSONObject> reqObjs) {
        HashMap<String, List<JSONObject>> mapReqObjsOrg = new HashMap<String, List<JSONObject>>(100);
        for (JSONObject reqObj : reqObjs) {
            String cobKey = this.getReqObjGroupKey(reqObj);
            ArrayList<JSONObject> lstReqObj = (ArrayList<JSONObject>)mapReqObjsOrg.get(cobKey);
            if (lstReqObj == null) {
                lstReqObj = new ArrayList<JSONObject>();
            }
            lstReqObj.add(reqObj);
            mapReqObjsOrg.put(cobKey, lstReqObj);
        }
        return mapReqObjsOrg;
    }

    private JSONObject getEmptyResJsObj() {
        JSONObject resObj = new JSONObject();
        resObj.put("successful", (Object)Boolean.FALSE);
        resObj.put("message", (Object)"");
        resObj.put("materialcfgids", new HashSet(16));
        return resObj;
    }

    private String getInsPectCFG() {
        StringBuilder sbField = new StringBuilder();
        sbField.append("id,");
        sbField.append("masterid,");
        sbField.append("finishflg,");
        sbField.append("qcpflg,");
        sbField.deleteCharAt(sbField.length() - 1);
        return sbField.toString();
    }

    private String getReqObjGroupKey(JSONObject reqObj) {
        StringBuilder sbField = new StringBuilder();
        String bizType = reqObj.getString("biztype");
        String userOrgId = reqObj.getString("userorg");
        sbField.append(userOrgId);
        sbField.append(mSpliteChar);
        sbField.append(bizType);
        return sbField.toString();
    }

    private String getResultKey(String userOrgId, String bizType, String materialID) {
        StringBuilder sbField = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)userOrgId)) {
            userOrgId = "0";
        }
        if (StringUtils.isBlank((CharSequence)materialID)) {
            materialID = "0";
        }
        if (StringUtils.isBlank((CharSequence)bizType)) {
            bizType = "0";
        }
        sbField.append(userOrgId);
        sbField.append(mSpliteChar);
        sbField.append(bizType);
        sbField.append(mSpliteChar);
        sbField.append(materialID);
        return sbField.toString();
    }

    private String getResultKey(JSONObject resObj) {
        String materialId = resObj.getString("materialid");
        String userOrg = resObj.getString("userorg");
        String billType = resObj.getString("biztype");
        return this.getResultKey(userOrg, billType, materialId);
    }

    private Map<Object, DynamicObject> getAllMaterialMap(List<JSONObject> reqObjs) {
        Set materialIDs = reqObjs.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getString("materialid"))).map(p -> p.getLong("materialid")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", materialIDs);
        StringBuilder sbField = new StringBuilder();
        sbField.append("id,");
        sbField.append("number");
        Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)sbField.toString(), (QFilter[])qfilter.toArray());
        return materialMap;
    }

    private Map<Object, DynamicObject> getAllOrgMap(List<JSONObject> reqObjs) {
        Set userOegIDs = reqObjs.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getString("userorg"))).map(p -> p.getLong("userorg")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", userOegIDs);
        StringBuilder sbField = new StringBuilder();
        sbField.append("id,");
        sbField.append("number");
        Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)sbField.toString(), (QFilter[])qfilter.toArray());
        return materialMap;
    }

    public void updateResult(Map<String, JSONObject> reResult, List<JSONObject> reqObjs) {
        Map<Object, DynamicObject> materialMap = this.getAllMaterialMap(reqObjs);
        Map<Object, DynamicObject> orgMap = this.getAllOrgMap(reqObjs);
        for (Map.Entry<String, JSONObject> entry : reResult.entrySet()) {
            JSONObject reResultObj = entry.getValue();
            Boolean isSuncess = reResultObj.getBoolean("successful");
            String errMessag = "";
            if (!isSuncess.booleanValue() && errMessag.length() == 0) {
                Long materialId = reResultObj.getLong("materialid");
                Long userOrgId = reResultObj.getLong("userorg");
                DynamicObject materialObj = materialMap.get(materialId);
                DynamicObject orgObj = orgMap.get(userOrgId);
                if (materialObj != null && orgObj != null) {
                    errMessag = String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7%1$s\uff0c\u7269\u6599%2$s\uff0c\u672a\u7ef4\u62a4\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u3002", (String)"CkInspectInfoHelper_4", (String)"qmc-qcbd-business", (Object[])new Object[0]), orgObj.getString("number"), materialObj.getString("number"));
                }
            }
            if (errMessag.length() <= 0) continue;
            reResultObj.put("message", (Object)errMessag);
        }
    }

    private Set<Long> getBizTypeId(String bizTypeNumber) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)bizTypeNumber)};
        DynamicObjectCollection qcbdBizType = QueryServiceHelper.query((String)"qcbd_biztype", (String)"id", (QFilter[])qFilters);
        Set<Object> bizTypeIdSet = new HashSet(16);
        if (!qcbdBizType.isEmpty()) {
            bizTypeIdSet = qcbdBizType.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        } else {
            DynamicObjectCollection bdBizType = QueryServiceHelper.query((String)"bd_biztype", (String)"id", (QFilter[])qFilters);
            if (!bdBizType.isEmpty()) {
                bizTypeIdSet = bdBizType.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            }
        }
        return bizTypeIdSet;
    }
}

