/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper.inspectexecute;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;

public class InspectBillHelper {
    private InspectBillHelper() {
    }

    public static Map<String, Integer> getIngoreFields() {
        HashMap<String, Integer> ingoreFields = new HashMap<String, Integer>(16);
        String fixID = "_id";
        ingoreFields.put("sampschemeview" + fixID, -1);
        ingoreFields.put("samplingqtyinsview", -1);
        ingoreFields.put("showtype", -1);
        ingoreFields.put("rinsqtyvalue", -1);
        ingoreFields.put("showtypeview", -1);
        return ingoreFields;
    }

    public static Map<String, Integer> getIngoreEntryFields() {
        HashMap<String, Integer> ingoreFields = new HashMap<String, Integer>(16);
        ingoreFields.put("acstr", -1);
        ingoreFields.put("re", -1);
        ingoreFields.put("showtype", -1);
        ingoreFields.put("samplenumid", -1);
        ingoreFields.put("materialid_id", -1);
        ingoreFields.put("joininspectflag", -1);
        ingoreFields.put("suspiciousstatus", -1);
        return ingoreFields;
    }

    public static Map<String, Integer> getSampEntryFields() {
        HashMap<String, Integer> ingoreFields = new HashMap<String, Integer>(16);
        ingoreFields.put("samplenumid", -1);
        return ingoreFields;
    }

    public static CkSampleCaleResModel getSampleInfo(CkSampleCaleModel model) {
        return InspectBillSampleHelper.getSampleInfo(model);
    }

    public static void setStandardProjectRow(DynamicObject stdEntry, DynamicObject inspsubEntry, int seq) {
        DynamicObject projSamp;
        if (inspsubEntry.getDataEntityType().getProperties().containsKey((Object)"isjoininspect")) {
            inspsubEntry.set("isjoininspect", stdEntry.get("isjoininspect"));
        }
        inspsubEntry.set("inspectbasis", stdEntry.get("checkbasis"));
        inspsubEntry.set("inspectioncontent", stdEntry.get("checkcontent"));
        inspsubEntry.set("inspectfreq", stdEntry.get("checkfreq"));
        inspsubEntry.set("inspectinstruct", stdEntry.get("checkinstruct"));
        inspsubEntry.set("inspectionitem", stdEntry.get("checkitems"));
        inspsubEntry.set("inspectmethod", stdEntry.get("checkmethod"));
        inspsubEntry.set("keyquality", stdEntry.get("keyquality"));
        inspsubEntry.set("normtype", stdEntry.get("normtype"));
        inspsubEntry.set("matchflag", stdEntry.get("matchflag"));
        inspsubEntry.set("specvalue", stdEntry.get("specvalue"));
        if (stdEntry.get("topvalue") != null || stdEntry.get("downvalue") != null) {
            inspsubEntry.set("topvalue", stdEntry.get("topvalue"));
            inspsubEntry.set("downvalue", stdEntry.get("downvalue"));
        }
        inspsubEntry.set("inspecunitid", stdEntry.get("unit"));
        inspsubEntry.set("projckvalstr", (Object)ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c(0/0)", (String)"InspectBillHelper_0", (String)"qmc-qcbd-business", (Object[])new Object[0]));
        inspsubEntry.set("seq", (Object)seq);
        String uqUUid = inspsubEntry.getString("uquuid");
        if (StringUtils.isEmpty((String)uqUUid)) {
            inspsubEntry.set("uquuid", (Object)Uuid16.create().toString());
        }
        if (Objects.nonNull(projSamp = stdEntry.getDynamicObject("projsamp"))) {
            projSamp = BusinessDataServiceHelper.loadSingleFromCache((Object)projSamp.getPkValue(), (String)"qcbd_sampscheme");
        }
        inspsubEntry.set("projsamp", (Object)projSamp);
    }

    public static void addNewItemEntry(IFormView view) {
        IDataModel model = view.getModel();
        int inspRowIndex = model.getEntryCurrentRowIndex("inspsubentity");
        model.beginInit();
        model.setValue("uquuid", (Object)Uuid16.create().toString(), inspRowIndex);
        model.setValue("projckvalstr", (Object)ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c(0/0)", (String)"InspectBillHelper_0", (String)"qmc-qcbd-business", (Object[])new Object[0]), inspRowIndex);
        model.endInit();
        view.updateView("uquuid", inspRowIndex);
        view.updateView("projckvalstr", inspRowIndex);
    }
}

