/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper.inspectexecute;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.qmc.qcbd.common.enums.SamplingTypeEnum;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.CalculatorEval;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class InspectBillSampleHelper {
    private static Log logger = LogFactory.getLog(InspectBillSampleHelper.class);

    private InspectBillSampleHelper() {
    }

    public static CkSampleCaleResModel getSampleInfo(CkSampleCaleModel model) {
        CkSampleCaleResModel resModel = new CkSampleCaleResModel();
        InspectBillSampleHelper.setSampleCaleRes(model, resModel);
        return resModel;
    }

    private static void setSampleCaleRes(CkSampleCaleModel model, CkSampleCaleResModel resModel) {
        DynamicObject sampeSchemObj = model.getSampeSchemObj();
        if (sampeSchemObj == null) {
            return;
        }
        BigDecimal sampeQty = model.getSampeQty();
        String sampingtype = sampeSchemObj.getString("samplingtype");
        DynamicObjectCollection recColls = sampeSchemObj.getDynamicObjectCollection("receiveinfoentity");
        boolean isMatch = false;
        BigDecimal sampleSize = BigDecimal.ZERO;
        for (DynamicObject recColl : recColls) {
            BigDecimal batchinitialValue = BigDecimalUtil.toBigDecimal((Object)recColl.get("batchinitialvalue"));
            BigDecimal batchcutoffValue = BigDecimalUtil.toBigDecimal((Object)recColl.get("batchcutoffvalue"));
            if (batchcutoffValue.compareTo(BigDecimal.ZERO) == 0) {
                batchcutoffValue = BigDecimal.valueOf(Double.MAX_VALUE);
            }
            if (sampeQty.compareTo(batchinitialValue) >= 0 && sampeQty.compareTo(batchcutoffValue) <= 0) {
                sampleSize = InspectBillSampleHelper.getSampleSize(model, recColl);
                isMatch = true;
            }
            if (!isMatch) continue;
            resModel.setAcceptyObj(recColl);
            break;
        }
        if (!isMatch) {
            if (SamplingTypeEnum.FULL_INSPECTION.getValue().equals(sampingtype)) {
                sampleSize = sampeQty;
            } else if (SamplingTypeEnum.EXEMPTION_INSPECTION.getValue().equals(sampingtype)) {
                sampleSize = BigDecimal.ZERO;
            }
            if (SamplingTypeEnum.FULL_INSPECTION.getValue().equals(sampingtype)) {
                sampleSize = InspectBillSampleHelper.getPrecisionVal(model, sampleSize);
            }
        }
        if (resModel.getAcceptyObj() != null) {
            BigDecimal acceptyQty = BigDecimalUtil.toBigDecimal((Object)resModel.getAcceptyObj().get("acstr"));
            BigDecimal rejQty = BigDecimalUtil.toBigDecimal((Object)resModel.getAcceptyObj().get("re"));
            resModel.setAcceptyQty(acceptyQty);
            resModel.setRejQty(rejQty);
        }
        resModel.setSampleSchemObj(sampeSchemObj);
        resModel.setSampleSize(sampleSize);
        resModel.setRinsQty(InspectBillSampleHelper.getSampQty(sampleSize, model.getRule(), sampeQty));
    }

    private static BigDecimal getSampleSize(CkSampleCaleModel model, DynamicObject recColl) {
        DynamicObject sampeSchemObj = model.getSampeSchemObj();
        BigDecimal sampeQty = model.getSampeQty();
        String sampingtype = sampeSchemObj.getString("samplingtype");
        BigDecimal sc = new BigDecimal(recColl.get("samppercentage").toString());
        String fl = recColl.get("formula").toString();
        BigDecimal ss = new BigDecimal(recColl.get("samplingsize").toString());
        String inspectionrule = recColl.getString("inspectionrule");
        BigDecimal rl = BigDecimal.ZERO;
        try {
            if (SamplingTypeEnum.PERCENTAGE.getValue().equals(sampingtype)) {
                rl = sampeQty.multiply(sc).multiply(new BigDecimal("0.01"));
            } else if (SamplingTypeEnum.CUSTOM.getValue().equals(sampingtype)) {
                rl = new CalculatorEval(fl.replace("N", sampeQty.toPlainString())).parse();
            } else if (SamplingTypeEnum.ZERO_AQL.getValue().equals(sampingtype) || SamplingTypeEnum.GB_2828.getValue().equals(sampingtype) || SamplingTypeEnum.FIXED_QUANTITY.getValue().equals(sampingtype)) {
                rl = ss;
            } else if (SamplingTypeEnum.CUSTOM_INSPECTION.getValue().equals(sampingtype)) {
                if ("A".equals(inspectionrule)) {
                    rl = sampeQty;
                } else if ("B".equals(inspectionrule)) {
                    rl = sampeQty.multiply(sc).multiply(new BigDecimal("0.01"));
                } else if ("C".equals(inspectionrule) || "D".equals(inspectionrule)) {
                    rl = ss;
                } else if ("E".equals(inspectionrule)) {
                    rl = new CalculatorEval(fl.replace("N", sampeQty.toString())).parse();
                }
            }
            rl = InspectBillSampleHelper.getPrecisionVal(model, rl);
        }
        catch (Exception ex) {
            logger.info("getSampleSize\u8ba1\u7b97:" + ex.getMessage());
        }
        return rl;
    }

    public static BigDecimal getPrecisionVal(CkSampleCaleModel model, BigDecimal rl) {
        if (model.getUnitObj() != null && rl != null) {
            int currencyPrecision = model.getUnitObj().getInt("precision");
            rl = rl.setScale(currencyPrecision, RoundingMode.HALF_UP);
        }
        return rl;
    }

    public static void setCKProjectSampleRow(DynamicObject matRow, DynamicObject inspsubEntry, CkSampleCaleResModel sampleResModel) {
        BigDecimal projRinsQty = null == sampleResModel.getRinsQty() ? BigDecimal.ZERO : sampleResModel.getRinsQty();
        inspsubEntry.set("projsampqty", (Object)projRinsQty);
        inspsubEntry.set("projacceptqty", (Object)sampleResModel.getAcceptyQty());
        BigDecimal rinsQty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)matRow, (String)"rinsqty");
        if (null == rinsQty || projRinsQty.compareTo(rinsQty) > 0) {
            matRow.set("rinsqty", (Object)projRinsQty);
        }
    }

    private static BigDecimal getSampQty(BigDecimal sampValue, String rule, BigDecimal matQty) {
        if (null == sampValue || null == matQty) {
            return null;
        }
        BigDecimal scaleSampValue = null;
        BigDecimal calValue = matQty.compareTo(sampValue) > 0 ? sampValue : matQty;
        switch (rule) {
            case "A": {
                scaleSampValue = calValue.setScale(0, 4);
                break;
            }
            case "B": {
                scaleSampValue = calValue.setScale(0, 0);
                break;
            }
            default: {
                scaleSampValue = calValue.setScale(0, 1);
            }
        }
        return scaleSampValue;
    }
}

