/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper.inspectexecute;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.qmc.qcbd.business.helper.CommonInspectParamHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCommonHelper;
import kd.qmc.qcbd.common.enums.ErrorTypeEnum;
import kd.qmc.qcbd.common.errorcode.QmcBaseErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCode;
import kd.qmc.qcbd.common.errorcode.QmcErrorCodeUtils;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.DataModelUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class InspectCkvalHelper {
    private static final String SYSTEM_TYPE = "qmc-qcbd-business";
    private static final Log logger = LogFactory.getLog(InspectCkvalHelper.class);

    public static void dealProjEntry(boolean isWebApi, DynamicObjectCollection subMeasureEntry, int sampCount, DynamicObjectCollection inspEntry, boolean reSetPassCntUnPassCount) {
        for (DynamicObject inspRow : inspEntry) {
            long chooseSampCount = subMeasureEntry.stream().filter(x -> inspRow.getString("uquuid").equals(x.getString("projuuid"))).count();
            inspRow.set("choosesampqty", (Object)chooseSampCount);
            long projSampCount = subMeasureEntry.stream().filter(x -> inspRow.getString("uquuid").equals(x.getString("projuuid")) && (StringUtils.isNotEmpty((CharSequence)x.getString("measuredval_deter")) || StringUtils.isNotEmpty((CharSequence)x.getString("measuredval_rat")))).count();
            inspRow.set("projckval", (Object)projSampCount);
            if (!isWebApi) continue;
            BigDecimal projAcceptQty = inspRow.getBigDecimal("projacceptqty");
            long unPassCount = subMeasureEntry.stream().filter(x -> inspRow.getString("uquuid").equals(x.getString("projuuid")) && "N".equals(x.getString("measuredval_judge"))).count();
            long passCount = subMeasureEntry.stream().filter(x -> inspRow.getString("uquuid").equals(x.getString("projuuid")) && "Y".equals(x.getString("measuredval_judge"))).count();
            if (reSetPassCntUnPassCount) {
                inspRow.set("projunqualifiyqty", (Object)unPassCount);
                inspRow.set("projqualifiyqty", (Object)passCount);
            }
            if (new BigDecimal(unPassCount).compareTo(projAcceptQty) > 0) {
                inspRow.set("projckresult", (Object)"N");
                continue;
            }
            if (new BigDecimal((long)sampCount - passCount).compareTo(projAcceptQty) > 0) continue;
            inspRow.set("projckresult", (Object)"Y");
        }
    }

    public static void dealSampEntry(boolean isWebApi, DynamicObjectCollection subMeasureEntry, DynamicObjectCollection sampEntry, int inspSize) {
        for (DynamicObject sampRow : sampEntry) {
            long sampCkCount = subMeasureEntry.stream().filter(x -> sampRow.getLong("samplenumid") == x.getLong("exmapleid") && (StringUtils.isNotEmpty((CharSequence)x.getString("measuredval_deter")) || StringUtils.isNotEmpty((CharSequence)x.getString("measuredval_rat")))).count();
            sampRow.set("sampckval", (Object)sampCkCount);
            if (!isWebApi) continue;
            long unPassCount = subMeasureEntry.stream().filter(x -> sampRow.getLong("samplenumid") == x.getLong("exmapleid") && "N".equals(x.getString("measuredval_judge"))).count();
            if (unPassCount > 0L) {
                sampRow.set("sampleres", (Object)"N");
                continue;
            }
            long passCount = subMeasureEntry.stream().filter(x -> sampRow.getLong("samplenumid") == x.getLong("exmapleid") && "Y".equals(x.getString("measuredval_judge"))).count();
            if (passCount < (long)inspSize) continue;
            sampRow.set("sampleres", (Object)"Y");
        }
    }

    public static void clearExampleInfo(IDataModel model, IFormView view, int rowIndex) {
        DataModelUtil.deleteSubEntry((IDataModel)model, (IFormView)view, (String)"matintoentity", (String)"subsampleresentity", (int)rowIndex);
        DataModelUtil.deleteSubEntry((IDataModel)model, (IFormView)view, (String)"matintoentity", (String)"submeasuredvalentity", (int)rowIndex);
    }

    public static String getUquuid(IDataModel model, int rowIndex) {
        int matRowIndex = model.getEntryCurrentRowIndex("matintoentity");
        DynamicObjectCollection inspSubEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)matRowIndex);
        return DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)((DynamicObject)inspSubEntry.get(rowIndex)), (String)"uquuid");
    }

    public static void addCellClick(String entryKey, IFormView view, CellClickListener listener) {
        EntryGrid eg = (EntryGrid)view.getControl(entryKey);
        if (eg != null) {
            eg.addCellClickListener(listener);
        }
    }

    public static DynamicObjectCollection validInspEntry(Map<Integer, List<String>> errInfo, int firstMatIndex, int nextMatRowIndex, DynamicObject matRow, BigDecimal rinsQty) {
        DynamicObjectCollection inspsubentity = matRow.getDynamicObjectCollection("inspsubentity");
        int inspSize = inspsubentity.size();
        for (int j = 0; j < inspSize; ++j) {
            String examples;
            DynamicObject inspRow = (DynamicObject)inspsubentity.get(j);
            ArrayList<String> inspErrList = new ArrayList<String>(32);
            String normType = inspRow.getString("normtype");
            DynamicObject matchFlag = inspRow.getDynamicObject("matchflag");
            String matchFlagNumber = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)matchFlag, (String)"number");
            if (kd.bos.util.StringUtils.isEmpty((String)normType) || null == matchFlag || StringQMCUtil.inside((String)matchFlag.getString("number"), (String[])new String[]{"=", "\u2260"}).booleanValue()) {
                inspRow.set("topvalue", null);
                inspRow.set("downvalue", null);
            } else if (StringQMCUtil.inside((String)matchFlag.getString("number"), (String[])new String[]{">", ">="}).booleanValue()) {
                inspRow.set("topvalue", null);
            } else if (StringQMCUtil.inside((String)matchFlag.getString("number"), (String[])new String[]{"<", "<="}).booleanValue()) {
                inspRow.set("downvalue", null);
            }
            if ("B".equals(normType)) {
                if (null != matchFlag && !StringQMCUtil.inside((String)matchFlag.getString("number"), (String[])new String[]{"=", "\u2260"}).booleanValue()) {
                    inspRow.set("matchflag", null);
                }
            } else if ("A".equals(normType)) {
                String specValue = inspRow.getString("specvalue");
                if (kd.bos.util.StringUtils.isNotEmpty((String)specValue) && !BigDecimalUtil.stringIsDouble((String)specValue)) {
                    inspRow.set("specvalue", (Object)"");
                    inspErrList.add(ResManager.loadKDString((String)"\u6307\u6807\u7c7b\u578b\u4e3a\u5b9a\u91cf\u65f6\uff0c\u6807\u51c6\u503c\u53ea\u80fd\u5f55\u5165\u6570\u503c\u3002", (String)"InspectCkvalHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                } else {
                    inspRow.set("specvalue", (Object)BigDecimalUtil.parserBigDecimal((String)specValue, (int)10));
                }
                BigDecimal topValue = inspRow.getBigDecimal("topvalue");
                BigDecimal downValue = inspRow.getBigDecimal("downvalue");
                if (null != topValue && null != downValue) {
                    if (topValue.compareTo(downValue) <= 0 && (BigDecimal.ZERO.compareTo(topValue) != 0 || BigDecimal.ZERO.compareTo(downValue) != 0)) {
                        inspErrList.add(ResManager.loadKDString((String)"\u4e0a\u9650\u503c\u5e94\u5927\u4e8e\u4e0b\u9650\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0a\u9650\u503c\u3002", (String)"InspectCkvalHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                    if (ArrayUtils.contains((Object[])new String[]{"[ )", "( ]"}, (Object)matchFlagNumber) && topValue.compareTo(downValue) <= 0) {
                        inspErrList.add(ResManager.loadKDString((String)"\u4e0a\u9650\u503c\u5e94\u5927\u4e8e\u4e0b\u9650\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0a\u9650\u503c\u3002", (String)"InspectCkvalHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    }
                }
                if (null == matchFlag) {
                    inspRow.set("specvalue", null);
                }
            }
            if ((examples = inspRow.getString("examples_tag")).length() > 0) {
                inspRow.set("examples", (Object)"");
                inspRow.set("examples_tag", (Object)"");
                Object exampleObj = JSONObject.parse((String)examples);
                if (exampleObj instanceof List) {
                    List exampleList = (List)exampleObj;
                    InspectCkvalHelper.checkCkVals(rinsQty, inspRow, inspErrList, exampleList);
                    InspectCkvalHelper.addCkVals(matRow, inspRow, inspErrList, exampleList);
                }
            }
            if (inspErrList.isEmpty()) continue;
            int so = firstMatIndex + nextMatRowIndex + j;
            List<String> list = errInfo.get(so);
            if (list == null) {
                errInfo.put(so, inspErrList);
                continue;
            }
            list.addAll(inspErrList);
        }
        return inspsubentity;
    }

    public static void completeData(IFormView view, DynamicObject matRow, int addSamps) {
        Object inspStd = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)matRow, (String)"inspectionstd");
        DynamicObjectCollection inspSubEntry = matRow.getDynamicObjectCollection("inspsubentity");
        InspectCkvalHelper.dealStdItem(view, inspStd, inspSubEntry);
        DynamicObjectCollection sampEntry = matRow.getDynamicObjectCollection("subsampleresentity");
        int sampSize = sampEntry.size();
        if (addSamps > 0) {
            for (int i = 1; i <= addSamps; ++i) {
                DynamicObject sampRow = sampEntry.addNew();
                int seq = sampSize + i;
                sampRow.set("seq", (Object)seq);
                sampRow.set("samplenum", (Object)String.format(ResManager.loadKDString((String)"\u6837\u672c%s", (String)"InspectCkvalHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), seq));
            }
        }
        InspectCkvalHelper.appendSampNumId(view, sampEntry);
    }

    public static void refreshCkValStr(IDataModel model, IFormView view) {
        logger.info("--\u5237\u65b0\u5b9e\u6d4b\u503c\u6587\u672c\u5f00\u59cb---");
        DynamicObjectCollection sampEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"subsampleresentity", (int)model.getEntryCurrentRowIndex("matintoentity"));
        DynamicObjectCollection inspSubEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)model.getEntryCurrentRowIndex("matintoentity"));
        if (null == inspSubEntry || inspSubEntry.size() <= 0) {
            return;
        }
        int inspSize = inspSubEntry.size();
        for (DynamicObject sampObj : sampEntry) {
            String sampCkvalStr = String.format(ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c(%1$s/%2$s)", (String)"InspectCkvalHelper_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), BigDecimalUtil.toBigDecimal((Object)sampObj.get("sampckval")).intValue(), inspSize);
            sampObj.set("sampckvalstr", (Object)sampCkvalStr);
            logger.info("--------\u5b9e\u6d4b\u503c--------sampCkvalStr--" + sampObj.getPkValue() + sampCkvalStr);
        }
        model.updateEntryCache(sampEntry);
        view.updateView("subsampleresentity");
        for (DynamicObject inspObj : inspSubEntry) {
            String projCkValStr = String.format(ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c(%1$s/%2$s)", (String)"InspectCkvalHelper_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), BigDecimalUtil.toBigDecimal((Object)inspObj.get("projckval")).intValue(), BigDecimalUtil.toBigDecimal((Object)inspObj.get("choosesampqty")).intValue());
            inspObj.set("projckvalstr", (Object)projCkValStr);
            logger.info("--------\u5b9e\u6d4b\u503c--------projCkValStr--" + inspObj.getPkValue() + projCkValStr);
        }
        model.updateEntryCache(inspSubEntry);
        view.updateView("inspsubentity");
    }

    public static String getCkValStr() {
        return InspectCkvalHelper.getCkValStr(0, 0);
    }

    public static String getCkValStr(int valCount, int chooseCount) {
        return String.format(ResManager.loadKDString((String)"\u5b9e\u6d4b\u503c(%1$s/%2$s)", (String)"InspectCkvalHelper_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), valCount, chooseCount);
    }

    public static void updateRinsQtyRealValue(ChangeData changeData, IDataModel model, IFormView view) {
        BigDecimal rinsQtyOld;
        BigDecimal matQty;
        int rowIndex = changeData.getRowIndex();
        BigDecimal rinsQty = BigDecimalUtil.toBigDecimal((Object)changeData.getNewValue());
        if (rinsQty.compareTo(matQty = BigDecimalUtil.toBigDecimal((Object)model.getValue("materialqty", rowIndex))) > 0) {
            QmcErrorCodeUtils.showMessge((IFormView)view, (QmcErrorCode)QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_SampOverMatQty));
        }
        if (rinsQty.compareTo(rinsQtyOld = BigDecimalUtil.toBigDecimal((Object)changeData.getOldValue())) < 0) {
            DynamicObjectCollection inspEntrys = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)rowIndex);
            int size = inspEntrys.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject inspEntry = (DynamicObject)inspEntrys.get(i);
                inspEntry.set("projckval", null);
                inspEntry.set("choosesampqty", null);
                inspEntry.set("projqualifiyqty", null);
                inspEntry.set("projunqualifiyqty", null);
                model.setValue("projckresult", null, i, rowIndex);
                inspEntry.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr());
            }
            model.updateEntryCache(inspEntrys);
            view.updateView("inspsubentity");
            InspectCkvalHelper.clearExampleInfo(model, view, rowIndex);
        }
    }

    public static void projqulifyChange(IDataModel model, IFormView view, int rowIndex) {
        BigDecimal unqualifyQty;
        BigDecimal rinsQty = BigDecimalUtil.toBigDecimal((Object)model.getValue("projsampqty", rowIndex));
        if (rinsQty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        BigDecimal qualifyQty = BigDecimalUtil.toBigDecimal((Object)model.getValue("projqualifiyqty", rowIndex));
        if (qualifyQty.add(unqualifyQty = BigDecimalUtil.toBigDecimal((Object)model.getValue("projunqualifiyqty", rowIndex))).compareTo(rinsQty) > 0) {
            QmcErrorCodeUtils.showMessge((IFormView)view, (QmcErrorCode)QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_ProjOver));
            return;
        }
        BigDecimal acQty = BigDecimalUtil.toBigDecimal((Object)model.getValue("projacceptqty", rowIndex));
        if (unqualifyQty.compareTo(acQty) > 0) {
            model.setValue("projckresult", (Object)"N", rowIndex);
        } else if (rinsQty.subtract(qualifyQty).compareTo(acQty) <= 0) {
            model.setValue("projckresult", (Object)"Y", rowIndex);
        }
    }

    public static void sampCkResChange(IDataModel model, IFormView view) {
        DynamicObjectCollection subSampEntity = model.getEntryEntity("subsampleresentity");
        long sampQualQty = subSampEntity.stream().filter(x -> "Y".equals(x.getString("sampleres"))).count();
        long samUnqualQty = subSampEntity.stream().filter(x -> "N".equals(x.getString("sampleres"))).count();
        DynamicObjectCollection matEntry = model.getEntryEntity("matintoentity");
        int matRowIndex = model.getEntryCurrentRowIndex("matintoentity") < 0 ? 0 : model.getEntryCurrentRowIndex("matintoentity");
        DynamicObject matEntryRow = (DynamicObject)matEntry.get(matRowIndex);
        long materialId = matEntryRow.getDynamicObject("materialid").getLong("id");
        long unitField = matEntryRow.getDynamicObject("unitfield").getLong("id");
        DynamicObject baseUnit = matEntryRow.getDynamicObject("baseunit");
        BigDecimal baseSampQlyQty = BaseUnitQtyConVertUtil.getQtyConvert((Long)materialId, (Long)unitField, (BigDecimal)BigDecimal.valueOf(sampQualQty), (DynamicObject)baseUnit);
        BigDecimal baseSampUnqualQty = BaseUnitQtyConVertUtil.getQtyConvert((Long)materialId, (Long)unitField, (BigDecimal)BigDecimal.valueOf(samUnqualQty), (DynamicObject)baseUnit);
        matEntryRow.set("sampqualqty", (Object)sampQualQty);
        matEntryRow.set("basesampqlyqty", (Object)baseSampQlyQty);
        matEntryRow.set("samunqualqty", (Object)samUnqualQty);
        matEntryRow.set("basesampuqlyqty", (Object)baseSampUnqualQty);
        model.updateEntryCache(matEntry);
        view.updateView("sampqualqty", matRowIndex);
        view.updateView("basesampqlyqty", matRowIndex);
        view.updateView("samunqualqty", matRowIndex);
        view.updateView("basesampuqlyqty", matRowIndex);
        InspectCkvalHelper.sampQualQtyChange(model, view, matRowIndex);
    }

    public static void sampQualQtyChange(IDataModel model, IFormView view, int rowIndex) {
        BigDecimal acNum = BigDecimalUtil.toBigDecimal((Object)model.getValue("acstr", rowIndex));
        BigDecimal sampQualQty = BigDecimalUtil.toBigDecimal((Object)model.getValue("sampqualqty", rowIndex));
        BigDecimal samUnqualQty = BigDecimalUtil.toBigDecimal((Object)model.getValue("samunqualqty", rowIndex));
        BigDecimal rinsQty = BigDecimalUtil.toBigDecimal((Object)model.getValue("rinsqty"));
        if (sampQualQty.add(samUnqualQty).compareTo(rinsQty) > 0) {
            QmcErrorCodeUtils.showMessge((IFormView)view, (QmcErrorCode)QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_SampOver));
            return;
        }
        if (samUnqualQty.compareTo(acNum) > 0) {
            model.setValue("samplingresult", (Object)"C", rowIndex);
        } else if (rinsQty.subtract(sampQualQty).compareTo(acNum) <= 0) {
            model.setValue("samplingresult", (Object)"B", rowIndex);
        }
    }

    public static void updateProjSamp(ChangeData changeData, IDataModel model, IFormView view, Boolean validQty) {
        int rowIndex = changeData.getRowIndex();
        int materialIndex = changeData.getParentRowIndex();
        BigDecimal matQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"materialqty", (int)materialIndex);
        if (matQty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        DynamicObject projSamp = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"projsamp", (int)rowIndex);
        DynamicObject unit = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"unitfield", (int)materialIndex);
        String rule = InspectCommonHelper.getSampNumRule(model);
        CkSampleCaleResModel sampleResModel = InspectCkvalHelper.getSampInfoByInspRow(projSamp, unit, matQty, rule);
        BigDecimal projsampqty = sampleResModel.getRinsQty();
        model.setValue("projsampqty", (Object)projsampqty, rowIndex);
        model.setValue("projacceptqty", (Object)sampleResModel.getAcceptyQty(), rowIndex);
        BigDecimal rinsQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqty", (int)materialIndex);
        if (projsampqty.compareTo(rinsQty) > 0) {
            model.setValue("rinsqty", (Object)projsampqty, materialIndex);
        }
    }

    public static void updateProjSampQty(ChangeData changeData, IDataModel model, IFormView view, Boolean validQty) {
        int rowIndex = changeData.getRowIndex();
        int materialIndex = changeData.getParentRowIndex();
        BigDecimal newQty = (BigDecimal)changeData.getNewValue();
        if (validQty.booleanValue()) {
            InspectCkvalHelper.validSchemResult(materialIndex, rowIndex, newQty, view);
        } else {
            BigDecimal rinQty;
            DynamicObjectCollection subEntry = model.getEntryEntity("inspsubentity");
            BigDecimal maxProjSampQty = subEntry.stream().map(x -> x.getBigDecimal("projsampqty")).max(Comparator.comparing(x -> x)).get();
            if (maxProjSampQty.compareTo(rinQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqty", (int)materialIndex)) > 0) {
                model.setValue("rinsqty", (Object)maxProjSampQty, materialIndex);
            }
        }
    }

    public static void showBillFieldForm(String fieldKey, IDataModel model, IFormView view, IFormPlugin plugin, String actionId, Boolean isInsp) {
        String billStatus;
        Object sampNum = model.getValue("rinsqty");
        BigDecimal rinsqtyvalue = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqty");
        if (null == sampNum || rinsqtyvalue.compareTo(BigDecimal.ONE) < 0) {
            QmcErrorCodeUtils.showMessge((IFormView)view, (QmcErrorCode)QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.MSG_GtZero, (String)ResManager.loadKDString((String)"\u6837\u672c\u6570\u91cf", (String)"InspectCkvalHelper_5", (String)SYSTEM_TYPE, (Object[])new Object[0])));
            return;
        }
        int addSampSize = rinsqtyvalue.intValue() - model.getEntryEntity("subsampleresentity").size();
        if (addSampSize > 0) {
            InspectCkvalHelper.batchAddSamples(model, view, addSampSize);
        }
        FormShowParameter showParameter = new FormShowParameter();
        Map customParams = showParameter.getCustomParams();
        customParams.put("enable", Boolean.TRUE);
        customParams.put("isInsp", isInsp);
        DynamicObjectCollection inspSubEntry = model.getEntryEntity("inspsubentity");
        customParams.put("subsampleresentity", model.getEntryEntity("subsampleresentity"));
        customParams.put("inspsubentity", inspSubEntry);
        customParams.put("submeasuredvalentity", model.getEntryEntity("submeasuredvalentity"));
        if ("sampckvalstr".equals(fieldKey)) {
            showParameter.setFormId("qcbd_insp_entrybysample");
            customParams.put("rowIndex", model.getEntryCurrentRowIndex("subsampleresentity"));
            if (isInsp.booleanValue()) {
                customParams.put("enable", inspSubEntry.stream().allMatch(x -> kd.bos.util.StringUtils.isEmpty((String)x.getString("joininspectstatus"))));
            }
        } else {
            showParameter.setFormId("qcbd_insp_entrybyitem");
            int inspRowIndex = model.getEntryCurrentRowIndex("inspsubentity");
            customParams.put("rowIndex", inspRowIndex);
        }
        if (!"A".equalsIgnoreCase(billStatus = DynamicObjDataUtil.getDataModelStringData((IDataModel)model, (String)"billstatus"))) {
            customParams.put("enable", Boolean.FALSE);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        view.showForm(showParameter);
    }

    public static Boolean addEntryRow(IDataModel model, IFormView view) {
        int curRowIndex = model.getEntryCurrentRowIndex("matintoentity");
        if (curRowIndex < 0) {
            return false;
        }
        BigDecimal rinsQtyVal = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqty", (int)curRowIndex);
        int rinsQtyValInt = rinsQtyVal.intValue();
        long realSampQty = model.getEntryEntity("subsampleresentity").stream().filter(x -> BigDecimalUtil.toBigDecimal((Object)x.get("samplenumid")).compareTo(BigDecimal.ZERO) > 0).count();
        if (realSampQty >= (long)rinsQtyValInt) {
            QmcErrorCodeUtils.showMessge((IFormView)view, (QmcErrorCode)QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.Msg_HasSamp));
            return false;
        }
        if (rinsQtyVal.compareTo(new BigDecimal(10000)) > 0 || rinsQtyVal.compareTo(new BigDecimal(1)) < 0) {
            QmcErrorCode qmcErr = QmcBaseErrorCode.getErrorInfo((ErrorTypeEnum)ErrorTypeEnum.MSG_MAX_RINSQTYVALUE);
            QmcErrorCodeUtils.showMessge((IFormView)view, (QmcErrorCode)qmcErr);
            return false;
        }
        InspectCkvalHelper.batchAddSamples(model, view, (int)((long)rinsQtyValInt - realSampQty));
        view.invokeOperation("firstentry");
        return true;
    }

    public static void refreshBackTab(Map<String, DynamicObjectCollection> retDataMap, IDataModel model, IFormView view) {
        logger.info("\u68c0\u9a8c\u5355\u8c03\u7528\u56de\u8c03\u51fd\u6570\uff1arefreshBackTab\u5f00\u59cb...");
        DynamicObjectCollection subMeasureEntryV = retDataMap.get("submeasuredvalentity_v");
        Set reflexCols = subMeasureEntryV.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).filter(name -> name.endsWith("_v")).collect(Collectors.toSet());
        DynamicObjectCollection subMeasureEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"submeasuredvalentity", (int)model.getEntryCurrentRowIndex("matintoentity"));
        logger.info("\u68c0\u9a8c\u5355\u8c03\u7528\u56de\u8c03\u51fd\u6570\uff1arefreshBackTab\uff1asubMeasureEntry" + subMeasureEntry);
        subMeasureEntry.clear();
        logger.info("\u68c0\u9a8c\u5355\u8c03\u7528\u56de\u8c03\u51fd\u6570\uff1arefreshBackTab\uff1asubMeasureEntry-clear" + subMeasureEntry);
        int size = subMeasureEntryV.size();
        if (size > 0) {
            for (DynamicObject dynamicObject : subMeasureEntryV) {
                DynamicObject newSubMeasureObj = subMeasureEntry.addNew();
                for (String colNameV : reflexCols) {
                    Object colValue = dynamicObject.get(colNameV);
                    if ("measuredval_rat_v".equals(colNameV)) {
                        colValue = null == colValue ? "" : ((BigDecimal)colValue).toPlainString();
                    }
                    newSubMeasureObj.set(colNameV.replace("_v", ""), colValue);
                }
            }
        }
        model.updateEntryCache(subMeasureEntry);
        view.updateView("submeasuredvalentity");
        logger.info("\u68c0\u9a8c\u5355\u8c03\u7528\u56de\u8c03\u51fd\u6570\uff1arefreshBackTab\uff1asubMeasureEntry-update" + subMeasureEntry);
    }

    public static void refreshSubInsp(Map<String, DynamicObjectCollection> retDataMap, IDataModel model, IFormView view, Boolean ignoreJoinInsp) {
        logger.info("\u68c0\u9a8c\u5355\u56de\u8c03\u65b9\u6cd5\uff1arefreshSubInsp\u5f00\u59cb...");
        Map<String, DynamicObject> subInspMap = retDataMap.get("inspsubentity_v").stream().collect(Collectors.toMap(x -> x.getString("uquuid_v"), x -> x));
        DynamicObjectCollection subInspEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)model.getEntryCurrentRowIndex("matintoentity"));
        logger.info("\u68c0\u9a8c\u5355\u56de\u8c03\u65b9\u6cd5\uff1arefreshSubInsp:subInspEntry" + subInspEntry);
        int size = subInspEntry.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject subInspObj = (DynamicObject)subInspEntry.get(i);
            if (ignoreJoinInsp.booleanValue() && StringQMCUtil.inside((String)subInspObj.getString("joininspectstatus"), (String[])new String[]{"P", "Y"}).booleanValue()) continue;
            DynamicObject inspObjV = subInspMap.get(subInspObj.getString("uquuid"));
            model.beginInit();
            model.setValue("projckval", inspObjV.get("projckval_v"), i);
            model.setValue("projqualifiyqty", inspObjV.get("projqualifiyqty_v"), i);
            model.setValue("projunqualifiyqty", inspObjV.get("projunqualifiyqty_v"), i);
            model.setValue("choosesampqty", inspObjV.get("choosesampqty_v"), i);
            model.endInit();
            InspectCkvalHelper.projqulifyChange(model, view, i);
        }
    }

    public static void refreshSubSamp(Map<String, DynamicObjectCollection> retDataMap, IDataModel model, IFormView view, Boolean propChange) {
        logger.info("\u68c0\u9a8c\u5355\u56de\u8c03\u65b9\u6cd5\uff1arefreshSubSamp\u5f00\u59cb...");
        Map<Long, DynamicObject> subSampMap = retDataMap.get("subsampleresentity_v").stream().collect(Collectors.toMap(x -> x.getLong("samplenumid_v"), x -> x));
        DynamicObjectCollection subSampEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"subsampleresentity", (int)model.getEntryCurrentRowIndex("matintoentity"));
        logger.info("\u68c0\u9a8c\u5355\u56de\u8c03\u65b9\u6cd5\uff1arefreshSubSamp:subSampEntry" + subSampEntry);
        int size = subSampEntry.size();
        model.beginInit();
        for (int i = 0; i < size; ++i) {
            InspectCkvalHelper.copySampCkVal(model, subSampMap, subSampEntry, i);
        }
        model.endInit();
        view.updateView("subsampleresentity");
        if (propChange.booleanValue()) {
            InspectCkvalHelper.sampCkResChange(model, view);
        }
    }

    private static void copySampCkVal(IDataModel model, Map<Long, DynamicObject> subSampMap, DynamicObjectCollection subSampEntry, int i) {
        DynamicObject subSampObj = (DynamicObject)subSampEntry.get(i);
        DynamicObject sampObjV = subSampMap.get(subSampObj.getLong("samplenumid"));
        model.setValue("sampleres", sampObjV.get("sampleres_v"), i);
        model.setValue("sampckval", sampObjV.get("sampckval_v"), i);
    }

    public static void clickMaterialRow(IDataModel model, IFormView view) {
        EntryGrid entryGrid = (EntryGrid)view.getControl("matintoentity");
        entryGrid.clickCell("matintoentity", model.getEntryCurrentRowIndex("matintoentity"));
    }

    public static void deleteSubMeasures(int inspRowIndex, IDataModel model, IFormView view) {
        if (DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"choosesampqty", (int)inspRowIndex).compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        String uqUuid = InspectCkvalHelper.getUquuid(model, inspRowIndex);
        int matRowIndex = model.getEntryCurrentRowIndex("matintoentity");
        DynamicObjectCollection subMeasureEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"submeasuredvalentity", (int)matRowIndex);
        List removeList = subMeasureEntry.stream().filter(x -> uqUuid.equals(x.getString("projuuid"))).collect(Collectors.toList());
        subMeasureEntry.removeAll(removeList);
        model.updateEntryCache(subMeasureEntry);
        Set sampIdSet = removeList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getString("measuredval_deter")) || StringUtils.isNotEmpty((CharSequence)x.getString("measuredval_rat"))).map(x -> x.getString("exmapleid")).collect(Collectors.toSet());
        DynamicObjectCollection sampEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"subsampleresentity", (int)matRowIndex);
        for (DynamicObject sampRow : sampEntry) {
            if (!sampIdSet.contains(String.valueOf(sampRow.get("samplenumid")))) continue;
            sampRow.set("sampckval", (Object)sampRow.getBigDecimal("sampckval").subtract(BigDecimal.ONE));
        }
        model.updateEntryCache(sampEntry);
        InspectCkvalHelper.clearInspCkVal(inspRowIndex, model, view);
    }

    public static void modifyRinsQty(BeforeFieldPostBackEvent e, IDataModel model, IFormView view) {
        boolean dataIlegle;
        int matRowIndex = model.getEntryCurrentRowIndex("matintoentity");
        boolean bl = dataIlegle = null == model.getValue("materialid", matRowIndex) || null == model.getValue("unitfield", matRowIndex);
        if (dataIlegle && BigDecimalUtil.toBigDecimal((Object)e.getValue()).compareTo(BigDecimal.ZERO) > 0) {
            e.setCancel(true);
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u548c\u5355\u4f4d\u3002", (String)"InspectCkvalHelper_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            view.updateView("rinsqtyvalue");
        }
    }

    public static CkSampleCaleResModel getSampInfoByMatRow(IDataModel model, int matRowIndex) {
        CkSampleCaleResModel resModel = new CkSampleCaleResModel();
        DynamicObject matRow = model.getEntryRowEntity("matintoentity", matRowIndex);
        String rule = InspectCommonHelper.getSampNumRule(model);
        Object sampScheme = matRow.get("sampscheme");
        if (sampScheme instanceof DynamicObject) {
            CkSampleCaleModel sampleModel = new CkSampleCaleModel((DynamicObject)sampScheme, matRow.getBigDecimal("materialqty"), matRow.getDynamicObject("unitfield"), rule);
            resModel = InspectBillSampleHelper.getSampleInfo(sampleModel);
        }
        return resModel;
    }

    public static CkSampleCaleResModel getSampInfoByInspRow(DynamicObject projSamp, DynamicObject unit, BigDecimal matQty, String rule) {
        CkSampleCaleResModel resModel = new CkSampleCaleResModel();
        if (null == projSamp) {
            return resModel;
        }
        CkSampleCaleModel sampleModel = new CkSampleCaleModel(projSamp, matQty, unit, rule);
        return InspectBillHelper.getSampleInfo(sampleModel);
    }

    private static void clearInspCkVal(int inspRowIndex, IDataModel model, IFormView view) {
        int matRowIndex = model.getEntryCurrentRowIndex("matintoentity");
        DynamicObjectCollection inspEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)matRowIndex);
        if (inspEntry.isEmpty()) {
            return;
        }
        DynamicObject inspRow = (DynamicObject)inspEntry.get(inspRowIndex);
        inspRow.set("projqualifiyqty", (Object)0);
        inspRow.set("projunqualifiyqty", (Object)0);
        inspRow.set("projckresult", (Object)" ");
        inspRow.set("projckval", (Object)0);
        inspRow.set("choosesampqty", (Object)0);
        inspRow.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr());
        model.updateEntryCache(inspEntry);
        view.updateView("projqualifiyqty", inspRowIndex);
        view.updateView("projunqualifiyqty", inspRowIndex);
        view.updateView("projckresult", inspRowIndex);
        view.updateView("projckval", inspRowIndex);
        view.updateView("choosesampqty", inspRowIndex);
        view.updateView("projckvalstr", inspRowIndex);
    }

    private static void validSchemResult(int materialIndex, int projectRowIndex, BigDecimal newQty, IFormView view) {
        IDataModel model = view.getModel();
        if (materialIndex < 0 || projectRowIndex < 0) {
            return;
        }
        BigDecimal rinsqty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqty", (int)materialIndex);
        if (newQty.compareTo(rinsqty) > 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u6837\u672c\u6570\u91cf\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6837\u672c\u6570\u91cf\u3002", (String)"InspectCkvalHelper_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public static void batchAddSamples(IDataModel model, IFormView view, int count) {
        if (count > 0) {
            long[] sampIds = InspectCkvalHelper.getSampIds(view.getEntityId(), count);
            int[] rows = model.batchCreateNewEntryRow("subsampleresentity", count);
            int inspSize = model.getEntryEntity("inspsubentity").size();
            for (int i = 0; i < count; ++i) {
                int rowIndex = rows[i];
                int sampId = rowIndex + 1;
                model.setValue("samplenumid", (Object)sampIds[i], rowIndex);
                model.setValue("samplenum", (Object)String.format(ResManager.loadKDString((String)"\u6837\u672c%s", (String)"InspectCkvalHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), sampId), rowIndex);
                model.setValue("sampckval", (Object)0, rowIndex);
                model.setValue("sampckvalstr", (Object)InspectCkvalHelper.getCkValStr(0, inspSize), rowIndex);
            }
        }
    }

    private static void addCkVals(DynamicObject matRow, DynamicObject inspRow, List<String> inspErrList, List<Map> exampleList) {
        if (inspErrList.isEmpty()) {
            int rinsQty = matRow.getBigDecimal("rinsqty").intValue();
            DynamicObjectCollection sampEntry = matRow.getDynamicObjectCollection("subsampleresentity");
            DynamicObjectCollection subMeasureEntry = matRow.getDynamicObjectCollection("submeasuredvalentity");
            String uquuid = inspRow.getString("uquuid");
            String normType = inspRow.getString("normtype");
            int size = exampleList.size();
            int seq = 1;
            for (int i = 0; i < size && i < rinsQty; ++i) {
                Map map = exampleList.get(i);
                if (!map.containsKey("exampleval")) continue;
                DynamicObject subMeassreObj = subMeasureEntry.addNew();
                subMeassreObj.set("projuuid", (Object)uquuid);
                subMeassreObj.set("exmapleid", (Object)((DynamicObject)sampEntry.get(i)).getLong("samplenumid"));
                subMeassreObj.set("samp_seq", (Object)seq++);
                if ("A".equals(normType)) {
                    subMeassreObj.set("measuredval_rat", map.get("exampleval"));
                } else if ("B".equals(normType)) {
                    subMeassreObj.set("measuredval_deter", map.get("exampleval"));
                }
                subMeassreObj.set("measuredval_judge", map.get("examplevalres"));
            }
        }
    }

    private static void checkCkVals(BigDecimal rinsQty, DynamicObject inspRow, List<String> inspErrList, List<Map> exampleList) {
        int size = exampleList.size();
        String normType = inspRow.getString("normtype");
        Set errInfos = exampleList.stream().filter(x -> null != x.get("example_errinfo")).map(x -> String.valueOf(x.get("example_errinfo"))).collect(Collectors.toSet());
        if (!errInfos.isEmpty()) {
            inspErrList.addAll(errInfos);
        }
        for (int i = 0; i < size && i < rinsQty.intValue(); ++i) {
            boolean exampleResLegal;
            String exampleValue;
            Map example = exampleList.get(i);
            if (example.isEmpty()) continue;
            String string = exampleValue = null == example.get("exampleval") ? "" : String.valueOf(example.get("exampleval"));
            if ("A".equals(normType)) {
                boolean legal;
                boolean bl = legal = kd.bos.util.StringUtils.isEmpty((String)exampleValue) || kd.bos.util.StringUtils.isNumeric((String)exampleValue);
                if (!legal) {
                    example.put("exampleval", "");
                    inspErrList.add(String.format(ResManager.loadKDString((String)"\u6837\u672c\u5206\u5f55\u884c%1$s\uff0c\u6307\u6807\u7c7b\u578b\u4e3a\u5b9a\u91cf\u65f6\uff0c\u5b9e\u6d4b\u503c\u5e94\u8be5\u4e3a\u6570\u503c:%2$s\u3002", (String)"InspectCkvalHelper_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), i + 1, exampleValue));
                }
            } else if ("B".equals(normType)) {
                boolean legal;
                boolean bl = legal = kd.bos.util.StringUtils.isEmpty((String)exampleValue) || "Y".equalsIgnoreCase(exampleValue) || "N".equalsIgnoreCase(exampleValue);
                if (!legal) {
                    example.put("exampleval", "");
                    inspErrList.add(String.format(ResManager.loadKDString((String)"\u6837\u672c\u5206\u5f55\u884c%1$s\uff0c\u6307\u6807\u7c7b\u578b\u4e3a\u5b9a\u6027\u65f6\uff0c\u5b9e\u6d4b\u503c\u5e94\u8be5\u4e3aY/N:%2$s\u3002", (String)"InspectCkvalHelper_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), i + 1, exampleValue));
                }
            }
            String exampleRes = null == example.get("examplevalres") ? "" : String.valueOf(example.get("examplevalres"));
            boolean bl = exampleResLegal = kd.bos.util.StringUtils.isEmpty((String)exampleRes) || "Y".equals(exampleRes) || "N".equals(exampleRes);
            if (exampleResLegal) continue;
            example.put("examplevalres", "");
            inspErrList.add(String.format(ResManager.loadKDString((String)"\u6837\u672c\u5206\u5f55\u884c%1$s\uff0c\u5b9e\u6d4b\u503c\u5224\u5b9a\u7ed3\u679c\u5e94\u8be5\u4e3a\u5408\u683c/\u4e0d\u5408\u683c:%2$s\u3002", (String)"InspectCkvalHelper_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), i + 1, exampleRes));
        }
    }

    private static void appendSampNumId(IFormView view, DynamicObjectCollection subSampEntry) {
        int size = subSampEntry.size();
        long[] sampIds = InspectCkvalHelper.getSampIds(view.getEntityId(), size);
        for (int i = 0; i < size; ++i) {
            DynamicObject subSampObj = (DynamicObject)subSampEntry.get(i);
            subSampObj.set("samplenumid", (Object)sampIds[i]);
        }
    }

    public static long[] getSampIds(String mainEntityId, int count) {
        String entityId = String.format("%s.%s.%s", mainEntityId, "matintoentity", "subsampleresentity");
        return ORM.create().genLongIds(entityId, count);
    }

    private static void dealStdItem(IFormView view, Object inspStd, DynamicObjectCollection inspSubEntry) {
        IDataModel model = view.getModel();
        Boolean inspItemMode = CommonInspectParamHelper.isInspItemMod(DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"transactype"));
        if (inspItemMode.booleanValue() && !inspSubEntry.isEmpty()) {
            for (DynamicObject inspObj : inspSubEntry) {
                inspObj.set("uquuid", (Object)Uuid16.create().toString());
            }
        } else if (inspStd instanceof DynamicObject) {
            DynamicObjectCollection inspItems = ((DynamicObject)inspStd).getDynamicObjectCollection("entryentity");
            if (!inspItemMode.booleanValue() || inspSubEntry.isEmpty()) {
                int inspSubSize = inspSubEntry.size();
                DynamicObjectType inspSubType = inspSubEntry.getDynamicObjectType();
                LinkedList<DynamicObject> inspObjList = new LinkedList<DynamicObject>();
                int itemSize = inspItems.size();
                for (int i = 0; i < itemSize; ++i) {
                    int seq = i + 1;
                    DynamicObject inspObj = seq <= inspSubSize ? (DynamicObject)inspSubEntry.get(i) : new DynamicObject(inspSubType);
                    inspObjList.add(inspObj);
                    InspectBillHelper.setStandardProjectRow((DynamicObject)inspItems.get(i), inspObj, seq);
                }
                inspSubEntry.clear();
                inspSubEntry.addAll(inspObjList);
            }
        } else if (!inspItemMode.booleanValue()) {
            inspSubEntry.clear();
        }
    }
}

