/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper.inspectexecute;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.DataModelUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;

public class InspectCommonHelper {
    public static void updateSampAndProjSampQtyCommon(int rowIndex, IDataModel model, IFormView view, BigDecimal maxSampQty, Boolean ignoreJoinInsp) {
        DynamicObject unit = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"unitfield", (int)rowIndex);
        BigDecimal matQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"materialqty", (int)rowIndex);
        DynamicObjectCollection inspSubEntry = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"inspsubentity", (int)rowIndex);
        String rule = InspectCommonHelper.getSampNumRule(model);
        for (DynamicObject inspSubRow : inspSubEntry) {
            if (ignoreJoinInsp.booleanValue() && inspSubRow.getBoolean("isjoininspect") && inspSubRow.getLong("srcitementryid") > 0L) continue;
            CkSampleCaleResModel resModel = InspectCkvalHelper.getSampInfoByInspRow(inspSubRow.getDynamicObject("projsamp"), unit, matQty, rule);
            BigDecimal sampleSize = resModel.getRinsQty();
            inspSubRow.set("projsampqty", (Object)sampleSize);
            inspSubRow.set("projacceptqty", (Object)resModel.getAcceptyQty());
            maxSampQty = InspectCommonHelper.getMaxSampQty(maxSampQty, sampleSize);
        }
        InspectCommonHelper.setRinsQty(rowIndex, model, maxSampQty);
        model.updateEntryCache(inspSubEntry);
        view.updateView("inspsubentity");
    }

    public static void setRinsQty(int rowIndex, IDataModel model, BigDecimal maxSampQty) {
        BigDecimal rinsQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"rinsqty", (int)rowIndex);
        DynamicObjectCollection subMeasures = DataModelUtil.getSubEntry((IDataModel)model, (String)"matintoentity", (String)"submeasuredvalentity", (int)rowIndex);
        if (subMeasures.isEmpty()) {
            model.setValue("rinsqty", (Object)maxSampQty, rowIndex);
        } else if (maxSampQty.compareTo(rinsQty) > 0) {
            model.setValue("rinsqty", (Object)maxSampQty, rowIndex);
        } else if (maxSampQty.compareTo(rinsQty) < 0) {
            for (DynamicObject subMeasureObj : subMeasures) {
                String measureValueDeter = subMeasureObj.getString("measuredval_deter");
                if (StringUtils.isNotEmpty((String)measureValueDeter)) {
                    return;
                }
                String measureValueRat = subMeasureObj.getString("measuredval_rat");
                if (StringUtils.isNotEmpty((String)measureValueRat)) {
                    return;
                }
                String measureValueJudge = subMeasureObj.getString("measuredval_judge");
                if (StringUtils.isNotEmpty((String)measureValueJudge)) {
                    return;
                }
                String measureComment = subMeasureObj.getString("measure_comment");
                if (!StringUtils.isNotEmpty((String)measureComment)) continue;
                return;
            }
            model.setValue("rinsqty", (Object)maxSampQty, rowIndex);
        }
    }

    public static String getSampNumRule(IDataModel model) {
        DynamicObject transactype = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"transactype");
        return InspectCommonHelper.getsSampNumRuleBytrans(transactype);
    }

    public static String getSampNumRule(DynamicObject billObj) {
        DynamicObject transactype = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)billObj, (String)"transactype");
        return InspectCommonHelper.getsSampNumRuleBytrans(transactype);
    }

    public static BigDecimal getMaxSampQty(BigDecimal maxSampQty, BigDecimal sampleSize) {
        if (maxSampQty.compareTo(sampleSize) < 0) {
            return sampleSize;
        }
        return maxSampQty;
    }

    private static String getsSampNumRuleBytrans(DynamicObject transactype) {
        return null == transactype ? "A" : (StringUtils.isEmpty((String)transactype.getString("sampnumrule")) ? "A" : transactype.getString("sampnumrule"));
    }
}

