/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.helper.inspectexecute;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.qmc.qcbd.common.model.joininspect.JoinInspectEntityModel;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.ParameterUtil;

public class JoinInspectHelper {
    private JoinInspectHelper() {
    }

    public static JoinInspectEntityModel getEntityModel(String joinInspectBill, String operate) {
        JoinInspectEntityModel model = null;
        Map joinInspReflex = ParameterUtil.getQmcSystemPropMap((String)"joininspect_reflex_S");
        String matchAttrKey = String.format("joininsp_%s", joinInspectBill);
        if (joinInspReflex.containsKey(matchAttrKey)) {
            String applyBill = (String)joinInspReflex.get(String.format("joininsp_%s_apply", joinInspectBill));
            String inspectBill = (String)joinInspReflex.get(String.format("joininsp_%s_insp", joinInspectBill));
            model = new JoinInspectEntityModel(applyBill, joinInspectBill, inspectBill, operate);
        }
        return model;
    }

    public static JoinInspectEntityModel getEntityModel(String inspectBill) {
        JoinInspectEntityModel model = null;
        Map joinInspReflex = ParameterUtil.getQmcSystemPropMap((String)"joininspect_reflex_S");
        String matchAttrKey = null;
        for (Map.Entry entry : joinInspReflex.entrySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)inspectBill, (CharSequence)((CharSequence)entry.getValue()))) continue;
            String key = (String)entry.getKey();
            int length = key.length();
            matchAttrKey = key.substring(0, length - 5);
            break;
        }
        if (joinInspReflex.containsKey(matchAttrKey)) {
            String applyBill = (String)joinInspReflex.get(String.format("%s_apply", matchAttrKey));
            String joinInspectBill = (String)joinInspReflex.get(matchAttrKey);
            model = new JoinInspectEntityModel(applyBill, joinInspectBill, inspectBill, "audit");
        }
        return model;
    }

    public static Map<Long, Set<Long>> getApplyBillEntryMap(DynamicObject[] billObjs, JoinInspectEntityModel entityModel) {
        HashMap<Long, Set<Long>> srcBillEntryMap = new HashMap<Long, Set<Long>>(16);
        if (ArrayUtils.isEmpty((Object[])billObjs)) {
            return srcBillEntryMap;
        }
        DynamicObjectCollection matRows = new DynamicObjectCollection();
        for (DynamicObject billObj : billObjs) {
            matRows.addAll((Collection)billObj.getDynamicObjectCollection("matintoentity"));
        }
        return JoinInspectHelper.getApplyIds(matRows, entityModel);
    }

    public static Map<Long, Set<Long>> getApplyIds(DynamicObjectCollection matEntry, JoinInspectEntityModel entityModel) {
        HashMap<Long, Set<Long>> applyIds = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject matRow : matEntry) {
            if (!entityModel.getApplyBill().equals(matRow.getString("srcbillentity"))) continue;
            Long srcBillId = matRow.getLong("srcbillid");
            HashSet<Long> entryIdSet = (HashSet<Long>)applyIds.get(srcBillId);
            if (null == entryIdSet) {
                entryIdSet = new HashSet<Long>(16);
                applyIds.put(srcBillId, entryIdSet);
            }
            entryIdSet.add(matRow.getLong("srcbillentryid"));
        }
        return applyIds;
    }

    public static DynamicObject[] getInspectInfoCommon(String billEntity, Set<Long> billIds, Set<Long> entryIds, Set<Long> srcEntryIds, String billStatus, String ... otherField) {
        DynamicObject[] inspectInfos;
        QFilter filter = new QFilter("id", "in", billIds);
        if (null != billStatus) {
            filter.and("billstatus", "=", (Object)billStatus);
        }
        for (DynamicObject inspectInfo : inspectInfos = BusinessDataServiceHelper.load((String)billEntity, (String)JoinInspectHelper.getSelectField(otherField), (QFilter[])filter.toArray())) {
            inspectInfo.getDynamicObjectCollection("matintoentity").removeIf(o -> Objects.nonNull(entryIds) && !entryIds.contains(o.getLong("id")) || Objects.nonNull(srcEntryIds) && !srcEntryIds.contains(o.getLong("srcbillentryid")));
        }
        return inspectInfos;
    }

    public static DynamicObject[] getInspectInfo(String billEntity, Set<Long> itemEntryIds, String ... otherField) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"A").and(String.format("%s.%s.%s", "matintoentity", "inspsubentity", "joininspentryid"), "in", itemEntryIds);
        return BusinessDataServiceHelper.load((String)billEntity, (String)JoinInspectHelper.getSelectField(otherField), (QFilter[])filter.toArray());
    }

    public static void joinInspectToInspect(DynamicObject[] joinInspects, DynamicObject[] inspects, JoinInspectEntityModel entityModel) {
        HashMap<String, DynamicObject> cacheMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject joinInspect : joinInspects) {
            DynamicObjectCollection joinMatEntry = joinInspect.getDynamicObjectCollection("matintoentity");
            for (DynamicObject joinMatRow : joinMatEntry) {
                Long srcBillId = joinMatRow.getLong("srcbillid");
                Long srcBillEntryId = joinMatRow.getLong("srcbillentryid");
                for (DynamicObject inspect : inspects) {
                    JoinInspectHelper.joinInspSingleToInspSingle(entityModel, joinMatRow, srcBillId, srcBillEntryId, inspect, cacheMap);
                }
            }
        }
    }

    private static void joinInspSingleToInspSingle(JoinInspectEntityModel entityModel, DynamicObject joinMatRow, Long srcBillId, Long srcBillEntryId, DynamicObject inspect, Map<String, DynamicObject> cacheMap) {
        DynamicObjectCollection inspMatEntry = inspect.getDynamicObjectCollection("matintoentity");
        for (DynamicObject inspRow : inspMatEntry) {
            Long inspSrcBillId = inspRow.getLong("srcbillid");
            Long inspSrcBillEntryId = inspRow.getLong("srcbillentryid");
            if (0L != srcBillId && 0L != srcBillEntryId && srcBillId.equals(inspSrcBillId) && srcBillEntryId.equals(inspSrcBillEntryId)) {
                JoinInspectHelper.joinRowToInspRow(joinMatRow, inspRow, entityModel, Boolean.FALSE, cacheMap);
                continue;
            }
            Set srcItemIds = inspRow.getDynamicObjectCollection("inspsubentity").stream().filter(x -> x.getLong("srcitementryid") > 0L).map(x -> x.getLong("srcitementryid")).collect(Collectors.toSet());
            Set joinInspItemIds = joinMatRow.getDynamicObjectCollection("inspsubentity").stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
            srcItemIds.retainAll(joinInspItemIds);
            if (srcItemIds.isEmpty()) continue;
            JoinInspectHelper.joinRowToInspRow(joinMatRow, inspRow, entityModel, Boolean.FALSE, cacheMap);
        }
    }

    public static void joinRowToInspRow(DynamicObject joinMatRow, DynamicObject inspMatRow, JoinInspectEntityModel entityModel, Boolean addNew, Map<String, DynamicObject> cacheMap) {
        BigDecimal rinsQty = null == inspMatRow.getBigDecimal("rinsqty") ? BigDecimal.ZERO : inspMatRow.getBigDecimal("rinsqty");
        BigDecimal joinRinsQty = joinMatRow.getBigDecimal("rinsqty");
        if (null != joinRinsQty && joinRinsQty.compareTo(rinsQty) > 0) {
            inspMatRow.set("rinsqty", (Object)joinRinsQty);
        }
        Map<Long, Long> sampIdReflex = JoinInspectHelper.joinSampToInspSamp(joinMatRow, inspMatRow, entityModel);
        Set<String> uuidSet = JoinInspectHelper.joinSubInspToInspSubInsp(joinMatRow, inspMatRow, entityModel, addNew);
        JoinInspectHelper.joinMeasureToInspMeasure(joinMatRow, inspMatRow, entityModel, sampIdReflex, uuidSet);
        JoinInspectHelper.dealSampRes(inspMatRow, cacheMap);
    }

    public static void chooseJoinData(DynamicObject joinMatRow, List<Integer> seqs) {
        DynamicObjectCollection inspSubEnry = joinMatRow.getDynamicObjectCollection("inspsubentity");
        List removedSeq = inspSubEnry.stream().filter(x -> !seqs.contains(x.getInt("seq"))).map(x -> x.getInt("seq")).collect(Collectors.toList());
        removedSeq.stream().sorted(Comparator.reverseOrder()).forEach(seq -> inspSubEnry.remove(seq - 1));
        Set choosedUuids = inspSubEnry.stream().map(x -> x.getString("uquuid")).collect(Collectors.toSet());
        DynamicObjectCollection subMeasureEntry = joinMatRow.getDynamicObjectCollection("submeasuredvalentity");
        subMeasureEntry.removeIf(x -> !choosedUuids.contains(x.getString("projuuid")));
        Map<Long, List<DynamicObject>> exampleIdGroup = subMeasureEntry.stream().collect(Collectors.groupingBy(x -> x.getLong("exmapleid")));
        DynamicObjectCollection subSampEntry = joinMatRow.getDynamicObjectCollection("subsampleresentity");
        for (DynamicObject subSampRow : subSampEntry) {
            Long sampId = subSampRow.getLong("samplenumid");
            List<DynamicObject> values = exampleIdGroup.get(sampId);
            int sampCkval = null == values ? 0 : values.size();
            subSampRow.set("sampckval", (Object)sampCkval);
        }
    }

    public static Set<Long> getJoinInspItemEntryIds(DynamicObject[] joinInspects) {
        HashSet<Long> itemEntryIds = new HashSet<Long>(16);
        for (DynamicObject joinInspect : joinInspects) {
            DynamicObjectCollection joinInspMatEnry = joinInspect.getDynamicObjectCollection("matintoentity");
            for (DynamicObject joinMatRow : joinInspMatEnry) {
                DynamicObjectCollection joinInspSubEntry = joinMatRow.getDynamicObjectCollection("inspsubentity");
                itemEntryIds.addAll(joinInspSubEntry.stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
            }
        }
        return itemEntryIds;
    }

    private static Map<Long, Long> joinSampToInspSamp(DynamicObject joinMatRow, DynamicObject inspMatRow, JoinInspectEntityModel entityModel) {
        DynamicObjectCollection joinSubSamp = joinMatRow.getDynamicObjectCollection("subsampleresentity");
        DynamicObjectCollection inspSubSamp = inspMatRow.getDynamicObjectCollection("subsampleresentity");
        String operate = entityModel.getOperate();
        int joinSampSize = joinSubSamp.size();
        int inspSampSize = inspSubSamp.size();
        if ("audit".equals(operate) && inspSampSize < joinSampSize) {
            long[] sampIds;
            inspMatRow.set("rinsqty", (Object)joinSampSize);
            int count = joinSampSize - inspSampSize;
            for (long sampId : sampIds = JoinInspectHelper.getSampIds(count, entityModel.getInspectBill())) {
                DynamicObject inspSampRow = inspSubSamp.addNew();
                inspSampRow.set("samplenumid", (Object)sampId);
                inspSampRow.set("seq", (Object)(++inspSampSize));
                inspSampRow.set("samplenum", (Object)String.format(ResManager.loadKDString((String)"\u6837\u672c%s", (String)"JoinInspectHelper_0", (String)"qmc-qcbd-business", (Object[])new Object[0]), inspSampSize));
            }
        }
        HashMap<Long, Long> sampIdReflex = new HashMap<Long, Long>(16);
        for (int i = 0; i < joinSampSize; ++i) {
            DynamicObject joinSampRow = (DynamicObject)joinSubSamp.get(i);
            DynamicObject inspSampRow = (DynamicObject)inspSubSamp.get(i);
            sampIdReflex.put(joinSampRow.getLong("samplenumid"), inspSampRow.getLong("samplenumid"));
        }
        return sampIdReflex;
    }

    private static Set<String> joinSubInspToInspSubInsp(DynamicObject joinMatRow, DynamicObject inspMatRow, JoinInspectEntityModel entityModel, Boolean addNew) {
        DynamicObjectCollection joinSubInsp = joinMatRow.getDynamicObjectCollection("inspsubentity");
        DynamicObjectCollection inspSubInsp = inspMatRow.getDynamicObjectCollection("inspsubentity");
        String operate = entityModel.getOperate();
        for (DynamicObject joinRow : joinSubInsp) {
            String uuid = joinRow.getString("uquuid");
            Optional<DynamicObject> optional = inspSubInsp.stream().filter(x -> uuid.equals(x.getString("uquuid"))).findFirst();
            DynamicObject inspRow = null;
            if (optional.isPresent()) {
                inspRow = optional.get();
            } else if (addNew.booleanValue()) {
                int seq = inspSubInsp.size() + 1;
                inspRow = inspSubInsp.addNew();
                inspRow.set("isjoininspect", (Object)Boolean.TRUE);
                inspRow.set("seq", (Object)seq);
                inspRow.set("srcitementity", (Object)entityModel.getJoinInspectBill());
                inspRow.set("srcitementryid", joinRow.getPkValue());
                JoinInspectHelper.copyJoinValue(joinRow, inspRow, "inspectmethod", "inspectfreq", "inspectbasis", "inspectinstruct", "inspecunitid", "uquuid");
            }
            if (null == inspRow) continue;
            if ("audit".equals(operate)) {
                JoinInspectHelper.copyJoinValue(joinRow, inspRow, "projqualifiyqty", "projunqualifiyqty", "projckresult", "projckval", "choosesampqty", "projsampqty", "inspectionitem", "inspectioncontent", "keyquality", "normtype", "matchflag", "specvalue", "topvalue", "downvalue", "projsamp", "projacceptqty");
                inspRow.set("joininspentryid", joinRow.getPkValue());
                inspRow.set("projckresult", (Object)joinRow.getString("projckresult"));
                inspRow.set("joininspectstatus", (Object)"Y");
                continue;
            }
            if (!"unaudit".equals(operate)) continue;
            JoinInspectHelper.addJoinValue(joinRow, inspRow, operate, "projqualifiyqty", "projunqualifiyqty", "projckval", "choosesampqty", "projsampqty", "projacceptqty");
            inspRow.set("projckresult", (Object)"");
            inspRow.set("joininspectstatus", (Object)"P");
        }
        return inspSubInsp.stream().map(x -> x.getString("uquuid")).collect(Collectors.toSet());
    }

    private static void joinMeasureToInspMeasure(DynamicObject joinMatRow, DynamicObject inspMatRow, JoinInspectEntityModel entityModel, Map<Long, Long> sampIdReflex, Set<String> uuidSet) {
        block4: {
            String operate;
            DynamicObjectCollection inspSubMeasure;
            DynamicObjectCollection joinSubMeasure;
            block3: {
                joinSubMeasure = joinMatRow.getDynamicObjectCollection("submeasuredvalentity");
                inspSubMeasure = inspMatRow.getDynamicObjectCollection("submeasuredvalentity");
                operate = entityModel.getOperate();
                if (!"audit".equals(operate)) break block3;
                int seqBegin = inspSubMeasure.size() + 1;
                for (DynamicObject joinMeasureRow : joinSubMeasure) {
                    if (!uuidSet.contains(joinMeasureRow.getString("projuuid"))) continue;
                    DynamicObject inspMeasureRow = inspSubMeasure.addNew();
                    inspMeasureRow.set("seq", (Object)seqBegin++);
                    inspMeasureRow.set("exmapleid", (Object)sampIdReflex.get(joinMeasureRow.getLong("exmapleid")));
                    JoinInspectHelper.copyJoinValue(joinMeasureRow, inspMeasureRow, "projuuid", "samp_seq", "measuredval_deter", "measuredval_rat", "measuredval_judge", "measure_comment");
                }
                break block4;
            }
            if (!"unaudit".equals(operate)) break block4;
            for (DynamicObject joinMeasureRow : joinSubMeasure) {
                String projUuid = joinMeasureRow.getString("projuuid");
                Long exampleId = sampIdReflex.get(joinMeasureRow.getLong("exmapleid"));
                inspSubMeasure.removeIf(x -> projUuid.equals(x.getString("projuuid")) && exampleId.equals(x.getLong("exmapleid")));
            }
            int size = inspSubMeasure.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject inspMeasureRow = (DynamicObject)inspSubMeasure.get(i);
                inspMeasureRow.set("seq", (Object)(i + 1));
            }
        }
    }

    private static void dealSampRes(DynamicObject inspMatRow, Map<String, DynamicObject> cacheMap) {
        DynamicObjectCollection subMeasureEntry = inspMatRow.getDynamicObjectCollection("submeasuredvalentity");
        Map<Long, List<DynamicObject>> exampleGroup = subMeasureEntry.stream().collect(Collectors.groupingBy(x -> x.getLong("exmapleid")));
        int inspItemSize = inspMatRow.getDynamicObjectCollection("inspsubentity").size();
        DynamicObjectCollection subSampleEntry = inspMatRow.getDynamicObjectCollection("subsampleresentity");
        int sampUnPassCount = 0;
        int sampPassCount = 0;
        for (DynamicObject subSampRow : subSampleEntry) {
            Long sampleId = subSampRow.getLong("samplenumid");
            if (!exampleGroup.containsKey(sampleId)) {
                subSampRow.set("sampleres", (Object)"");
                subSampRow.set("sampckval", (Object)0);
                continue;
            }
            List<DynamicObject> ckvals = exampleGroup.get(sampleId);
            subSampRow.set("sampckval", (Object)ckvals.size());
            Boolean unPass = ckvals.stream().anyMatch(x -> "N".equals(x.getString("measuredval_judge")));
            if (unPass.booleanValue()) {
                subSampRow.set("sampleres", (Object)"N");
                ++sampUnPassCount;
                continue;
            }
            Long passCount = ckvals.stream().filter(x -> "Y".equals(x.getString("measuredval_judge"))).count();
            if ((long)inspItemSize == passCount) {
                subSampRow.set("sampleres", (Object)"Y");
                ++sampPassCount;
                continue;
            }
            subSampRow.set("sampleres", (Object)"");
        }
        inspMatRow.set("sampqualqty", (Object)sampPassCount);
        inspMatRow.set("samunqualqty", (Object)sampUnPassCount);
        Long materialId = inspMatRow.getDynamicObject("materialid").getLong("id");
        Long unitId = inspMatRow.getDynamicObject("unitfield").getLong("id");
        DynamicObject baseUnit = inspMatRow.getDynamicObject("baseunit");
        BigDecimal sampBaseQty = BaseUnitQtyConVertUtil.getQtyConvert((Long)materialId, (Long)unitId, (BigDecimal)new BigDecimal(sampPassCount), (DynamicObject)baseUnit, cacheMap);
        BigDecimal sampBaseUqty = BaseUnitQtyConVertUtil.getQtyConvert((Long)materialId, (Long)unitId, (BigDecimal)new BigDecimal(sampUnPassCount), (DynamicObject)baseUnit, cacheMap);
        inspMatRow.set("basesampqlyqty", (Object)sampBaseQty);
        inspMatRow.set("basesampuqlyqty", (Object)sampBaseUqty);
        BigDecimal rinsQty = inspMatRow.getBigDecimal("rinsqty");
        if (null == rinsQty || sampPassCount + sampUnPassCount > rinsQty.intValue()) {
            return;
        }
        int acNum = BigDecimalUtil.toBigDecimal((Object)inspMatRow.getString("acstr")).intValue();
        if (sampUnPassCount > acNum) {
            inspMatRow.set("samplingresult", (Object)"C");
        } else if (rinsQty.intValue() - sampPassCount <= acNum) {
            inspMatRow.set("samplingresult", (Object)"B");
        }
    }

    private static void copyJoinValue(DynamicObject joinRow, DynamicObject inspRow, String ... keyIds) {
        for (String keyId : keyIds) {
            inspRow.set(keyId, joinRow.get(keyId));
        }
    }

    private static void addJoinValue(DynamicObject joinRow, DynamicObject inspRow, String operate, String ... keyIds) {
        for (String keyId : keyIds) {
            if ("audit".equals(operate)) {
                inspRow.set(keyId, (Object)inspRow.getBigDecimal(keyId).add(joinRow.getBigDecimal(keyId)));
                continue;
            }
            if (!"unaudit".equals(operate)) continue;
            inspRow.set(keyId, (Object)inspRow.getBigDecimal(keyId).subtract(joinRow.getBigDecimal(keyId)));
        }
    }

    private static long[] getSampIds(int count, String entityId) {
        return ORM.create().genLongIds(entityId, count);
    }

    private static String getSelectField(String ... otherField) {
        String selectFields = String.join((CharSequence)",", "materialid", "unitfield", "baseunit", "srcbillentity", "srcbillid", "srcbillentryid", "rinsqty", "sampqualqty", "samunqualqty", "basesampqlyqty", "basesampuqlyqty", "acstr", "samplenumid", "samplenum", "sampleres", "sampckval", String.format("%s.%s", "subsampleresentity", "seq"), "uquuid", "inspectionitem", "inspectioncontent", "keyquality", "normtype", "matchflag", "specvalue", "topvalue", "downvalue", "projsamp", "projsampqty", "projqualifiyqty", "projunqualifiyqty", "projckresult", "projckval", "projckvalstr", "choosesampqty", "projacceptqty", String.format("%s.%s", "inspsubentity", "seq"), "projuuid", "exmapleid", "samp_seq", "measuredval_deter", "measuredval_rat", "measuredval_judge", "measure_comment", String.format("%s.%s", "submeasuredvalentity", "seq"));
        StringBuilder sb = new StringBuilder();
        for (String field : otherField) {
            sb.append(",");
            sb.append(field);
        }
        return selectFields + sb;
    }
}

