/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.insobj;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.business.helper.InspObjectQtyHelper;
import kd.qmc.qcbd.business.insobj.InspObjectBase;
import kd.qmc.qcbd.common.args.insobj.AuditAssBillInfoEventArgs;
import kd.qmc.qcbd.common.args.insobj.CaleInsObjectQtyEventArgs;
import kd.qmc.qcbd.common.args.insobj.DeleteInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.GlobalSaveInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.IniInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveAssBillInfoEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveInspObjectEventArgs;
import kd.qmc.qcbd.common.model.insobj.InspObjAssModel;
import kd.qmc.qcbd.common.model.insobj.InspObjModel;
import kd.qmc.qcbd.common.util.DynamicObjUtil;
import kd.qmc.qcbd.common.util.ListQMCUtil;

public abstract class InspObjectBizBase
extends InspObjectBase {
    private String mFormatEntryField = "entryentity.%s";
    private String mInspObjEntityNumber = "";
    private IniInspObjectEventArgs mIniParam = new IniInspObjectEventArgs();

    public String getmInspObjEntityNumber() {
        return this.mInspObjEntityNumber;
    }

    public IniInspObjectEventArgs getIniParam() {
        return this.mIniParam;
    }

    @Override
    public void iniInspObject(IniInspObjectEventArgs args) {
        this.mIniParam = args;
        this.mInspObjEntityNumber = InspObjectHelper.getInspObjEntityNumberByAppid(args.getAppId());
    }

    @Override
    public void afterSaveInspObject(SaveInspObjectEventArgs args, GlobalSaveInspObjectEventArgs globalargs) {
        super.afterSaveInspObject(args, globalargs);
        List models = args.getInspObjs();
        ArrayList<DynamicObject> inspDyncObjs = new ArrayList<DynamicObject>(16);
        Set<Long> pkVals = models.stream().filter(p -> p.getId() > 0L).map(InspObjModel::getId).collect(Collectors.toSet());
        this.setInspObject(args, pkVals);
        RequestContext rc = RequestContext.get();
        args.setCurUserID(Long.valueOf(rc.getCurrUserId()));
        for (InspObjModel model : models) {
            this.iniSaveInspObjectSingle(args, model);
            DynamicObject inspObject = this.saveInspObjectSingle(args, model);
            inspDyncObjs.add(inspObject);
            model.setInspObject(inspObject);
        }
        List inspObjs = globalargs.getInspObjs();
        globalargs.getBillIndexs().put(args.getSaveBillID(), inspObjs.size());
        inspObjs.addAll(inspDyncObjs);
        this.setInspID(models);
    }

    @Override
    public void afterSaveAssBillInfo(SaveAssBillInfoEventArgs args, GlobalSaveInspObjectEventArgs globalargs) {
        super.afterSaveAssBillInfo(args, globalargs);
        Long saveBillID = args.getSaveInspArgs().getSaveBillID();
        Integer startIndex = (Integer)globalargs.getBillIndexs().get(saveBillID);
        List inspObjs = globalargs.getInspObjs();
        this.dealDeleteAssId(args);
        if (null == startIndex || inspObjs.isEmpty()) {
            return;
        }
        List assModels = args.getInspObjAsss();
        int size = assModels.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject inspObj = (DynamicObject)inspObjs.get(i + startIndex);
            if (null == inspObj) continue;
            InspObjAssModel assModel = (InspObjAssModel)assModels.get(i);
            Long assID = assModel.getAssId();
            DynamicObjectCollection colls = inspObj.getDynamicObjectCollection("entryentity");
            this.iniSaveInspObjectAssSingle(args.getSaveInspArgs(), assModel);
            Optional<DynamicObject> collOpt = assID == 0L ? colls.stream().filter(p -> StringUtils.equalsIgnoreCase((CharSequence)assModel.getBillId(), (CharSequence)p.getString("ass_billid")) && StringUtils.equalsIgnoreCase((CharSequence)assModel.getBillEntryId(), (CharSequence)p.getString("ass_billentryid")) && StringUtils.equalsIgnoreCase((CharSequence)assModel.getEntityNumber(), (CharSequence)p.getDynamicObject("ass_entitynumber").getString("number"))).findFirst() : colls.stream().filter(p -> p.getLong("id") == assID.longValue()).findFirst();
            DynamicObject coll = null;
            if (!collOpt.isPresent()) {
                coll = colls.addNew();
                coll.set("seq", (Object)colls.getRowCount());
            } else {
                coll = collOpt.get();
            }
            if (coll == null) continue;
            assModel.setObjectEntryObj(coll);
            this.saveInspObjectAssSingle(args, assModel, coll);
        }
        globalargs.getAssModels().addAll(assModels);
    }

    @Override
    public void batchSaveInspObject(GlobalSaveInspObjectEventArgs globalargs) {
        List inspObjs = globalargs.getInspObjs();
        int size = inspObjs.size();
        LinkedList<DynamicObject> distinctInspObjs = new LinkedList<DynamicObject>();
        HashMap<Long, Integer> inspObjSeq = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> inspIndex = new HashMap<Long, Integer>(16);
        ArrayList<Integer> reflexIndex = new ArrayList<Integer>(16);
        for (int i = 0; i < size; ++i) {
            DynamicObject inspObj = (DynamicObject)inspObjs.get(i);
            if (null == inspObj) continue;
            long inspObjId = inspObj.getLong("id");
            if (0L == inspObjId) {
                reflexIndex.add(distinctInspObjs.size());
                distinctInspObjs.add(inspObj);
                continue;
            }
            Integer nowSeq = (Integer)inspObjSeq.get(inspObjId);
            if (null == nowSeq) {
                int disSize = distinctInspObjs.size();
                reflexIndex.add(disSize);
                inspIndex.put(inspObjId, disSize);
                inspObjSeq.put(inspObjId, 0);
                distinctInspObjs.add(inspObj);
                continue;
            }
            nowSeq = nowSeq + 1;
            inspObjSeq.put(inspObjId, nowSeq);
            reflexIndex.add((Integer)inspIndex.get(inspObjId));
        }
        OperateOption option = this.getObjectOption();
        option.setVariableValue("Option_CaleQty", "true");
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)this.mInspObjEntityNumber, (DynamicObject[])distinctInspObjs.toArray(new DynamicObject[distinctInspObjs.size()]), (OperateOption)option);
        if (operationResult.isSuccess()) {
            this.setAssObject(globalargs.getAssModels(), distinctInspObjs, reflexIndex);
        }
    }

    @Override
    public void afterAuditAssBillInfo(AuditAssBillInfoEventArgs args) {
        super.afterAuditAssBillInfo(args);
        this.dealAuditAssBillInfo(args);
    }

    @Override
    public void afterUnAuditAssBillInfo(AuditAssBillInfoEventArgs args) {
        super.afterUnAuditAssBillInfo(args);
        this.dealAuditAssBillInfo(args);
    }

    @Override
    public void beforeDeleteInspObject(DeleteInspObjectEventArgs args) {
        super.beforeDeleteInspObject(args);
        this.structAssParams(args.getPkVals(), args.getInspObjAsss());
    }

    @Override
    public void afterDeleteInspObject(DeleteInspObjectEventArgs args) {
        super.afterDeleteInspObject(args);
        List billIds = args.getPkVals();
        if (billIds.isEmpty()) {
            return;
        }
        this.deleteInspObj(args, billIds);
        this.deleteInspAss(args);
    }

    @Override
    public void beforeAuditAssBillInfo(AuditAssBillInfoEventArgs args) {
        super.beforeAuditAssBillInfo(args);
        this.structAssParams(args.getPkVals(), args.getInspObjAsss());
    }

    @Override
    public void beforeUnAuditAssBillInfo(AuditAssBillInfoEventArgs args) {
        super.beforeUnAuditAssBillInfo(args);
        this.structAssParams(args.getPkVals(), args.getInspObjAsss());
    }

    private void dealAuditAssBillInfo(AuditAssBillInfoEventArgs args) {
        List assModels = args.getInspObjAsss();
        args.setCkObjectMap(this.getInspObject(assModels));
        Map<Long, DynamicObject> ckObjectEntryMap = this.getCkObjectEntryMap(args.getCkObjectMap());
        String billStatus = this.getBillStatus(args.getOperator());
        for (InspObjAssModel assModel : assModels) {
            Long assID = assModel.getAssId();
            DynamicObject objectEntryObj = ckObjectEntryMap.get(assID);
            assModel.setObjectEntryObj(objectEntryObj);
            assModel.setBillStatus(billStatus);
            objectEntryObj.set("ass_status", (Object)billStatus);
            objectEntryObj.set("ass_updtime", (Object)KDDateUtils.now());
        }
        List<DynamicObject> ckObjects = args.getCkObjectMap().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        DynamicObject[] ckObjectArray = ckObjects.toArray(new DynamicObject[ckObjects.size()]);
        if ("audit".equalsIgnoreCase(args.getOperator()) || "unaudit".equalsIgnoreCase(args.getOperator())) {
            CaleInsObjectQtyEventArgs caleQtyargs = new CaleInsObjectQtyEventArgs();
            new InspObjectQtyHelper().caleInsObjectQtyBatch(ckObjectArray, caleQtyargs);
        }
        SaveServiceHelper.update((DynamicObject[])ckObjectArray);
    }

    private void setAssObject(List<InspObjAssModel> assModels, List<DynamicObject> inspObjs, List<Integer> reflexIndex) {
        int size = assModels.size();
        for (int i = 0; i < size; ++i) {
            boolean fromDatabase;
            InspObjAssModel assModel = assModels.get(i);
            int inspIndex = reflexIndex.get(i);
            DynamicObject inspObj = inspObjs.get(inspIndex);
            DynamicObject entryObj = assModel.getSrcBillDyncObj();
            if (null == entryObj || (fromDatabase = entryObj.getDataEntityState().getFromDatabase())) continue;
            long inspObjId = inspObj.getLong("id");
            assModel.setObjectId(Long.valueOf(inspObjId));
            long entryId = entryObj.getLong("id");
            Optional<DynamicObject> optional = inspObj.getDynamicObjectCollection("entryentity").stream().filter(x -> x.getLong("ass_billentryid") == entryId).findAny();
            if (!optional.isPresent()) continue;
            DynamicObject inspEntry = optional.get();
            long inspObjAssid = inspEntry.getLong("id");
            assModel.setAssId(Long.valueOf(inspObjAssid));
            DynamicObject srcBillDyncObj = assModel.getSrcBillDyncObj();
            srcBillDyncObj.set("chkobjentryid", (Object)inspObjAssid);
            srcBillDyncObj.set("chkobjid", (Object)inspObjId);
            if (!srcBillDyncObj.getDataEntityType().getProperties().containsKey((Object)"inspfirstentrykey")) continue;
            srcBillDyncObj.set("inspfirstentrykey", (Object)assModel.getInspfirstentryid());
        }
    }

    private void setInspID(List<InspObjModel> models) {
        for (int i = 0; i < models.size(); ++i) {
            InspObjModel model = models.get(i);
            if (model.getId() != 0L) continue;
            Long pkval = (Long)model.getInspObject().getPkValue();
            model.setId(pkval);
            DynamicObject srcBillDyncObj = model.getSrcBillDyncObj();
            srcBillDyncObj.set("chkobjid", (Object)pkval);
        }
    }

    private void iniSaveInspObjectSingle(SaveInspObjectEventArgs args, InspObjModel model) {
        DynamicObject tempObj;
        if (args.getBillEntityType() != null) {
            String entityNumber = args.getBillEntityType().getName();
            model.setSentityNumber(entityNumber);
        }
        if ((tempObj = args.getSaveBillObj()) != null) {
            String billID = String.valueOf(tempObj.getPkValue());
            model.setSbillId(billID);
        }
        if (StringUtils.isBlank((CharSequence)model.getSrcBillNo()) || StringUtils.isBlank((CharSequence)model.getSrcBillId())) {
            model.setSrcBillNo(model.getSbillNo());
            model.setSrcEntityNumber(model.getSentityNumber());
            model.setSrcEntryId(model.getSbillEntryID());
            model.setSrcBillId(model.getSbillId());
        }
    }

    private DynamicObject saveInspObjectSingle(SaveInspObjectEventArgs args, InspObjModel model) {
        DynamicObject inspDyncObj = null;
        Long inspObjId = model.getId();
        if (inspObjId > 0L && args.getCkObjectMap().containsKey(inspObjId)) {
            Object assBillId;
            inspDyncObj = (DynamicObject)args.getCkObjectMap().get(inspObjId);
            DynamicObjectCollection entryEntity = inspDyncObj.getDynamicObjectCollection("entryentity");
            if (!entryEntity.isEmpty() && (assBillId = ((DynamicObject)entryEntity.get(0)).get("ass_billid")).equals(String.valueOf(args.getSaveBillID()))) {
                inspDyncObj.set("srcmaterialid", (Object)model.getSrcMaterialIdObj());
                inspDyncObj.set("srcunitid", (Object)model.getSrcUnitIdObj());
                inspDyncObj.set("srcbaseunitid", (Object)model.getSrcBaseUnitIdObj());
                inspDyncObj.set("srcqty", (Object)model.getSrcQty());
                inspDyncObj.set("srcbaseqty", (Object)model.getSrcBaseQty());
                inspDyncObj.set("srcentryseq", (Object)model.getSrcEntrySeq());
            }
        } else {
            inspDyncObj = BusinessDataServiceHelper.newDynamicObject((String)this.mInspObjEntityNumber);
            inspDyncObj.set("creator", (Object)args.getCurUserID());
            inspDyncObj.set("createtime", (Object)args.getCurDate());
            inspDyncObj.set("sbillno", (Object)model.getSbillNo());
            inspDyncObj.set("biztype", (Object)model.getBizTypeId());
            inspDyncObj.set("sbillentryid", (Object)model.getSbillEntryID());
            inspDyncObj.set("sbillid", (Object)model.getSbillId());
            inspDyncObj.set("sentitynumber", (Object)model.getSentityNumber());
            inspDyncObj.set("status", (Object)"C");
            inspDyncObj.set("enable", (Object)"1");
            inspDyncObj.set("srcbillno", (Object)model.getSrcBillNo());
            inspDyncObj.set("scsystem", (Object)model.getScSystem());
            inspDyncObj.set("srcentitynumber", (Object)model.getSrcEntityNumber());
            inspDyncObj.set("srcbillid", (Object)model.getSrcBillId());
            inspDyncObj.set("srcentryid", (Object)model.getSrcEntryId());
            inspDyncObj.set("srcmaterialid", (Object)model.getSrcMaterialIdObj());
            inspDyncObj.set("srcunitid", (Object)model.getSrcUnitIdObj());
            inspDyncObj.set("srcbaseunitid", (Object)model.getSrcBaseUnitIdObj());
            inspDyncObj.set("srcqty", (Object)model.getSrcQty());
            inspDyncObj.set("srcbaseqty", (Object)model.getSrcBaseQty());
            inspDyncObj.set("srcentryseq", (Object)model.getSrcEntrySeq());
        }
        return inspDyncObj;
    }

    private void iniSaveInspObjectAssSingle(SaveInspObjectEventArgs args, InspObjAssModel assModel) {
        if (args.getBillEntityType() != null) {
            String entityNumber = args.getBillEntityType().getName();
            assModel.setEntityNumber(entityNumber);
        }
    }

    private DynamicObject saveInspObjectAssSingle(SaveAssBillInfoEventArgs args, InspObjAssModel assModel, DynamicObject assObject) {
        String appId = args.getBillEntityType().getAppId();
        assObject.set("ass_billid", (Object)assModel.getBillId());
        assObject.set("ass_billentryid", (Object)assModel.getBillEntryId());
        assObject.set("ass_entrynumber", (Object)assModel.getEntryNumber());
        assObject.set("ass_entitynumber", (Object)assModel.getEntityNumber());
        assObject.set("ass_billno", (Object)assModel.getBillNo());
        assObject.set("ass_billentryseq", (Object)assModel.getBillEntrySeq());
        assObject.set("ass_unitid", (Object)assModel.getUnitIdObj());
        assObject.set("ass_status", (Object)assModel.getBillStatus());
        if (assModel.getQualifQty().compareTo(BigDecimal.ZERO) == 0 || assModel.getQualifBaseQty().compareTo(BigDecimal.ZERO) == 0) {
            assObject.set("ass_qualifqty", (Object)BigDecimal.ZERO);
            assObject.set("ass_qualifbaseqty", (Object)BigDecimal.ZERO);
        } else {
            assObject.set("ass_qualifqty", (Object)assModel.getQualifQty());
            assObject.set("ass_qualifbaseqty", (Object)assModel.getQualifBaseQty());
        }
        if (StringUtils.isNotBlank((CharSequence)assModel.getHandMethed())) {
            assObject.set("ass_handmethed", (Object)(appId + assModel.getHandMethed()));
        } else {
            assObject.set("ass_handmethed", (Object)"");
        }
        if (null != assModel.getNewHandMode() && 0L != assModel.getNewHandMode()) {
            assObject.set("ass_newhandmode", (Object)assModel.getNewHandMode());
        }
        if (assModel.getUnQualifQty().compareTo(BigDecimal.ZERO) == 0 || assModel.getUnQualifBaseQty().compareTo(BigDecimal.ZERO) == 0) {
            assObject.set("ass_unqualifqty", (Object)BigDecimal.ZERO);
            assObject.set("ass_unqualifbaseqty", (Object)BigDecimal.ZERO);
        } else {
            assObject.set("ass_unqualifqty", (Object)assModel.getUnQualifQty());
            assObject.set("ass_unqualifbaseqty", (Object)assModel.getUnQualifBaseQty());
        }
        assObject.set("ass_updtime", (Object)KDDateUtils.now());
        assObject.set("ass_secondck", (Object)assModel.getSecondck());
        assObject.set("ass_inspfirstentrykey", (Object)String.valueOf(assModel.getInspfirstentryid()));
        return assObject;
    }

    private void setInspObject(SaveInspObjectEventArgs args, Set<Long> pkVals) {
        DynamicObject[] inspObjects = DynamicObjUtil.getLoadData((String)this.mInspObjEntityNumber, pkVals);
        Map inspObjectMap = DynamicObjUtil.getObjectMap((DynamicObject[])inspObjects);
        args.setCkObjectMap(inspObjectMap);
    }

    private OperateOption getObjectOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("strictvalidation", String.valueOf(true));
        return option;
    }

    private Map<Long, DynamicObject> getInspObject(List<InspObjAssModel> assModels) {
        Set pkVals = assModels.stream().filter(p -> p.getObjectId() > 0L).map(InspObjAssModel::getObjectId).collect(Collectors.toSet());
        String selectFields = "srcunitid,entryentity.ass_unitid,entryentity.ass_qualifqty,entryentity.ass_unqualifqty,entryentity.ass_qualifbaseqty,entryentity.ass_unqualifbaseqty,entryentity.ass_status,entryentity.ass_updtime,ass_qualifsrcqty,ass_unqualifsrcqty,sumunqualifbaseqty,sumqualifbaseqty,sumsrcqualifqty,sumsrcunqualifqty,ass_handmethed,ass_newhandmode";
        DynamicObject[] inspObjects = BusinessDataServiceHelper.load((String)this.mInspObjEntityNumber, (String)selectFields, (QFilter[])new QFilter("id", "in", pkVals).toArray());
        return DynamicObjUtil.getObjectMap((DynamicObject[])inspObjects);
    }

    private Map<Long, DynamicObject> getCkObjectEntryMap(Map<Long, DynamicObject> ckObjectMap) {
        HashMap<Long, DynamicObject> ckObjectEntryMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> entry : ckObjectMap.entrySet()) {
            DynamicObject ckObject = entry.getValue();
            DynamicObjectCollection colls = ckObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject coll : colls) {
                ckObjectEntryMap.put(coll.getLong("id"), coll);
            }
        }
        return ckObjectEntryMap;
    }

    private String getBillStatus(String opr) {
        String billStatus = "";
        switch (opr) {
            case "audit": {
                billStatus = "C";
                break;
            }
            case "unaudit": {
                billStatus = "A";
                break;
            }
        }
        return billStatus;
    }

    private void deleteInspObj(DeleteInspObjectEventArgs args, List<Object> billIds) {
        String entityNumber = args.getBillEntityType().getName();
        QFilter qfilter = new QFilter("sentitynumber", "=", (Object)entityNumber);
        List pkValStrs = ListQMCUtil.convertListStr(billIds);
        qfilter.and("sbillid", "in", (Object)pkValStrs);
        DeleteServiceHelper.delete((String)this.mInspObjEntityNumber, (QFilter[])qfilter.toArray());
    }

    private void deleteInspAss(DeleteInspObjectEventArgs args) {
        Set<Long> ckObjEntryIDs = args.getInspObjAsss().stream().filter(p -> p.getAssId() > 0L).map(InspObjAssModel::getAssId).collect(Collectors.toSet());
        List<Object> inspIdList = this.getDistinctInspIds(ckObjEntryIDs);
        if (inspIdList.isEmpty()) {
            return;
        }
        Map<Object, DynamicObject> inspMap = this.getInspMap(inspIdList);
        List<DynamicObject> saveDatas = this.batchRemoveDeleteAss(ckObjEntryIDs, inspIdList, inspMap);
        SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[saveDatas.size()]));
    }

    private List<Object> getDistinctInspIds(Set<Long> ckObjEntryIDs) {
        String ckObjEntryIdField = String.format(this.mFormatEntryField, "id");
        QFilter qfilter = new QFilter(ckObjEntryIdField, "in", ckObjEntryIDs);
        DynamicObjectCollection inspIdCollection = QueryServiceHelper.query((String)this.mInspObjEntityNumber, (String)"id", (QFilter[])qfilter.toArray());
        if (inspIdCollection.isEmpty()) {
            return Collections.emptyList();
        }
        return inspIdCollection.stream().map(x -> x.get("id")).distinct().collect(Collectors.toList());
    }

    private Map<Object, DynamicObject> getInspMap(List<Object> inspIdList) {
        DynamicObject[] inspObjs = BusinessDataServiceHelper.load((Object[])inspIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.mInspObjEntityNumber));
        return Arrays.stream(inspObjs).collect(Collectors.toMap(DataEntityBase::getPkValue, x -> x));
    }

    private List<DynamicObject> batchRemoveDeleteAss(Set<Long> ckObjEntryIDs, List<Object> inspIds, Map<Object, DynamicObject> inspMap) {
        LinkedList<DynamicObject> saveDatas = new LinkedList<DynamicObject>();
        for (Object inspId : inspIds) {
            DynamicObject inspObj = inspMap.get(inspId);
            if (null == inspObj) continue;
            DynamicObjectCollection assEntrys = inspObj.getDynamicObjectCollection("entryentity");
            assEntrys.removeIf(x -> ckObjEntryIDs.contains(x.getLong("id")));
            saveDatas.add(inspObj);
        }
        return saveDatas;
    }

    private void dealDeleteAssId(SaveAssBillInfoEventArgs args) {
        Set deleteAssIdSet = args.getDeleteAssID();
        if (!deleteAssIdSet.isEmpty()) {
            int deletePksSize;
            QFilter qfilter = new QFilter("entryentity.id", "in", (Object)deleteAssIdSet);
            DynamicObjectCollection inspCollection = QueryServiceHelper.query((String)this.mInspObjEntityNumber, (String)"id", (QFilter[])qfilter.toArray());
            Set inspIdSet = inspCollection.stream().map(x -> x.get("id")).collect(Collectors.toSet());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.mInspObjEntityNumber);
            DynamicObject[] inspObjs = BusinessDataServiceHelper.load((Object[])inspIdSet.toArray(), (DynamicObjectType)dataEntityType);
            LinkedList<DynamicObject> deleteAss = new LinkedList<DynamicObject>();
            LinkedList<DynamicObject> deletePks = new LinkedList<DynamicObject>();
            for (DynamicObject inspObj : inspObjs) {
                DynamicObjectCollection assEntrys = inspObj.getDynamicObjectCollection("entryentity");
                assEntrys.removeIf(x -> deleteAssIdSet.contains(x.get("id")));
                if (assEntrys.isEmpty()) {
                    deletePks.add(inspObj);
                    continue;
                }
                deleteAss.add(inspObj);
            }
            int deleteAssSize = deleteAss.size();
            if (deleteAssSize > 0) {
                SaveServiceHelper.save((DynamicObject[])deleteAss.toArray(new DynamicObject[deleteAssSize]));
            }
            if ((deletePksSize = deletePks.size()) > 0) {
                DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])deletePks.toArray());
            }
        }
    }
}

