/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.insobj.bill;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.qmc.qcbd.business.helper.InspBillAssModelHelper;
import kd.qmc.qcbd.business.insobj.InspObjectBizBase;
import kd.qmc.qcbd.common.args.insobj.GlobalSaveInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.IniInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveAssBillInfoEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveInspObjectEventArgs;
import kd.qmc.qcbd.common.model.insobj.InspObjAssModel;
import kd.qmc.qcbd.common.model.insobj.InspObjModel;

public class BadBillInsObj
extends InspObjectBizBase {
    private static final String FORMAT_ENTRYFIELD = "materialentry.%s";

    @Override
    public void iniInspObject(IniInspObjectEventArgs args) {
        super.iniInspObject(args);
        this.setBillFlag("baddeal");
    }

    @Override
    public void beforeSaveInspObject(SaveInspObjectEventArgs args, GlobalSaveInspObjectEventArgs globalargs) {
        super.beforeSaveInspObject(args, globalargs);
        DynamicObject inspObj = args.getSaveBillObj();
        DynamicObjectCollection matEntry = inspObj.getDynamicObjectCollection("materialentry");
        for (DynamicObject sEntry : matEntry) {
            long insobj;
            Object scSystem = sEntry.get("scsystem");
            if (null == scSystem || StringUtils.isBlank((CharSequence)scSystem.toString()) || 0L == (insobj = sEntry.getLong("chkobjid"))) continue;
            InspObjModel model = new InspObjModel();
            model.setId(Long.valueOf(insobj));
            model.setSrcBillDyncObj(sEntry);
            args.getInspObjs().add(model);
        }
    }

    @Override
    public void beforeSaveAssBillInfo(SaveAssBillInfoEventArgs args, GlobalSaveInspObjectEventArgs globalargs) {
        super.beforeSaveAssBillInfo(args, globalargs);
        SaveInspObjectEventArgs saveArgs = args.getSaveInspArgs();
        DynamicObject inspObj = saveArgs.getSaveBillObj();
        DynamicObjectCollection inspObjEntry = inspObj.getDynamicObjectCollection("materialentry");
        List inspObjAsss = args.getInspObjAsss();
        for (DynamicObject sEntry : inspObjEntry) {
            Object scSystem = sEntry.get("scsystem");
            if (null == scSystem || StringUtils.isBlank((CharSequence)scSystem.toString())) continue;
            InspObjAssModel model = new InspObjAssModel();
            Long insobjId = sEntry.getLong("chkobjid");
            if (0L != insobjId) {
                model.setObjectId(insobjId);
            }
            model.setAssId(Long.valueOf(sEntry.getLong("chkobjentryid")));
            model.setBillEntryId(String.valueOf(sEntry.getPkValue()));
            model.setBillId(String.valueOf(inspObj.getPkValue()));
            model.setBillEntrySeq(sEntry.getInt("seq"));
            model.setBillNo(inspObj.getString("billno"));
            model.setEntryNumber(sEntry.getDataEntityType().getName());
            DynamicObject tempObj = sEntry.getDynamicObject("unit");
            if (tempObj != null) {
                model.setUnitIdObj(tempObj);
            }
            model.setSrcBillDyncObj(sEntry);
            model.setSecondck(Boolean.valueOf(sEntry.getBoolean("secondck")));
            model.setInspfirstentryid(sEntry.getString("inspfirstentrykey"));
            inspObjAsss.add(model);
        }
    }

    @Override
    public void structAssParams(List<Object> pkVals, List<InspObjAssModel> assModels) {
        super.structAssParams(pkVals, assModels);
        List<InspObjAssModel> srcAssModels = new InspBillAssModelHelper(FORMAT_ENTRYFIELD).getInspObjAsssModel(this.getIniParam().getFormId(), pkVals);
        assModels.addAll(srcAssModels);
    }

    @Override
    public void structDeleteParams(DynamicObject saveBillObj, SaveAssBillInfoEventArgs args) {
        super.structDeleteParams(saveBillObj, args);
        if (null == saveBillObj) {
            return;
        }
        InspBillAssModelHelper assHelper = new InspBillAssModelHelper(FORMAT_ENTRYFIELD);
        Set<Object> billAssIds = assHelper.getBillAssId(this.getIniParam().getFormId(), saveBillObj.getPkValue());
        if (!billAssIds.isEmpty()) {
            DynamicObjectCollection entrys = saveBillObj.getDynamicObjectCollection("materialentry");
            assHelper.setDeleteParams(args, billAssIds, entrys);
        }
    }
}

