/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.insobj.bill;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.qmc.qcbd.business.helper.InspBillAssModelHelper;
import kd.qmc.qcbd.business.insobj.InspObjectBizBase;
import kd.qmc.qcbd.common.args.insobj.GlobalSaveInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.IniInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveAssBillInfoEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveInspObjectEventArgs;
import kd.qmc.qcbd.common.model.insobj.InspObjAssModel;
import kd.qmc.qcbd.common.model.insobj.InspObjModel;

public class InspectBillInsObj
extends InspObjectBizBase {
    private static final String FORMAT_ENTRYFIELD = "matintoentity.%s";

    @Override
    public void iniInspObject(IniInspObjectEventArgs args) {
        super.iniInspObject(args);
        this.setBillFlag("inspect");
    }

    @Override
    public void beforeSaveInspObject(SaveInspObjectEventArgs args, GlobalSaveInspObjectEventArgs globalargs) {
        super.beforeSaveInspObject(args, globalargs);
        DynamicObject inspObj = args.getSaveBillObj();
        DynamicObjectCollection inspObjEntrys = inspObj.getDynamicObjectCollection("matintoentity");
        for (DynamicObject sEntry : inspObjEntrys) {
            Object scSystem = sEntry.get("scsystem");
            if (null == scSystem || StringUtils.isBlank((CharSequence)scSystem.toString())) continue;
            InspObjModel model = this.setModelValue(inspObj, sEntry);
            args.getInspObjs().add(model);
        }
    }

    private InspObjModel setModelValue(DynamicObject inspObj, DynamicObject sEntry) {
        InspObjModel model = new InspObjModel();
        long insobj = sEntry.getLong("chkobjid");
        if (0L != insobj) {
            model.setId(Long.valueOf(insobj));
        }
        model.setSbillNo(inspObj.getString("billno"));
        DynamicObject bizTypeObj = inspObj.getDynamicObject("biztype");
        model.setBizTypeId(Long.valueOf(null == bizTypeObj ? 0L : bizTypeObj.getLong("id")));
        model.setSbillEntryID(String.valueOf(sEntry.getPkValue()));
        model.setSrcBillNo(sEntry.getString("sourcebillno"));
        model.setSrcBillId(sEntry.getString("srcbillid"));
        model.setSrcEntryId(sEntry.getString("srcbillentryid"));
        model.setScSystem(sEntry.getString("scsystem"));
        model.setSrcEntityNumber(sEntry.getString("srcbillentity"));
        model.setSrcEntrySeq(sEntry.getInt("srcbillentryseq"));
        DynamicObject tempObj = sEntry.getDynamicObject("materialid");
        if (tempObj != null) {
            model.setSrcMaterialIdObj(tempObj);
        }
        if ((tempObj = sEntry.getDynamicObject("srcunitid")) != null) {
            model.setSrcUnitIdObj(tempObj);
        }
        if ((tempObj = sEntry.getDynamicObject("baseunit")) != null) {
            model.setSrcBaseUnitIdObj(tempObj);
        }
        model.setSrcQty(sEntry.getBigDecimal("materialqty"));
        model.setSrcBaseQty(sEntry.getBigDecimal("baseqty"));
        if (StringUtils.isBlank((CharSequence)model.getSrcBillNo()) || StringUtils.isBlank((CharSequence)model.getSrcBillId())) {
            model.setSrcEntrySeq(sEntry.getInt("seq"));
            tempObj = sEntry.getDynamicObject("unitfield");
            if (tempObj != null) {
                model.setSrcUnitIdObj(tempObj);
            }
        }
        model.setSrcBillDyncObj(sEntry);
        return model;
    }

    @Override
    public void beforeSaveAssBillInfo(SaveAssBillInfoEventArgs args, GlobalSaveInspObjectEventArgs globalargs) {
        super.beforeSaveAssBillInfo(args, globalargs);
        SaveInspObjectEventArgs saveArgs = args.getSaveInspArgs();
        DynamicObject inspObj = saveArgs.getSaveBillObj();
        DynamicObjectCollection inspObjEntry = inspObj.getDynamicObjectCollection("matintoentity");
        List inspObjAsss = args.getInspObjAsss();
        for (DynamicObject sEntry : inspObjEntry) {
            Object scSystem = sEntry.get("scsystem");
            if (null == scSystem || StringUtils.isBlank((CharSequence)scSystem.toString())) continue;
            InspObjAssModel model = new InspObjAssModel();
            Long insobjId = sEntry.getLong("chkobjid");
            if (0L != insobjId) {
                model.setObjectId(insobjId);
            }
            model.setAssId(Long.valueOf(sEntry.getLong("chkobjentryid")));
            Object billEntryIDObj = sEntry.getPkValue();
            model.setBillEntryId(String.valueOf(billEntryIDObj));
            model.setBillId(String.valueOf(inspObj.getPkValue()));
            model.setBillEntrySeq(sEntry.getInt("seq"));
            model.setBillNo(inspObj.getString("billno"));
            DynamicObject tempObj = sEntry.getDynamicObject("unitfield");
            if (tempObj != null) {
                model.setUnitIdObj(tempObj);
            }
            model.setSrcBillDyncObj(sEntry);
            Boolean secondCk = sEntry.getBoolean("secondck");
            model.setSecondck(secondCk);
            String entryName = sEntry.getDataEntityType().getName();
            model.setEntryNumber(entryName);
            if (secondCk.booleanValue()) {
                model.setInspfirstentryid(sEntry.getString("inspfirstentrykey"));
            } else {
                model.setInspfirstentryid(entryName + "_" + billEntryIDObj);
            }
            inspObjAsss.add(model);
        }
    }

    @Override
    public void structAssParams(List<Object> pkVals, List<InspObjAssModel> assModels) {
        super.structAssParams(pkVals, assModels);
        List<InspObjAssModel> srcAssModels = new InspBillAssModelHelper(FORMAT_ENTRYFIELD).getInspObjAsssModel(this.getIniParam().getFormId(), pkVals);
        assModels.addAll(srcAssModels);
    }

    @Override
    public void structDeleteParams(DynamicObject saveBillObj, SaveAssBillInfoEventArgs args) {
        super.structDeleteParams(saveBillObj, args);
        if (null == saveBillObj) {
            return;
        }
        InspBillAssModelHelper assHelper = new InspBillAssModelHelper(FORMAT_ENTRYFIELD);
        Set<Object> billAssIds = assHelper.getBillAssId(this.getIniParam().getFormId(), saveBillObj.getPkValue());
        if (!billAssIds.isEmpty()) {
            DynamicObjectCollection entrys = saveBillObj.getDynamicObjectCollection("matintoentity");
            assHelper.setDeleteParams(args, billAssIds, entrys);
        }
    }
}

