/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.insobj.bill;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.qmc.qcbd.business.helper.InspBillAssModelHelper;
import kd.qmc.qcbd.business.insobj.InspObjectBizBase;
import kd.qmc.qcbd.common.args.insobj.GlobalSaveInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.IniInspObjectEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveAssBillInfoEventArgs;
import kd.qmc.qcbd.common.args.insobj.SaveInspObjectEventArgs;
import kd.qmc.qcbd.common.model.insobj.InspObjAssModel;
import kd.qmc.qcbd.common.model.insobj.InspObjModel;

public class UrgentpassInsObj
extends InspObjectBizBase {
    private static final String FORMAT_ENTRYFIELD = "materialentry.%s";

    @Override
    public void iniInspObject(IniInspObjectEventArgs args) {
        super.iniInspObject(args);
        this.setBillFlag("urgentpass");
    }

    @Override
    public void beforeSaveInspObject(SaveInspObjectEventArgs args, GlobalSaveInspObjectEventArgs globalargs) {
        super.beforeSaveInspObject(args, globalargs);
        DynamicObject billObj = args.getSaveBillObj();
        DynamicObjectCollection billEntrys = billObj.getDynamicObjectCollection("materialentry");
        for (DynamicObject entry : billEntrys) {
            Object scSystem = entry.get("srcsystem");
            if (null == scSystem || StringUtils.isBlank((CharSequence)scSystem.toString())) continue;
            InspObjModel model = this.setModelValue(billObj, entry);
            args.getInspObjs().add(model);
        }
    }

    private InspObjModel setModelValue(DynamicObject billObj, DynamicObject matEntry) {
        InspObjModel model = new InspObjModel();
        long insobj = matEntry.getLong("chkobjid");
        if (0L != insobj) {
            model.setId(Long.valueOf(insobj));
        }
        model.setSbillNo(billObj.getString("billno"));
        DynamicObject bizTypeObj = billObj.getDynamicObject("biztype");
        model.setBizTypeId(Long.valueOf(null == bizTypeObj ? 0L : bizTypeObj.getLong("id")));
        model.setSbillEntryID(String.valueOf(matEntry.getPkValue()));
        model.setSrcBillNo(matEntry.getString("srcbillnumber"));
        model.setSrcBillId(matEntry.getString("srcbillid"));
        model.setSrcEntryId(matEntry.getString("srcbillentryid"));
        model.setScSystem(matEntry.getString("srcsystem"));
        model.setSrcEntityNumber(matEntry.getString("srcbillentity"));
        model.setSrcEntrySeq(matEntry.getInt("srcbillentryseq"));
        DynamicObject tempObj = matEntry.getDynamicObject("materialid");
        if (tempObj != null) {
            model.setSrcMaterialIdObj(tempObj);
        }
        if ((tempObj = matEntry.getDynamicObject("srcunit")) != null) {
            model.setSrcUnitIdObj(tempObj);
        }
        if ((tempObj = matEntry.getDynamicObject("baseunit")) != null) {
            model.setSrcBaseUnitIdObj(tempObj);
        }
        model.setSrcQty(matEntry.getBigDecimal("qty"));
        model.setSrcBaseQty(matEntry.getBigDecimal("baseqty"));
        if (StringUtils.isBlank((CharSequence)model.getSrcBillNo()) || StringUtils.isBlank((CharSequence)model.getSrcBillId())) {
            model.setSrcEntrySeq(matEntry.getInt("seq"));
            tempObj = matEntry.getDynamicObject("unit");
            if (tempObj != null) {
                model.setSrcUnitIdObj(tempObj);
            }
        }
        model.setSrcBillDyncObj(matEntry);
        return model;
    }

    @Override
    public void beforeSaveAssBillInfo(SaveAssBillInfoEventArgs args, GlobalSaveInspObjectEventArgs globalargs) {
        super.beforeSaveAssBillInfo(args, globalargs);
        SaveInspObjectEventArgs saveArgs = args.getSaveInspArgs();
        DynamicObject inspObj = saveArgs.getSaveBillObj();
        DynamicObjectCollection inspObjEntry = inspObj.getDynamicObjectCollection("materialentry");
        List inspObjAsss = args.getInspObjAsss();
        for (DynamicObject sEntry : inspObjEntry) {
            Object scSystem = sEntry.get("srcsystem");
            if (null == scSystem || StringUtils.isBlank((CharSequence)scSystem.toString())) continue;
            InspObjAssModel model = new InspObjAssModel();
            Long insobjId = sEntry.getLong("chkobjid");
            if (0L != insobjId) {
                model.setObjectId(insobjId);
            }
            model.setAssId(Long.valueOf(sEntry.getLong("chkobjentryid")));
            model.setBillEntryId(String.valueOf(sEntry.getPkValue()));
            model.setBillId(String.valueOf(inspObj.getPkValue()));
            model.setBillEntrySeq(sEntry.getInt("seq"));
            model.setBillNo(inspObj.getString("billno"));
            model.setEntryNumber(sEntry.getDataEntityType().getName());
            DynamicObject tempObj = sEntry.getDynamicObject("unit");
            if (tempObj != null) {
                model.setUnitIdObj(tempObj);
            }
            model.setSrcBillDyncObj(sEntry);
            inspObjAsss.add(model);
        }
    }

    @Override
    public void structAssParams(List<Object> pkVals, List<InspObjAssModel> assModels) {
        super.structAssParams(pkVals, assModels);
        List<InspObjAssModel> srcAssModels = new InspBillAssModelHelper(FORMAT_ENTRYFIELD).getInspObjAsssModel(this.getIniParam().getFormId(), pkVals);
        assModels.addAll(srcAssModels);
    }

    @Override
    public void structDeleteParams(DynamicObject billObj, SaveAssBillInfoEventArgs args) {
        super.structDeleteParams(billObj, args);
        if (null == billObj) {
            return;
        }
        InspBillAssModelHelper assHelper = new InspBillAssModelHelper(FORMAT_ENTRYFIELD);
        Set<Object> billAssIds = assHelper.getBillAssId(this.getIniParam().getFormId(), billObj.getPkValue());
        if (!billAssIds.isEmpty()) {
            DynamicObjectCollection entrys = billObj.getDynamicObjectCollection("materialentry");
            assHelper.setDeleteParams(args, billAssIds, entrys);
        }
    }
}

