/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.inspbill.project;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_BL_BR;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_BL_CR;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_CL_BR;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_CL_CR;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_Deter;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_E;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_G;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_G_E;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_L;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_L_E;
import kd.qmc.qcbd.business.inspbill.project.logic.CPCStrategy_NE;

public class CheckProjectCaleFactory {
    private static CheckProjectCaleFactory caleFactory = new CheckProjectCaleFactory();
    private final Hashtable<String, ICheckProjectCaleStrategy> cache = new Hashtable(20);

    private CheckProjectCaleFactory() {
    }

    public static CheckProjectCaleFactory getInstance() {
        return caleFactory;
    }

    public ICheckProjectCaleStrategy getCkProjectStrategy(String compareStr, String normtype) {
        StringBuilder sbCache = new StringBuilder();
        sbCache.append(normtype);
        sbCache.append("_");
        sbCache.append(compareStr);
        ICheckProjectCaleStrategy strategyFactory = this.cache.get(sbCache.toString());
        if (strategyFactory == null) {
            Map<String, ICheckProjectCaleStrategy> strategyDXMap = this.getStrategyDXMap();
            if (StringUtils.equalsIgnoreCase((CharSequence)normtype, (CharSequence)"B")) {
                compareStr = "deter";
            }
            if ((strategyFactory = strategyDXMap.get(compareStr)) != null) {
                this.cache.put(sbCache.toString(), strategyFactory);
            }
        }
        return strategyFactory;
    }

    private Map<String, ICheckProjectCaleStrategy> getStrategyDXMap() {
        HashMap<String, ICheckProjectCaleStrategy> dxMap = new HashMap<String, ICheckProjectCaleStrategy>(16);
        dxMap.put("[ ]", new CPCStrategy_CL_CR());
        dxMap.put("( )", new CPCStrategy_BL_BR());
        dxMap.put("[ )", new CPCStrategy_CL_BR());
        dxMap.put("( ]", new CPCStrategy_BL_CR());
        dxMap.put("<", new CPCStrategy_L());
        dxMap.put("<=", new CPCStrategy_L_E());
        dxMap.put(">", new CPCStrategy_G());
        dxMap.put(">=", new CPCStrategy_G_E());
        dxMap.put("=", new CPCStrategy_E());
        dxMap.put("\u2260", new CPCStrategy_NE());
        dxMap.put("deter", new CPCStrategy_Deter());
        return dxMap;
    }
}

