/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.inspres;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.common.constant.InspResultConst;
import kd.qmc.qcbd.common.util.MainEntityTypeUtil;
import org.apache.commons.collections.MapUtils;

public abstract class InspResHelperBase {
    private static final String[] COMMON_SELECT_FIELDS = new String[]{"id", "ass_entitynumber", "ass_billid", "ass_billno", "ass_billentryid", "ck_unitid", "ck_baseunitid", "ck_newhandmode", String.format("%s.%s %s", "splitbatchentity", "m_srcentitynumber", "m_srcentitynumber"), String.format("%s.%s %s", "splitbatchentity", "m_srcbillid", "m_srcbillid"), String.format("%s.%s %s", "splitbatchentity", "m_srcbillentryid", "m_srcbillentryid"), String.format("%s.%s %s", "splitbatchentity", "m_qualifqty", "m_qualifqty"), String.format("%s.%s %s", "splitbatchentity", "m_qualifybaseqty", "m_qualifybaseqty"), String.format("%s.%s %s", "splitbatchentity", "m_unqualifqty", "m_unqualifqty"), String.format("%s.%s %s", "splitbatchentity", "m_unqualifbaseqty", "m_unqualifbaseqty"), String.format("%s.name", "ck_newhandmode")};
    private Map<String, Object> retParam;
    private String retType;
    private List<String> appNumbers;
    private String callEntity;
    private Long callBillId;
    private List<Long> callBillIds;
    private List<Long> callEntryIds;
    private Map<Long, List<Long>> callEntryIdReflex;
    private Map<Long, DynamicObject> unitReflex;
    private Map<String, Map<Long, Collection<Map<String, Long>>>> entryIdReflex;
    private Set<String> sendEntitys;
    private Map<String, Set<Long>> sendBillIds;
    private Map<String, Set<Long>> sendEntryIds;

    public abstract void initRetParam(Map<String, Object> var1);

    public void appendSendQty() {
        Set<String> sendEntitys = this.getSendEntitys();
        for (String sendEntity : sendEntitys) {
            HashMap<String, BigDecimal> applyCountMap = new HashMap<String, BigDecimal>(16);
            Map<Long, Collection<Map<String, Long>>> sendEntityBizInfos = this.getEntryIdReflex().get(sendEntity);
            if (MapUtils.isEmpty(sendEntityBizInfos)) continue;
            Map<String, List<DynamicObject>> inspObjInfos = this.getInspObjInfos(sendEntity);
            Map<Long, DynamicObject> unitMap = this.getUnitReflex();
            Set<Map.Entry<String, List<DynamicObject>>> entrySet = inspObjInfos.entrySet();
            for (Map.Entry<String, List<DynamicObject>> entry : entrySet) {
                List<DynamicObject> inspObjInfoList = entry.getValue();
                for (DynamicObject inspInfo : inspObjInfoList) {
                    Long srcBillId = inspInfo.getLong("srcbillid");
                    Long srcEntryId = inspInfo.getLong("srcentryid");
                    Long unit = inspInfo.getLong("srcunitid");
                    BigDecimal srcQty = this.formatPrecision(inspInfo.getBigDecimal("srcqty"), unitMap.get(unit));
                    String uniKey = sendEntity + srcBillId + srcEntryId;
                    if (!applyCountMap.containsKey(uniKey)) {
                        applyCountMap.put(uniKey, srcQty);
                        continue;
                    }
                    BigDecimal nowQty = (BigDecimal)applyCountMap.get(uniKey);
                    applyCountMap.put(uniKey, nowQty.add(srcQty));
                }
            }
            Map<String, Object> retParam = this.getRetParam();
            List datas = (List)retParam.get("data");
            for (Map dataMap : datas) {
                Collection<Map<String, Long>> collection = sendEntityBizInfos.get(dataMap.get("call_entryid"));
                for (Map<String, Long> bizInfoMap : collection) {
                    String key = sendEntity + bizInfoMap.get("biz_billId") + bizInfoMap.get("biz_entryid");
                    if (!applyCountMap.containsKey(key)) continue;
                    BigDecimal sendQty = (BigDecimal)dataMap.get("send_qty");
                    dataMap.put("send_qty", sendQty.add((BigDecimal)applyCountMap.get(key)));
                }
            }
        }
    }

    public DynamicObjectCollection getInspectRes() {
        List<String> appNumbers = this.getAppNumbers();
        DynamicObjectCollection inspectRes = new DynamicObjectCollection();
        for (String appNumber : appNumbers) {
            Set<String> bizEntitys = this.getSendEntitys();
            for (String entity : bizEntitys) {
                Set<Long> bizEntryIdSet = this.getSendEntryIds().get(entity);
                String inspResultEntity = (String)InspResultConst.getInspresultAppMap().get(appNumber);
                if (CollectionUtils.isEmpty(bizEntryIdSet) || StringUtils.isEmpty((String)inspResultEntity)) continue;
                QFilter qFilter = new QFilter("billstatus", "=", (Object)"C").and(String.format("%s.%s", "splitbatchentity", "m_srcbillentryid"), "in", bizEntryIdSet.stream().map(String::valueOf).collect(Collectors.toSet())).and(String.format("%s.%s", "splitbatchentity", "m_srcentitynumber"), "in", this.getSendEntitys());
                StringBuilder sb = new StringBuilder();
                sb.append(String.join((CharSequence)",", COMMON_SELECT_FIELDS));
                inspectRes.addAll((Collection)QueryServiceHelper.query((String)this.getClass().getName(), (String)inspResultEntity, (String)sb.toString(), (QFilter[])qFilter.toArray(), (String)"id"));
            }
        }
        return inspectRes;
    }

    public void addInspresInfo(DynamicObjectCollection inspectRes, Map<String, BigDecimal> inspCountMap) {
        Map<String, Object> retParam = this.getRetParam();
        Set<String> bizEntitys = this.getSendEntitys();
        for (String bizEntity : bizEntitys) {
            Map<Long, List<Long>> srcEntryIdMap = this.getCallEntryIdReflex();
            String callType = this.getRetType();
            Set ckUnitIdSet = inspectRes.stream().map(x -> x.getLong("ck_unitid")).collect(Collectors.toSet());
            ckUnitIdSet.addAll(inspectRes.stream().map(x -> x.getLong("ck_baseunitid")).collect(Collectors.toSet()));
            DynamicObjectCollection precisionInfos = QueryServiceHelper.query((String)"bd_measureunits", (String)"id, precisionaccount, precision", (QFilter[])new QFilter("id", "in", ckUnitIdSet).toArray());
            Map<Long, DynamicObject> ckUnitInfos = precisionInfos.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
            for (DynamicObject inspectRow : inspectRes) {
                this.setPrecision(inspectRow, ckUnitInfos, "ck_unitid", "m_qualifqty", "m_unqualifqty");
                this.setPrecision(inspectRow, ckUnitInfos, "ck_unitid", "m_qualifybaseqty", "m_unqualifbaseqty");
            }
            Map<String, List<DynamicObject>> entryGroups = inspectRes.stream().collect(Collectors.groupingBy(x -> x.getString("m_srcentitynumber") + x.getLong("m_srcbillid") + x.getLong("m_srcbillentryid")));
            List dataList = (List)retParam.get("data");
            Map<String, List<Map>> dataGroupByEntry = dataList.stream().collect(Collectors.groupingBy(x -> String.valueOf(x.get("call_billid")) + x.get("call_entryid")));
            Set<Map.Entry<Long, List<Long>>> entrySet = srcEntryIdMap.entrySet();
            for (Map.Entry<Long, List<Long>> entry : entrySet) {
                Long billId = entry.getKey();
                List<Long> entryIds = entry.getValue();
                for (Long entryId : entryIds) {
                    Map<String, Map<Long, Collection<Map<String, Long>>>> entryIdReflex;
                    Map<Long, Collection<Map<String, Long>>> bizEntityReflexMap;
                    List<Map> entryRetDatas = dataGroupByEntry.get(String.valueOf(billId) + entryId);
                    if (!CollectionUtils.isNotEmpty(entryRetDatas) || MapUtils.isEmpty(bizEntityReflexMap = (entryIdReflex = this.getEntryIdReflex()).get(bizEntity)) || !bizEntityReflexMap.containsKey(entryId)) continue;
                    Collection<Map<String, Long>> bizInfoCollection = bizEntityReflexMap.get(entryId);
                    for (Map<String, Long> bizInfoMap : bizInfoCollection) {
                        String key = bizEntity + bizInfoMap.get("biz_billId") + bizInfoMap.get("biz_entryid");
                        this.addSingleInspResInfo(entryGroups, entryRetDatas.get(0), key, ckUnitInfos, inspCountMap, callType);
                    }
                }
            }
        }
    }

    public Map<String, Set<Object>> getBillInfos(String type) {
        DynamicObjectCollection inspectRes = this.getInspectRes();
        Map<Object, Object> billGroups = new HashMap(16);
        switch (type) {
            case "qcp_inspecapplypbill": {
                billGroups = inspectRes.stream().filter(x -> MainEntityTypeUtil.isInherit((String)x.getString("ass_entitynumber"), (String)"qcp_inspecapplypbill")).collect(Collectors.groupingBy(x -> x.getString("ass_entitynumber")));
                break;
            }
            case "inspect_type": {
                billGroups = inspectRes.stream().filter(x -> MainEntityTypeUtil.isInherit((String)x.getString("ass_entitynumber"), (String)"qcp_inspecpbill") != false || MainEntityTypeUtil.isInherit((String)x.getString("ass_entitynumber"), (String)"qcbd_urgentpass") != false).collect(Collectors.groupingBy(x -> x.getString("ass_entitynumber")));
                break;
            }
            case "baddeal_type": {
                billGroups = inspectRes.stream().filter(x -> MainEntityTypeUtil.isInherit((String)x.getString("ass_entitynumber"), (String)"qcp_baddealpbill")).collect(Collectors.groupingBy(x -> x.getString("ass_entitynumber")));
                break;
            }
        }
        HashMap<String, Set<Object>> billInfoRetmap = new HashMap<String, Set<Object>>(16);
        Set entrySet = billGroups.entrySet();
        for (Map.Entry entry : entrySet) {
            String entity = (String)entry.getKey();
            Set billIds = ((List)entry.getValue()).stream().map(x -> Long.parseLong(x.getString("ass_billid"))).collect(Collectors.toSet());
            billInfoRetmap.put(entity, billIds);
        }
        return billInfoRetmap;
    }

    public Map<String, BigDecimal> getInspectCount(DynamicObjectCollection inspectRes) {
        HashMap<String, BigDecimal> inspectCountMap = new HashMap<String, BigDecimal>(16);
        List inspectResList = inspectRes.stream().filter(x -> MainEntityTypeUtil.isInherit((String)x.getString("ass_entitynumber"), (String)"qcp_inspecpbill")).collect(Collectors.toList());
        Map<String, List<DynamicObject>> inspectResGroup = inspectResList.stream().collect(Collectors.groupingBy(x -> x.getString("ass_entitynumber")));
        Map<String, List<DynamicObject>> inspectInfos = this.getInspectInfos(inspectResGroup);
        Map<String, List<DynamicObject>> srcEntryGroup = inspectResList.stream().collect(Collectors.groupingBy(x -> x.getString("m_srcentitynumber") + x.get("m_srcbillid") + x.get("m_srcbillentryid")));
        Set<Map.Entry<String, List<DynamicObject>>> entrySet = srcEntryGroup.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entrySet) {
            BigDecimal inspCount = BigDecimal.ZERO;
            for (DynamicObject inspInfo : entry.getValue()) {
                String inspEntityId = inspInfo.getString("ass_entitynumber");
                Long entryId = Long.parseLong(inspInfo.getString("ass_billentryid"));
                List<DynamicObject> inspInfoList = inspectInfos.get(inspEntityId + entryId);
                if (CollectionUtils.isEmpty(inspInfoList)) continue;
                inspCount = inspCount.add(inspInfoList.get(0).getBigDecimal("materialqty"));
            }
            inspectCountMap.put(entry.getKey(), inspCount);
        }
        return inspectCountMap;
    }

    public Map<String, List<DynamicObject>> getInspObjInfos(String sendEntity) {
        HashMap<String, List<DynamicObject>> inspObjInfos = new HashMap<String, List<DynamicObject>>(16);
        List<String> appNumbers = this.getAppNumbers();
        Set<Long> sendEntryIds = this.getSendEntryIds().get(sendEntity);
        if (CollectionUtils.isEmpty(sendEntryIds)) {
            return inspObjInfos;
        }
        Set srcBillEntryIds = sendEntryIds.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet());
        for (String appNumber : appNumbers) {
            String entityNumber = InspObjectHelper.getInspObjEntityNumberByAppid(appNumber);
            String selectFields = String.join((CharSequence)",", "sbillid", "sbillentryid", "sbillno", "sentitynumber", "srcentitynumber", "srcbillid", "srcentryid", "srcunitid", "srcbaseunitid", "srcqty", "srcbaseqty", "createtime");
            QFilter qFilter = new QFilter("srcentryid", "in", srcBillEntryIds).and("srcentitynumber", "=", (Object)sendEntity).and(String.format("%s.%s", "entryentity", "seq"), "=", (Object)1);
            DynamicObjectCollection inspObjCollection = QueryServiceHelper.query((String)entityNumber, (String)selectFields, (QFilter[])qFilter.toArray());
            Map<String, List<DynamicObject>> sentityGroup = inspObjCollection.stream().collect(Collectors.groupingBy(x -> x.getString("sentitynumber")));
            for (Map.Entry<String, List<DynamicObject>> entry : sentityGroup.entrySet()) {
                Set sbillIdSet;
                String entity = entry.getKey();
                DynamicObjectCollection idToRemoveInfos = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter("id", "in", sbillIdSet = entry.getValue().stream().map(x -> Long.parseLong(x.getString("sbillid"))).collect(Collectors.toSet())).and("billstatus", "!=", (Object)"C").toArray());
                if (!CollectionUtils.isNotEmpty((Collection)idToRemoveInfos)) continue;
                Set idToRemove = idToRemoveInfos.stream().map(x -> String.valueOf(x.getLong("id"))).collect(Collectors.toSet());
                inspObjCollection.removeIf(x -> entity.equals(x.getString("sentitynumber")) && idToRemove.contains(x.getString("sbillid")));
            }
            inspObjInfos.put(entityNumber, (List<DynamicObject>)inspObjCollection);
        }
        return inspObjInfos;
    }

    protected BigDecimal formatPrecision(BigDecimal origin, DynamicObject unit) {
        if (null == origin || null == unit) {
            return BigDecimal.ZERO;
        }
        return origin.setScale(unit.getInt("precision"), this.getRoundType(unit));
    }

    protected void buildEntryIdReflex(Map<String, Object> postParam) {
        HashMap<String, Map<Long, Set<Map<String, Long>>>> entryIdReflex = new HashMap<String, Map<Long, Set<Map<String, Long>>>>(16);
        postParam.put("entryid_reflex", entryIdReflex);
        Set<String> sendEntitys = this.getSendEntitys();
        if (sendEntitys.contains(this.getCallEntity())) {
            this.buildEntryIdReflexOwn(entryIdReflex);
        }
        if (CollectionUtils.isNotEmpty(sendEntitys)) {
            this.buildEntryIdReflexOther(entryIdReflex, sendEntitys, postParam);
        }
    }

    protected void buildSendBillInfo(Map<String, Object> postParam) {
        Object entryidReflexObj = postParam.get("entryid_reflex");
        if (entryidReflexObj instanceof Map) {
            Map entryidReflex = (Map)entryidReflexObj;
            this.setEntryIdReflex(entryidReflex);
            HashMap<String, Set<Long>> bizBillIds = new HashMap<String, Set<Long>>(16);
            HashMap<String, Set<Long>> bizEntryIds = new HashMap<String, Set<Long>>(16);
            Set entries = entryidReflex.entrySet();
            for (Map.Entry entry : entries) {
                HashSet bizBillIdSet = new HashSet(16);
                HashSet bizEntryIdSet = new HashSet(16);
                Map entryReflex = (Map)entry.getValue();
                Collection bizEntryInfos = entryReflex.values();
                for (Collection bizEntryInfoSet : bizEntryInfos) {
                    bizBillIdSet.addAll(bizEntryInfoSet.stream().map(x -> (Long)x.get("biz_billId")).collect(Collectors.toSet()));
                    bizEntryIdSet.addAll(bizEntryInfoSet.stream().map(x -> (Long)x.get("biz_entryid")).collect(Collectors.toSet()));
                }
                String bizBillEntity = (String)entry.getKey();
                bizBillIds.put(bizBillEntity, bizBillIdSet);
                bizEntryIds.put(bizBillEntity, bizEntryIdSet);
            }
            this.setSendBillIds(bizBillIds);
            this.setSendEntryIds(bizEntryIds);
        }
    }

    private void buildEntryIdReflexOwn(Map<String, Map<Long, Set<Map<String, Long>>>> entryIdReflex) {
        HashMap entryIdReflexMap = new HashMap(16);
        List<Long> billIds = this.getCallBillIds();
        Map<Long, List<Long>> callEntryIdReflex = this.getCallEntryIdReflex();
        for (Long billId : billIds) {
            List<Long> entryIds = callEntryIdReflex.get(billId);
            for (Long entryId : entryIds) {
                HashSet reflexMapSet = new HashSet(16);
                HashMap<String, Long> reflexMap = new HashMap<String, Long>(16);
                reflexMap.put("biz_billId", billId);
                reflexMap.put("biz_entryid", entryId);
                reflexMapSet.add(reflexMap);
                entryIdReflexMap.put(entryId, reflexMapSet);
            }
        }
        entryIdReflex.put(this.getCallEntity(), entryIdReflexMap);
    }

    private void buildEntryIdReflexOther(Map<String, Map<Long, Set<Map<String, Long>>>> entryIdReflex, Set<String> bizEntitys, Map<String, Object> postParam) {
        Long[] billIds = this.getCallBillIds().toArray(new Long[0]);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)this.getCallEntity(), (Long[])billIds);
        HashMap<String, Set> sendBillMap = new HashMap<String, Set>(16);
        HashMap<Long, String> billidEntityMap = new HashMap<Long, String>(16);
        for (String billEntity : bizEntitys) {
            if (billEntity.equals(this.getCallEntity()) || !targetBills.containsKey(billEntity)) continue;
            Set billIdSet = (Set)targetBills.get(billEntity);
            sendBillMap.put(billEntity, billIdSet);
            for (Long srcBillId : billIdSet) {
                billidEntityMap.put(srcBillId, billEntity);
            }
        }
        if (!sendBillMap.isEmpty()) {
            Set billIdSet = billidEntityMap.keySet();
            String entryField = String.valueOf(postParam.get("entry_field"));
            List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)this.getCallEntity(), (String)entryField, (Long[])billIds, (Long[])this.getCallEntryIds().toArray(new Long[0]), null);
            Set sendBfRowSet = bfRows.stream().filter(x -> billIdSet.contains(x.getId().getBillId())).collect(Collectors.toSet());
            for (BFRow bfRow : sendBfRowSet) {
                Set<Map<String, Long>> targetEntryidSet;
                BFRow srcBfRow = this.getSrcBfRow(bfRow, bfRows, this.getCallEntryIds());
                if (null == srcBfRow) continue;
                Long srcEntryId = srcBfRow.getSId().getEntryId();
                Long targetBillId = bfRow.getId().getBillId();
                String entity = (String)billidEntityMap.get(targetBillId);
                if (!StringUtils.isNotEmpty((String)entity)) continue;
                Map<Long, Set<Map<String, Long>>> entityReflexMap = entryIdReflex.get(entity);
                if (null == entityReflexMap) {
                    entityReflexMap = new HashMap<Long, Set<Map<String, Long>>>(16);
                    entryIdReflex.put(entity, entityReflexMap);
                }
                if (null == (targetEntryidSet = entityReflexMap.get(srcEntryId))) {
                    targetEntryidSet = new HashSet<Map<String, Long>>(16);
                    entityReflexMap.put(srcEntryId, targetEntryidSet);
                }
                HashMap<String, Long> targetMap = new HashMap<String, Long>(16);
                targetMap.put("biz_billId", targetBillId);
                targetMap.put("biz_entryid", bfRow.getId().getEntryId());
                targetEntryidSet.add(targetMap);
            }
        }
    }

    private void addSingleInspResInfo(Map<String, List<DynamicObject>> entryGroups, Map<String, Object> dataMap, String key, Map<Long, DynamicObject> unitInfos, Map<String, BigDecimal> inspCountMap, String type) {
        LinkedList<Map<String, Object>> unqualifyInfos = new LinkedList<Map<String, Object>>();
        dataMap.put("unqualified_info", unqualifyInfos);
        if (entryGroups.containsKey(key)) {
            List<DynamicObject> inspRes = entryGroups.get(key);
            for (DynamicObject inspResRow : inspRes) {
                Long handMode;
                dataMap.put("unit_id", inspResRow.getLong("ck_unitid"));
                dataMap.put("baseunit_id", inspResRow.getLong("ck_baseunitid"));
                if ("qulipanel".equals(type)) {
                    dataMap.put("checked_qty", this.formatPrecision(inspCountMap.get(key), unitInfos.get(inspResRow.getLong("ck_unitid"))));
                }
                if (0L == (handMode = Long.valueOf(inspResRow.getLong("ck_newhandmode")))) {
                    this.addQualifyValue(dataMap, inspResRow);
                    continue;
                }
                this.addUnqualifyValue(unqualifyInfos, inspResRow, handMode, dataMap);
            }
        }
    }

    private Map<String, List<DynamicObject>> getInspectInfos(Map<String, List<DynamicObject>> inspectResGroup) {
        HashMap<String, List<DynamicObject>> groupMap = new HashMap<String, List<DynamicObject>>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : inspectResGroup.entrySet()) {
            String inspectBilEntity = entry.getKey();
            String entryIdKeyStr = String.format("%s.%s", "matintoentity", "id");
            Set entryIds = entry.getValue().stream().map(x -> Long.parseLong(x.getString("ass_billentryid"))).collect(Collectors.toSet());
            String selectFields = String.join((CharSequence)",", entryIdKeyStr, String.format("%s.%s %s", "matintoentity", "materialqty", "materialqty"));
            QFilter qFilter = new QFilter(entryIdKeyStr, "in", entryIds);
            DynamicObjectCollection datas = QueryServiceHelper.query((String)this.getClass().getName(), (String)inspectBilEntity, (String)selectFields, (QFilter[])qFilter.toArray(), (String)entryIdKeyStr);
            groupMap.putAll(datas.stream().collect(Collectors.groupingBy(x -> inspectBilEntity + x.getLong(entryIdKeyStr))));
        }
        return groupMap;
    }

    private void addQualifyValue(Map<String, Object> qualifyValue, DynamicObject inspResRow) {
        if (!qualifyValue.containsKey("qualified_qty")) {
            qualifyValue.put("qualified_qty", inspResRow.getBigDecimal("m_qualifqty"));
            qualifyValue.put("qualified_baseqty", inspResRow.getBigDecimal("m_qualifybaseqty"));
        } else {
            qualifyValue.put("qualified_qty", inspResRow.getBigDecimal("m_qualifqty").add((BigDecimal)qualifyValue.get("qualified_qty")));
            qualifyValue.put("qualified_baseqty", inspResRow.getBigDecimal("m_qualifybaseqty").add((BigDecimal)qualifyValue.get("qualified_baseqty")));
        }
    }

    private void addUnqualifyValue(List<Map<String, Object>> unqualifyInfos, DynamicObject inspResRow, Long handMode, Map<String, Object> dataMap) {
        HashMap<String, BigDecimal> unqualifyValue;
        Optional<Map> optional = unqualifyInfos.stream().filter(x -> handMode.equals(x.get("handmodeid"))).findFirst();
        BigDecimal unqualifyQty = inspResRow.getBigDecimal("m_unqualifqty");
        BigDecimal baseUnqualifyQty = inspResRow.getBigDecimal("m_unqualifbaseqty");
        if (optional.isPresent()) {
            unqualifyValue = optional.get();
            unqualifyValue.put("unqualified_qty", unqualifyQty.add((BigDecimal)unqualifyValue.get("unqualified_qty")));
            unqualifyValue.put("unqualified_baseqty", baseUnqualifyQty.add((BigDecimal)unqualifyValue.get("unqualified_baseqty")));
        } else {
            unqualifyValue = new HashMap<String, BigDecimal>(16);
            unqualifyValue.put("handmodeid", (BigDecimal)((Object)handMode));
            unqualifyValue.put("handmodename", (BigDecimal)((Object)inspResRow.getString(String.format("%s.name", "ck_newhandmode"))));
            unqualifyValue.put("unqualified_qty", unqualifyQty);
            unqualifyValue.put("unqualified_baseqty", baseUnqualifyQty);
            unqualifyInfos.add(unqualifyValue);
        }
        Object badDealQty = dataMap.get("baddeal_qty");
        if (badDealQty instanceof BigDecimal) {
            dataMap.put("baddeal_qty", ((BigDecimal)badDealQty).add(unqualifyQty));
            dataMap.put("basebaddeal_qty", ((BigDecimal)dataMap.get("basebaddeal_qty")).add(baseUnqualifyQty));
        } else {
            dataMap.put("baddeal_qty", unqualifyQty);
            dataMap.put("basebaddeal_qty", baseUnqualifyQty);
        }
    }

    private void setPrecision(DynamicObject inspectRow, Map<Long, DynamicObject> ckUnitInfos, String unitField, String ... qtyArr) {
        DynamicObject unit = ckUnitInfos.get(inspectRow.getLong(unitField));
        for (String qtyField : qtyArr) {
            inspectRow.set(qtyField, (Object)this.formatPrecision(inspectRow.getBigDecimal(qtyField), unit));
        }
    }

    private int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    private BFRow getSrcBfRow(BFRow bfRow, List<BFRow> bfRows, List<Long> sendEntryIds) {
        if (null != bfRow) {
            Long srcEntryId = bfRow.getSId().getEntryId();
            if (sendEntryIds.contains(srcEntryId)) {
                return bfRow;
            }
            Optional<BFRow> optional = bfRows.stream().filter(x -> x.getId().getEntryId().equals(bfRow.getSId().getEntryId())).findFirst();
            if (optional.isPresent()) {
                return this.getSrcBfRow(optional.get(), bfRows, sendEntryIds);
            }
        }
        return null;
    }

    public Map<String, Object> getRetParam() {
        return this.retParam;
    }

    public void setRetParam(Map<String, Object> retParam) {
        this.retParam = retParam;
    }

    public String getRetType() {
        return this.retType;
    }

    public void setRetType(String retType) {
        this.retType = retType;
    }

    public List<String> getAppNumbers() {
        return this.appNumbers;
    }

    public void setAppNumbers(List<String> appNumbers) {
        this.appNumbers = appNumbers;
    }

    public String getCallEntity() {
        return this.callEntity;
    }

    public void setCallEntity(String callEntity) {
        this.callEntity = callEntity;
    }

    public Long getCallBillId() {
        return this.callBillId;
    }

    public void setCallBillId(Long callBillId) {
        this.callBillId = callBillId;
    }

    public List<Long> getCallBillIds() {
        return this.callBillIds;
    }

    public void setCallBillIds(List<Long> callBillIds) {
        this.callBillIds = callBillIds;
    }

    public List<Long> getCallEntryIds() {
        return this.callEntryIds;
    }

    public void setCallEntryIds(List<Long> callEntryIds) {
        this.callEntryIds = callEntryIds;
    }

    public Map<Long, List<Long>> getCallEntryIdReflex() {
        return this.callEntryIdReflex;
    }

    public void setCallEntryIdReflex(Map<Long, List<Long>> callEntryIdReflex) {
        this.callEntryIdReflex = callEntryIdReflex;
    }

    public Map<Long, DynamicObject> getUnitReflex() {
        return this.unitReflex;
    }

    public void setUnitReflex(Map<Long, DynamicObject> unitReflex) {
        this.unitReflex = unitReflex;
    }

    public Map<String, Map<Long, Collection<Map<String, Long>>>> getEntryIdReflex() {
        return this.entryIdReflex;
    }

    public void setEntryIdReflex(Map<String, Map<Long, Collection<Map<String, Long>>>> entryIdReflex) {
        this.entryIdReflex = entryIdReflex;
    }

    public Set<String> getSendEntitys() {
        return this.sendEntitys;
    }

    public void setSendEntitys(Set<String> sendEntitys) {
        this.sendEntitys = sendEntitys;
    }

    public Map<String, Set<Long>> getSendBillIds() {
        return this.sendBillIds;
    }

    public void setSendBillIds(Map<String, Set<Long>> sendBillIds) {
        this.sendBillIds = sendBillIds;
    }

    public Map<String, Set<Long>> getSendEntryIds() {
        return this.sendEntryIds;
    }

    public void setSendEntryIds(Map<String, Set<Long>> sendEntryIds) {
        this.sendEntryIds = sendEntryIds;
    }

    public String toString() {
        return "InspResHelperBase{retParam=" + this.retParam + ", retType='" + this.retType + '\'' + ", appNumbers=" + this.appNumbers + ", callEntity='" + this.callEntity + '\'' + ", callBillId=" + this.callBillId + ", callBillIds=" + this.callBillIds + ", callEntryIds=" + this.callEntryIds + ", callEntryIdReflex=" + this.callEntryIdReflex + ", unitReflex=" + this.unitReflex + ", entryIdReflex=" + this.entryIdReflex + ", sendEntitys=" + this.sendEntitys + ", sendBillIds=" + this.sendBillIds + ", sendEntryIds=" + this.sendEntryIds + '}';
    }
}

