/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.inspres;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.business.inspres.InspResHelperBase;

public class InspResQualPanelHelper
extends InspResHelperBase {
    public InspResQualPanelHelper(Map<String, Object> postParam) {
        this.setRetParam(new HashMap<String, Object>(16));
        this.setAppNumbers(Arrays.asList(String.valueOf(postParam.get("inspect_appnumbers")).split(",")));
        this.setRetType("qulipanel");
        this.setCallEntity((String)postParam.get("call_entitynumber"));
        Long callBillId = (Long)postParam.get("call_billid");
        this.setCallBillId(callBillId);
        LinkedList<Long> billIds = new LinkedList<Long>();
        billIds.add(callBillId);
        this.setCallBillIds(billIds);
        List<Long> callEntryIds = this.buildEntryIds(postParam);
        this.setCallEntryIds(callEntryIds);
        HashMap<Long, List<Long>> callEntryIdReflex = new HashMap<Long, List<Long>>(16);
        callEntryIdReflex.put(callBillId, callEntryIds);
        this.setCallEntryIdReflex(callEntryIdReflex);
        String[] bizEntityArr = String.valueOf(postParam.get("send_entitys")).split(",");
        HashSet<String> bizEntitys = new HashSet<String>(16);
        for (String bizEntity : bizEntityArr) {
            bizEntitys.add(bizEntity);
        }
        this.setSendEntitys(bizEntitys);
        this.buildEntryIdReflex(postParam);
        this.buildSendBillInfo(postParam);
    }

    @Override
    public void initRetParam(Map<String, Object> postParam) {
        Map<String, Object> retParam = this.getRetParam();
        retParam.put("successful", true);
        retParam.put("message", "");
        retParam.put("errorcode", "");
        LinkedList data = new LinkedList();
        retParam.put("data", data);
        String srcEntity = this.getCallEntity();
        Long srcBillId = this.getCallBillId();
        List<Long> srcBillEntryIds = this.getCallEntryIds();
        String entryField = String.valueOf(postParam.get("entry_field"));
        String materialField = String.valueOf(postParam.get("material_field"));
        String unitField = String.valueOf(postParam.get("unit_field"));
        String baseUnitField = String.valueOf(postParam.get("baseunit_field"));
        String qyField = String.valueOf(postParam.get("qty_field"));
        String entryIdQKey = String.format("%s.id", entryField);
        String materialIdQKey = String.format("%s.%s", entryField, materialField);
        String materialNumQKey = String.format("%s.%s.number", entryField, materialField);
        String materialNameQKey = String.format("%s.%s.name", entryField, materialField);
        String materialModelNumQKey = String.format("%s.%s.modelnum", entryField, materialField);
        String unitIdQKey = String.format("%s.%s", entryField, unitField);
        String unitNameQKey = String.format("%s.%s.name", entryField, unitField);
        String baseunitIdQKey = String.format("%s.%s", entryField, baseUnitField);
        String qtyQKey = String.format("%s.%s", entryField, qyField);
        String selectFields = String.join((CharSequence)",", entryIdQKey, materialIdQKey, materialNumQKey, materialNameQKey, materialModelNumQKey, unitIdQKey, unitNameQKey, baseunitIdQKey, qtyQKey);
        DynamicObjectCollection entryInfos = QueryServiceHelper.query((String)srcEntity, (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)srcBillId).and(entryField, "in", srcBillEntryIds).toArray());
        Set unitIdSet = entryInfos.stream().map(x -> x.getLong(unitIdQKey)).collect(Collectors.toSet());
        DynamicObjectCollection precisionInfos = QueryServiceHelper.query((String)"bd_measureunits", (String)"id, precisionaccount, precision", (QFilter[])new QFilter("id", "in", unitIdSet).toArray());
        Map<Long, DynamicObject> ckUnitInfos = precisionInfos.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
        this.setUnitReflex(ckUnitInfos);
        for (DynamicObject entryInfo : entryInfos) {
            Long entryId = entryInfo.getLong(entryIdQKey);
            HashMap<String, Object> entryRetMap = new HashMap<String, Object>(16);
            data.add(entryRetMap);
            entryRetMap.put("call_billid", srcBillId);
            entryRetMap.put("call_entryid", entryId);
            entryRetMap.put("material_id", entryInfo.getLong(materialIdQKey));
            entryRetMap.put("material_number", entryInfo.getString(materialNumQKey));
            entryRetMap.put("material_name", entryInfo.getString(materialNameQKey));
            entryRetMap.put("material_modelnum", entryInfo.getString(materialModelNumQKey));
            Long unitId = entryInfo.getLong(unitIdQKey);
            DynamicObject unitObj = ckUnitInfos.get(unitId);
            entryRetMap.put("unitId", unitId);
            entryRetMap.put("unit_name", entryInfo.getString(unitNameQKey));
            entryRetMap.put("baseunit", entryInfo.getLong(baseunitIdQKey));
            entryRetMap.put("material_qty", this.formatPrecision(entryInfo.getBigDecimal(qtyQKey), unitObj));
            BigDecimal formatZero = this.formatPrecision(BigDecimal.ZERO, unitObj);
            entryRetMap.put("send_qty", formatZero);
            entryRetMap.put("checked_qty", formatZero);
            entryRetMap.put("qualified_qty", formatZero);
            entryRetMap.put("qualified_baseqty", formatZero);
            entryRetMap.put("baddeal_qty", formatZero);
            entryRetMap.put("basebaddeal_qty", formatZero);
        }
    }

    private List<Long> buildEntryIds(Map<String, Object> postParam) {
        Object callBillId = postParam.get("call_billid");
        Object callType = postParam.get("call_type");
        LinkedList<Long> callEntryIds = new LinkedList<Long>();
        if ("E".equals(callType)) {
            callEntryIds.add((Long)postParam.get("call_entryid"));
        } else {
            String entryField = String.valueOf(postParam.get("entry_field"));
            String selectField = String.format("%s.id", entryField);
            DynamicObject[] callBillInfoArr = BusinessDataServiceHelper.load((String)this.getCallEntity(), (String)selectField, (QFilter[])new QFilter("id", "=", callBillId).toArray());
            if (callBillInfoArr.length > 0) {
                List entryIdSet = callBillInfoArr[0].getDynamicObjectCollection(entryField).stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                callEntryIds.addAll(entryIdSet);
            }
        }
        return callEntryIds;
    }
}

