/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.inspresult;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.qmc.qcbd.business.helper.InspObjectHelper;
import kd.qmc.qcbd.common.util.BillStatusUtil;
import kd.qmc.qcbd.common.util.DynamicObjUtil;
import kd.qmc.qcbd.common.util.MainEntityTypeUtil;
import kd.qmc.qcbd.common.util.OperationPrompt;

public class InspResultExcute {
    private static final Log logger = LogFactory.getLog(InspResultExcute.class);
    private String mResEntityNumber = "";
    private MainEntityType mTriggerBillEntityType = null;

    public InspResultExcute(MainEntityType triggerBillEntityType) {
        this.mTriggerBillEntityType = triggerBillEntityType;
        this.mResEntityNumber = this.getResEntityNumber();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mainBeforeExecuteResOperationTransaction(BeforeOperationArgs e, AbstractOperationServicePlugIn opPlugin) {
        String operationKey = e.getOperationKey();
        Set triggerPkVals = DynamicObjUtil.getFieldSetStr((DynamicObject[])e.getDataEntities(), (String)"id");
        OperateOption option = opPlugin.getOption();
        long startTime = System.currentTimeMillis();
        logger.info("call mainBeginOperationTransaction begin");
        try {
            String errMsg;
            this.iniParas(opPlugin, operationKey);
            String billStatus = BillStatusUtil.getExcutingBillStatusByOpr((String)operationKey);
            Set<Long> resPkVals = this.getResPkVals(triggerPkVals, billStatus);
            OperationResult res = this.execDockBillResOpr(resPkVals, operationKey);
            Set inspresbillids = Arrays.stream(res.getSuccessPkIds().toArray(new Long[res.getSuccessPkIds().size()])).collect(Collectors.toSet());
            if (!inspresbillids.isEmpty()) {
                option.setVariableValue("trigger_inspresids", JSON.toJSONString(inspresbillids));
            }
            if (!res.isSuccess() && (errMsg = this.getOperationResultError(res)).length() > 0) {
                throw new KDBizException(errMsg);
            }
        }
        catch (KDBizException ex) {
            try {
                logger.error("mainBeginOperationTransaction:" + ex.getMessage());
                throw ex;
                catch (Exception ex2) {
                    logger.error("mainBeginOperationTransaction:" + ex2.getMessage());
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u68c0\u9a8c\u7ed3\u679c\u5355\u636e\u65f6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002%s", (String)"InspResultExcute_0", (String)"qmc-qcbd-business", (Object[])new Object[0]), ex2.getMessage()));
                }
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                logger.info(String.format("consum:%s ms", startTime - endTime));
                logger.info("call mainBeginOperationTransaction end");
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info(String.format("consum:%s ms", startTime - endTime));
        logger.info("call mainBeginOperationTransaction end");
    }

    private void iniParas(AbstractOperationServicePlugIn opPlugin, String operationKey) {
        OperateOption option = opPlugin.getOption();
        option.setVariableValue("trigger_operation", operationKey);
    }

    public void mainAfterExecuteOperationTransaction(AbstractOperationServicePlugIn opPlugin) {
        opPlugin.getOption().setVariableValue("trigger_after_execute", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainRollbackResOperation(AbstractOperationServicePlugIn opPlugin) {
        OperateOption option = opPlugin.getOption();
        String inspresidsStr = option.getVariableValue("trigger_inspresids", "");
        String operationKey = option.getVariableValue("trigger_operation", "");
        if (StringUtils.isNotEmpty((CharSequence)operationKey) && StringUtils.isNotEmpty((CharSequence)inspresidsStr)) {
            try {
                logger.info("call mainRollbackOperation begin");
                Set inspresids = (Set)JSON.parseObject((String)inspresidsStr, (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
                OperationResult res = this.execInverseOp(operationKey, inspresids);
                if (!res.isSuccess()) {
                    logger.error(OperationPrompt.getOutErrMsgLog((OperationResult)res));
                }
            }
            catch (Exception ex) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
            }
            finally {
                logger.info("call mainRollbackOperation end");
            }
        }
    }

    public OperationResult execInverseOp(String opr, Set<Long> pkSunccessSet) {
        OperationResult res = null;
        long startTime = System.currentTimeMillis();
        logger.info("call execInverseOp begin");
        switch (opr) {
            case "unaudit": {
                res = this.execDockBillResOpr(pkSunccessSet, "submit", "audit");
                break;
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info(String.format("consum:%s s", startTime - endTime));
        logger.info("call execInverseOp end");
        return res;
    }

    private String getOperationResultError(OperationResult opRes) {
        StringBuilder sbErr = new StringBuilder();
        List errorInfos = opRes.getAllErrorOrValidateInfo();
        if (!errorInfos.isEmpty()) {
            for (IOperateInfo errInfo : errorInfos) {
                String errStrLine = String.format(ResManager.loadKDString((String)"\u68c0\u9a8c\u7ed3\u679c\uff1a%s", (String)"InspResultExcute_1", (String)"qmc-qcbd-business", (Object[])new Object[0]), errInfo.getMessage());
                sbErr.append(errStrLine);
                sbErr.append("\r\n");
            }
        } else if (!opRes.isSuccess()) {
            String errStrLine;
            String string = errStrLine = opRes.getMessage() == null ? "" : opRes.getMessage();
            if (errStrLine.length() > 0) {
                sbErr.append(errStrLine);
                sbErr.append("\r\n");
            }
        }
        return sbErr.toString();
    }

    public Map<String, Set<Long>> getResPkMap(Set<String> triggerPkVals, String billStatus) {
        QFilter qfilters = new QFilter("ass_billid", "in", triggerPkVals);
        qfilters.and("ass_entitynumber", "=", (Object)this.mTriggerBillEntityType.getName());
        qfilters.and("execstatus", "=", (Object)"completed");
        qfilters.and("billstatus", "=", (Object)billStatus);
        DynamicObjectCollection resColls = QueryServiceHelper.query((String)this.mResEntityNumber, (String)"id, ass_billid", (QFilter[])qfilters.toArray());
        Map<String, List<DynamicObject>> resCollsGroup = resColls.stream().collect(Collectors.groupingBy(x -> x.getString("ass_billid")));
        HashMap<String, Set<Long>> retmap = new HashMap<String, Set<Long>>(16);
        Set<Map.Entry<String, List<DynamicObject>>> entrySet = resCollsGroup.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entrySet) {
            retmap.put(entry.getKey(), entry.getValue().stream().map(x -> x.getLong("id")).collect(Collectors.toSet()));
        }
        return retmap;
    }

    public Set<Long> getResPkVals(Set<String> triggerPkVals, String billStatus) {
        QFilter qfilters = new QFilter("ass_billid", "in", triggerPkVals);
        qfilters.and("ass_entitynumber", "=", (Object)this.mTriggerBillEntityType.getName());
        qfilters.and("execstatus", "=", (Object)"completed");
        qfilters.and("billstatus", "=", (Object)billStatus);
        DynamicObjectCollection resColls = QueryServiceHelper.query((String)this.mResEntityNumber, (String)"", (QFilter[])qfilters.toArray());
        return resColls.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
    }

    public OperationResult execDockBillResOpr(Set<Long> inspResIds, String ... oprParas) {
        OperationResult res = null;
        if (inspResIds.isEmpty()) {
            res = new OperationResult();
            res.setSuccess(true);
            return res;
        }
        OperationServiceImpl oprService = new OperationServiceImpl();
        for (String oprPara : oprParas) {
            res = oprService.localInvokeOperation(oprPara, this.mResEntityNumber, inspResIds.toArray(), OperateOption.create());
            if (res.isSuccess()) continue;
            logger.error(String.format("opreate: %s,message:%s\u3002", oprPara, OperationPrompt.getOutErrMsgLog((OperationResult)res)));
            break;
        }
        return res;
    }

    public final String getResEntityNumber() {
        StringBuilder sbStr = new StringBuilder();
        String appId = this.mTriggerBillEntityType.getAppId();
        sbStr.append(appId);
        sbStr.append("_inspresult");
        if ("qcbd".equals(appId)) {
            sbStr.append("_example");
        }
        return sbStr.toString();
    }

    public void updateInspObjResult(List<String> triggerBillIds) {
        if (triggerBillIds.isEmpty()) {
            return;
        }
        String inspObjectNumber = InspObjectHelper.getInspObjEntityNumberByAppid(this.mTriggerBillEntityType.getAppId());
        MainEntityType objEntityType = MetadataServiceHelper.getDataEntityType((String)inspObjectNumber);
        String relateTableName = MainEntityTypeUtil.getTableName((MainEntityType)objEntityType, (String)"entryentity");
        SqlBuilder sbSql = new SqlBuilder();
        sbSql.append(String.format("update %s", relateTableName), new Object[0]);
        sbSql.append("set finspresbillid = 0", new Object[0]);
        sbSql.append("where fentitynumberid = ? and", new Object[]{this.mTriggerBillEntityType.getName()});
        sbSql.appendIn("fbillid", triggerBillIds.toArray());
        DB.update((DBRoute)DBRoute.of((String)"qmc"), (SqlBuilder)sbSql);
    }
}

