/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.samplingscheme;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.qmc.qcbd.common.constant.RelaxedAqlConst;
import kd.qmc.qcbd.common.constant.SamplingSchemeConst;
import kd.qmc.qcbd.common.constant.StrictAqlConst;
import kd.qmc.qcbd.common.enums.SamplingTypeEnum;
import kd.qmc.qcbd.common.enums.StrictnessEnum;
import kd.qmc.qcbd.common.util.AqlBo;

public class SamplingSchemeHelper {
    public static List<AqlBo> initAqlGBList(String aqlValue, String checkLevel, String strictness, String sampleStandard) {
        BigInteger[] batchArr = new BigInteger[]{BigInteger.valueOf(8L), BigInteger.valueOf(15L), BigInteger.valueOf(25L), BigInteger.valueOf(50L), BigInteger.valueOf(90L), BigInteger.valueOf(150L), BigInteger.valueOf(280L), BigInteger.valueOf(500L), BigInteger.valueOf(1200L), BigInteger.valueOf(3200L), BigInteger.valueOf(10000L), BigInteger.valueOf(35000L), BigInteger.valueOf(150000L), BigInteger.valueOf(500000L), BigInteger.valueOf(500002L)};
        int i = (int)((float)batchArr.length / 0.75f + 1.0f);
        ArrayList<AqlBo> abl = new ArrayList<AqlBo>(i);
        for (BigInteger bigInteger : batchArr) {
            AqlBo ab = new AqlBo();
            ab.setBatchSize(bigInteger);
            ab.setInspectionLevel(checkLevel);
            ab.setAqlValue(aqlValue);
            ab.setStrictness(strictness);
            ab.setSampleStandard(sampleStandard);
            SamplingSchemeHelper.calculationAql(ab);
            abl.add(ab);
        }
        return abl;
    }

    public static List<AqlBo> initZeroAql(String aqlValue, String sampleStandard) {
        BigInteger[] batchArr = new BigInteger[]{BigInteger.valueOf(8L), BigInteger.valueOf(15L), BigInteger.valueOf(25L), BigInteger.valueOf(50L), BigInteger.valueOf(90L), BigInteger.valueOf(150L), BigInteger.valueOf(280L), BigInteger.valueOf(500L), BigInteger.valueOf(1200L), BigInteger.valueOf(3200L), BigInteger.valueOf(10000L), BigInteger.valueOf(35000L), BigInteger.valueOf(150000L), BigInteger.valueOf(500000L), BigInteger.valueOf(500002L)};
        int i = (int)((float)batchArr.length / 0.75f + 1.0f);
        ArrayList<AqlBo> abl = new ArrayList<AqlBo>(i);
        for (BigInteger bigInteger : batchArr) {
            AqlBo ab = new AqlBo();
            ab.setBatchSize(bigInteger);
            ab.setInspectionLevel(null);
            ab.setAqlValue(aqlValue);
            ab.setStrictness(null);
            ab.setSampleStandard(sampleStandard);
            SamplingSchemeHelper.calculationZeroAql(ab);
            abl.add(ab);
        }
        return abl;
    }

    private static AqlBo calculationAql(AqlBo ab) {
        if (SamplingTypeEnum.GB_2828.getValue().equals(ab.getSampleStandard())) {
            SamplingSchemeHelper.matchSampleSizeCode(ab);
            Map aqlGB = null;
            if (StrictnessEnum.NORMAL_INSPECTION.getValue().equals(ab.getStrictness())) {
                aqlGB = SamplingSchemeConst.AQLGB;
            } else if (StrictnessEnum.STRICT_INSPECTION.getValue().equals(ab.getStrictness())) {
                aqlGB = StrictAqlConst.STRICT_AQLGB;
            } else if (StrictnessEnum.RELAXED_INSPECTION.getValue().equals(ab.getStrictness())) {
                aqlGB = RelaxedAqlConst.RELAXED_AQLGB;
            }
            if (aqlGB != null) {
                String[] aql = (String[])aqlGB.get(ab.getAqlValue());
                for (int i = 0; i < aql.length; ++i) {
                    String[] temp = aql[i].split(",");
                    if (temp[0].compareTo(ab.getSamplingSizeCode()) < 0 && i + 1 != aql.length) continue;
                    ab.setSamplingSize(new BigInteger(temp[1]));
                    ab.setAc(new BigInteger(temp[2]));
                    ab.setRe(new BigInteger(temp[3]));
                    break;
                }
            }
        }
        return ab;
    }

    public static void batchCreateNewEntryRow(IDataModel model, List<AqlBo> abl) {
        int i = 0;
        BigInteger min = BigInteger.valueOf(2L);
        model.deleteEntryData("receiveinfoentity");
        model.batchCreateNewEntryRow("receiveinfoentity", abl.size());
        for (AqlBo aqlBo : abl) {
            if (abl.size() - 1 == i) {
                model.setValue("batchinitialvalue", (Object)min, i);
            } else {
                model.setValue("batchinitialvalue", (Object)min, i);
                model.setValue("batchcutoffvalue", (Object)aqlBo.getBatchSize(), i);
            }
            model.setValue("samplingsizecode", (Object)aqlBo.getSamplingSizeCode(), i);
            model.setValue("samplingsize", (Object)aqlBo.getSamplingSize(), i);
            model.setValue("ac", (Object)aqlBo.getAc(), i);
            model.setValue("acstr", (Object)aqlBo.getAc(), i);
            model.setValue("re", (Object)aqlBo.getRe(), i);
            min = aqlBo.getBatchSize().add(BigInteger.valueOf(1L));
            ++i;
        }
    }

    private static AqlBo calculationZeroAql(AqlBo ab) {
        if (SamplingTypeEnum.ZERO_AQL.getValue().equals(ab.getSampleStandard())) {
            SamplingSchemeHelper.matchSampleSizeCode(ab);
            Map aqlGB = null;
            aqlGB = SamplingSchemeConst.ZEROAQL;
            if (aqlGB != null) {
                String[] aql = (String[])aqlGB.get(ab.getAqlValue());
                for (int i = 0; i < aql.length; ++i) {
                    String[] temp = aql[i].split(",");
                    if (new BigInteger(temp[0]).compareTo(ab.getBatchSize()) < 0) continue;
                    ab.setSamplingSize(new BigInteger(temp[1]));
                    ab.setAc(BigInteger.ZERO);
                    ab.setRe(BigInteger.ONE);
                    break;
                }
            }
        }
        return ab;
    }

    private static AqlBo matchSampleSizeCode(AqlBo ab) {
        if (SamplingTypeEnum.GB_2828.getValue().equals(ab.getSampleStandard())) {
            Map batchSizeGB = SamplingSchemeConst.batchSizeGB;
            int row = (Integer)batchSizeGB.get(new BigInteger(String.valueOf(-1)));
            for (Map.Entry entry : batchSizeGB.entrySet()) {
                if (((BigInteger)entry.getKey()).compareTo(ab.getBatchSize()) < 0) continue;
                row = (Integer)entry.getValue();
                break;
            }
            Map checkLevelGB = SamplingSchemeConst.checkLevelGB;
            ab.setSamplingSizeCode(((String[])checkLevelGB.get(ab.getInspectionLevel()))[row]);
        }
        return ab;
    }
}

