/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.baseplugin.insresult;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.baseplugin.insresult.SubmitResultBasePlugin;
import kd.qmc.qcbd.business.commonmodel.plugin.args.BeginInspResOperationTransactionArgs;
import kd.qmc.qcbd.common.constant.InspResultConst;
import kd.qmc.qcbd.common.util.OperationPrompt;

public class BaddealSubmitResultPlugin
extends SubmitResultBasePlugin {
    @Override
    public void beginOperationTransaction(BeginInspResOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        List billIds = (List)this.operateMeta.get("trigger_billids");
        String srcMetaKey = (String)this.operateMeta.get("trigger_entitynumber");
        String srcAppId = (String)this.operateMeta.get("trigger_appid");
        DynamicObject[] inspecObjs = this.getInspecObjs(srcAppId, srcMetaKey, billIds);
        DynamicObjectCollection billObjs = this.getOpBillObjs(srcMetaKey, billIds);
        try {
            this.dealSubmit(srcAppId, srcMetaKey, operationKey, inspecObjs, billObjs);
        }
        catch (Exception exception) {
            this.dealException(inspecObjs, billObjs, srcMetaKey, "materialentry");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u68c0\u9a8c\u7ed3\u679c\u53d1\u751f\u5f02\u5e38\uff0c\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"BaddealSubmitResultPlugin_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)exception)));
        }
        finally {
            SaveServiceHelper.save((DynamicObject[])inspecObjs);
        }
    }

    private void dealSubmit(String srcAppId, String srcMetaKey, String operationKey, DynamicObject[] inspecObjs, DynamicObjectCollection billObjs) {
        ArrayList<Object> resultBillObjIds = new ArrayList<Object>(16);
        ArrayList<Object> noResultBillObjIds = new ArrayList<Object>(16);
        String resultEntity = (String)InspResultConst.getInspresultAppMap().get(srcAppId);
        ArrayList<DynamicObject> inspResultObjList = new ArrayList<DynamicObject>();
        DynamicObject resultDyo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)resultEntity));
        if (Objects.isNull(CodeRuleServiceHelper.getCodeRule((String)resultEntity, (DynamicObject)resultDyo, null))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"BaddealSubmitResultPlugin_1", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
        }
        for (DynamicObject inspObj : inspecObjs) {
            Map<Long, DynamicObject> billObjIdsMap = this.getOpBillObjListByInspObj(billObjs, inspObj, "materialentry");
            List<DynamicObject> inspObjEntrys = this.getInsObjEntry(inspObj, billObjIdsMap);
            for (DynamicObject inspObjEntry : inspObjEntrys) {
                DynamicObject billObj = billObjIdsMap.get(inspObjEntry.getLong("ass_billentryid"));
                Object billObjId = billObj.get("materialentry.id");
                if (billObj.getString("materialentry.handmethed").indexOf(84) != -1) {
                    noResultBillObjIds.add(billObjId);
                    continue;
                }
                String inspFirstEntryKey = inspObjEntry.getString("ass_inspfirstentrykey");
                if (StringUtils.isBlank((String)inspFirstEntryKey)) {
                    noResultBillObjIds.add(billObjId);
                    continue;
                }
                DynamicObject inspResultObj = this.buildRespecResult(srcAppId, resultEntity, operationKey, inspObj, inspObjEntry, billObj);
                this.buildRespecEntry(billObj, inspObj, Long.valueOf(inspFirstEntryKey.substring(inspFirstEntryKey.lastIndexOf("_") + 1)), inspResultObj);
                inspResultObjList.add(inspResultObj);
                resultBillObjIds.add(billObjId);
                inspObjEntry.set("ass_inspresbillid", (Object)inspResultObj.getLong("id"));
            }
        }
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)resultEntity, (DynamicObject[])inspResultObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!saveResult.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u68c0\u9a8c\u7ed3\u679c\u5931\u8d25\uff1a%s", (String)"BaddealSubmitResultPlugin_2", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]), OperationPrompt.getOutErrMsgLog((OperationResult)saveResult)));
        }
        if (!CollectionUtils.isEmpty(resultBillObjIds)) {
            this.updateBillObjResultStatus(resultBillObjIds, InspResultConst.EXECSTATUSENUM.completed.name(), srcMetaKey, "materialentry");
        }
        if (!CollectionUtils.isEmpty(noResultBillObjIds)) {
            this.updateBillObjResultStatus(noResultBillObjIds, " ", srcMetaKey, "materialentry");
        }
    }

    private DynamicObjectCollection getOpBillObjs(String srcMetaKey, List<String> billIds) {
        String selectFields = "id,biztype,transactype,billno,materialentry.id,materialentry.seq,materialentry.materielid,materialentry.unit,materialentry.baseunit,materialentry.unqualiqty,materialentry.baseqty,materialentry.handmethed,materialentry.newhandmode";
        Set ids = billIds.stream().map(Long::parseLong).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)srcMetaKey, (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private DynamicObject buildRespecResult(String srcAppId, String resultEntity, String operationKey, DynamicObject inspecObj, DynamicObject inspObjentry, DynamicObject billObj) {
        DynamicObject inspResultObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)resultEntity));
        long id = ORM.create().genLongId(resultEntity);
        inspResultObj.set("id", (Object)id);
        inspResultObj.set("billstatus", (Object)"B");
        inspResultObj.set("billtype", InspResultConst.getBilltypeMap().get(srcAppId));
        inspResultObj.set("ass_transactype", billObj.get("transactype"));
        inspResultObj.set("ass_biztype", billObj.get("biztype"));
        inspResultObj.set("ass_billno", billObj.get("billno"));
        inspResultObj.set("ass_entitynumber", inspObjentry.get("ass_entitynumber"));
        inspResultObj.set("ass_billid", billObj.get("id"));
        inspResultObj.set("ass_billentryid", billObj.get("materialentry.id"));
        inspResultObj.set("ass_billentryseq", billObj.get("materialentry.seq"));
        inspResultObj.set("insobjid", (Object)inspecObj.getLong("id"));
        inspResultObj.set("insobjentryid", (Object)inspObjentry.getLong("id"));
        inspResultObj.set("execstatus", (Object)InspResultConst.EXECSTATUSENUM.completed.name());
        inspResultObj.set("ck_materialid", billObj.get("materialentry.materielid"));
        inspResultObj.set("ck_unitid", billObj.get("materialentry.unit"));
        inspResultObj.set("ck_baseunitid", billObj.get("materialentry.baseunit"));
        inspResultObj.set("ck_unqualifqty", billObj.get("materialentry.unqualiqty"));
        inspResultObj.set("ck_unqualifbaseqty", billObj.get("materialentry.baseqty"));
        String handMethod = billObj.getString("materialentry.handmethed");
        if (StringUtils.isNotEmpty((String)handMethod)) {
            inspResultObj.set("ck_handmethed", (Object)srcAppId.concat(handMethod));
        }
        inspResultObj.set("ck_newhandmode", billObj.get("materialentry.newhandmode"));
        return inspResultObj;
    }

    private void buildRespecEntry(DynamicObject billObj, DynamicObject inspObj, Long inspectFirstId, DynamicObject inspResultObj) {
        Optional<DynamicObject> insObjInspectEntryOpt = inspObj.getDynamicObjectCollection("entryentity").stream().filter(o -> o.getLong("ass_billentryid") == inspectFirstId.longValue()).findFirst();
        if (insObjInspectEntryOpt.isPresent()) {
            DynamicObject insObjInspectEntry = insObjInspectEntryOpt.get();
            DynamicObjectCollection resultEntrys = inspResultObj.getDynamicObjectCollection("splitbatchentity");
            DynamicObject entryObj = new DynamicObject(resultEntrys.getDynamicObjectType());
            entryObj.set("m_srcbillid_direct", insObjInspectEntry.get("ass_billid"));
            entryObj.set("m_srcentitynumber_direct", insObjInspectEntry.get("ass_entitynumber"));
            entryObj.set("m_srcbillentryid_direct", insObjInspectEntry.get("ass_billentryid"));
            entryObj.set("m_srcbillentryseq_direct", insObjInspectEntry.get("ass_billentryseq"));
            entryObj.set("m_srcentrynumber_direct", insObjInspectEntry.get("ass_entrynumber"));
            entryObj.set("m_unqualifqty", billObj.get("materialentry.unqualiqty"));
            entryObj.set("m_unqualifbaseqty", billObj.get("materialentry.baseqty"));
            entryObj.set("m_srcentitynumber", inspObj.get("srcentitynumber"));
            entryObj.set("m_srcbillno", inspObj.get("srcbillno"));
            entryObj.set("m_srcbillid", inspObj.get("srcbillid"));
            entryObj.set("m_srcbillentryid", inspObj.get("srcentryid"));
            entryObj.set("m_srcbillentryseq", inspObj.get("srcentryseq"));
            entryObj.set("m_srcsystem", inspObj.get("scsystem"));
            entryObj.set("m_submitunit", inspObj.get("srcunitid"));
            resultEntrys.add((Object)entryObj);
        }
    }
}

