/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.baseplugin.insresult;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.commonmodel.baseplugin.insresult.SubmitResultBasePlugin;
import kd.qmc.qcbd.business.commonmodel.plugin.args.BeginInspResOperationTransactionArgs;
import kd.qmc.qcbd.common.constant.InspResultConst;
import kd.qmc.qcbd.common.util.OperationPrompt;

public class InspectSubmitResultPlugin
extends SubmitResultBasePlugin {
    @Override
    public void beginOperationTransaction(BeginInspResOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        List billIds = (List)this.operateMeta.get("trigger_billids");
        String srcMetaKey = (String)this.operateMeta.get("trigger_entitynumber");
        String srcAppId = (String)this.operateMeta.get("trigger_appid");
        Map modifiedInfos = (Map)this.operateMeta.get("trigger_modifiedInfos");
        DynamicObject[] inspecObjs = this.getInspecObjs(srcAppId, srcMetaKey, billIds);
        DynamicObjectCollection billObjs = this.getOpBillObjs(srcMetaKey, billIds);
        try {
            this.dealSubmit(srcAppId, srcMetaKey, operationKey, inspecObjs, billObjs, modifiedInfos);
        }
        catch (Exception exception) {
            this.dealException(inspecObjs, billObjs, srcMetaKey, "matintoentity");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u751f\u6210\u68c0\u9a8c\u7ed3\u679c\u53d1\u751f\u5f02\u5e38\uff0c\u62a5\u9519\u4fe1\u606f\uff1a%s", (String)"InspectSubmitResultPlugin_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)exception)));
        }
        finally {
            SaveServiceHelper.save((DynamicObject[])inspecObjs);
        }
    }

    private void dealSubmit(String srcAppId, String srcMetaKey, String operationKey, DynamicObject[] inspecObjs, DynamicObjectCollection billObjs, Map<Long, Map<String, Object>> modifiedInfos) {
        ArrayList<Object> resultBillObjIds = new ArrayList<Object>(16);
        ArrayList<Object> noResultBillObjIds = new ArrayList<Object>(16);
        String resultEntity = (String)InspResultConst.getInspresultAppMap().get(srcAppId);
        ArrayList<DynamicObject> inspResultObjList = new ArrayList<DynamicObject>();
        DynamicObject resultDyo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)resultEntity));
        if (Objects.isNull(CodeRuleServiceHelper.getCodeRule((String)resultEntity, (DynamicObject)resultDyo, null))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219\u3002", (String)"InspectSubmitResultPlugin_1", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
        }
        for (DynamicObject inspObj : inspecObjs) {
            Map<Long, DynamicObject> billObjIdsMap = this.getOpBillObjListByInspObj(billObjs, inspObj, "matintoentity");
            List<DynamicObject> inspObjEntrys = this.getInsObjEntry(inspObj, billObjIdsMap);
            for (DynamicObject inspObjEntry : inspObjEntrys) {
                DynamicObject billObj = billObjIdsMap.get(inspObjEntry.getLong("ass_billentryid"));
                Object billObjId = billObj.get("matintoentity.id");
                if (billObj.getBigDecimal("matintoentity.qualiqty").compareTo(BigDecimal.ZERO) <= 0 && !inspObj.getDynamicObject("biztype").getString("number").equals("qcpp-003")) {
                    inspObjEntry.set("ass_inspresbillid", (Object)"B");
                    noResultBillObjIds.add(billObjId);
                    continue;
                }
                String inspFirstEntryKey = inspObjEntry.getString("ass_inspfirstentrykey");
                if (StringUtils.isBlank((String)inspFirstEntryKey)) {
                    noResultBillObjIds.add(billObjId);
                    continue;
                }
                DynamicObject inspResultObj = this.buildRespecResult(srcAppId, resultEntity, operationKey, inspObj, inspObjEntry, billObj, modifiedInfos);
                this.buildRespecEntry(billObj, inspObj, Long.valueOf(inspFirstEntryKey.substring(inspFirstEntryKey.lastIndexOf("_") + 1)), inspResultObj, modifiedInfos);
                inspResultObjList.add(inspResultObj);
                resultBillObjIds.add(billObjId);
                inspObjEntry.set("ass_inspresbillid", (Object)inspResultObj.getLong("id"));
            }
        }
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)resultEntity, (DynamicObject[])inspResultObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!saveResult.isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u68c0\u9a8c\u7ed3\u679c\u5931\u8d25\uff1a%s", (String)"InspectSubmitResultPlugin_2", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]), OperationPrompt.getOutErrMsgLog((OperationResult)saveResult)));
        }
        if (!CollectionUtils.isEmpty(resultBillObjIds)) {
            this.updateBillObjResultStatus(resultBillObjIds, InspResultConst.EXECSTATUSENUM.completed.name(), srcMetaKey, "matintoentity");
        }
        if (!CollectionUtils.isEmpty(noResultBillObjIds)) {
            this.updateBillObjResultStatus(noResultBillObjIds, " ", srcMetaKey, "matintoentity");
        }
    }

    private DynamicObjectCollection getOpBillObjs(String srcMetaKey, List<String> billIds) {
        String selectFields = "id,biztype,transactype,billno,matintoentity.id,matintoentity.seq,matintoentity.materialid,matintoentity.unitfield,matintoentity.baseunit,matintoentity.materialqty,matintoentity.baseqty,matintoentity.qualiqty,matintoentity.basequaliqty,matintoentity.samplingresult";
        Set ids = billIds.stream().map(Long::parseLong).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)srcMetaKey, (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private DynamicObject buildRespecResult(String srcAppId, String resultEntity, String operationKey, DynamicObject inspecObj, DynamicObject inspObjentry, DynamicObject billObj, Map<Long, Map<String, Object>> modifiedInfos) {
        DynamicObject inspResultObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)resultEntity));
        long id = ORM.create().genLongId(resultEntity);
        inspResultObj.set("id", (Object)id);
        inspResultObj.set("billstatus", (Object)"B");
        inspResultObj.set("billtype", InspResultConst.getBilltypeMap().get(srcAppId));
        inspResultObj.set("ass_transactype", billObj.get("transactype"));
        inspResultObj.set("ass_biztype", billObj.get("biztype"));
        inspResultObj.set("ass_billno", billObj.get("billno"));
        inspResultObj.set("ass_entitynumber", inspObjentry.get("ass_entitynumber"));
        inspResultObj.set("ass_billid", billObj.get("id"));
        inspResultObj.set("ass_billentryid", billObj.get("matintoentity.id"));
        inspResultObj.set("ass_billentryseq", billObj.get("matintoentity.seq"));
        inspResultObj.set("insobjid", (Object)inspecObj.getLong("id"));
        inspResultObj.set("insobjentryid", (Object)inspObjentry.getLong("id"));
        inspResultObj.set("execstatus", (Object)InspResultConst.EXECSTATUSENUM.completed.name());
        inspResultObj.set("ck_materialid", billObj.get("matintoentity.materialid"));
        inspResultObj.set("ck_unitid", billObj.get("matintoentity.unitfield"));
        inspResultObj.set("ck_baseunitid", billObj.get("matintoentity.baseunit"));
        Long matEnryId = billObj.getLong("matintoentity.id");
        if (null != modifiedInfos && modifiedInfos.containsKey(matEnryId)) {
            Map<String, Object> modifiedInfo = modifiedInfos.get(matEnryId);
            inspResultObj.set("ck_qualifqty", modifiedInfo.get("qualiqty"));
            inspResultObj.set("ck_qualifbaseqty", modifiedInfo.get("basequaliqty"));
        } else {
            inspResultObj.set("ck_qualifqty", billObj.get("matintoentity.qualiqty"));
            inspResultObj.set("ck_qualifbaseqty", billObj.get("matintoentity.basequaliqty"));
        }
        return inspResultObj;
    }

    private void buildRespecEntry(DynamicObject billObj, DynamicObject inspObj, Long inspectFirstEntryId, DynamicObject inspResultObj, Map<Long, Map<String, Object>> modifiedInfos) {
        Optional<DynamicObject> insObjInspectEntryOpt = inspObj.getDynamicObjectCollection("entryentity").stream().filter(o -> o.getLong("ass_billentryid") == inspectFirstEntryId.longValue()).findFirst();
        if (insObjInspectEntryOpt.isPresent()) {
            DynamicObject insObjInspectEntry = insObjInspectEntryOpt.get();
            DynamicObjectCollection resultEntrys = inspResultObj.getDynamicObjectCollection("splitbatchentity");
            DynamicObject entryObj = new DynamicObject(resultEntrys.getDynamicObjectType());
            entryObj.set("m_srcbillid_direct", insObjInspectEntry.get("ass_billid"));
            entryObj.set("m_srcentitynumber_direct", insObjInspectEntry.get("ass_entitynumber"));
            entryObj.set("m_srcbillentryid_direct", insObjInspectEntry.get("ass_billentryid"));
            entryObj.set("m_srcbillentryseq_direct", insObjInspectEntry.get("ass_billentryseq"));
            entryObj.set("m_srcentrynumber_direct", insObjInspectEntry.get("ass_entrynumber"));
            Long matEnryId = billObj.getLong("matintoentity.id");
            if (null != modifiedInfos && modifiedInfos.containsKey(matEnryId)) {
                Map<String, Object> modifiedInfo = modifiedInfos.get(matEnryId);
                entryObj.set("m_qualifqty", modifiedInfo.get("qualiqty"));
                entryObj.set("m_qualifybaseqty", modifiedInfo.get("basequaliqty"));
                entryObj.set("m_samplingresult", modifiedInfo.get("samplingresult"));
            } else {
                entryObj.set("m_qualifqty", billObj.get("matintoentity.qualiqty"));
                entryObj.set("m_qualifybaseqty", billObj.get("matintoentity.basequaliqty"));
                entryObj.set("m_samplingresult", billObj.get("matintoentity.samplingresult"));
            }
            entryObj.set("m_srcentitynumber", inspObj.get("srcentitynumber"));
            entryObj.set("m_srcbillno", inspObj.get("srcbillno"));
            entryObj.set("m_srcbillid", inspObj.get("srcbillid"));
            entryObj.set("m_srcbillentryid", inspObj.get("srcentryid"));
            entryObj.set("m_srcbillentryseq", inspObj.get("srcentryseq"));
            entryObj.set("m_srcsystem", inspObj.get("scsystem"));
            entryObj.set("m_submitunit", inspObj.get("srcunitid"));
            resultEntrys.add((Object)entryObj);
        }
    }
}

