/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.botp;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class AppInspectCommonBotp
extends AbstractConvertPlugIn {
    private static final String QMC = "qmc";
    private static final String QCBD = "qcbd";
    private static final String ORG = "org";
    private static final String ADUITED = "C";
    private static final String INSPECORG = "inspecorg";
    private static final String BIZTYPE = "biztype";
    private static final String BILLSTATUS = "billstatus";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        this.materialcfgCheck(e);
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        HashMap<Long, Long> qctOrgMap = new HashMap<Long, Long>(10);
        long currorgid = RequestContext.get().getOrgId();
        for (DynamicObject data : sourceRows) {
            long orgid = data.getLong((IDataEntityProperty)fldProperties.get(INSPECORG));
            if (orgid <= 0L && data.getLong((IDataEntityProperty)fldProperties.get(ORG)) > 0L) {
                orgid = this.cacheorg(qctOrgMap, data.getLong((IDataEntityProperty)fldProperties.get(ORG)));
            }
            if (orgid <= 0L) {
                orgid = this.cacheorg(qctOrgMap, currorgid);
            }
            if (orgid <= 0L) continue;
            data.set((IDataEntityProperty)fldProperties.get(INSPECORG), (Object)orgid);
        }
    }

    private long cacheorg(Map<Long, Long> qctOrgMap, long orgid) {
        Long qcorg = qctOrgMap.get(orgid);
        if (null == qcorg) {
            qcorg = this.getQctoOrgid(orgid);
            qctOrgMap.put(orgid, qcorg);
        }
        return qcorg;
    }

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        ConvertOpType opType = this.getOpType();
        if (opType == ConvertOpType.BeforeDraw) {
            DynamicObject targetDataEntity = e.getTargetDataEntity();
            String srcMainType = this.getSrcMainType().getName();
            if (targetDataEntity != null) {
                DynamicObject obj = targetDataEntity.getDynamicObject(ORG);
                DynamicObject objbiz = targetDataEntity.getDynamicObject(BIZTYPE);
                Object pkValue = objbiz.getPkValue();
                QFilter qFilter = new QFilter(BIZTYPE, "=", pkValue);
                if (obj != null) {
                    Object opk = obj.getPkValue();
                    qFilter.and(new QFilter(INSPECORG, "=", opk));
                    qFilter.or("id", "in", this.getQcFromId(Long.parseLong(opk.toString()), pkValue, srcMainType));
                }
                e.setPlugFilter(qFilter);
            }
        }
    }

    private List<Long> getQcFromId(Long insIrgId, Object bizTypeId, String srcMainType) {
        QFilter qf = new QFilter(INSPECORG, "=", (Object)0).and(new QFilter(BILLSTATUS, "=", (Object)ADUITED)).and(BIZTYPE, "=", bizTypeId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)srcMainType, (String)"id,org,inspecorg", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> ids = new ArrayList<Long>(10);
        HashMap<Long, Long> qctOrgMap = new HashMap<Long, Long>(10);
        for (DynamicObject dynamicObject : query) {
            Long qctoOrgid = (Long)qctOrgMap.get(dynamicObject.getLong(ORG));
            if (qctoOrgid == null) {
                qctoOrgid = this.getQctoOrgid(dynamicObject.getLong(ORG));
                qctOrgMap.put(dynamicObject.getLong(ORG), qctoOrgid);
            }
            if (!qctoOrgid.equals(insIrgId)) continue;
            ids.add(Long.parseLong(dynamicObject.get("id").toString()));
        }
        return ids;
    }

    private Long getQctoOrgid(Long orgid) {
        Long l = 0L;
        List deftoOrgs = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)orgid, (boolean)true);
        if (!deftoOrgs.isEmpty()) {
            l = (Long)deftoOrgs.get(0);
        }
        return l;
    }

    private void materialcfgCheck(BeforeBuildRowConditionEventArgs e) {
        List selectedRows = e.getSelectedRows();
        ArrayList<Long> pkList = new ArrayList<Long>(selectedRows.size());
        ArrayList<JSONObject> batInvok = new ArrayList<JSONObject>(selectedRows.size());
        HashMap errMat = new HashMap(selectedRows.size());
        HashMap sucMat = new HashMap(selectedRows.size());
        HashMap<String, String> matIdNameMap = new HashMap<String, String>(selectedRows.size());
        for (ListSelectedRow listSelectedRow : selectedRows) {
            String pkvalue = String.valueOf(listSelectedRow.getPrimaryKeyValue());
            if ("null".equals(pkvalue)) continue;
            pkList.add(Long.parseLong(pkvalue));
        }
        String srcMainType = this.getSrcMainType().getName();
        DynamicObjectCollection query = QueryServiceHelper.query((String)srcMainType, (String)srcMainType, (String)"biztype.number,org.id,materialentry.materialid.id,materialentry.materialid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)}, null);
        for (Object d : query) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(BIZTYPE, (Object)d.getString("biztype.number"));
            jSONObject.put("userorg", (Object)d.getString("org.id"));
            jSONObject.put("materialid", (Object)d.getString("materialentry.materialid.id"));
            matIdNameMap.put(d.getString("materialentry.materialid.id"), d.getString("materialentry.materialid.name"));
            batInvok.add(jSONObject);
        }
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)QMC, (String)QCBD, (String)"MaterialInspectService", (String)"ckInspectInfoBatch", (Object[])new Object[]{batInvok});
        if (resMap != null && !resMap.isEmpty()) {
            for (Map.Entry entry : resMap.entrySet()) {
                JSONObject rjso = (JSONObject)entry.getValue();
                if (!rjso.getBoolean("successful").booleanValue()) {
                    errMat.put(rjso.getString("materialid"), matIdNameMap.get(rjso.getString("materialid")));
                    continue;
                }
                sucMat.put(rjso.getString("materialid"), matIdNameMap.get(rjso.getString("materialid")));
            }
        }
        if (!errMat.isEmpty()) {
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u672a\u8bbe\u7f6e\u53ef\u7528\u7684\u201c\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u201d\uff0c\u6216\u201c\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u201d\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"AppInspectCommonBotp_1", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
            e.setCustFilterExpression(" materialid.id in (" + String.join((CharSequence)",", sucMat.keySet()) + ")");
            QFilter qFilter = new QFilter("materialid.id", "in", sucMat.keySet());
            e.getCustQFilters().add(qFilter);
        }
    }
}

