/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.botp;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.qmc.qcbd.business.helper.inspectexecute.JoinInspectHelper;
import kd.qmc.qcbd.common.model.joininspect.JoinInspectEntityModel;
import kd.qmc.qcbd.common.platform.org.PlatformOrgUnitServiceHelper;

public class InSpecCommonbotp
extends AbstractConvertPlugIn {
    private static final String ORG = "org";
    private static final String INSPECORG = "inspecorg";
    private Map<Long, List<Long>> mOrgToQcOrgMap = new HashMap<Long, List<Long>>(16);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            if ("C".equals(listSelectedRow.getBillStatus())) continue;
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"InSpecCommonbotp_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
            e.setCustFilterExpression(" billstatus ='C' ");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
            e.getCustQFilters().add(qFilter);
            break;
        }
        this.materialcfgCheck(e);
    }

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        ConvertOpType opType = this.getOpType();
        if (opType == ConvertOpType.BeforeDraw) {
            this.afterBuildDrawFilterApplyBill(e);
        }
    }

    private void afterBuildDrawFilterApplyBill(AfterBuildDrawFilterEventArgs e) {
        DynamicObject targetDataEntity = e.getTargetDataEntity();
        if (targetDataEntity == null) {
            return;
        }
        DynamicObject orgObj = targetDataEntity.getDynamicObject(ORG);
        DynamicObject biztypeObj = targetDataEntity.getDynamicObject("biztype");
        if (biztypeObj == null) {
            return;
        }
        if (orgObj != null) {
            Long inspectOrgPk = orgObj.getLong("id");
            QFilter qfilterByInspectOrg = new QFilter(INSPECORG, "=", (Object)inspectOrgPk);
            List applyOrgs = PlatformOrgUnitServiceHelper.getFromOrgs((String)"06", (Long)inspectOrgPk, (String)"", (boolean)true);
            QFilter qfilterByApplyOrg = new QFilter(INSPECORG, "=", (Object)0L);
            HashSet<Long> applyOrgIdSet = new HashSet<Long>(16);
            for (Long applyOrgId : applyOrgs) {
                List inspOrgIds = PlatformOrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)applyOrgId, (boolean)true);
                if (!CollectionUtils.isNotEmpty((Collection)inspOrgIds) || !((Long)inspOrgIds.get(0)).equals(inspectOrgPk)) continue;
                applyOrgIdSet.add(applyOrgId);
            }
            qfilterByApplyOrg.and(ORG, "in", applyOrgIdSet);
            QFilter qfilterComb = qfilterByInspectOrg;
            if (applyOrgs.size() > 0) {
                qfilterComb = qfilterComb.or(qfilterByApplyOrg);
            }
            e.setPlugFilter(qfilterComb);
        }
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        IDataEntityProperty inspectOrgProp = (IDataEntityProperty)fldProperties.get(INSPECORG);
        IDataEntityProperty orgProp = (IDataEntityProperty)fldProperties.get(ORG);
        long curOrgid = RequestContext.get().getOrgId();
        for (DynamicObject srcRow : sourceRows) {
            Long orgID;
            long orgid = srcRow.getLong(inspectOrgProp);
            if (orgid <= 0L && (orgID = Long.valueOf(srcRow.getLong(orgProp))) != null && orgID > 0L) {
                orgid = this.getQctoOrgid(orgID);
            }
            if (orgid <= 0L) {
                orgid = this.getQctoOrgid(curOrgid);
            }
            if (orgid <= 0L) continue;
            srcRow.set(inspectOrgProp, (Object)orgid);
        }
    }

    private Long getQctoOrgid(Long orgid) {
        Long qcOrgID = 0L;
        List qcOrgIDs = this.mOrgToQcOrgMap.get(orgid);
        if (!this.mOrgToQcOrgMap.containsKey(orgid)) {
            qcOrgIDs = PlatformOrgUnitServiceHelper.getAllToOrg((String)"", (String)"06", (Long)orgid, (boolean)true);
            this.mOrgToQcOrgMap.put(orgid, qcOrgIDs);
        }
        if (!qcOrgIDs.isEmpty()) {
            qcOrgID = (Long)qcOrgIDs.get(0);
        }
        return qcOrgID;
    }

    public void afterConvert(AfterConvertEventArgs e) {
        this.sychoJoinInspect(e);
    }

    private void materialcfgCheck(BeforeBuildRowConditionEventArgs e) {
        List selectedRows = e.getSelectedRows();
        HashSet<Long> pkIdSet = new HashSet<Long>(selectedRows.size());
        ArrayList<JSONObject> batInvok = new ArrayList<JSONObject>(selectedRows.size());
        HashMap errMat = new HashMap(selectedRows.size());
        HashMap sucMat = new HashMap(selectedRows.size());
        HashMap<String, String> matIdNameMap = new HashMap<String, String>(selectedRows.size());
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long pkVal = (Long)listSelectedRow.getPrimaryKeyValue();
            pkIdSet.add(pkVal);
        }
        if (pkIdSet.isEmpty()) {
            return;
        }
        String srcMainType = this.getSrcMainType().getName();
        DynamicObjectCollection query = QueryServiceHelper.query((String)srcMainType, (String)srcMainType, (String)"biztype.number,org.id,materialentry.materielid.id,materialentry.materielid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIdSet)}, null);
        for (Object d : query) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("biztype", (Object)d.getString("biztype.number"));
            jSONObject.put("userorg", (Object)d.getString("org.id"));
            jSONObject.put("materialid", (Object)d.getString("materialentry.materielid.id"));
            matIdNameMap.put(d.getString("materialentry.materielid.id"), d.getString("materialentry.materielid.name"));
            batInvok.add(jSONObject);
        }
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"MaterialInspectService", (String)"ckInspectInfoBatch", (Object[])new Object[]{batInvok});
        if (resMap != null && !resMap.isEmpty()) {
            for (Map.Entry entry : resMap.entrySet()) {
                JSONObject rjso = (JSONObject)entry.getValue();
                if (!rjso.getBoolean("successful").booleanValue()) {
                    errMat.put(rjso.getString("materialid"), matIdNameMap.get(rjso.getString("materialid")));
                    continue;
                }
                sucMat.put(rjso.getString("materialid"), matIdNameMap.get(rjso.getString("materialid")));
            }
        }
        if (!errMat.isEmpty()) {
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u672a\u8bbe\u7f6e\u53ef\u7528\u7684\u201c\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u201d\uff0c\u6216\u201c\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u201d\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"InSpecCommonbotp_1", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
            e.setCustFilterExpression(" materielid.id in (" + String.join((CharSequence)",", sucMat.keySet()) + ")");
            QFilter qFilter = new QFilter("materielid.id", "in", sucMat.keySet());
            e.getCustQFilters().add(qFilter);
        }
    }

    private void sychoJoinInspect(AfterConvertEventArgs e) {
        String inspBillEntity = this.getTgtMainType().getName();
        JoinInspectEntityModel entityModel = JoinInspectHelper.getEntityModel((String)inspBillEntity);
        if (null == entityModel) {
            return;
        }
        String applyBillEntity = this.getSrcMainType().getName();
        if (!StringUtils.equalsIgnoreCase((CharSequence)entityModel.getApplyBill(), (CharSequence)applyBillEntity)) {
            return;
        }
        ExtendedDataEntity[] targets = e.getTargetExtDataEntitySet().FindByEntityKey(inspBillEntity);
        List<DynamicObject> targetList = Arrays.stream(targets).map(x -> x.getDataEntity()).collect(Collectors.toList());
        DynamicObject[] inspects = targetList.toArray(new DynamicObject[0]);
        Map applyIds = JoinInspectHelper.getApplyBillEntryMap((DynamicObject[])inspects, (JoinInspectEntityModel)entityModel);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityModel.getApplyBill(), (Long[])applyIds.keySet().toArray(new Long[0]));
        if (!targetBills.containsKey(entityModel.getJoinInspectBill())) {
            return;
        }
        Set joinInspectBills = (Set)targetBills.get(entityModel.getJoinInspectBill());
        HashSet srcEntryIds = new HashSet(16);
        applyIds.values().forEach(srcEntryIds::addAll);
        DynamicObject[] joinInspects = JoinInspectHelper.getInspectInfoCommon((String)entityModel.getJoinInspectBill(), (Set)joinInspectBills, null, srcEntryIds, (String)"C", (String[])new String[0]);
        JoinInspectHelper.joinInspectToInspect((DynamicObject[])joinInspects, (DynamicObject[])inspects, (JoinInspectEntityModel)entityModel);
    }
}

