/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.botp;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class InspecApplyCommonBotp
extends AbstractConvertPlugIn {
    private static final String INSPECORG = "inspecorg";
    private static final String ORG = "org";

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        this.materialcfgCheck(e);
        super.beforeBuildRowCondition(e);
    }

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        DynamicObject targetDataEntity;
        ConvertOpType opType = this.getOpType();
        if (opType == ConvertOpType.BeforeDraw && (targetDataEntity = e.getTargetDataEntity()) != null) {
            DynamicObject obj = targetDataEntity.getDynamicObject(INSPECORG);
            DynamicObject objbiz = targetDataEntity.getDynamicObject("biztype");
            QFilter qFilter = new QFilter("biztype", "=", objbiz.getPkValue());
            if (obj != null) {
                qFilter.and(new QFilter(ORG, "=", obj.getPkValue()));
            }
            e.setPlugFilter(qFilter);
        }
    }

    private void materialcfgCheck(BeforeBuildRowConditionEventArgs e) {
        List selectedRows = e.getSelectedRows();
        HashSet<Long> pkIdSet = new HashSet<Long>(selectedRows.size());
        ArrayList<JSONObject> batInvok = new ArrayList<JSONObject>(selectedRows.size());
        HashMap errMat = new HashMap(selectedRows.size());
        HashMap sucMat = new HashMap(selectedRows.size());
        HashMap<String, String> matIdNameMap = new HashMap<String, String>(selectedRows.size());
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long pkVal = (Long)listSelectedRow.getPrimaryKeyValue();
            pkIdSet.add(pkVal);
        }
        if (pkIdSet.isEmpty()) {
            return;
        }
        String srcMainType = this.getSrcMainType().getName();
        DynamicObjectCollection query = QueryServiceHelper.query((String)srcMainType, (String)srcMainType, (String)"biztype.number,org.id,materialentry.materielid.id,materialentry.materielid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIdSet)}, null);
        for (Object d : query) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("biztype", (Object)d.getString("biztype.number"));
            jSONObject.put("userorg", (Object)d.getString("org.id"));
            jSONObject.put("materialid", (Object)d.getString("materialentry.materielid.id"));
            matIdNameMap.put(d.getString("materialentry.materielid.id"), d.getString("materialentry.materielid.name"));
            batInvok.add(jSONObject);
        }
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"MaterialInspectService", (String)"ckInspectInfoBatch", (Object[])new Object[]{batInvok});
        if (resMap != null && !resMap.isEmpty()) {
            for (Map.Entry entry : resMap.entrySet()) {
                JSONObject rjso = (JSONObject)entry.getValue();
                if (!rjso.getBoolean("successful").booleanValue()) {
                    errMat.put(rjso.getString("materialid"), matIdNameMap.get(rjso.getString("materialid")));
                    continue;
                }
                sucMat.put(rjso.getString("materialid"), matIdNameMap.get(rjso.getString("materialid")));
            }
        }
        if (!errMat.isEmpty()) {
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u672a\u8bbe\u7f6e\u53ef\u7528\u7684\u201c\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u201d\uff0c\u6216\u201c\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u201d\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"InspecApplyCommonBotp_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
            e.setCustFilterExpression(" materielid.id in (" + String.join((CharSequence)",", sucMat.keySet()) + ")");
            QFilter qFilter = new QFilter("materielid.id", "in", sucMat.keySet());
            e.getCustQFilters().add(qFilter);
        }
    }
}

