/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.botp;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCommonHelper;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;

public class JoinInspecCommonBotp
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        List selectedRows = e.getSelectedRows();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            if ("C".equals(listSelectedRow.getBillStatus())) continue;
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"JoinInspecCommonBotp_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
            e.setCustFilterExpression(" billstatus ='C' ");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
            e.getCustQFilters().add(qFilter);
            break;
        }
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        long curLoginOrgId = RequestContext.get().getOrgId();
        boolean hasQcBiz = OrgUnitServiceHelper.checkOrgFunction((Long)curLoginOrgId, (String)"06");
        for (DynamicObject billObj : sourceRows) {
            billObj.set((IDataEntityProperty)fldProperties.get("inspecorg"), null);
            if (!hasQcBiz) continue;
            billObj.set((IDataEntityProperty)fldProperties.get("inspecorg"), (Object)curLoginOrgId);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        Long curLoginOrgId = RequestContext.get().getOrgId();
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = targetExtDataEntitySet.FindByEntityKey(targetEntityNumber)) {
            DynamicObject dataEntity = billDataEntity.getDataEntity();
            dataEntity.set("org", (Object)curLoginOrgId);
            DynamicObjectCollection matEntrys = dataEntity.getDynamicObjectCollection("matintoentity");
            String rule = InspectCommonHelper.getSampNumRule((DynamicObject)dataEntity);
            for (DynamicObject matEntry : matEntrys) {
                DynamicObjectCollection subProjEntrys = matEntry.getDynamicObjectCollection("inspsubentity");
                this.setProjectSample(subProjEntrys, matEntry, rule);
                Optional<BigDecimal> maxProjSampQtyOpt = subProjEntrys.stream().map(o -> o.getBigDecimal("projsampqty")).max(Comparator.naturalOrder());
                maxProjSampQtyOpt.ifPresent(maxProjSampQty -> matEntry.set("rinsqty", maxProjSampQty));
            }
        }
    }

    private void setProjectSample(DynamicObjectCollection subProjEntrys, DynamicObject matEntry, String rule) {
        BigDecimal qty = matEntry.getBigDecimal("materialqty");
        DynamicObject unitObj = matEntry.getDynamicObject("unit");
        for (DynamicObject subProjEntry : subProjEntrys) {
            DynamicObject projSamp = subProjEntry.getDynamicObject("projsamp");
            if (!Objects.nonNull(projSamp)) continue;
            CkSampleCaleModel sampleModel = new CkSampleCaleModel(projSamp, qty, unitObj, rule);
            sampleModel.setSampeSchemObj(projSamp);
            CkSampleCaleResModel sampleResModel = InspectBillSampleHelper.getSampleInfo((CkSampleCaleModel)sampleModel);
            subProjEntry.set("projsamp", (Object)sampleResModel.getSampleSchemObj());
            subProjEntry.set("projsampqty", (Object)sampleResModel.getRinsQty());
            subProjEntry.set("projacceptqty", (Object)sampleResModel.getAcceptyQty());
        }
    }
}

