/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.qmc.qcbd.common.enums.BizTypeEnum;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class BizTypeHelper {
    private static final String BIZTYPE = "biztype";
    private static final Map<Long, Set<Long>> bizTypeReflex = new HashMap<Long, Set<Long>>(16);

    public static void biztypeChange(Object oldValue, AbstractBillPlugIn abp) {
        if (oldValue != null) {
            abp.getPageCache().put("biztypetmp", ((DynamicObject)oldValue).getPkValue().toString());
        } else {
            abp.getPageCache().put("biztypetmp", null);
        }
        ConfirmCallBackListener listener = new ConfirmCallBackListener("biztypeChange", (IFormPlugin)abp);
        abp.getView().showConfirm(ResManager.loadKDString((String)"\u6539\u53d8\u4e1a\u52a1\u7c7b\u578b\u5c06\u6e05\u7a7a\u5355\u636e\u4f53\u7269\u6599\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InSpecBillCommon_5", (String)"qmc-qcbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
    }

    public static boolean bizTypeCheck(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject billType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"billtype");
        DynamicObject bizType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)BIZTYPE);
        if (null == billType || null == bizType) {
            return false;
        }
        Long billTypeId = billType.getLong("id");
        Long bizTypeId = bizType.getLong("id");
        if (!bizTypeReflex.containsKey(billTypeId)) {
            BillEntityType entityType = (BillEntityType)model.getDataEntityType();
            Set<Long> bizTypes = BizTypeHelper.getAllBizTypes(view.getEntityId(), billTypeId, entityType.getBillTypePara());
            bizTypeReflex.put(billTypeId, bizTypes);
        }
        return bizTypeReflex.get(billTypeId).contains(bizTypeId);
    }

    public static void selectBizType(IDataModel model, IFormView view, ListShowParameter showParameter) {
        BillEntityType entityType = (BillEntityType)model.getDataEntityType();
        DynamicObject billtypeObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"billtype");
        if (null == billtypeObj) {
            QFilter qFilter = new QFilter("id", "=", (Object)-1L);
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
        Long billId = billtypeObj.getLong("id");
        Set<Long> allBizTypes = BizTypeHelper.getAllBizTypes(view.getEntityId(), billId, entityType.getBillTypePara());
        QFilter qFilter = new QFilter("id", "in", allBizTypes);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public static void selectBizType(DynamicObject dataEntity, ListShowParameter showParameter) {
        DynamicObject billtypeObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)dataEntity, (String)"billtype");
        if (null == billtypeObj) {
            QFilter qFilter = new QFilter("id", "=", (Object)-1L);
            showParameter.getListFilterParameter().setFilter(qFilter);
            return;
        }
        Long billId = billtypeObj.getLong("id");
        String billTypePara = ((BillEntityType)dataEntity.getDynamicObjectType()).getBillTypePara();
        String entityId = dataEntity.getDataEntityType().getName();
        Set<Long> allBizTypes = BizTypeHelper.getAllBizTypes(entityId, billId, billTypePara);
        QFilter qFilter = new QFilter("id", "in", allBizTypes);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public static Set<Long> getAllBizTypes(String formId, Long billTypeId, String paramFormId) {
        Object bizTypes;
        Set<Long> bizTypeSet = new HashSet<Long>(16);
        if (StringUtils.isNotEmpty((CharSequence)formId) && null != billTypeId && StringUtils.isNotEmpty((CharSequence)paramFormId) && null != (bizTypes = BizTypeHelper.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity")) && bizTypes instanceof DynamicObjectCollection) {
            bizTypeSet = ((DynamicObjectCollection)bizTypes).stream().map(dym -> dym.getLong("biztypenumber.id")).collect(Collectors.toSet());
        }
        return bizTypeSet;
    }

    public static Long getDefaultBizType(String formId, Long billTypeId, String paramFormId) {
        if (StringUtils.isEmpty((CharSequence)formId) || null == billTypeId || StringUtils.isEmpty((CharSequence)paramFormId)) {
            return 0L;
        }
        Object bizTypes = BizTypeHelper.getBillTypeParameter(formId, billTypeId, paramFormId, "entryentity");
        if (null != bizTypes && bizTypes instanceof DynamicObjectCollection) {
            DynamicObjectCollection bizTypeCollection = (DynamicObjectCollection)bizTypes;
            if (bizTypeCollection.isEmpty()) {
                return 0L;
            }
            Optional<DynamicObject> defaultOption = bizTypeCollection.stream().filter(x -> x.getBoolean("isdefault")).findFirst();
            if (defaultOption.isPresent()) {
                return defaultOption.get().getLong("biztypenumber.id");
            }
            return ((DynamicObject)bizTypeCollection.get(0)).getLong("biztypenumber.id");
        }
        return 0L;
    }

    public static Object getBillTypeParameter(String formId, Long billTypeId, String paramFormId, String propertyName) {
        if (StringUtils.isNotEmpty((CharSequence)formId) && null != billTypeId && StringUtils.isNotEmpty((CharSequence)paramFormId) && StringUtils.isNotEmpty((CharSequence)propertyName)) {
            DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
            return null != billTypeParam ? billTypeParam.get(propertyName) : null;
        }
        return null;
    }

    public static void qrouteDeal(IFormView view) {
        IDataModel model = view.getModel();
        Object value = model.getValue(BIZTYPE);
        if (value == null) {
            return;
        }
        DynamicObject bizTypeObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)BIZTYPE);
        String number = bizTypeObj.getString("number");
        if (StringQMCUtil.inside((String)number, (String[])new String[]{"qcpp-001", "qcpp-003", "qcpp-005_S", "qcpp-006_S"}).booleanValue()) {
            view.setVisible(Boolean.valueOf(true), new String[]{"qroute", "qroutename", "productionworkshop", "processseq", "operationno", "oproperation", "oproperationname", "oprworkcenter", "operationdesc"});
            view.setVisible(Boolean.valueOf(false), new String[]{"oprworkshop"});
        } else if (BizTypeEnum.QCPP_004.getValue().equals(number)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"qroute", "qroutename", "productionworkshop", "processseq", "operationno", "oproperation", "oproperationname", "oprworkcenter", "operationdesc"});
            view.setVisible(Boolean.valueOf(true), new String[]{"oprworkshop"});
        } else if (!bizTypeObj.getBoolean("ispreset")) {
            view.setVisible(Boolean.valueOf(true), new String[]{"qroute", "qroutename", "productionworkshop", "processseq", "operationno", "oproperation", "oproperationname", "oprworkcenter", "operationdesc", "oprworkshop"});
        }
    }
}

