/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.qmc.qcbd.business.commonmodel.helper.inspect.InspectServiceHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCommonHelper;
import kd.qmc.qcbd.common.constant.basedata.inspectstd.InspectstdConst;
import kd.qmc.qcbd.common.model.InspectProjModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.BigDecimalUtil;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.DynamicObjUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class InspectStdHelper {
    public static void setProjEntryByStd(DynamicObject inspectStd, DynamicObjectCollection projEntrys, InspectProjModel projModel, boolean isJoinInspect) {
        if (Objects.isNull(inspectStd)) {
            return;
        }
        DynamicObjectCollection stdEntrys = inspectStd.getDynamicObjectCollection("entryentity");
        if (isJoinInspect) {
            stdEntrys.removeIf(o -> !o.getBoolean("isjoininspect"));
        }
        if (!CollectionUtils.isEmpty((Collection)stdEntrys)) {
            for (int i = 0; i < stdEntrys.size(); ++i) {
                DynamicObject inspsubEntry = projEntrys.addNew();
                InspectStdHelper.setRow(projModel, (DynamicObject)stdEntrys.get(i), inspsubEntry, i);
            }
        }
    }

    public static void inspectStdAfterF7(ListSelectedRowCollection selectedRowColls, DynamicObjectCollection projEntrys, InspectProjModel projModel, boolean isNotAllSelected) {
        Set pkValues = Arrays.stream(selectedRowColls.getPrimaryKeyValues()).map(o -> Long.valueOf(o.toString())).collect(Collectors.toSet());
        HashSet entryPkValues = (HashSet)Arrays.stream(selectedRowColls.getEntryPrimaryKeyValues()).collect(Collectors.toSet());
        String selectFields = "isjoininspect,checkitems,unit,checkcontent,checkmethod,checkbasis,checkinstruct,checkfreq,keyquality,normtype,matchflag,specvalue,topvalue,downvalue,projsamp";
        QFilter qFilter = new QFilter("id", "in", pkValues);
        DynamicObject[] inspectStds = BusinessDataServiceHelper.load((String)"qcbd_inspectionstd", (String)selectFields, (QFilter[])qFilter.toArray());
        Map<Object, DynamicObject> inspectStdsMap = Arrays.stream(inspectStds).collect(Collectors.toMap(DataEntityBase::getPkValue, item -> item, (a, b) -> a));
        for (Object id : pkValues) {
            DynamicObject inspectStd = inspectStdsMap.get(id);
            List checkItems = inspectStd.getDynamicObjectCollection("entryentity").stream().filter(o -> o.getBoolean("isjoininspect")).collect(Collectors.toList());
            for (int i = 0; i < checkItems.size(); ++i) {
                DynamicObject inspectStdEntry = (DynamicObject)checkItems.get(i);
                if (isNotAllSelected && !entryPkValues.contains(inspectStdEntry.getPkValue())) continue;
                DynamicObject inspsubEntry = projEntrys.addNew();
                InspectStdHelper.setRow(projModel, inspectStdEntry, inspsubEntry, projEntrys.size() - 1);
            }
        }
    }

    public static void setRow(InspectProjModel projModel, DynamicObject stdEntry, DynamicObject subProjEntry, int seq) {
        subProjEntry.set(projModel.getIsJoinInspectField(), stdEntry.get("isjoininspect"));
        subProjEntry.set(projModel.getCheckItemsField(), stdEntry.get("checkitems"));
        subProjEntry.set(projModel.getUnitField(), stdEntry.get("unit"));
        subProjEntry.set(projModel.getCheckContentField(), stdEntry.get("checkcontent"));
        subProjEntry.set(projModel.getCheckMethodField(), stdEntry.get("checkmethod"));
        subProjEntry.set(projModel.getCheckBasisField(), stdEntry.get("checkbasis"));
        subProjEntry.set(projModel.getCheckInstructField(), stdEntry.get("checkinstruct"));
        subProjEntry.set(projModel.getCheckFreqField(), stdEntry.get("checkfreq"));
        subProjEntry.set(projModel.getKeyQualityField(), stdEntry.get("keyquality"));
        subProjEntry.set(projModel.getNormTypeField(), stdEntry.get("normtype"));
        subProjEntry.set(projModel.getMatchFlagField(), stdEntry.get("matchflag"));
        subProjEntry.set(projModel.getSpecValueField(), stdEntry.get("specvalue"));
        DynamicObject projSamp = stdEntry.getDynamicObject("projsamp");
        if (Objects.nonNull(projSamp)) {
            projSamp = BusinessDataServiceHelper.loadSingleFromCache((Object)projSamp.getPkValue(), (String)"qcbd_sampscheme");
        }
        subProjEntry.set(projModel.getProjSampField(), (Object)projSamp);
        subProjEntry.set(projModel.getStdEntryId(), stdEntry.getPkValue());
        if (stdEntry.get("topvalue") != null || stdEntry.get("downvalue") != null) {
            subProjEntry.set(projModel.getTopValueField(), stdEntry.get("topvalue"));
            subProjEntry.set(projModel.getDownValueField(), stdEntry.get("downvalue"));
        }
        subProjEntry.set("seq", (Object)(seq + 1));
    }

    public static DynamicObjectCollection checkItemAfterF7(int curProjRowIndex, ListSelectedRowCollection selectedRowColls, DynamicObjectCollection projEntrys, InspectProjModel projModel) {
        DynamicObjectCollection returnDyos = new DynamicObjectCollection();
        Set pkValues = Arrays.stream(selectedRowColls.getPrimaryKeyValues()).map(o -> Long.valueOf(o.toString())).collect(Collectors.toSet());
        HashSet entryPkValues = (HashSet)Arrays.stream(selectedRowColls.getEntryPrimaryKeyValues()).collect(Collectors.toSet());
        boolean isNotAllSelected = InspectStdHelper.getIsNotAllSelected();
        String selectFields = "id,checkcontent,keyquality,unit,checkmethod,checkbasis,checkinstruct";
        DynamicObject[] checkItems = BusinessDataServiceHelper.load((String)"qcbd_inspectionitems", (String)selectFields, (QFilter[])new QFilter("id", "in", pkValues).toArray());
        Map<Object, DynamicObject> chcekItemsMap = Arrays.stream(checkItems).collect(Collectors.toMap(DataEntityBase::getPkValue, item -> item, (a, b) -> a));
        int m = 0;
        for (Object id : pkValues) {
            DynamicObject checkItem = chcekItemsMap.get(id);
            DynamicObjectCollection checkItemEntrys = checkItem.getDynamicObjectCollection("entryentity");
            for (DynamicObject checkItemEntry : checkItemEntrys) {
                DynamicObject projEntry;
                if (isNotAllSelected && !entryPkValues.contains(checkItemEntry.getPkValue())) continue;
                int rowIndex = curProjRowIndex + m;
                if (m < entryPkValues.size()) {
                    projEntry = (DynamicObject)projEntrys.get(rowIndex);
                } else {
                    projEntry = new DynamicObject(projEntrys.getDynamicObjectType());
                    projEntrys.add(rowIndex, projEntry);
                }
                projEntry.set(projModel.getCheckItemsField(), (Object)checkItem);
                InspectStdHelper.copyItemData(projEntry, checkItemEntry, projModel, rowIndex);
                returnDyos.add((Object)projEntry);
                ++m;
            }
        }
        int nowSize = projEntrys.size();
        for (int i = curProjRowIndex; i < nowSize; ++i) {
            ((DynamicObject)projEntrys.get(i)).set("seq", (Object)(i + 1));
        }
        return returnDyos;
    }

    private static void copyItemData(DynamicObject projEntry, DynamicObject cherkItem, InspectProjModel projModel, int rowIndex) {
        projEntry.set(projModel.getCheckContentField(), cherkItem.get("checkcontent"));
        projEntry.set(projModel.getCheckMethodField(), cherkItem.get("checkmethod"));
        projEntry.set(projModel.getCheckBasisField(), cherkItem.get("checkbasis"));
        projEntry.set(projModel.getCheckInstructField(), cherkItem.get("checkinstruct"));
        projEntry.set(projModel.getKeyQualityField(), cherkItem.get("keyquality"));
        projEntry.set(projModel.getUnitField(), cherkItem.get("unit"));
        projEntry.set("seq", (Object)(rowIndex + 1));
    }

    public static void setFilterMatchflag(BeforeF7SelectEvent event, IDataModel model, String entryKey, String fieldkey) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        QFilter qFilter = new QFilter("name", "in", (Object)new Object[]{"=", "\u2260"});
        int row = model.getEntryCurrentRowIndex(entryKey);
        if (InspectstdConst.NORMTYPEENUM.B.name().equals(model.getValue(fieldkey, row))) {
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
        showParameter.getListFilterParameter().setOrderBy("createtime");
    }

    public static void topValueChange(IDataModel model, IFormView view, BeforeFieldPostBackEvent e, DynamicObject matchflagObj, BigDecimal downValue, BigDecimal oldValue) {
        BigDecimal topValue = BigDecimalUtil.toBigDecimalNull((Object)e.getValue());
        InspectStdHelper.valueCheck(model, view, e, matchflagObj, topValue, downValue, oldValue);
    }

    public static void downValueChange(IDataModel model, IFormView view, BeforeFieldPostBackEvent e, DynamicObject matchflagObj, BigDecimal topValue, BigDecimal oldValue) {
        BigDecimal downValue = BigDecimalUtil.toBigDecimalNull((Object)e.getValue());
        InspectStdHelper.valueCheck(model, view, e, matchflagObj, topValue, downValue, oldValue);
    }

    public static void valueCheck(IDataModel model, IFormView view, BeforeFieldPostBackEvent e, DynamicObject matchflagObj, BigDecimal topValue, BigDecimal downValue, BigDecimal oldValue) {
        if (null == topValue || null == downValue) {
            return;
        }
        FieldEdit fieldEdit = (FieldEdit)e.getSource();
        String fieldKey = fieldEdit.getFieldKey();
        int rowIndex = e.getRowIndex();
        String tips = "";
        boolean isNotZeroTopAndDown = topValue.compareTo(BigDecimal.ZERO) != 0 || downValue.compareTo(BigDecimal.ZERO) != 0;
        String matchflagNumber = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)matchflagObj, (String)"number");
        if (!isNotZeroTopAndDown && matchflagNumber != null && StringQMCUtil.inside((String)matchflagNumber, (String[])new String[]{"[ )", "( ]"}).booleanValue()) {
            if ("topvalue".equals(fieldKey)) {
                tips = ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0a\u9650\u503c\uff0c\u4e0a\u9650\u503c\u548c\u4e0b\u9650\u503c\u4e0d\u80fd\u540c\u65f6\u4e3a0\u3002", (String)"InspectStdHelper_3", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]);
            } else if ("downvalue".equals(fieldKey)) {
                tips = ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0b\u9650\u503c\uff0c\u4e0a\u9650\u503c\u548c\u4e0b\u9650\u503c\u4e0d\u80fd\u540c\u65f6\u4e3a0\u3002", (String)"InspectStdHelper_4", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]);
            }
        }
        if (downValue.compareTo(topValue) >= 0 && "topvalue".equals(fieldKey) && isNotZeroTopAndDown) {
            tips = ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0a\u9650\u503c\uff0c\u4e0a\u9650\u503c\u987b\u5927\u4e8e\u4e0b\u9650\u503c\u3002", (String)"InspectStdHelper_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]);
        } else if (downValue.compareTo(topValue) >= 0 && "downvalue".equals(fieldKey) && isNotZeroTopAndDown) {
            tips = ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u4e0b\u9650\u503c\uff0c\u4e0b\u9650\u503c\u5e94\u5c0f\u4e8e\u4e0a\u9650\u503c\u3002", (String)"InspectStdHelper_1", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)tips)) {
            if (rowIndex >= 0) {
                view.updateView(fieldKey, rowIndex);
            } else {
                view.updateView(fieldKey);
            }
            view.showTipNotification(tips);
            e.setCancel(true);
        }
    }

    public static void validSpecValue(IDataModel model, IFormView view, BeforeFieldPostBackEvent e, String fieldKey) {
        String specValue;
        int rowIndex = e.getRowIndex();
        Object normType = model.getValue("normtype", rowIndex);
        if (InspectstdConst.NORMTYPEENUM.A.name().equals(normType) && StringUtils.isNotEmpty((CharSequence)(specValue = String.valueOf(e.getValue()))) && !BigDecimalUtil.stringIsDouble((String)specValue)) {
            e.setCancel(true);
            view.updateView(fieldKey, rowIndex);
            view.showTipNotification(ResManager.loadKDString((String)"\u5b9a\u91cf\u6307\u6807\u7c7b\u578b\u65f6\uff0c\u6807\u51c6\u503c\u53ea\u80fd\u8f93\u5165\u6570\u503c\u3002", (String)"InspectStdHelper_2", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]));
        }
    }

    public static void dealSpecValue(IDataModel model, IFormView view, Object newValue, String fieldKey, int rowIndex) {
        Object normType = model.getValue("normtype", rowIndex);
        String specValue = String.valueOf(newValue);
        String formatSpecValue = BigDecimalUtil.parserBigDecimalStr((String)specValue, (int)10);
        if (InspectstdConst.NORMTYPEENUM.B.name().equals(normType) || StringUtils.isEmpty((CharSequence)specValue) || formatSpecValue.equals(specValue)) {
            return;
        }
        model.beginInit();
        model.setValue(fieldKey, (Object)formatSpecValue, rowIndex);
        model.endInit();
        view.updateView(fieldKey, rowIndex);
    }

    public static void inspectionstdChange(DynamicObject pcDataEntity, IFormView view, Object inspectionStdNew, int matRowIndex) {
        InspectStdHelper.inspectionstdChange(pcDataEntity, view, inspectionStdNew, matRowIndex, false);
    }

    public static void inspectionstdChange(DynamicObject pcDataEntity, IFormView view, Object inspectionStdNew, int matRowIndex, boolean filterJoinInsp) {
        DynamicObject matRow = (DynamicObject)pcDataEntity.getDynamicObjectCollection("matintoentity").get(matRowIndex);
        DynamicObjectCollection inspSubEntry = matRow.getDynamicObjectCollection("inspsubentity");
        DynamicObject inspectionstd = (DynamicObject)inspectionStdNew;
        inspSubEntry.clear();
        if (null != inspectionstd) {
            DynamicObjectCollection stdEntry = inspectionstd.getDynamicObjectCollection("entryentity");
            if (filterJoinInsp) {
                stdEntry.removeIf(x -> !x.getBoolean("isjoininspect"));
            }
            Set inspProjSampidSet = stdEntry.stream().filter(x -> null != x.getDynamicObject("projsamp")).map(x -> x.getDynamicObject("projsamp").getLong("id")).collect(Collectors.toSet());
            Map sampSchemeMap = BusinessDataServiceHelper.loadFromCache((Object[])inspProjSampidSet.toArray(), (String)"qcbd_sampscheme");
            int size = stdEntry.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject stdRow = (DynamicObject)stdEntry.get(i);
                DynamicObject inspsubRow = inspSubEntry.addNew();
                InspectBillHelper.setStandardProjectRow((DynamicObject)stdRow, (DynamicObject)inspsubRow, (int)(i + 1));
                inspsubRow.set("projsamp", sampSchemeMap.get(DynamicObjUtil.getLongId((DynamicObject)inspsubRow.getDynamicObject("projsamp"))));
                InspectStdHelper.setProjectSample(matRow, inspsubRow, pcDataEntity);
            }
        }
        if (null != view) {
            IDataModel model = view.getModel();
            model.updateEntryCache(inspSubEntry);
            view.updateView("inspsubentity");
        }
        InspectServiceHelper.clearExampleInfo(matRow, view);
    }

    private static void setProjectSample(DynamicObject matRow, DynamicObject inspsubRow, DynamicObject pcDataEntity) {
        CkSampleCaleResModel sampleResModel = new CkSampleCaleResModel();
        DynamicObject projSamp = inspsubRow.getDynamicObject("projsamp");
        if (Objects.nonNull(projSamp)) {
            String rule = InspectCommonHelper.getSampNumRule((DynamicObject)pcDataEntity);
            DynamicObject unit = matRow.containsProperty("unitfield") ? matRow.getDynamicObject("unitfield") : matRow.getDynamicObject("unit");
            CkSampleCaleModel sampleModel = new CkSampleCaleModel(projSamp, matRow.getBigDecimal("materialqty"), unit, rule);
            sampleResModel = InspectBillSampleHelper.getSampleInfo((CkSampleCaleModel)sampleModel);
        }
        BigDecimal rinsqty = matRow.getBigDecimal("rinsqty");
        sampleResModel.setSampleSize(rinsqty);
        InspectBillSampleHelper.setCKProjectSampleRow((DynamicObject)matRow, (DynamicObject)inspsubRow, (CkSampleCaleResModel)sampleResModel);
    }

    private static boolean getIsNotAllSelected() {
        boolean result = false;
        RequestContext rc = RequestContext.get();
        long userId = rc.getCurrUserId();
        Object ismergerows = ParameterHelper.getListOption((long)userId, (String)"qcbd_inspectionstd", (String)"bos_listoptiontpl", null, (String)"ismergerows");
        if (Objects.nonNull(ismergerows)) {
            result = (Boolean)ismergerows;
        }
        return result;
    }
}

