/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class LotNumberHelper {
    public static void lotnumberEnable(IDataModel model, IFormView view, DynamicObject materialInfo, int rowIndex, Boolean isChange) {
        if (Objects.isNull(materialInfo)) {
            return;
        }
        Object matPk = materialInfo.getPkValue();
        HashSet<Long> materialidSet = new HashSet<Long>(1);
        materialidSet.add((Long)matPk);
        Map<Object, DynamicObject> materialInvInfoMap = LotNumberHelper.getMaterialInvInfoMap(materialidSet);
        DynamicObject materialInvInfo = materialInvInfoMap.get(matPk);
        LotNumberHelper.updateModelAndView(model, view, materialInvInfo, rowIndex, isChange);
    }

    private static void updateModelAndView(IDataModel model, IFormView view, DynamicObject materialInvInfo, int rowIndex, Boolean isChange) {
        if (isChange.booleanValue()) {
            model.setValue("lotnumber", null, rowIndex);
        }
        if (null != materialInvInfo) {
            view.setEnable(Boolean.valueOf(materialInvInfo.getBoolean("enablelot")), rowIndex, new String[]{"lotnumber"});
        } else {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
        }
    }

    public static void lotnumberEntryGridBind(IDataModel model, IFormView view, EntryGridBindDataEvent e, String entryKey, String matKey) {
        EntryGrid entryGrid;
        if (e.getSource() != null && entryKey.equals((entryGrid = (EntryGrid)e.getSource()).getEntryKey())) {
            Map<Object, DynamicObject> materialInvInfoMap = LotNumberHelper.getMaterialInvInfo(e.getRows(), matKey);
            for (RowDataEntity rowDataEntity : e.getRows()) {
                int rowIndex = rowDataEntity.getRowIndex();
                DynamicObject rowDy = rowDataEntity.getDataEntity();
                if (rowDy == null || rowDy.getDynamicObject(matKey) == null) continue;
                Long materialID = rowDy.getDynamicObject(matKey).getLong("id");
                LotNumberHelper.updateModelAndView(model, view, materialInvInfoMap.get(materialID), rowIndex, Boolean.FALSE);
            }
        }
    }

    public static boolean lotnumberCheck(DynamicObject materialInfo) {
        DynamicObject materialInvInfo;
        return materialInfo != null && null != (materialInvInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (String)"enablelot", (QFilter[])new QFilter("masterid", "=", materialInfo.getPkValue()).toArray())) && materialInvInfo.getBoolean("enablelot");
    }

    public static Map<Object, DynamicObject> getMaterialInvInfoMap(Set<Long> materialidSet) {
        HashMap<Object, DynamicObject> mapMaterial = new HashMap<Object, DynamicObject>(16);
        if (materialidSet.size() <= 0 || materialidSet == null) {
            return mapMaterial;
        }
        QFilter qfilters = new QFilter("masterid", "in", materialidSet);
        qfilters.and("status", "=", (Object)"C");
        qfilters.and("enable", "=", (Object)"1");
        HashSet<String> propSet = new HashSet<String>(10);
        propSet.add("masterid");
        propSet.add("enablelot");
        Map mapMaterialInvInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)StringQMCUtil.getFieldStr(propSet), (QFilter[])qfilters.toArray(), null);
        for (Map.Entry entry : mapMaterialInvInfo.entrySet()) {
            DynamicObject coll = (DynamicObject)entry.getValue();
            DynamicObject materialObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)coll, (String)"masterid");
            if (materialObj == null) continue;
            mapMaterial.put(materialObj.getPkValue(), coll);
        }
        return mapMaterial;
    }

    public static Map<Object, DynamicObject> getMaterialInvInfo(List<RowDataEntity> rows, String matKey) {
        HashSet<Long> materialidSet = new HashSet<Long>();
        for (RowDataEntity rowDataEntity : rows) {
            DynamicObject rowDy = rowDataEntity.getDataEntity();
            if (rowDy == null) continue;
            Long srcbillid = rowDy.getLong("srcbillid");
            if (rowDy.getDynamicObject(matKey) == null || srcbillid == null || srcbillid > 0L) continue;
            materialidSet.add(rowDy.getDynamicObject(matKey).getLong("id"));
        }
        Map<Object, DynamicObject> materialInvInfoMap = LotNumberHelper.getMaterialInvInfoMap(materialidSet);
        return materialInvInfoMap;
    }
}

