/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.qmc.qcbd.common.util.DynamicObjDataUtil;
import kd.qmc.qcbd.common.util.StringQMCUtil;

public class RouteProccMatchHelper {
    public static void matchRouteProccEntry(DynamicObject[] dataEntities, String entryEntity) {
        Date now = KDDateUtils.now();
        String proplk = entryEntity + "_lk";
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection(entryEntity);
            for (DynamicObject entryRow : entryRows) {
                RouteProccMatchHelper.setMatchRouteProcc(now, entryRow, proplk);
            }
        }
    }

    private static void setMatchRouteProcc(Date now, DynamicObject entryRow, String proplk) {
        String srcbillid;
        DynamicObjectCollection lkRows;
        Long routeProcObj = DynamicObjDataUtil.getDynamicObjectLongData((DynamicObject)entryRow, (String)"route_procentryid");
        DynamicObject qrouteObj = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryRow, (String)"qroute");
        String processseq = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entryRow, (String)"processseq");
        String operationno = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entryRow, (String)"operationno");
        if (routeProcObj != null && routeProcObj != 0L) {
            return;
        }
        if (qrouteObj == null || StringUtils.isBlank((CharSequence)processseq) || StringUtils.isBlank((CharSequence)operationno)) {
            return;
        }
        Boolean ispush = Boolean.FALSE;
        DataEntityPropertyCollection colls = entryRow.getDynamicObjectType().getProperties();
        if (colls.containsKey((Object)proplk) && (lkRows = entryRow.getDynamicObjectCollection(proplk)).size() > 0) {
            ispush = Boolean.TRUE;
        }
        if (colls.containsKey((Object)"srcbillid") && StringUtils.isNotBlank((CharSequence)(srcbillid = entryRow.getString("srcbillid"))) && !StringUtils.equalsIgnoreCase((CharSequence)srcbillid, (CharSequence)"0")) {
            ispush = Boolean.TRUE;
        }
        if (ispush.booleanValue()) {
            return;
        }
        DynamicObject routeProc = RouteProccMatchHelper.getMatchRouteEntry(now, qrouteObj, processseq, operationno);
        if (routeProc != null) {
            DataEntityPropertyCollection props = entryRow.getDataEntityType().getProperties();
            if (props.containsKey((Object)"route_procentryid")) {
                entryRow.set("route_procentryid", (Object)routeProc.getLong("route_procentryid"));
            }
            if (props.containsKey((Object)"srcopentryid")) {
                entryRow.set("srcopentryid", (Object)routeProc.getLong("srcopentryid"));
            }
        }
    }

    public static DynamicObject getMatchRouteEntry(Date now, DynamicObject qrouteObj, String processseq, String operationno) {
        QFilter qfilters = new QFilter("routeid", "=", qrouteObj.getPkValue());
        qfilters.and("operationno", "=", (Object)operationno);
        qfilters.and("parent", "=", (Object)processseq);
        qfilters.and("entryvaliddate", "<=", (Object)now);
        qfilters.and("entryinvaliddate", ">", (Object)now);
        String selectProp = StringQMCUtil.getCombStr((String)",", (String[])new String[]{"procentryid", "route_procentryid", "srcopentryid"});
        DynamicObject routEntry = null;
        DynamicObjectCollection routEntrys = QueryServiceHelper.query((String)"qcbd_qmcroute_procentry", (String)selectProp, (QFilter[])qfilters.toArray());
        if (routEntrys.size() > 0) {
            routEntry = (DynamicObject)routEntrys.get(0);
        }
        return routEntry;
    }
}

