/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.qmc.qcbd.common.enums.SuspiciousStatusEnum;
import kd.qmc.qcbd.common.enums.SuspiciousValidateRuleEnum;
import kd.qmc.qcbd.common.util.DynamicObjUtil;

public class SuspiciousValidateHelper {
    public static void validateSuspicious(IFormView view, DynamicObject dataEntity, int rowIndex, String ... valName) {
        Set<String> varSet = SuspiciousValidateHelper.getValidateRule(dataEntity);
        if (varSet == null || varSet.size() == 0) {
            return;
        }
        boolean flag = false;
        for (String s : valName) {
            if (!varSet.contains(s)) continue;
            flag = true;
            break;
        }
        if (flag) {
            SuspiciousValidateHelper.valSuspicious(view, dataEntity, rowIndex, varSet);
        }
    }

    public static void valSuspicious(IFormView view, DynamicObject dataEntity, int rowIndex, Set<String> validateRuleSet) {
        SuspiciousValidateHelper suspiciousValidate = new SuspiciousValidateHelper();
        List<String> checkList = suspiciousValidate.setValidateFields(validateRuleSet);
        DynamicObjectCollection matEntity = dataEntity.getDynamicObjectCollection("matintoentity");
        Set<String> checkSet = suspiciousValidate.checkSuspicious(dataEntity, validateRuleSet);
        DynamicObject entryObj = (DynamicObject)matEntity.get(rowIndex);
        if (entryObj == null) {
            return;
        }
        String onlyObjStr = DynamicObjUtil.getOnlyObjStr((DynamicObject)entryObj, checkList);
        if (checkSet != null && checkSet.contains(onlyObjStr)) {
            entryObj.set("suspiciousstatus", (Object)SuspiciousStatusEnum.SUSPICIOUS.getValue());
        } else {
            entryObj.set("suspiciousstatus", (Object)SuspiciousStatusEnum.NON_SUSPICIOUS.getValue());
        }
        if (Objects.nonNull(view)) {
            view.updateView("suspiciousstatus", rowIndex);
        }
    }

    public Set<String> checkSuspicious(DynamicObject dynamicObject, Set<String> validateRuleSet) {
        QFilter[] qFilters;
        Long org = dynamicObject.getLong("org.id");
        if (validateRuleSet == null || validateRuleSet.isEmpty()) {
            return null;
        }
        List<String> checkList = this.setValidateFields(validateRuleSet);
        HashSet<String> checkSet = new HashSet<String>(16);
        if (validateRuleSet.contains(SuspiciousValidateRuleEnum.ORG.getValue())) {
            qFilters = new QFilter[]{new QFilter("createorg.id", "=", (Object)org), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        } else {
            QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"qcbd_suspicious", (Long)org);
            qfilter.and("status", "=", (Object)"C");
            qfilter.and("enable", "=", (Object)Boolean.TRUE);
            qFilters = qfilter.toArray();
        }
        String selectFields = "id,status,createorg.id,entryentity.material.id as materialid.id,entryentity.material.number as materialid.number,entryentity.material.name as materialid.name,entryentity.supplier.id as supplier.id,entryentity.batchno as lotnumber";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SuspiciousValidate", (String)"qcbd_suspicious", (String)selectFields, (QFilter[])qFilters, null);){
            for (Row ds : dataSet) {
                String onlyObjStr = DynamicObjUtil.getOnlyRowStr((Row)ds, checkList);
                checkSet.add(onlyObjStr);
            }
        }
        return checkSet;
    }

    public List<String> setValidateFields(Set<String> paras) {
        ArrayList<String> validateList = new ArrayList<String>(10);
        for (String para : paras) {
            if (SuspiciousValidateRuleEnum.MATERIAL.getValue().equals(para)) {
                validateList.add("materialid.id");
                continue;
            }
            if (SuspiciousValidateRuleEnum.MATERIAL_NUMBER.getValue().equals(para)) {
                validateList.add("materialid.number");
                continue;
            }
            if (SuspiciousValidateRuleEnum.SUPPLIER.getValue().equals(para)) {
                validateList.add("supplier.id");
                continue;
            }
            if (SuspiciousValidateRuleEnum.LOTNUMBER.getValue().equals(para)) {
                validateList.add("lotnumber");
                continue;
            }
            if (!SuspiciousValidateRuleEnum.PN.getValue().equals(para)) continue;
            validateList.add("materialid.name");
        }
        return validateList;
    }

    public static Set<String> getValidateRule(DynamicObject billObj) {
        HashSet<String> valRuleSet = new HashSet<String>();
        String validateRule = billObj.getString("transactype.suspiciousrule");
        if (validateRule == null || validateRule.isEmpty()) {
            return valRuleSet;
        }
        Collections.addAll(valRuleSet, validateRule.split(","));
        return valRuleSet;
    }
}

