/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper.inspect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.BigDecimalUtil;

public class InspectApiServiceHelper {
    public static JSONObject getJudgeRes(JSONObject requestObj, Boolean retMeasureJudge) {
        JSONObject resultObj = new JSONObject();
        resultObj.put("id", (Object)requestObj.getLong("id"));
        JSONArray measureEntry = requestObj.getJSONArray("submeasuredvalentity");
        JSONArray inspSubEntry = requestObj.getJSONArray("inspsubentity");
        if (retMeasureJudge.booleanValue()) {
            InspectApiServiceHelper.buildMeasureEntry(measureEntry, inspSubEntry, resultObj);
        }
        Map<Object, List<Object>> sampMeasureGroup = measureEntry.stream().collect(Collectors.groupingBy(x -> ((JSONObject)x).getLong("exmapleid")));
        Map<Object, List<Object>> projMeasureGroup = measureEntry.stream().collect(Collectors.groupingBy(x -> ((JSONObject)x).getString("projuuid")));
        JSONArray subSampEntry = requestObj.getJSONArray("subsampleresentity");
        int inspSize = inspSubEntry.size();
        InspectApiServiceHelper.buildSampEntryResult(sampMeasureGroup, subSampEntry, inspSize, resultObj);
        InspectApiServiceHelper.buildInspEntryResult(projMeasureGroup, inspSubEntry, resultObj);
        InspectApiServiceHelper.buildMatRowResult(requestObj, resultObj);
        return resultObj;
    }

    private static void buildMeasureEntry(JSONArray measureEntry, JSONArray inspSubEntry, JSONObject resultObj) {
        JSONArray newSubmeasureEntry = new JSONArray();
        resultObj.put("submeasuredvalentity", (Object)newSubmeasureEntry);
        HashMap<String, Boolean> inspIsJoinStatus = new HashMap<String, Boolean>(16);
        for (Object inspObj : inspSubEntry) {
            JSONObject inspSubJsonObj = (JSONObject)inspObj;
            String uquuid = inspSubJsonObj.getString("uquuid");
            boolean isJoinStatus = inspSubJsonObj.getBoolean("isjoininspect") != false && StringUtils.isNotEmpty((String)inspSubJsonObj.getString("joininspectstatus"));
            inspIsJoinStatus.put(uquuid, isJoinStatus);
        }
        for (Object measureObj : measureEntry) {
            JSONObject measureJsonObj = (JSONObject)measureObj;
            String projuuid = measureJsonObj.getString("projuuid");
            if (((Boolean)inspIsJoinStatus.get(projuuid)).booleanValue()) continue;
            JSONObject newMeasureObj = new JSONObject();
            newMeasureObj.put("projuuid", (Object)projuuid);
            newMeasureObj.put("exmapleid", (Object)measureJsonObj.getLong("exmapleid"));
            newMeasureObj.put("measuredval_judge", (Object)measureJsonObj.getString("measuredval_judge"));
            newSubmeasureEntry.add((Object)newMeasureObj);
        }
    }

    public static void buildSampEntryResult(Map<Object, List<Object>> sampMeasureGroup, JSONArray subSampEntry, int inspSize, JSONObject resultObj) {
        JSONArray subSampEntryNew = new JSONArray();
        resultObj.put("subsampleresentity", (Object)subSampEntryNew);
        for (Object subSampObj : subSampEntry) {
            JSONObject subSampJsonObj = (JSONObject)subSampObj;
            JSONObject subSampJsonObjNew = new JSONObject();
            subSampEntryNew.add((Object)subSampJsonObjNew);
            long sampleNumId = subSampJsonObj.getLong("samplenumid");
            subSampJsonObjNew.put("samplenumid", (Object)sampleNumId);
            List<Object> sampMeasureList = sampMeasureGroup.get(sampleNumId);
            long sampCount = CollectionUtils.isEmpty(sampMeasureList) ? 0L : sampMeasureList.stream().filter(x -> StringUtils.isNotEmpty((String)((JSONObject)x).getString("measuredval_deter")) || StringUtils.isNotEmpty((String)((JSONObject)x).getString("measuredval_rat"))).count();
            subSampJsonObjNew.put("sampckval", (Object)sampCount);
            if (0L == sampCount) {
                subSampJsonObjNew.put("sampleres", (Object)"");
                continue;
            }
            if (sampMeasureList.stream().anyMatch(x -> "N".equals(((JSONObject)x).getString("measuredval_judge")))) {
                subSampJsonObjNew.put("sampleres", (Object)"N");
                continue;
            }
            if (inspSize == sampMeasureList.size() && sampMeasureList.stream().allMatch(x -> "Y".equals(((JSONObject)x).getString("measuredval_judge")))) {
                subSampJsonObjNew.put("sampleres", (Object)"Y");
                continue;
            }
            subSampJsonObjNew.put("sampleres", (Object)"");
        }
    }

    private static void buildInspEntryResult(Map<Object, List<Object>> projMeasureGroup, JSONArray inspSubEntry, JSONObject resultObj) {
        JSONArray inspSubEntryNew = new JSONArray();
        resultObj.put("inspsubentity", (Object)inspSubEntryNew);
        for (Object inspSubObj : inspSubEntry) {
            JSONObject inspSubJsonObj = (JSONObject)inspSubObj;
            if (inspSubJsonObj.getBoolean("isjoininspect").booleanValue() && StringUtils.isNotEmpty((String)inspSubJsonObj.getString("joininspectstatus"))) continue;
            JSONObject inspSubJsonObjNew = new JSONObject();
            inspSubEntryNew.add((Object)inspSubJsonObjNew);
            String uqUuid = inspSubJsonObj.getString("uquuid");
            inspSubJsonObjNew.put("uquuid", (Object)uqUuid);
            List<Object> projMeasureList = projMeasureGroup.get(uqUuid);
            BigDecimal qualifyQty = new BigDecimal(CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> "Y".equals(((JSONObject)x).getString("measuredval_judge"))).count());
            inspSubJsonObjNew.put("projqualifiyqty", (Object)qualifyQty);
            BigDecimal unqualifyQty = new BigDecimal(CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> "N".equals(((JSONObject)x).getString("measuredval_judge"))).count());
            inspSubJsonObjNew.put("projunqualifiyqty", (Object)unqualifyQty);
            long chooseSampQty = CollectionUtils.isEmpty(projMeasureList) ? 0L : (long)projMeasureList.size();
            inspSubJsonObjNew.put("choosesampqty", (Object)chooseSampQty);
            long inspProjCnt = CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> StringUtils.isNotEmpty((String)((JSONObject)x).getString("measuredval_deter")) || StringUtils.isNotEmpty((String)((JSONObject)x).getString("measuredval_rat"))).count();
            inspSubJsonObjNew.put("projckval", (Object)inspProjCnt);
            InspectApiServiceHelper.setProjCkresult(inspSubJsonObj, inspSubJsonObjNew, qualifyQty, unqualifyQty);
        }
    }

    private static void setProjCkresult(JSONObject inspSubObj, JSONObject inspSubObjNew, BigDecimal qualifyQty, BigDecimal unqualifyQty) {
        BigDecimal acQty = inspSubObj.getBigDecimal("projacceptqty");
        String projckresult = "";
        BigDecimal projSampQty = inspSubObj.getBigDecimal("projsampqty");
        if (qualifyQty.add(unqualifyQty).compareTo(projSampQty) <= 0) {
            if (unqualifyQty.compareTo(acQty) > 0) {
                projckresult = "N";
            } else if (projSampQty.compareTo(BigDecimal.ZERO) > 0 && projSampQty.subtract(qualifyQty).compareTo(acQty) <= 0) {
                projckresult = "Y";
            }
        }
        inspSubObjNew.put("projckresult", (Object)projckresult);
    }

    private static void buildMatRowResult(JSONObject matRow, JSONObject newMatRow) {
        JSONArray subSampEntry = newMatRow.getJSONArray("subsampleresentity");
        BigDecimal sampQualQty = new BigDecimal(subSampEntry.stream().filter(x -> "Y".equalsIgnoreCase(((JSONObject)x).getString("sampleres"))).count());
        newMatRow.put("sampqualqty", (Object)sampQualQty);
        BigDecimal samUnqualQty = new BigDecimal(subSampEntry.stream().filter(x -> "N".equalsIgnoreCase(((JSONObject)x).getString("sampleres"))).count());
        newMatRow.put("samunqualqty", (Object)samUnqualQty);
        InspectApiServiceHelper.buildSamplingResult(matRow, newMatRow);
        InspectApiServiceHelper.setBaseqty("sampqualqty", "basesampqlyqty", matRow, newMatRow);
        InspectApiServiceHelper.setBaseqty("samunqualqty", "basesampuqlyqty", matRow, newMatRow);
    }

    public static void buildSamplingResult(JSONObject matRow, JSONObject newMatRow) {
        BigDecimal rinsQty = matRow.getBigDecimal("rinsqty");
        BigDecimal acNum = BigDecimalUtil.toBigDecimal((Object)matRow.getString("acstr"));
        BigDecimal sampQualQty = newMatRow.getBigDecimal("sampqualqty");
        BigDecimal samUnqualQty = newMatRow.getBigDecimal("samunqualqty");
        String samplingresult = "";
        if (sampQualQty.add(samUnqualQty).compareTo(rinsQty) <= 0) {
            if (samUnqualQty.compareTo(acNum) > 0) {
                samplingresult = "C";
            } else if (rinsQty.subtract(sampQualQty).compareTo(acNum) <= 0) {
                samplingresult = "B";
            }
        }
        newMatRow.put("samplingresult", (Object)samplingresult);
    }

    public static void setBaseqty(String srcField, String baseField, JSONObject matRow, JSONObject newMatRow) {
        Long materialid = matRow.getLong("materialid");
        Long unitId = matRow.getLong("unitfield");
        Long baseUnitId = matRow.getLong("baseunit");
        DynamicObject baseUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)baseUnitId, (String)"bd_measureunits");
        BigDecimal srcValue = newMatRow.getBigDecimal(srcField);
        BigDecimal baseValue = BaseUnitQtyConVertUtil.getQtyConvert((Long)materialid, (Long)unitId, (BigDecimal)srcValue, (DynamicObject)baseUnit);
        newMatRow.put(baseField, (Object)baseValue);
    }
}

