/*
 * Decompiled with CFR 0.152.
 */
package kd.qmc.qcbd.business.commonmodel.helper.inspect;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectBillSampleHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCkvalHelper;
import kd.qmc.qcbd.business.helper.inspectexecute.InspectCommonHelper;
import kd.qmc.qcbd.business.inspbill.project.CheckProjectCaleFactory;
import kd.qmc.qcbd.business.inspbill.project.ICheckProjectCaleStrategy;
import kd.qmc.qcbd.common.constant.basedata.inspectstd.InspectstdConst;
import kd.qmc.qcbd.common.model.inspbill.project.CheckProjectCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleModel;
import kd.qmc.qcbd.common.model.inspbill.project.CkSampleCaleResModel;
import kd.qmc.qcbd.common.util.BaseUnitQtyConVertUtil;
import kd.qmc.qcbd.common.util.BigDecimalUtil;

public class InspectServiceHelper {
    public static String judgmentResultMain(String compareStr, String normtype, CheckProjectCaleModel model) {
        ICheckProjectCaleStrategy strategy = CheckProjectCaleFactory.getInstance().getCkProjectStrategy(compareStr, normtype);
        return null == strategy ? "" : strategy.judgmentResultMain(model);
    }

    public static long[] getSampIds(String mainEntityId, int count) {
        return InspectCkvalHelper.getSampIds((String)mainEntityId, (int)count);
    }

    public static void refreshSampAndInsp(DynamicObject matRow, Boolean refreshMatRow) {
        DynamicObjectCollection measureEntry = matRow.getDynamicObjectCollection("submeasuredvalentity");
        InspectServiceHelper.formatMeasureEntry(measureEntry);
        Map<Long, List<DynamicObject>> sampMeasureGroup = measureEntry.stream().collect(Collectors.groupingBy(x -> x.getLong("exmapleid")));
        Map<String, List<DynamicObject>> projMeasureGroup = measureEntry.stream().collect(Collectors.groupingBy(x -> x.getString("projuuid")));
        DynamicObjectCollection subSampEntry = matRow.getDynamicObjectCollection("subsampleresentity");
        DynamicObjectCollection inspSubEntry = matRow.getDynamicObjectCollection("inspsubentity");
        int inspSize = inspSubEntry.size();
        InspectServiceHelper.refreshSampEntry(sampMeasureGroup, subSampEntry, inspSize);
        InspectServiceHelper.refreshInspEntry(projMeasureGroup, inspSubEntry);
        if (refreshMatRow.booleanValue()) {
            InspectServiceHelper.refreshMatRow(matRow, subSampEntry);
        }
    }

    public static void clearInspInfo(DynamicObject matRow, IFormView view) {
        DynamicObjectCollection inspEntrys = matRow.getDynamicObjectCollection("inspsubentity");
        int size = inspEntrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject inspEntry = (DynamicObject)inspEntrys.get(i);
            InspectServiceHelper.clearInspitemCkValInfo(inspEntry);
        }
        if (null != view) {
            IDataModel model = view.getModel();
            model.updateEntryCache(inspEntrys);
            view.updateView("inspsubentity");
        }
    }

    public static void clearExampleInfo(DynamicObject matRow, IFormView view) {
        DynamicObjectCollection subSampEntry = matRow.getDynamicObjectCollection("subsampleresentity");
        subSampEntry.clear();
        DynamicObjectCollection subMeasureEntry = matRow.getDynamicObjectCollection("submeasuredvalentity");
        subMeasureEntry.clear();
        if (null != view) {
            IDataModel model = view.getModel();
            model.updateEntryCache(subSampEntry);
            view.updateView("subsampleresentity");
            model.updateEntryCache(subMeasureEntry);
            view.updateView("submeasuredvalentity");
        }
    }

    public static void rinsQtyPropChange(DynamicObject pcDataEntity, Object rinsQty, int matRowIndex) {
        DynamicObject matRow;
        DynamicObjectCollection subSampEntry;
        int rinsQtyIntValue = 0;
        if (rinsQty instanceof BigDecimal) {
            rinsQtyIntValue = ((BigDecimal)rinsQty).intValue();
        }
        if (rinsQtyIntValue < (subSampEntry = (matRow = (DynamicObject)pcDataEntity.getDynamicObjectCollection("matintoentity").get(matRowIndex)).getDynamicObjectCollection("subsampleresentity")).size()) {
            DynamicObjectCollection inspSubEntrys = matRow.getDynamicObjectCollection("inspsubentity");
            int size = inspSubEntrys.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject inspEntry = (DynamicObject)inspSubEntrys.get(i);
                InspectServiceHelper.clearInspitemCkValInfo(inspEntry);
            }
            InspectServiceHelper.clearExampleInfo(matRow, null);
        }
    }

    public static boolean createSample(DynamicObject pcEntityFromCache, int matRowIndex) {
        DynamicObjectCollection pcSampSubEntry;
        int pcSampSize;
        boolean create;
        DynamicObject pcMatRow = (DynamicObject)pcEntityFromCache.getDynamicObjectCollection("matintoentity").get(matRowIndex);
        int rinsQty = pcMatRow.getBigDecimal("rinsqty").intValue();
        boolean bl = create = rinsQty > (pcSampSize = (pcSampSubEntry = pcMatRow.getDynamicObjectCollection("subsampleresentity")).size());
        if (create) {
            int addRowCount = rinsQty - pcSampSize;
            long[] longIds = InspectServiceHelper.getSampIds(pcEntityFromCache.getDataEntityType().getName(), addRowCount);
            for (int i = 0; i < addRowCount; ++i) {
                DynamicObject sampRow = pcSampSubEntry.addNew();
                sampRow.set("samplenumid", (Object)longIds[i]);
                sampRow.set("seq", (Object)(i + 1));
                String sampleNumPrefix = ResManager.loadKDString((String)"\u6837\u672c", (String)"MeasureValueServiceHelper_0", (String)"qmc-qcbd-business-commonmodel", (Object[])new Object[0]);
                sampRow.set("samplenum", (Object)(sampleNumPrefix + (i + pcSampSize + 1)));
            }
        }
        return create;
    }

    public static void deleteSubMeasures(DynamicObject pcDataEntity, int matRowIndex, int inspRowIndex) {
        DynamicObject matRow = (DynamicObject)pcDataEntity.getDynamicObjectCollection("matintoentity").get(matRowIndex);
        DynamicObject inspRow = (DynamicObject)matRow.getDynamicObjectCollection("inspsubentity").get(inspRowIndex);
        BigDecimal chooseSampqty = inspRow.getBigDecimal("choosesampqty");
        if (null == chooseSampqty || chooseSampqty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        String uqUuid = inspRow.getString("uquuid");
        DynamicObjectCollection subMeasureEntry = matRow.getDynamicObjectCollection("submeasuredvalentity");
        List removeList = subMeasureEntry.stream().filter(x -> uqUuid.equals(x.getString("projuuid"))).collect(Collectors.toList());
        subMeasureEntry.removeAll(removeList);
        Set sampIdSet = removeList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getString("measuredval_deter")) || StringUtils.isNotEmpty((String)x.getString("measuredval_rat"))).map(x -> x.getString("exmapleid")).collect(Collectors.toSet());
        DynamicObjectCollection sampEntry = matRow.getDynamicObjectCollection("subsampleresentity");
        for (DynamicObject sampRow : sampEntry) {
            if (!sampIdSet.contains(String.valueOf(sampRow.get("samplenumid")))) continue;
            sampRow.set("sampckval", (Object)sampRow.getBigDecimal("sampckval").subtract(BigDecimal.ONE));
        }
        InspectServiceHelper.refreshSampAndInsp(matRow, Boolean.TRUE);
    }

    public static void dealSpecValue(DynamicObject inspSubRow, String fieldKey) {
        String normType = inspSubRow.getString("normtype");
        String specValue = inspSubRow.getString("specvalue");
        String formatSpecValue = BigDecimalUtil.parserBigDecimalStr((String)specValue, (int)10);
        if (InspectstdConst.NORMTYPEENUM.B.name().equals(normType) || StringUtils.isEmpty((String)specValue) || formatSpecValue.equals(specValue)) {
            return;
        }
        inspSubRow.set(fieldKey, (Object)formatSpecValue);
    }

    public static void refreshSamplingResult(DynamicObject matRow) {
        BigDecimal samUnqualQty;
        BigDecimal rinsQty = matRow.getBigDecimal("rinsqty");
        BigDecimal acNum = BigDecimalUtil.toBigDecimal((Object)matRow.getString("acstr"));
        BigDecimal sampQualQty = matRow.getBigDecimal("sampqualqty");
        if (sampQualQty.add(samUnqualQty = matRow.getBigDecimal("samunqualqty")).compareTo(rinsQty) <= 0) {
            if (samUnqualQty.compareTo(acNum) > 0) {
                matRow.set("samplingresult", (Object)"C");
            } else if (rinsQty.subtract(sampQualQty).compareTo(acNum) <= 0) {
                matRow.set("samplingresult", (Object)"B");
            }
        }
    }

    public static void setBaseqty(String srcField, String baseField, DynamicObject matRow, Map<String, DynamicObject> cacheMap) {
        DynamicObject materialObj = matRow.getDynamicObject("materialid");
        DynamicObject unitObj = matRow.getDynamicObject("unitfield");
        DynamicObject baseUnit = matRow.getDynamicObject("baseunit");
        if (null == materialObj || null == unitObj || null == baseUnit) {
            return;
        }
        long materialid = materialObj.getLong("id");
        long unitId = unitObj.getLong("id");
        BigDecimal srcValue = matRow.getBigDecimal(srcField);
        BigDecimal baseValue = BaseUnitQtyConVertUtil.getQtyConvert((Long)materialid, (Long)unitId, (BigDecimal)srcValue, (DynamicObject)baseUnit, cacheMap);
        matRow.set(baseField, (Object)baseValue);
    }

    public static void updateSampAndProjSampQtyCommon(int matRowIndex, DynamicObject pcDataEntity, BigDecimal maxSampQty, Boolean ignoreJoinInsp) {
        DynamicObject matRow = (DynamicObject)pcDataEntity.getDynamicObjectCollection("matintoentity").get(matRowIndex);
        DynamicObject unit = matRow.containsProperty("unitfield") ? matRow.getDynamicObject("unitfield") : matRow.getDynamicObject("unit");
        BigDecimal matQty = matRow.getBigDecimal("materialqty");
        DynamicObjectCollection inspSubEntry = matRow.getDynamicObjectCollection("inspsubentity");
        String rule = InspectCommonHelper.getSampNumRule((DynamicObject)pcDataEntity);
        for (DynamicObject inspSubRow : inspSubEntry) {
            if (ignoreJoinInsp.booleanValue() && inspSubRow.getBoolean("isjoininspect") && inspSubRow.getLong("srcitementryid") > 0L) continue;
            CkSampleCaleResModel resModel = InspectCkvalHelper.getSampInfoByInspRow((DynamicObject)inspSubRow.getDynamicObject("projsamp"), (DynamicObject)unit, (BigDecimal)matQty, (String)rule);
            BigDecimal sampleSize = resModel.getRinsQty();
            inspSubRow.set("projsampqty", (Object)sampleSize);
            inspSubRow.set("projacceptqty", (Object)resModel.getAcceptyQty());
            maxSampQty = InspectCommonHelper.getMaxSampQty((BigDecimal)maxSampQty, (BigDecimal)sampleSize);
        }
        InspectServiceHelper.setRinsQty(matRow, maxSampQty);
    }

    public static void setRinsQty(DynamicObject matRow, BigDecimal maxSampQty) {
        BigDecimal rinsQty = matRow.getBigDecimal("rinsqty");
        DynamicObjectCollection subMeasures = matRow.getDynamicObjectCollection("submeasuredvalentity");
        DynamicObjectCollection inspSubEntry = matRow.getDynamicObjectCollection("inspsubentity");
        BigDecimal maxProjSampQty = inspSubEntry.stream().map(x -> x.getBigDecimal("projsampqty")).max(Comparator.comparing(x -> x)).orElse(BigDecimal.ZERO);
        if (maxSampQty.compareTo(maxProjSampQty) < 0) {
            maxSampQty = maxProjSampQty;
        }
        if (subMeasures.isEmpty()) {
            matRow.set("rinsqty", (Object)maxSampQty);
        } else if (maxSampQty.compareTo(rinsQty) > 0) {
            matRow.set("rinsqty", (Object)maxSampQty);
        } else if (maxSampQty.compareTo(rinsQty) < 0) {
            for (DynamicObject subMeasureObj : subMeasures) {
                String measureValueDeter = subMeasureObj.getString("measuredval_deter");
                if (StringUtils.isNotEmpty((String)measureValueDeter)) {
                    return;
                }
                String measureValueRat = subMeasureObj.getString("measuredval_rat");
                if (StringUtils.isNotEmpty((String)measureValueRat)) {
                    return;
                }
                String measureValueJudge = subMeasureObj.getString("measuredval_judge");
                if (StringUtils.isNotEmpty((String)measureValueJudge)) {
                    return;
                }
                String measureComment = subMeasureObj.getString("measure_comment");
                if (!StringUtils.isNotEmpty((String)measureComment)) continue;
                return;
            }
            matRow.set("rinsqty", (Object)maxSampQty);
            InspectServiceHelper.clearExampleInfo(matRow, null);
            InspectServiceHelper.clearInspInfo(matRow, null);
        }
    }

    public static CkSampleCaleResModel getSampInfoByMatRow(DynamicObject pcDataEntity, int matRowIndex) {
        CkSampleCaleResModel resModel = new CkSampleCaleResModel();
        DynamicObject matRow = (DynamicObject)pcDataEntity.getDynamicObjectCollection("matintoentity").get(matRowIndex);
        String rule = InspectCommonHelper.getSampNumRule((DynamicObject)pcDataEntity);
        Object sampScheme = matRow.get("sampscheme");
        if (sampScheme instanceof DynamicObject) {
            CkSampleCaleModel sampleModel = new CkSampleCaleModel((DynamicObject)sampScheme, matRow.getBigDecimal("materialqty"), matRow.getDynamicObject("unitfield"), rule);
            resModel = InspectBillSampleHelper.getSampleInfo((CkSampleCaleModel)sampleModel);
        }
        return resModel;
    }

    public static void setProjCkresult(DynamicObject inspSubObj, BigDecimal qualifyQty, BigDecimal unqualifyQty) {
        BigDecimal acQty = inspSubObj.getBigDecimal("projacceptqty");
        BigDecimal projSampQty = inspSubObj.getBigDecimal("projsampqty");
        if (qualifyQty.add(unqualifyQty).compareTo(projSampQty) > 0) {
            return;
        }
        if (unqualifyQty.compareTo(acQty) > 0) {
            inspSubObj.set("projckresult", (Object)"N");
        } else if (projSampQty.compareTo(BigDecimal.ZERO) > 0 && projSampQty.subtract(qualifyQty).compareTo(acQty) <= 0) {
            inspSubObj.set("projckresult", (Object)"Y");
        }
    }

    public static void refreshMatRow(DynamicObject matRow, DynamicObjectCollection subSampEntry) {
        if (!matRow.containsProperty("sampqualqty")) {
            return;
        }
        BigDecimal sampQualQty = new BigDecimal(subSampEntry.stream().filter(x -> "Y".equalsIgnoreCase(x.getString("sampleres"))).count());
        matRow.set("sampqualqty", (Object)sampQualQty);
        BigDecimal samUnqualQty = new BigDecimal(subSampEntry.stream().filter(x -> "N".equalsIgnoreCase(x.getString("sampleres"))).count());
        matRow.set("samunqualqty", (Object)samUnqualQty);
        InspectServiceHelper.refreshSamplingResult(matRow);
        HashMap<String, DynamicObject> cacheCovertQtyMap = new HashMap<String, DynamicObject>(16);
        InspectServiceHelper.setBaseqty("sampqualqty", "basesampqlyqty", matRow, cacheCovertQtyMap);
        InspectServiceHelper.setBaseqty("samunqualqty", "basesampuqlyqty", matRow, cacheCovertQtyMap);
    }

    private static void formatMeasureEntry(DynamicObjectCollection measureEntry) {
        measureEntry.removeIf(x -> -1 == x.getInt("samp_seq") && StringUtils.isEmpty((String)x.getString("measuredval_rat")) && StringUtils.isEmpty((String)x.getString("measuredval_deter")));
        HashMap<String, Integer> sampSeqMap = new HashMap<String, Integer>(16);
        int size = measureEntry.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject measureRow = (DynamicObject)measureEntry.get(i);
            measureRow.set("seq", (Object)(i + 1));
            String projuuid = measureRow.getString("projuuid");
            if (!sampSeqMap.containsKey(projuuid)) {
                sampSeqMap.put(projuuid, 0);
            }
            Integer sampSeq = (Integer)sampSeqMap.get(projuuid) + 1;
            sampSeqMap.put(projuuid, sampSeq);
            measureRow.set("samp_seq", (Object)sampSeq);
        }
    }

    private static void refreshSampEntry(Map<Long, List<DynamicObject>> sampMeasureGroup, DynamicObjectCollection subSampEntry, int inspSize) {
        for (DynamicObject subSampObj : subSampEntry) {
            long sampleNumId = subSampObj.getLong("samplenumid");
            List<DynamicObject> sampMeasureList = sampMeasureGroup.get(sampleNumId);
            long sampCount = CollectionUtils.isEmpty(sampMeasureList) ? 0L : sampMeasureList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getString("measuredval_deter")) || StringUtils.isNotEmpty((String)x.getString("measuredval_rat"))).count();
            subSampObj.set("sampckval", (Object)sampCount);
            if (0L == sampCount) {
                subSampObj.set("sampleres", (Object)"");
                continue;
            }
            if (sampMeasureList.stream().anyMatch(x -> "N".equals(x.getString("measuredval_judge")))) {
                subSampObj.set("sampleres", (Object)"N");
                continue;
            }
            if (inspSize == sampMeasureList.size() && sampMeasureList.stream().allMatch(x -> "Y".equals(x.getString("measuredval_judge")))) {
                subSampObj.set("sampleres", (Object)"Y");
                continue;
            }
            subSampObj.set("sampleres", (Object)"");
        }
    }

    private static void refreshInspEntry(Map<String, List<DynamicObject>> projMeasureGroup, DynamicObjectCollection inspSubEntry) {
        for (DynamicObject inspSubObj : inspSubEntry) {
            if (inspSubObj.containsProperty("joininspectstatus") && inspSubObj.getBoolean("isjoininspect") && StringUtils.isNotEmpty((String)inspSubObj.getString("joininspectstatus"))) continue;
            String uqUuid = inspSubObj.getString("uquuid");
            List<DynamicObject> projMeasureList = projMeasureGroup.get(uqUuid);
            BigDecimal qualifyQty = new BigDecimal(CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> "Y".equals(x.getString("measuredval_judge"))).count());
            inspSubObj.set("projqualifiyqty", (Object)qualifyQty);
            BigDecimal unqualifyQty = new BigDecimal(CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> "N".equals(x.getString("measuredval_judge"))).count());
            inspSubObj.set("projunqualifiyqty", (Object)unqualifyQty);
            long chooseSampQty = CollectionUtils.isEmpty(projMeasureList) ? 0L : (long)projMeasureList.size();
            inspSubObj.set("choosesampqty", (Object)chooseSampQty);
            long inspProjCnt = CollectionUtils.isEmpty(projMeasureList) ? 0L : projMeasureList.stream().filter(x -> StringUtils.isNotEmpty((String)x.getString("measuredval_deter")) || StringUtils.isNotEmpty((String)x.getString("measuredval_rat"))).count();
            inspSubObj.set("projckval", (Object)inspProjCnt);
            InspectServiceHelper.setProjCkresult(inspSubObj, qualifyQty, unqualifyQty);
        }
    }

    private static void clearInspitemCkValInfo(DynamicObject inspRow) {
        inspRow.set("projckval", null);
        inspRow.set("choosesampqty", null);
        inspRow.set("projqualifiyqty", null);
        inspRow.set("projunqualifiyqty", null);
        inspRow.set("projckresult", null);
        inspRow.set("projckvalstr", (Object)InspectCkvalHelper.getCkValStr());
    }
}

